"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = alertingPlugin;
var _constants = require("../../services/utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function alertingPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.alerting = components.clientAction.namespaceFactory();
  const alerting = Client.prototype.alerting.prototype;
  alerting.getFindings = ca({
    url: {
      fmt: `${_constants.API_ROUTE_PREFIX}/findings/_search`
    },
    needBody: true,
    method: 'GET'
  });
  alerting.getWorkflow = ca({
    url: {
      fmt: `${_constants.API_ROUTE_PREFIX}/workflows/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.getMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.createMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.createWorkflow = ca({
    url: {
      fmt: `${_constants.API_ROUTE_PREFIX}/workflows?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.deleteMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  alerting.deleteWorkflow = ca({
    url: {
      fmt: `${_constants.WORKFLOW_BASE_API}/<%=workflowId%>`,
      req: {
        workflowId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });

  // TODO DRAFT: May need to add 'refresh' assignment here again.
  alerting.updateMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });

  // TODO DRAFT: May need to add 'refresh' assignment here again.
  alerting.updateWorkflow = ca({
    url: {
      fmt: `${_constants.API_ROUTE_PREFIX}/workflows/<%=monitorId%>`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  alerting.getMonitors = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.acknowledgeAlerts = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/<%=monitorId%>/_acknowledge/alerts`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  alerting.acknowledgeChainedAlerts = ca({
    url: {
      fmt: `${_constants.WORKFLOW_BASE_API}/<%=workflowId%>/_acknowledge/alerts`,
      req: {
        workflowId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  alerting.getAlerts = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/alerts`
    },
    method: 'GET'
  });
  alerting.executeMonitor = ca({
    url: {
      fmt: `${_constants.MONITOR_BASE_API}/_execute?dryrun=<%=dryrun%>`,
      req: {
        dryrun: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  alerting.getDestination = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}/<%=destinationId%>`,
      req: {
        destinationId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.searchDestinations = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}`
    },
    method: 'GET'
  });
  alerting.createDestination = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.updateDestination = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}/<%=destinationId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        destinationId: {
          type: 'string',
          required: true
        },
        ifSeqNo: {
          type: 'string',
          required: true
        },
        ifPrimaryTerm: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  alerting.deleteDestination = ca({
    url: {
      fmt: `${_constants.DESTINATION_BASE_API}/<%=destinationId%>`,
      req: {
        destinationId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  alerting.getEmailAccount = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}/<%=emailAccountId%>`,
      req: {
        emailAccountId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.getEmailAccounts = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.createEmailAccount = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.updateEmailAccount = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}/<%=emailAccountId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        emailAccountId: {
          type: 'string',
          required: true
        },
        ifSeqNo: {
          type: 'string',
          required: true
        },
        ifPrimaryTerm: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  alerting.deleteEmailAccount = ca({
    url: {
      fmt: `${_constants.EMAIL_ACCOUNT_BASE_API}/<%=emailAccountId%>`,
      req: {
        emailAccountId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  alerting.getEmailGroup = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}/<%=emailGroupId%>`,
      req: {
        emailGroupId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alerting.getEmailGroups = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.createEmailGroup = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}?refresh=wait_for`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.updateEmailGroup = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}/<%=emailGroupId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        emailGroupId: {
          type: 'string',
          required: true
        },
        ifSeqNo: {
          type: 'string',
          required: true
        },
        ifPrimaryTerm: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  alerting.deleteEmailGroup = ca({
    url: {
      fmt: `${_constants.EMAIL_GROUP_BASE_API}/<%=emailGroupId%>`,
      req: {
        emailGroupId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  alerting.getWorkflowAlerts = ca({
    url: {
      fmt: `${_constants.WORKFLOW_BASE_API}/alerts?workflowIds=<%=workflowIds%>&getAssociatedAlerts=<%=getAssociatedAlerts%>&sortString=<%=sortString%>&sortOrder=<%=sortOrder%>&startIndex=<%=startIndex%>&size=<%=size%>&severityLevel=<%=severityLevel%>&alertState=<%=alertState%>&searchString=<%=searchString%>&alertIds=<%=alertIds%>`,
      req: {
        workflowIds: {
          type: 'string',
          required: true
        },
        alertIds: {
          type: 'string',
          required: true
        },
        getAssociatedAlerts: {
          type: 'boolean',
          required: true
        },
        sortString: {
          type: 'string',
          required: true
        },
        sortOrder: {
          type: 'string',
          required: true
        },
        startIndex: {
          type: 'number',
          required: true
        },
        size: {
          type: 'number',
          required: true
        },
        severityLevel: {
          type: 'string',
          required: false
        },
        alertState: {
          type: 'string',
          required: false
        },
        searchString: {
          type: 'string',
          required: false
        }
      }
    },
    method: 'GET'
  });
  alerting.getRemoteIndexes = ca({
    url: {
      fmt: `${_constants.CROSS_CLUSTER_BASE_API}/indexes?indexes=<%=indexes%>&include_mappings=<%=include_mappings%>`,
      req: {
        indexes: {
          type: 'string',
          required: true
        },
        include_mappings: {
          type: 'boolean',
          required: false
        }
      }
    },
    needBody: true,
    method: 'GET'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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