"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router) {
  const {
    destinationsService
  } = services;
  router.get({
    path: '/api/alerting/destinations',
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.maybe(_configSchema.schema.number()),
        size: _configSchema.schema.maybe(_configSchema.schema.number()),
        search: _configSchema.schema.maybe(_configSchema.schema.string()),
        sortField: _configSchema.schema.maybe(_configSchema.schema.string()),
        sortDirection: _configSchema.schema.maybe(_configSchema.schema.string()),
        type: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, destinationsService.getDestinations);
  router.get({
    path: '/api/alerting/destinations/{destinationId}',
    validate: {
      params: _configSchema.schema.object({
        destinationId: _configSchema.schema.string()
      })
    }
  }, destinationsService.getDestination);
  router.post({
    path: '/api/alerting/destinations',
    validate: {
      body: _configSchema.schema.any()
    }
  }, destinationsService.createDestination);
  router.put({
    path: '/api/alerting/destinations/{destinationId}',
    validate: {
      params: _configSchema.schema.object({
        destinationId: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ifSeqNo: _configSchema.schema.string(),
        ifPrimaryTerm: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, destinationsService.updateDestination);
  router.delete({
    path: '/api/alerting/destinations/{destinationId}',
    validate: {
      params: _configSchema.schema.object({
        destinationId: _configSchema.schema.string()
      })
    }
  }, destinationsService.deleteDestination);
  router.get({
    path: '/api/alerting/destinations/email_accounts',
    validate: {
      query: _configSchema.schema.object({
        search: _configSchema.schema.maybe(_configSchema.schema.string()),
        size: _configSchema.schema.number()
      })
    }
  }, destinationsService.getEmailAccounts);
  router.post({
    path: '/api/alerting/destinations/email_accounts',
    validate: {
      body: _configSchema.schema.any()
    }
  }, destinationsService.createEmailAccount);
  router.get({
    path: '/api/alerting/destinations/email_accounts/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, destinationsService.getEmailAccount);
  router.put({
    path: '/api/alerting/destinations/email_accounts/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ifSeqNo: _configSchema.schema.number(),
        ifPrimaryTerm: _configSchema.schema.number()
      }),
      body: _configSchema.schema.any()
    }
  }, destinationsService.updateEmailAccount);
  router.delete({
    path: '/api/alerting/destinations/email_accounts/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, destinationsService.deleteEmailAccount);
  router.get({
    path: '/api/alerting/destinations/email_groups',
    validate: {
      query: _configSchema.schema.object({
        search: _configSchema.schema.maybe(_configSchema.schema.string()),
        size: _configSchema.schema.number()
      })
    }
  }, destinationsService.getEmailGroups);
  router.post({
    path: '/api/alerting/destinations/email_groups',
    validate: {
      body: _configSchema.schema.any()
    }
  }, destinationsService.createEmailGroup);
  router.get({
    path: '/api/alerting/destinations/email_groups/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, destinationsService.getEmailGroup);
  router.put({
    path: '/api/alerting/destinations/email_groups/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ifSeqNo: _configSchema.schema.number(),
        ifPrimaryTerm: _configSchema.schema.number()
      }),
      body: _configSchema.schema.any()
    }
  }, destinationsService.updateEmailGroup);
  router.delete({
    path: '/api/alerting/destinations/email_groups/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, destinationsService.deleteEmailGroup);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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