"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isIndexNotFoundError = void 0;
exports.mapKeysDeep = mapKeysDeep;
exports.toSnake = exports.toCamel = void 0;
var _lodash = require("lodash");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function mapKeysDeep(obj, fn) {
  if (Array.isArray(obj)) {
    return (0, _lodash.map)(obj, innerObj => mapKeysDeep(innerObj, fn));
  } else {
    return (0, _lodash.isPlainObject)(obj) ? (0, _lodash.mapValues)((0, _lodash.mapKeys)(obj, fn), value => mapKeysDeep(value, fn)) : obj;
  }
}
const toSnake = (value, key) => (0, _lodash.snakeCase)(key);
exports.toSnake = toSnake;
const toCamel = (value, key) => (0, _lodash.camelCase)(key);
exports.toCamel = toCamel;
const isIndexNotFoundError = err => {
  return err.statusCode === 404 && (0, _lodash.get)(err, 'body.error.reason', '') === 'Configured indices are not found: [.opendistro-alerting-config]';
};
exports.isIndexNotFoundError = isIndexNotFoundError;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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