/*
 * Decompiled with CFR 0.152.
 */
package zext.plantuml.com.ctreber.acearth;

import zext.plantuml.com.ctreber.acearth.Configuration;
import zext.plantuml.com.ctreber.acearth.util.Coordinate;
import zext.plantuml.com.ctreber.aclib.gui.MOBoolean;
import zext.plantuml.com.ctreber.aclib.gui.MODouble;
import zext.plantuml.com.ctreber.aclib.gui.MOEnum;
import zext.plantuml.com.ctreber.aclib.gui.MOInteger;
import zext.plantuml.com.ctreber.aclib.gui.MOString;

public class ConfigurationACearth
extends Configuration {
    private static final int DEFAULT_DIMENSION = 512;

    public ConfigurationACearth() {
        MOEnum lProjection = new MOEnum();
        lProjection.addValidValue("Mercator");
        lProjection.addValidValue("Orthographic");
        lProjection.addValidValue("Cylindrical");
        lProjection.set("Orthographic");
        this.add("projection", lProjection);
        MOEnum lPositionType = new MOEnum();
        lPositionType.addValidValue("Fixed");
        lPositionType.addValidValue("Sun-relative");
        lPositionType.addValidValue("Orbit");
        lPositionType.addValidValue("Random");
        lPositionType.addValidValue("Moon");
        lPositionType.set("Sun-relative");
        this.add("viewPositionType", lPositionType);
        MOEnum lViewRotationType = new MOEnum();
        lViewRotationType.addValidValue("North");
        lViewRotationType.addValidValue("Galactic");
        lViewRotationType.set("North");
        this.add("viewRotationType", lViewRotationType);
        MOString lOutputMode = new MOString("gui");
        this.add("outputMode", lOutputMode);
        MODouble lViewPosLat = new MODouble(0.0, -90.0, 90.0);
        this.add("viewPosLat", lViewPosLat);
        MODouble lViewPosLong = new MODouble(0.0, -180.0, 180.0);
        this.add("viewPosLong", lViewPosLong);
        MODouble lSunPosRelLat = new MODouble(0.0, -90.0, 90.0);
        this.add("sunPosRelLat", lSunPosRelLat);
        MODouble lSunPosRelLong = new MODouble(0.0, -180.0, 180.0);
        this.add("sunPosRelLong", lSunPosRelLong);
        MOBoolean lSunMovesP = new MOBoolean(true);
        this.add("sunMovesP", lSunMovesP);
        MODouble lSunPosLat = new MODouble(0.0, -90.0, 90.0);
        this.add("sunPosLat", lSunPosLat);
        MODouble lSunPosLong = new MODouble(0.0, -180.0, 180.0);
        this.add("sunPosLong", lSunPosLong);
        MODouble lTimeWarpFactor = new MODouble(1.0, 0.0, Double.MAX_VALUE);
        this.add("timeWarpFactor", lTimeWarpFactor);
        MOInteger lFixedTime = new MOInteger(0, 0, Integer.MAX_VALUE);
        this.add("fixedTime", lFixedTime);
        MOInteger lWaitTime = new MOInteger(300, 0, Integer.MAX_VALUE);
        this.add("waitTime", lWaitTime);
        MODouble lOrbitPeriod = new MODouble(1.0, 1.0E-4, Double.MAX_VALUE);
        this.add("orbitPeriod", lOrbitPeriod);
        MODouble lOrbitInclination = new MODouble(45.0, 0.0, 90.0);
        this.add("orbitInclination", lOrbitInclination);
        MOBoolean lLabelP = new MOBoolean(false);
        this.add("labelP", lLabelP);
        MOInteger lImageWidth = new MOInteger(512, 0, Integer.MAX_VALUE);
        this.add("imageWidth", lImageWidth);
        MOInteger lImageHeight = new MOInteger(512, 0, Integer.MAX_VALUE);
        this.add("imageHeight", lImageHeight);
        MOBoolean lStarsP = new MOBoolean(true);
        this.add("starsP", lStarsP);
        MODouble lStarFrequency = new MODouble(0.002, 0.0, Double.MAX_VALUE);
        this.add("starFrequency", lStarFrequency);
        MOInteger lBigStars = new MOInteger(0, 0, 100);
        this.add("bigStars", lBigStars);
        MOBoolean lGridP = new MOBoolean(true);
        this.add("gridP", lGridP);
        MOInteger lGridDivision = new MOInteger(6, 0, Integer.MAX_VALUE);
        this.add("gridDivision", lGridDivision);
        MOInteger lGridPixelDevision = new MOInteger(15, 0, Integer.MAX_VALUE);
        this.add("gridPixelDivision", lGridPixelDevision);
        MOInteger lShiftX = new MOInteger(0, 0, Integer.MAX_VALUE);
        this.add("shiftX", lShiftX);
        MOInteger lShiftY = new MOInteger(0, 0, Integer.MAX_VALUE);
        this.add("shiftY", lShiftY);
        MODouble lViewMagnification = new MODouble(1.0, 0.0, Double.MAX_VALUE);
        this.add("viewMagnification", lViewMagnification);
        MOBoolean lShadeP = new MOBoolean(true);
        this.add("shadeP", lShadeP);
        MOInteger lDaySideBrightness = new MOInteger(100, 0, 100);
        this.add("daySideBrightness", lDaySideBrightness);
        MOInteger lNightSideBrightness = new MOInteger(5, 0, 100);
        this.add("nightSideBrightness", lNightSideBrightness);
        MOInteger lTerminatorDiscontinuity = new MOInteger(1, 0, 100);
        this.add("terminatorDiscontinuity", lTerminatorDiscontinuity);
        MODouble lViewRotation = new MODouble(0.0, 0.0, Double.MAX_VALUE);
        this.add("viewRotation", lViewRotation);
    }

    public Coordinate getViewPos() {
        return new Coordinate(this.getDouble("viewPosLat"), this.getDouble("viewPosLong"));
    }

    public void setViewPos(Coordinate pViewPos) {
        this.setDouble("viewPosLat", pViewPos.getLat());
        this.setDouble("viewPosLong", pViewPos.getLong());
    }

    public Coordinate getSunPos() {
        return new Coordinate(this.getDouble("sunPosLat"), this.getDouble("sunPosLong"));
    }

    public void setSunPos(Coordinate pSunPos) {
        this.setDouble("sunPosLat", pSunPos.getLat());
        this.setDouble("sunPosLong", pSunPos.getLong());
    }

    public Coordinate getSunPosRel() {
        return new Coordinate(this.getDouble("sunPosRelLat"), this.getDouble("sunPosRelLong"));
    }

    public void setSunPosRel(Coordinate pSunPosRel) {
        this.setDouble("sunPosRelLat", pSunPosRel.getLat());
        this.setDouble("sunPosRelLong", pSunPosRel.getLong());
    }
}

