# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
gce module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_gce.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _gce
else:
    import _gce

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gce.delete_SwigPyIterator

    def value(self):
        return _gce.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _gce.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _gce.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _gce.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _gce.SwigPyIterator_equal(self, x)

    def copy(self):
        return _gce.SwigPyIterator_copy(self)

    def next(self):
        return _gce.SwigPyIterator_next(self)

    def __next__(self):
        return _gce.SwigPyIterator___next__(self)

    def previous(self):
        return _gce.SwigPyIterator_previous(self)

    def advance(self, n):
        return _gce.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _gce.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _gce.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _gce.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _gce.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _gce.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _gce.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _gce:
_gce.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _gce.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection

from enum import IntEnum
from OCC.Core.Exception import *

gce_Done = _gce.gce_Done
gce_ConfusedPoints = _gce.gce_ConfusedPoints
gce_NegativeRadius = _gce.gce_NegativeRadius
gce_ColinearPoints = _gce.gce_ColinearPoints
gce_IntersectionError = _gce.gce_IntersectionError
gce_NullAxis = _gce.gce_NullAxis
gce_NullAngle = _gce.gce_NullAngle
gce_NullRadius = _gce.gce_NullRadius
gce_InvertAxis = _gce.gce_InvertAxis
gce_BadAngle = _gce.gce_BadAngle
gce_InvertRadius = _gce.gce_InvertRadius
gce_NullFocusLength = _gce.gce_NullFocusLength
gce_NullVector = _gce.gce_NullVector
gce_BadEquation = _gce.gce_BadEquation


class gce_ErrorType(IntEnum):
	gce_Done = 0
	gce_ConfusedPoints = 1
	gce_NegativeRadius = 2
	gce_ColinearPoints = 3
	gce_IntersectionError = 4
	gce_NullAxis = 5
	gce_NullAngle = 6
	gce_NullRadius = 7
	gce_InvertAxis = 8
	gce_BadAngle = 9
	gce_InvertRadius = 10
	gce_NullFocusLength = 11
	gce_NullVector = 12
	gce_BadEquation = 13
gce_Done = gce_ErrorType.gce_Done
gce_ConfusedPoints = gce_ErrorType.gce_ConfusedPoints
gce_NegativeRadius = gce_ErrorType.gce_NegativeRadius
gce_ColinearPoints = gce_ErrorType.gce_ColinearPoints
gce_IntersectionError = gce_ErrorType.gce_IntersectionError
gce_NullAxis = gce_ErrorType.gce_NullAxis
gce_NullAngle = gce_ErrorType.gce_NullAngle
gce_NullRadius = gce_ErrorType.gce_NullRadius
gce_InvertAxis = gce_ErrorType.gce_InvertAxis
gce_BadAngle = gce_ErrorType.gce_BadAngle
gce_InvertRadius = gce_ErrorType.gce_InvertRadius
gce_NullFocusLength = gce_ErrorType.gce_NullFocusLength
gce_NullVector = gce_ErrorType.gce_NullVector
gce_BadEquation = gce_ErrorType.gce_BadEquation

class gce_MakeMirror(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Point: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Axis: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Line: gp_Lin

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Point: gp_Pnt
        Direc: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Makes a symmetry transformation af axis defined by <point> and <direc>.

        Parameters
        ----------
        Plane: gp_Pln

        Return
        -------
        None

        Description
        -----------
        Makes a symmetry transformation of plane <plane>.

        Parameters
        ----------
        Plane: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        Makes a symmetry transformation of plane <plane>.

        """
        _gce.gce_MakeMirror_swiginit(self, _gce.new_gce_MakeMirror(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Trsf

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeMirror_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Trsf

        Description
        -----------
        Returns the constructed transformation.

        """
        return _gce.gce_MakeMirror_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeMirror

# Register gce_MakeMirror in _gce:
_gce.gce_MakeMirror_swigregister(gce_MakeMirror)
class gce_MakeMirror2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Point: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Axis: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Line: gp_Lin2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Point: gp_Pnt2d
        Direc: gp_Dir2d

        Return
        -------
        None

        Description
        -----------
        Makes a symmetry transformation af axis defined by <point> and <direc>.

        """
        _gce.gce_MakeMirror2d_swiginit(self, _gce.new_gce_MakeMirror2d(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Trsf2d

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeMirror2d_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Trsf2d

        Description
        -----------
        Returns the constructed transformation.

        """
        return _gce.gce_MakeMirror2d_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeMirror2d

# Register gce_MakeMirror2d in _gce:
_gce.gce_MakeMirror2d_swigregister(gce_MakeMirror2d)
class gce_MakeRotation(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Line: gp_Lin
        Angle: float

        Return
        -------
        None

        Description
        -----------
        Constructs a rotation through angle angle about the axis defined by the line line.

        Parameters
        ----------
        Axis: gp_Ax1
        Angle: float

        Return
        -------
        None

        Description
        -----------
        Constructs a rotation through angle angle about the axis defined by the axis axis.

        Parameters
        ----------
        Point: gp_Pnt
        Direc: gp_Dir
        Angle: float

        Return
        -------
        None

        Description
        -----------
        Constructs a rotation through angle angle about the axis defined by: the point point and the unit vector direc.

        """
        _gce.gce_MakeRotation_swiginit(self, _gce.new_gce_MakeRotation(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Trsf

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeRotation_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Trsf

        Description
        -----------
        Returns the constructed transformation.

        """
        return _gce.gce_MakeRotation_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeRotation

# Register gce_MakeRotation in _gce:
_gce.gce_MakeRotation_swigregister(gce_MakeRotation)
class gce_MakeRotation2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Point: gp_Pnt2d
        Angle: float

        Return
        -------
        None

        Description
        -----------
        Constructs a rotation through angle angle about the center point.

        """
        _gce.gce_MakeRotation2d_swiginit(self, _gce.new_gce_MakeRotation2d(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Trsf2d

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeRotation2d_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Trsf2d

        Description
        -----------
        Returns the constructed transformation.

        """
        return _gce.gce_MakeRotation2d_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeRotation2d

# Register gce_MakeRotation2d in _gce:
_gce.gce_MakeRotation2d_swigregister(gce_MakeRotation2d)
class gce_MakeScale(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Point: gp_Pnt
        Scale: float

        Return
        -------
        None

        Description
        -----------
        Constructs a scaling transformation with - point as the center of the transformation, and - scale as the scale factor.

        """
        _gce.gce_MakeScale_swiginit(self, _gce.new_gce_MakeScale(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Trsf

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeScale_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Trsf

        Description
        -----------
        Returns the constructed transformation.

        """
        return _gce.gce_MakeScale_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeScale

# Register gce_MakeScale in _gce:
_gce.gce_MakeScale_swigregister(gce_MakeScale)
class gce_MakeScale2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Point: gp_Pnt2d
        Scale: float

        Return
        -------
        None

        Description
        -----------
        Constructs a scaling transformation with: - point as the center of the transformation, and - scale as the scale factor.

        """
        _gce.gce_MakeScale2d_swiginit(self, _gce.new_gce_MakeScale2d(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Trsf2d

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeScale2d_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Trsf2d

        Description
        -----------
        Returns the constructed transformation.

        """
        return _gce.gce_MakeScale2d_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeScale2d

# Register gce_MakeScale2d in _gce:
_gce.gce_MakeScale2d_swigregister(gce_MakeScale2d)
class gce_MakeTranslation(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Vect: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Constructs a translation along the vector ' vect'.

        Parameters
        ----------
        Point1: gp_Pnt
        Point2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Constructs a translation along the vector (point1,point2) defined from the point point1 to the point point2.

        """
        _gce.gce_MakeTranslation_swiginit(self, _gce.new_gce_MakeTranslation(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Trsf

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeTranslation_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Trsf

        Description
        -----------
        Returns the constructed transformation.

        """
        return _gce.gce_MakeTranslation_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeTranslation

# Register gce_MakeTranslation in _gce:
_gce.gce_MakeTranslation_swigregister(gce_MakeTranslation)
class gce_MakeTranslation2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Vect: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        Constructs a translation along the vector vect.

        Parameters
        ----------
        Point1: gp_Pnt2d
        Point2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Constructs a translation along the vector (point1,point2) defined from the point point1 to the point point2.

        """
        _gce.gce_MakeTranslation2d_swiginit(self, _gce.new_gce_MakeTranslation2d(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Trsf2d

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeTranslation2d_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Trsf2d

        Description
        -----------
        Returns the constructed transformation.

        """
        return _gce.gce_MakeTranslation2d_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeTranslation2d

# Register gce_MakeTranslation2d in _gce:
_gce.gce_MakeTranslation2d_swigregister(gce_MakeTranslation2d)
class gce_Root(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the construction is successful.

        """
        return _gce.gce_Root_IsDone(self, *args)

    def Status(self, *args):
        r"""
        Return
        -------
        gce_ErrorType

        Description
        -----------
        Returns the status of the construction: - gce_done, if the construction is successful, or - another value of the gce_errortype enumeration indicating why the construction failed.

        """
        return _gce.gce_Root_Status(self, *args)

    __repr__ = _dumps_object


    def __init__(self):
        _gce.gce_Root_swiginit(self, _gce.new_gce_Root())
    __swig_destroy__ = _gce.delete_gce_Root

# Register gce_Root in _gce:
_gce.gce_Root_swigregister(gce_Root)
class gce_MakeCirc(gce_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        A2: gp_Ax2
        Radius: float

        Return
        -------
        None

        Description
        -----------
        A2 locates the circle and gives its orientation in 3d space. warnings: it is not forbidden to create a circle with radius = 0.0 the status is 'negativeradius' if radius < 0.0.

        Parameters
        ----------
        Circ: gp_Circ
        Dist: float

        Return
        -------
        None

        Description
        -----------
        Makes a circ from gp <thecirc> coaxial to another circ <circ> at a distance <dist>. if dist is greater than zero the result is encloses the circle <circ>, else the result is enclosed by the circle <circ>.

        Parameters
        ----------
        Circ: gp_Circ
        Point: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Makes a circ from gp <thecirc> coaxial to another circ <circ> and passing through a pnt2d <point>.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Makes a circ from gp <thecirc> passing through 3 pnt2d <p1>,<p2>,<p3>.

        Parameters
        ----------
        Center: gp_Pnt
        Norm: gp_Dir
        Radius: float

        Return
        -------
        None

        Description
        -----------
        Makes a circ from gp <thecirc> with its center <center> and the normal of its plane <norm> and its radius <radius>.

        Parameters
        ----------
        Center: gp_Pnt
        Plane: gp_Pln
        Radius: float

        Return
        -------
        None

        Description
        -----------
        Makes a circ from gp <thecirc> with its center <center> and the normal of its plane <plane> and its radius <radius>.

        Parameters
        ----------
        Center: gp_Pnt
        Ptaxis: gp_Pnt
        Radius: float

        Return
        -------
        None

        Description
        -----------
        Makes a circ from gp <thecirc> with its center <center> and a point <ptaxis> giving the normal of its plane <plane> and its radius <radius>.

        Parameters
        ----------
        Axis: gp_Ax1
        Radius: float

        Return
        -------
        None

        Description
        -----------
        Makes a circ from gp <thecirc> with its center <center> and its radius <radius>. warning the makecirc class does not prevent the construction of a circle with a null radius. if an error occurs (that is, when isdone returns false), the status function returns: - gce_negative radius if: - radius is less than 0.0, or - dist is less than 0.0 and the absolute value of dist is greater than the radius of circ; - gce_intersectionerror if the points p1, p2 and p3 are collinear, and the three are not coincident; - gce_confusedpoints if two of the three points p1, p2 and p3 are coincident; or - gce_nullaxis if center and ptaxis are coincident.

        """
        _gce.gce_MakeCirc_swiginit(self, _gce.new_gce_MakeCirc(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Circ

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeCirc_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Circ

        Description
        -----------
        Returns the constructed circle. exceptions stdfail_notdone if no circle is constructed.

        """
        return _gce.gce_MakeCirc_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeCirc

# Register gce_MakeCirc in _gce:
_gce.gce_MakeCirc_swigregister(gce_MakeCirc)
class gce_MakeCirc2d(gce_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        XAxis: gp_Ax2d
        Radius: float
        Sense: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        The location point of xaxis is the center of the circle. warnings: it is not forbidden to create a circle with radius = 0.0 if sense is true the local coordinate system of the solution is direct and non direct in the other case. the status is 'negativeradius' if radius < 0.0.

        Parameters
        ----------
        Axis: gp_Ax22d
        Radius: float

        Return
        -------
        None

        Description
        -----------
        The location point of axis is the center of the circle. warnings: it is not forbidden to create a circle with radius = 0.0.

        Parameters
        ----------
        Circ: gp_Circ2d
        Dist: float

        Return
        -------
        None

        Description
        -----------
        Makes a circ2d from gp <thecirc> concentric with another circ2d <circ> with a distance <dist>. if dist is greater than zero the result encloses the circle <circ>, else the result is enclosed by the circle <circ>. the local coordinate system of the solution is the same as circ.

        Parameters
        ----------
        Circ: gp_Circ2d
        Point: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Makes a circ2d from gp <thecirc> concentric with another circ2d <circ> and passing through a pnt2d <point>. the local coordinate system of the solution is the same as circ.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d
        P3: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Makes a circ2d from gp <thecirc> passing through 3 pnt2d <p1>,<p2>,<p3>. the local coordinate system of the solution is given by the three points p1, p2, p3.

        Parameters
        ----------
        Center: gp_Pnt2d
        Radius: float
        Sense: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Makes a circ2d from gp <thecirc> with its center <center> and its radius <radius>. if sense is true the local coordinate system of the solution is direct and non direct in the other case.

        Parameters
        ----------
        Center: gp_Pnt2d
        Point: gp_Pnt2d
        Sense: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Makes a circ2d from gp <thecirc> with its center <center> and a point giving the radius. if sense is true the local coordinate system of the solution is direct and non direct in the other case.

        """
        _gce.gce_MakeCirc2d_swiginit(self, _gce.new_gce_MakeCirc2d(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Circ2d

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeCirc2d_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Circ2d

        Description
        -----------
        Returns the constructed circle. exceptions stdfail_notdone if no circle is constructed.

        """
        return _gce.gce_MakeCirc2d_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeCirc2d

# Register gce_MakeCirc2d in _gce:
_gce.gce_MakeCirc2d_swigregister(gce_MakeCirc2d)
class gce_MakeCone(gce_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        A2: gp_Ax2
        Ang: float
        Radius: float

        Return
        -------
        None

        Description
        -----------
        Creates an infinite conical surface. a2 locates the cone in the space and defines the reference plane of the surface. ang is the conical surface semi-angle between 0 and pi/2 radians. radius is the radius of the circle in the reference plane of the cone. if radius is lower than 0.0 the status is ' if ang < resolution from gp or ang >= (pi/2) - resolution.

        Parameters
        ----------
        Cone: gp_Cone
        Point: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Makes a cone from gp <thecone> coaxial to another cone <cone> and passing through a pnt <point>.

        Parameters
        ----------
        Cone: gp_Cone
        Dist: float

        Return
        -------
        None

        Description
        -----------
        Makes a cone from gp <thecone> coaxial to another cone <cone> at the distance <dist> which can be greater or lower than zero.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt
        P4: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Makes a cone from gp <thecone> by four points <p1>, <p2>,<p3> and <p4>. its axis is <p1p2> and the radius of its base is the distance between <p3> and <p1p2>. the distance between <p4> and <p1p2> is the radius of the section passing through <p4>. if <p1> and <p2> are confused or <p3> and <p4> are confused we have the status 'confusedpoints' if <p1>,<p2>,<p3>,<p4> are colinear we have the status 'colinearpoints' if <p3p4> is perpendicular to <p1p2> we have the status 'nullangle'. <p3p4> is colinear to <p1p2> we have the status 'nullangle'.

        Parameters
        ----------
        Axis: gp_Ax1
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Makes a cone by its axis <axis> and two points. the distance between <p1> and the axis is the radius of the section passing through <p1>. the distance between <p2> and the axis is the radius of the section passing through <p2>. if <p1p2> is colinear to <axis> we have the status 'nullangle' if <p3p4> is perpendicular to <axis> we have the status 'nullangle' if <p1> and <p2> are confused we have the status 'confusedpoints'.

        Parameters
        ----------
        Axis: gp_Lin
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Makes a cone by its axis <axis> and two points. the distance between <p1> and the axis is the radius of the section passing through <p1> the distance between <p2> and the axis is the radius of the section passing through <p2> if <p1p2> is colinear to <axis> we have the status 'nullangle' if <p3p4> is perpendicular to <axis> we have the status 'nullangle' if <p1> and <p2> are confused we have the status 'confusedpoints'.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        R1: float
        R2: float

        Return
        -------
        None

        Description
        -----------
        Makes a cone with two points and two radius. the axis of the solution is the line passing through <p1> and <p2>. <r1> is the radius of the section passing through <p1> and <r2> the radius of the section passing through <p2>. if <p1> and <p2> are confused we have the status 'nullaxis'. warning if an error occurs (that is, when isdone returns false), the status function returns: - gce_negativeradius if radius, r1 or r2 is less than 0.0; - gce_badangle if ang is less than gp::resolution() or greater than pi/2.- gp::resolution(); - gce_confusedpoints if p1 and p2 or p3 and p4 are coincident; - gce_nullaxis if the points p1 and p2, are coincident (5th syntax only); - gce_nullangle if: - the vector joining p1 to p2 is parallel to either axis or the line joining p3 to p4, or - r1 and r2 are equal, (that is, their difference is less than gp::resolution()); or - gce_nullradius if: - the vector joining p1 to p2 is perpendicular to the line joining p3 to p4, - the vector joining p1 to p2 is perpendicular to axis, or - p1, p2, p3, and p4 are collinear.

        """
        _gce.gce_MakeCone_swiginit(self, _gce.new_gce_MakeCone(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Cone

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeCone_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Cone

        Description
        -----------
        Returns the constructed cone. exceptions stdfail_notdone if no cone is constructed.

        """
        return _gce.gce_MakeCone_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeCone

# Register gce_MakeCone in _gce:
_gce.gce_MakeCone_swigregister(gce_MakeCone)
class gce_MakeCylinder(gce_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        A2: gp_Ax2
        Radius: float

        Return
        -------
        None

        Description
        -----------
        <a2> is the local cartesian coordinate system of <self>. the status is 'negativeradius' if r < 0.0.

        Parameters
        ----------
        Cyl: gp_Cylinder
        Point: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Makes a cylinder from gp <thecylinder> coaxial to another cylinder <cylinder> and passing through a pnt <point>.

        Parameters
        ----------
        Cyl: gp_Cylinder
        Dist: float

        Return
        -------
        None

        Description
        -----------
        Makes a cylinder from gp <thecylinder> coaxial to another cylinder <cylinder> at the distance <dist> which can be greater or lower than zero. the radius of the result is the absolute value of the radius of <cyl> plus <dist>.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Makes a cylinder from gp <thecylinder> with 3 points <p1>,<p2>,<p3>. its axis is <p1p2> and its radius is the distance between <p3> and <p1p2>.

        Parameters
        ----------
        Axis: gp_Ax1
        Radius: float

        Return
        -------
        None

        Description
        -----------
        Makes a cylinder by its axis <axis> and radius <radius>.

        Parameters
        ----------
        Circ: gp_Circ

        Return
        -------
        None

        Description
        -----------
        Makes a cylinder by its circular base. warning if an error occurs (that is, when isdone returns false), the status function returns: - gce_negativeradius if: - radius is less than 0.0, or - dist is negative and has an absolute value which is greater than the radius of cyl; or - gce_confusedpoints if points p1 and p2 are coincident.

        """
        _gce.gce_MakeCylinder_swiginit(self, _gce.new_gce_MakeCylinder(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Cylinder

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeCylinder_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Cylinder

        Description
        -----------
        Returns the constructed cylinder. exceptions stdfail_notdone if no cylinder is constructed.

        """
        return _gce.gce_MakeCylinder_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeCylinder

# Register gce_MakeCylinder in _gce:
_gce.gce_MakeCylinder_swigregister(gce_MakeCylinder)
class gce_MakeDir(gce_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        V: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Normalizes the vector v and creates a direction. status is 'nullvector' if v.magnitude() <= resolution.

        Parameters
        ----------
        Coord: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Creates a direction from a triplet of coordinates. status is 'nullvector' if coord.modulus() <= resolution from gp.

        Parameters
        ----------
        Xv: float
        Yv: float
        Zv: float

        Return
        -------
        None

        Description
        -----------
        Creates a direction with its 3 cartesian coordinates. status is 'nullvector' if sqrt(xv*xv + yv*yv + zv*zv) <= resolution.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Make a dir from gp <thedir> passing through 2 pnt <p1>,<p2>. status is 'confusedpoints' if <p1> and <p2> are confused. warning if an error occurs (that is, when isdone returns false), the status function returns: - gce_confusedpoints if points p1 and p2 are coincident, or - gce_nullvector if one of the following is less than or equal to gp::resolution(): - the magnitude of vector v, - the modulus of coord, - sqrt(xv*xv + yv*yv + zv*zv).

        """
        _gce.gce_MakeDir_swiginit(self, _gce.new_gce_MakeDir(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeDir_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Dir

        Description
        -----------
        Returns the constructed unit vector. exceptions stdfail_notdone if no unit vector is constructed.

        """
        return _gce.gce_MakeDir_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeDir

# Register gce_MakeDir in _gce:
_gce.gce_MakeDir_swigregister(gce_MakeDir)
class gce_MakeDir2d(gce_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        V: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        Normalizes the vector v and creates a direction. status is 'nullvector' if v.magnitude() <= resolution.

        Parameters
        ----------
        Coord: gp_XY

        Return
        -------
        None

        Description
        -----------
        Creates a direction from a triplet of coordinates. status is 'nullvector' if coord.modulus() <= resolution from gp.

        Parameters
        ----------
        Xv: float
        Yv: float

        Return
        -------
        None

        Description
        -----------
        Creates a direction with its 3 cartesian coordinates. status is 'nullvector' if sqrt(xv*xv + yv*yv ) <= resolution.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Make a dir2d from gp <thedir> passing through 2 pnt <p1>,<p2>. status is 'confusedpoints' if <p1> and <p2> are confused. warning if an error occurs (that is, when isdone returns false), the status function returns: - gce_confusedpoints if points p1 and p2 are coincident, or - gce_nullvector if one of the following is less than or equal to gp::resolution(): - the magnitude of vector v, - the modulus of coord, - sqrt(xv*xv + yv*yv).

        """
        _gce.gce_MakeDir2d_swiginit(self, _gce.new_gce_MakeDir2d(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Dir2d

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeDir2d_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Dir2d

        Description
        -----------
        Returns the constructed unit vector. exceptions stdfail_notdone if no unit vector is constructed.

        """
        return _gce.gce_MakeDir2d_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeDir2d

# Register gce_MakeDir2d in _gce:
_gce.gce_MakeDir2d_swigregister(gce_MakeDir2d)
class gce_MakeElips(gce_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        A2: gp_Ax2
        MajorRadius: float
        MinorRadius: float

        Return
        -------
        None

        Description
        -----------
        The major radius of the ellipse is on the 'xaxis' and the minor radius is on the 'yaxis' of the ellipse. the 'xaxis' is defined with the 'xdirection' of a2 and the 'yaxis' is defined with the 'ydirection' of a2. warnings: it is not forbidden to create an ellipse with majorradius = minorradius.

        Parameters
        ----------
        S1: gp_Pnt
        S2: gp_Pnt
        Center: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Make an ellipse with its center and two points. warning the makeelips class does not prevent the construction of an ellipse where the majorradius is equal to the minorradius. if an error occurs (that is, when isdone returns false), the status function returns: - gce_invertradius if majorradius is less than minorradius; - gce_negativeradius if minorradius is less than 0.0; - gce_nullaxis if the points s1 and center are coincident; or - gce_invertaxis if: - the major radius computed with center and s1 is less than the minor radius computed with center, s1 and s2, or - center, s1 and s2 are collinear.

        """
        _gce.gce_MakeElips_swiginit(self, _gce.new_gce_MakeElips(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Elips

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeElips_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Elips

        Description
        -----------
        Returns the constructed ellipse. exceptions stdfail_notdone if no ellipse is constructed.

        """
        return _gce.gce_MakeElips_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeElips

# Register gce_MakeElips in _gce:
_gce.gce_MakeElips_swigregister(gce_MakeElips)
class gce_MakeElips2d(gce_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        MajorAxis: gp_Ax2d
        MajorRadius: float
        MinorRadius: float
        Sense: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Creates an ellipse with the major axis, the major and the minor radius. the location of the majoraxis is the center of the ellipse. the sense of parametrization is given by sense. it is possible to create an ellipse with majorradius = minorradius. the status is 'invertradius' if majorradius < minorradius or 'negativeradius' if minorradius < 0.0.

        Parameters
        ----------
        A: gp_Ax22d
        MajorRadius: float
        MinorRadius: float

        Return
        -------
        None

        Description
        -----------
        Axis defines the xaxis and yaxis of the ellipse which defines the origin and the sense of parametrization. creates an ellipse with the axisplacement the major and the minor radius. the location of axis is the center of the ellipse. it is possible to create an ellipse with majorradius = minorradius. the status is 'invertradius' if majorradius < minorradius or 'negativeradius' if minorradius < 0.0.

        Parameters
        ----------
        S1: gp_Pnt2d
        S2: gp_Pnt2d
        Center: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Makes an elips2d with its center and two points. the sense of parametrization is given by s1, s2, and center. depending on the constructor, the implicit orientation of the ellipse is: - the sense defined by a, - the sense defined by points center, s1 and s2, - the trigonometric sense if sense is not given or is true, or - the opposite if sense is false. it is possible to construct an ellipse where the major and minor radii are equal. warning if an error occurs (that is, when isdone returns false), the status function returns: - gce_invertradius if majorradius is less than minorradius, - gce_negativeradius if majorradius or minorradius is less than 0.0, - gce_nullaxis if points s1, s2 and center are collinear, or - gce_invertaxis if the major radius computed with center and s1 is less than the minor radius computed with center, s1 and s2.

        """
        _gce.gce_MakeElips2d_swiginit(self, _gce.new_gce_MakeElips2d(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Elips2d

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeElips2d_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Elips2d

        Description
        -----------
        Returns the constructed ellipse. exceptions stdfail_notdone if no ellipse is constructed.

        """
        return _gce.gce_MakeElips2d_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeElips2d

# Register gce_MakeElips2d in _gce:
_gce.gce_MakeElips2d_swigregister(gce_MakeElips2d)
class gce_MakeHypr(gce_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        A2: gp_Ax2
        MajorRadius: float
        MinorRadius: float

        Return
        -------
        None

        Description
        -----------
        A2 is the local coordinate system of the hyperbola. in the local coordinates system a2 the equation of the hyperbola is: x*x / majorradius*majorradius - y*y / minorradius*minorradius = 1.0 it is not forbidden to create an hyperbola with majorradius = minorradius. for the hyperbola the majorradius can be lower than the minorradius. the status is 'negativeradius' if majorradius < 0.0 and 'invertradius' if minorradius > majorradius.

        Parameters
        ----------
        S1: gp_Pnt
        S2: gp_Pnt
        Center: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Constructs a hyperbola - centered on the point center, where: - the plane of the hyperbola is defined by center, s1 and s2, - its major axis is defined by center and s1, - its major radius is the distance between center and s1, and - its minor radius is the distance between s2 and the major axis. warning if an error occurs (that is, when isdone returns false), the status function returns: - gce_negativeradius if majorradius is less than 0.0; - gce_invertradius if: - the major radius (computed with center, s1) is less than the minor radius (computed with center, s1 and s2), or - majorradius is less than minorradius; or - gce_colinearpoints if s1, s2 and center are collinear.

        """
        _gce.gce_MakeHypr_swiginit(self, _gce.new_gce_MakeHypr(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Hypr

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeHypr_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Hypr

        Description
        -----------
        Returns the constructed hyperbola. exceptions stdfail_notdone if no hyperbola is constructed.

        """
        return _gce.gce_MakeHypr_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeHypr

# Register gce_MakeHypr in _gce:
_gce.gce_MakeHypr_swigregister(gce_MakeHypr)
class gce_MakeHypr2d(gce_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        S1: gp_Pnt2d
        S2: gp_Pnt2d
        Center: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Constructs a hyperbola centered on the point center, where: - the major axis of the hyperbola is defined by center and point s1, - the major radius is the distance between center and s1, and - the minor radius is the distance between point s2 and the major axis.

        Parameters
        ----------
        MajorAxis: gp_Ax2d
        MajorRadius: float
        MinorRadius: float
        Sense: bool

        Return
        -------
        None

        Description
        -----------
        Constructs a hyperbola with major and minor radii majorradius and minorradius, where: - the center of the hyperbola is the origin of the axis majoraxis, and - the major axis is defined by majoraxis if sense is true, or the opposite axis to majoraxis if sense is false; or - centered on the origin of the coordinate system a, with major and minor radii majorradius and minorradius, where its major axis is the 'x axis' of a (a is the local coordinate system of the hyperbola).

        Parameters
        ----------
        A: gp_Ax22d
        MajorRadius: float
        MinorRadius: float

        Return
        -------
        None

        Description
        -----------
        Creates a hypr2d centered on the origin of the coordinate system a, with major and minor radii majorradius and minorradius, where its major axis is the 'x axis' of a (a is the local coordinate system of the hyperbola).

        """
        _gce.gce_MakeHypr2d_swiginit(self, _gce.new_gce_MakeHypr2d(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Hypr2d

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeHypr2d_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Hypr2d

        Description
        -----------
        Returns the constructed hyperbola. exceptions stdfail_notdone if no hyperbola is constructed.

        """
        return _gce.gce_MakeHypr2d_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeHypr2d

# Register gce_MakeHypr2d in _gce:
_gce.gce_MakeHypr2d_swigregister(gce_MakeHypr2d)
class gce_MakeLin(gce_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        A1: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Creates a line located along the axis a1.

        Parameters
        ----------
        P: gp_Pnt
        V: gp_Dir

        Return
        -------
        None

        Description
        -----------
        <p> is the location point (origin) of the line and <v> is the direction of the line.

        Parameters
        ----------
        Lin: gp_Lin
        Point: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Make a lin from gp <thelin> parallel to another lin <lin> and passing through a pnt <point>.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Make a lin from gp <thelin> passing through 2 pnt <p1>,<p2>. it returns false if <p1> and <p2> are confused.

        """
        _gce.gce_MakeLin_swiginit(self, _gce.new_gce_MakeLin(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Lin

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeLin_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Lin

        Description
        -----------
        Returns the constructed line. exceptions stdfail_notdone is raised if no line is constructed.

        """
        return _gce.gce_MakeLin_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeLin

# Register gce_MakeLin in _gce:
_gce.gce_MakeLin_swigregister(gce_MakeLin)
class gce_MakeLin2d(gce_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        A: gp_Ax2d

        Return
        -------
        None

        Description
        -----------
        Creates a line located with a.

        Parameters
        ----------
        P: gp_Pnt2d
        V: gp_Dir2d

        Return
        -------
        None

        Description
        -----------
        <p> is the location point (origin) of the line and <v> is the direction of the line.

        Parameters
        ----------
        A: float
        B: float
        C: float

        Return
        -------
        None

        Description
        -----------
        Creates the line from the equation a*x + b*y + c = 0.0 the status is 'nullaxis'if sqrt(a*a + b*b) <= resolution from gp.

        Parameters
        ----------
        Lin: gp_Lin2d
        Dist: float

        Return
        -------
        None

        Description
        -----------
        Make a lin2d from gp <thelin> parallel to another lin2d <lin> at a distance <dist>. if dist is greater than zero the result is on the right of the line <lin>, else the result is on the left of the line <lin>.

        Parameters
        ----------
        Lin: gp_Lin2d
        Point: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Make a lin2d from gp <thelin> parallel to another lin2d <lin> and passing through a pnt2d <point>.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Make a lin2d from gp <thelin> passing through 2 pnt2d <p1>,<p2>. it returns false if <p1> and <p2> are confused. warning if an error occurs (that is, when isdone returns false), the status function returns: - gce_nullaxis if sqrt(a*a + b*b) is less than or equal to gp::resolution(), or - gce_confusedpoints if points p1 and p2 are coincident.

        """
        _gce.gce_MakeLin2d_swiginit(self, _gce.new_gce_MakeLin2d(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Lin2d

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeLin2d_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Lin2d

        Description
        -----------
        Returns the constructed line. exceptions stdfail_notdone if no line is constructed.

        """
        return _gce.gce_MakeLin2d_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeLin2d

# Register gce_MakeLin2d in _gce:
_gce.gce_MakeLin2d_swigregister(gce_MakeLin2d)
class gce_MakeParab(gce_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        A2: gp_Ax2
        Focal: float

        Return
        -------
        None

        Description
        -----------
        --- purpose ; creates a parabola with its local coordinate system 'a2' and it's focal length 'focal'. the xdirection of a2 defines the axis of symmetry of the parabola. the ydirection of a2 is parallel to the directrix of the parabola. the location point of a2 is the vertex of the parabola the status is 'nullfocuslength' if focal < 0.0.

        Parameters
        ----------
        D: gp_Ax1
        F: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        D is the directrix of the parabola and f the focus point. the symmetry axis (xaxis) of the parabola is normal to the directrix and pass through the focus point f, but its location point is the vertex of the parabola. the yaxis of the parabola is parallel to d and its location point is the vertex of the parabola. the normal to the plane of the parabola is the cross product between the xaxis and the yaxis.

        """
        _gce.gce_MakeParab_swiginit(self, _gce.new_gce_MakeParab(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Parab

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeParab_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Parab

        Description
        -----------
        Returns the constructed parabola. exceptions stdfail_notdone if no parabola is constructed.

        """
        return _gce.gce_MakeParab_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeParab

# Register gce_MakeParab in _gce:
_gce.gce_MakeParab_swigregister(gce_MakeParab)
class gce_MakeParab2d(gce_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        MirrorAxis: gp_Ax2d
        Focal: float
        Sense: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Creates a parabola with its axis of symmetry ('mirroraxis') and its focal length. warnings: it is possible to have focal = 0. the status is 'nullfocallength' raised if focal < 0.0.

        Parameters
        ----------
        A: gp_Ax22d
        Focal: float

        Return
        -------
        None

        Description
        -----------
        Creates a parabola with its local coordinate system <a> and its focal length. warnings: it is possible to have focal = 0. the status is 'nullfocallength' raised if focal < 0.0.

        Parameters
        ----------
        D: gp_Ax2d
        F: gp_Pnt2d
        Sense: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Creates a parabola with the directrix and the focus point. the sense of parametrization is given by sense.

        Parameters
        ----------
        S1: gp_Pnt2d
        Center: gp_Pnt2d
        Sense: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Make an parab2d with s1 as the focal point and center as the apex of the parabola warning the makeparab2d class does not prevent the construction of a parabola with a null focal distance. if an error occurs (that is, when isdone returns false), the status function returns: - gce_nullfocuslength if focal is less than 0.0, or - gce_nullaxis if s1 and center are coincident.

        """
        _gce.gce_MakeParab2d_swiginit(self, _gce.new_gce_MakeParab2d(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Parab2d

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakeParab2d_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Parab2d

        Description
        -----------
        Returns the constructed parabola. exceptions stdfail_notdone if no parabola is constructed.

        """
        return _gce.gce_MakeParab2d_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakeParab2d

# Register gce_MakeParab2d in _gce:
_gce.gce_MakeParab2d_swigregister(gce_MakeParab2d)
class gce_MakePln(gce_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        A2: gp_Ax2

        Return
        -------
        None

        Description
        -----------
        The coordinate system of the plane is defined with the axis placement a2. the 'direction' of a2 defines the normal to the plane. the 'location' of a2 defines the location (origin) of the plane. the 'xdirection' and 'ydirection' of a2 define the 'xaxis' and the 'yaxis' of the plane used to parametrize the plane.

        Parameters
        ----------
        P: gp_Pnt
        V: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Creates a plane with the 'location' point <p> and the normal direction <v>.

        Parameters
        ----------
        A: float
        B: float
        C: float
        D: float

        Return
        -------
        None

        Description
        -----------
        Creates a plane from its cartesian equation: a * x + b * y + c * z + d = 0.0 //! the status is 'badequation' if sqrt (a*a + b*b + c*c) <= resolution from gp.

        Parameters
        ----------
        Pln: gp_Pln
        Point: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Make a pln from gp <thepln> parallel to another pln <pln> and passing through a pnt <point>.

        Parameters
        ----------
        Pln: gp_Pln
        Dist: float

        Return
        -------
        None

        Description
        -----------
        Make a pln from gp <thepln> parallel to another pln <pln> at the distance <dist> which can be greater or less than zero. in the first case the result is at the distance <dist> to the plane <pln> in the direction of the normal to <pln>. otherwise it is in the opposite direction.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Make a pln from gp <thepln> passing through 3 pnt <p1>,<p2>,<p3>. it returns false if <p1> <p2> <p3> are confused.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Make a pln from gp <thepln> perpendicular to the line passing through <p1>,<p2>. the status is 'confusedpoints' if <p1> <p2> are confused.

        Parameters
        ----------
        Axis: gp_Ax1

        Return
        -------
        None

        Description
        -----------
        Make a pln passing through the location of <axis>and normal to the direction of <axis>. warning - if an error occurs (that is, when isdone returns false), the status function returns: - gce_badequation if sqrt(a*a + b*b + c*c) is less than or equal to gp::resolution(), - gce_confusedpoints if p1 and p2 are coincident, or - gce_colinearpoints if p1, p2 and p3 are collinear.

        """
        _gce.gce_MakePln_swiginit(self, _gce.new_gce_MakePln(*args))

    def Operator(self, *args):
        r"""
        Return
        -------
        gp_Pln

        Description
        -----------
        No available documentation.

        """
        return _gce.gce_MakePln_Operator(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        gp_Pln

        Description
        -----------
        Returns the constructed plane. exceptions stdfail_notdone if no plane is constructed.

        """
        return _gce.gce_MakePln_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gce.delete_gce_MakePln

# Register gce_MakePln in _gce:
_gce.gce_MakePln_swigregister(gce_MakePln)



