/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import sun.awt.SunToolkit;
import sun.font.GlyphList;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.FontInfo;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.pipe.GlyphListPipe;
import sun.java2d.pipe.Region;
import sun.java2d.x11.X11SurfaceData;

public class X11TextRenderer
extends GlyphListPipe {
    @Override
    public void drawGlyphVector(SunGraphics2D sg2d, GlyphVector g, float x, float y) {
        FontRenderContext frc = g.getFontRenderContext();
        FontInfo info = sg2d.getGVFontInfo(g.getFont(), frc);
        switch (info.aaHint) {
            case 1: {
                super.drawGlyphVector(sg2d, g, x, y);
                return;
            }
            case 2: {
                SurfaceData cfr_ignored_0 = sg2d.surfaceData;
                SurfaceData.aaTextRenderer.drawGlyphVector(sg2d, g, x, y);
                return;
            }
            case 4: 
            case 6: {
                SurfaceData cfr_ignored_1 = sg2d.surfaceData;
                SurfaceData.lcdTextRenderer.drawGlyphVector(sg2d, g, x, y);
                return;
            }
        }
    }

    native void doDrawGlyphList(long var1, long var3, Region var5, GlyphList var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawGlyphList(SunGraphics2D sg2d, GlyphList gl) {
        SunToolkit.awtLock();
        try {
            X11SurfaceData x11sd = (X11SurfaceData)sg2d.surfaceData;
            Region clip = sg2d.getCompClip();
            long xgc = x11sd.getRenderGC(clip, 0, null, sg2d.pixel);
            this.doDrawGlyphList(x11sd.getNativeOps(), xgc, clip, gl);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    public X11TextRenderer traceWrap() {
        return new Tracer();
    }

    public static class Tracer
    extends X11TextRenderer {
        @Override
        void doDrawGlyphList(long dstData, long xgc, Region clip, GlyphList gl) {
            GraphicsPrimitive.tracePrimitive("X11DrawGlyphs");
            super.doDrawGlyphList(dstData, xgc, clip, gl);
        }
    }
}

