/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.ratelimit;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Random;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ad.NodeStateManager;
import org.opensearch.ad.breaker.ADCircuitBreakerService;
import org.opensearch.ad.ratelimit.QueuedRequest;
import org.opensearch.ad.ratelimit.RateLimitedRequestWorker;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.threadpool.ThreadPool;

public abstract class ConcurrentWorker<RequestType extends QueuedRequest>
extends RateLimitedRequestWorker<RequestType> {
    private static final Logger LOG = LogManager.getLogger(ConcurrentWorker.class);
    private Semaphore permits;
    private Instant lastExecuteTime;
    private Duration executionTtl;

    public ConcurrentWorker(String queueName, long heapSizeInBytes, int singleRequestSizeInBytes, Setting<Float> maxHeapPercentForQueueSetting, ClusterService clusterService, Random random, ADCircuitBreakerService adCircuitBreakerService, ThreadPool threadPool, Settings settings, float maxQueuedTaskRatio, Clock clock, float mediumSegmentPruneRatio, float lowSegmentPruneRatio, int maintenanceFreqConstant, Setting<Integer> concurrencySetting, Duration executionTtl, Duration stateTtl, NodeStateManager nodeStateManager) {
        super(queueName, heapSizeInBytes, singleRequestSizeInBytes, maxHeapPercentForQueueSetting, clusterService, random, adCircuitBreakerService, threadPool, settings, maxQueuedTaskRatio, clock, mediumSegmentPruneRatio, lowSegmentPruneRatio, maintenanceFreqConstant, stateTtl, nodeStateManager);
        this.permits = new Semaphore((Integer)concurrencySetting.get(settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(concurrencySetting, it -> {
            this.permits = new Semaphore((int)it);
        });
        this.lastExecuteTime = clock.instant();
        this.executionTtl = executionTtl;
    }

    @Override
    public void maintenance() {
        super.maintenance();
        if (this.lastExecuteTime.plus(this.executionTtl).isBefore(this.clock.instant()) && this.permits.availablePermits() == 0 && !this.isQueueEmpty()) {
            LOG.warn("previous execution has been running for too long.  Maybe there are bugs.");
            this.permits.release();
        }
    }

    @Override
    protected void triggerProcess() {
        this.threadPool.executor("ad-threadpool").execute(() -> {
            if (this.permits.tryAcquire()) {
                try {
                    this.lastExecuteTime = this.clock.instant();
                    this.execute(() -> {
                        this.permits.release();
                        this.process();
                    }, () -> this.permits.release());
                }
                catch (Exception e) {
                    this.permits.release();
                    throw e;
                }
            }
        });
    }

    protected abstract void execute(Runnable var1, Runnable var2);
}

