/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.regex.OpAtom;
import net.sf.saxon.regex.OpBOL;
import net.sf.saxon.regex.OpCapture;
import net.sf.saxon.regex.OpCharClass;
import net.sf.saxon.regex.OpRepeat;
import net.sf.saxon.regex.OpSequence;
import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.REFlags;
import net.sf.saxon.regex.RegexPrecondition;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntPredicateProxy;

public class REProgram {
    protected static final int OPT_HASBACKREFS = 1;
    protected static final int OPT_HASBOL = 2;
    protected Operation operation;
    protected REFlags flags;
    protected UnicodeString prefix;
    protected IntPredicateProxy initialCharClass;
    protected List<RegexPrecondition> preconditions = new ArrayList<RegexPrecondition>();
    protected int minimumLength = 0;
    protected int fixedLength = -1;
    protected int optimizationFlags;
    protected int maxParens = -1;
    protected int backtrackingLimit = -1;

    public REProgram(Operation operation, int parens, REFlags flags) {
        this.flags = flags;
        this.setOperation(operation);
        this.maxParens = parens;
    }

    private void setOperation(Operation operation) {
        this.operation = operation;
        this.optimizationFlags = 0;
        this.prefix = null;
        this.operation = operation.optimize(this, this.flags);
        if (operation instanceof OpSequence) {
            Operation first = ((OpSequence)operation).getOperations().get(0);
            if (first instanceof OpBOL) {
                this.optimizationFlags |= 2;
            } else if (first instanceof OpAtom) {
                this.prefix = ((OpAtom)first).getAtom();
            } else if (first instanceof OpCharClass) {
                this.initialCharClass = ((OpCharClass)first).getPredicate();
            }
            this.addPrecondition(operation, -1, 0);
        }
        this.minimumLength = operation.getMinimumMatchLength();
        this.fixedLength = operation.getMatchLength();
    }

    public void setBacktrackingLimit(int limit) {
        this.backtrackingLimit = limit;
    }

    public int getBacktrackingLimit() {
        return this.backtrackingLimit;
    }

    private void addPrecondition(Operation op, int fixedPosition, int minPosition) {
        if (op instanceof OpAtom || op instanceof OpCharClass) {
            this.preconditions.add(new RegexPrecondition(op, fixedPosition, minPosition));
        } else if (op instanceof OpRepeat && ((OpRepeat)op).min >= 1) {
            OpRepeat parent = (OpRepeat)op;
            Operation child = parent.op;
            if (child instanceof OpAtom || child instanceof OpCharClass) {
                if (parent.min == 1) {
                    this.preconditions.add(new RegexPrecondition(parent, fixedPosition, minPosition));
                } else {
                    OpRepeat parent2 = new OpRepeat(child, parent.min, parent.min, true);
                    this.preconditions.add(new RegexPrecondition(parent2, fixedPosition, minPosition));
                }
            } else {
                this.addPrecondition(child, fixedPosition, minPosition);
            }
        } else if (op instanceof OpCapture) {
            this.addPrecondition(((OpCapture)op).childOp, fixedPosition, minPosition);
        } else if (op instanceof OpSequence) {
            int fp = fixedPosition;
            int mp = minPosition;
            for (Operation o : ((OpSequence)op).getOperations()) {
                if (o instanceof OpBOL) {
                    fp = 0;
                }
                this.addPrecondition(o, fp, mp);
                fp = fp != -1 && o.getMatchLength() != -1 ? (fp += o.getMatchLength()) : -1;
                mp += o.getMinimumMatchLength();
            }
        }
    }

    public boolean isNullable() {
        int m = this.operation.matchesEmptyString();
        return (m & 7) != 0;
    }

    public UnicodeString getPrefix() {
        return this.prefix;
    }
}

