############################ Copyrights and license ############################
#                                                                              #
# Copyright 2023 Jonathan Leitschuh <Jonathan.Leitschuh@gmail.com>             #
#                                                                              #
# This file is part of PyGithub.                                               #
# http://pygithub.readthedocs.io/                                              #
#                                                                              #
# PyGithub is free software: you can redistribute it and/or modify it under    #
# the terms of the GNU Lesser General Public License as published by the Free  #
# Software Foundation, either version 3 of the License, or (at your option)    #
# any later version.                                                           #
#                                                                              #
# PyGithub is distributed in the hope that it will be useful, but WITHOUT ANY  #
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS    #
# FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more #
# details.                                                                     #
#                                                                              #
# You should have received a copy of the GNU Lesser General Public License     #
# along with PyGithub. If not, see <http://www.gnu.org/licenses/>.             #
#                                                                              #
################################################################################
from __future__ import annotations

from typing import Any

from github.GithubObject import Attribute, NonCompletableGithubObject, NotSet


class RepositoryAdvisoryVulnerabilityPackage(NonCompletableGithubObject):
    """
    This class represents an identifier for a package that is vulnerable tao  parent SecurityAdvisory.
    The reference can be found here https://docs.github.com/en/rest/security-advisories/repository-advisories
    """

    def _initAttributes(self) -> None:
        self._ecosystem: Attribute[str] = NotSet
        self._name: Attribute[str | None] = NotSet

    @property
    def ecosystem(self) -> str:
        """
        :type: string
        """
        return self._ecosystem.value

    @property
    def name(self) -> str | None:
        """
        :type: string or None
        """
        return self._name.value

    def _useAttributes(self, attributes: dict[str, Any]) -> None:
        if "ecosystem" in attributes:  # pragma no branch
            self._ecosystem = self._makeStringAttribute(attributes["ecosystem"])
        if "name" in attributes:  # pragma no branch
            self._name = self._makeStringAttribute(attributes["name"])
