# dhcpcd is a DHCP client
# See: https://roy.marples.name/projects/dhcpcd/index

complete -c dhcpcd -f -a "(__fish_print_interfaces)"

complete -c dhcpcd -l background -s b -d 'Background immediately'
complete -c dhcpcd -l script -s c -r -F -d 'Use given script instead of default hook'
complete -c dhcpcd -l duid -s D -d 'Use a DHCP Unique Identifier'
complete -c dhcpcd -l debug -s d -d 'Echo debug messages to stderr & syslog'
complete -c dhcpcd -l lastlease -s E -d 'Use last acquired lease if cannot obtain one'
complete -c dhcpcd -l lastleaseextend -d 'Use last acquired lease if cannot obtain one even if expired'
complete -c dhcpcd -l env -s e -x -d 'Push given value to environment for hooks'
complete -c dhcpcd -l reconfigure -s g -d 'Reapply configuration for each interface'
complete -c dhcpcd -l fqdn -s F -xa "disable none ptr both" -d 'Request DHCP server to update DNS using FQDN instead of hostname'
complete -c dhcpcd -l config -s f -r -F -d 'Specify config to load instead of /etc/dhcpcd.conf'
complete -c dhcpcd -l hostname -s h -x -d 'Send hostname to DHCP server'
complete -c dhcpcd -l clientid -s I -x -d 'Send given clientid'
complete -c dhcpcd -l vendorclassid -s i -x -d 'Override DHCPv4 vendorclassid field sent'
complete -c dhcpcd -l logfile -s j -r -F -d 'Write to specfied log file'
complete -c dhcpcd -l release -s k -d 'Release lease and de-configure interface'
complete -c dhcpcd -l leasetime -s l -x -d 'Request specific lease time in secs'
complete -c dhcpcd -l manager -s M -d 'Start dhcpcd in Manager mode'
complete -c dhcpcd -l metric -s m -x -d 'Set preferred interface based on given rank (lowest wins)'
complete -c dhcpcd -l rebind -s n -d 'Reload config and rebind specified interface'
complete -c dhcpcd -l renew -s N -d 'Renew existing addresses on specified interface'
complete -c dhcpcd -l option -s o -x -d 'Request DHCP option'
complete -c dhcpcd -l persistent -s p -d 'Keep configuration even when dhcpcd exits'
complete -c dhcpcd -l request -s r -x -d 'Request given address in DHCP DISCOVER message'
complete -c dhcpcd -l inform -s s -x -d 'Request given address in DHCP INFORM message'
complete -c dhcpcd -l inform6 -d 'Perform DHCPv6 Information Request'
complete -c dhcpcd -l static -s S -x -d 'Configure static DHCP value'
complete -c dhcpcd -l timeout -s t -x -d 'Timeout after seconds' -a '0\tForever 30\tDefault'
complete -c dhcpcd -l userclass -s u -x -d 'Tag DHCPv4 message with given userclass'
complete -c dhcpcd -l vendor -s v -x -d 'Add encapsulated vendor option'
complete -c dhcpcd -l version -d 'Show version and exit'
complete -c dhcpcd -s w -d 'Wait for address to be assigned before forking to background'
complete -c dhcpcd -l waitip -x -d 'Wait for address to be assigned before forking to background' -a '4\tIPv4 6\tIPv6'
complete -c dhcpcd -l exit -s x -d 'Exit dhcpcd process linked to given interface'
complete -c dhcpcd -l reboot -s y -x -d 'Allow reboot after secs'
complete -c dhcpcd -l oneshot -s 1 -d 'Exit after configuring an interface'
complete -c dhcpcd -l ipv4only -s 4 -d 'Configure IPv4 only'
complete -c dhcpcd -l ipv6only -s 6 -d 'Configure IPv6 only'
complete -c dhcpcd -l noarp -s A -d 'Don\'t request or claim the address by ARP'
complete -c dhcpcd -l nobackground -s B -d 'Don\'t run in the background'
complete -c dhcpcd -l nohook -s C -r -F -d 'Don\'t run this hook script'
complete -c dhcpcd -l nogateway -s G -d 'Don\'t set any default routes'
complete -c dhcpcd -l xidhwaddr -s H -d 'Use last four bytes of the MAC as the DHCP xid'
complete -c dhcpcd -l broadcast -s J -d 'Instructs DHCP server to broadcast replies back to the client'
complete -c dhcpcd -l nolink -s K -d 'Don\'t receive link messages for carrier status'
complete -c dhcpcd -l noipv4ll -s L -d 'Don\'t use IPv4LL'
complete -c dhcpcd -l nooption -s O -x -d 'Remove given option from the DHCP message'
complete -c dhcpcd -l printpidfile -s P -d 'Print the pidfile dhcpcd will use to stdout'
complete -c dhcpcd -l require -s Q -x -d 'Requires the option to be present in all DHCP messages'
complete -c dhcpcd -l quiet -s q -d 'Only warnings and errors will be displayed'
complete -c dhcpcd -l test -s T -d 'Call hooks with TEST reason to print DHCP variables'
complete -c dhcpcd -l dumplease -s U -d 'Dump current lease for the interface to stdout'
complete -c dhcpcd -l variables -s V -d 'Display hook variables'
complete -c dhcpcd -l whitelist -s W -x -d 'Only accept packets from given address'
complete -c dhcpcd -l blacklist -s X -d 'Ignore all packets from given address'
complete -c dhcpcd -l denyinterfaces -s Z -x -d 'Interface name must not match pattern'
complete -c dhcpcd -l allowinterfaces -s z -x -d 'Interface name must match pattern'
complete -c dhcpcd -l inactive -d 'Don\'t start any interfaces other than those specified'
complete -c dhcpcd -l configure -d 'Allows dhcpcd to configure the system'
complete -c dhcpcd -l noconfigure -d 'dhcpcd will not configure the system at all'
complete -c dhcpcd -l nodev -d 'Don\'t load any /dev management modules'
