/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.properties.HasName;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.freeplane.core.extension.Configurable;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.plugin.codeexplorer.connectors.CodeLinkController;
import org.freeplane.plugin.codeexplorer.dependencies.CodeDependency;
import org.freeplane.plugin.codeexplorer.map.AnnotationAttribute;
import org.freeplane.plugin.codeexplorer.map.ClassNode;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNodeLinks;
import org.freeplane.plugin.codeexplorer.task.AnnotationMatcher;
import org.freeplane.plugin.codeexplorer.task.DependencyJudge;

public abstract class CodeNode
extends NodeModel {
    protected final int subprojectIndex;

    static String formatClassCount(long classCount) {
        return " (" + classCount + (classCount == 1L ? " class)" : " classes)");
    }

    public static JavaClass findEnclosingNamedClass(JavaClass javaClass) {
        if (javaClass.isAnonymousClass()) {
            return CodeNode.findEnclosingNamedClass((JavaClass)javaClass.getEnclosingClass().get());
        }
        if (javaClass.isArray()) {
            return javaClass.getBaseComponentType();
        }
        return javaClass;
    }

    public static boolean hasValidTopLevelClass(JavaClass javaClass) {
        if (javaClass.isArray()) {
            return CodeNode.hasValidTopLevelClass(javaClass.getBaseComponentType());
        }
        if (javaClass.isTopLevelClass()) {
            return true;
        }
        JavaClass enclosingClass = (JavaClass)javaClass.getEnclosingClass().get();
        while (enclosingClass.getSource().equals(javaClass.getSource())) {
            if (enclosingClass.isTopLevelClass()) {
                return true;
            }
            enclosingClass = (JavaClass)javaClass.getEnclosingClass().get();
        }
        return false;
    }

    public static boolean hasValidTopLevelClasses(Dependency dependency) {
        return CodeNode.hasValidTopLevelClass(dependency.getOriginClass()) && CodeNode.hasValidTopLevelClass(dependency.getTargetClass());
    }

    static String idWithSubprojectIndex(String idWithoutIndex, int subprojectIndex) {
        return idWithoutIndex + "[" + subprojectIndex + "]";
    }

    static JavaClass getTargetNodeClass(Dependency dependency) {
        return CodeNode.findEnclosingNamedClass(dependency.getTargetClass());
    }

    static boolean isNamed(JavaClass jc) {
        return !jc.isAnonymousClass() && !jc.isArray();
    }

    private static boolean isTargetSourceKnown(Dependency dep) {
        return CodeNode.isClassSourceKnown(dep.getTargetClass());
    }

    private static boolean isOriginSourceKnown(Dependency dep) {
        return CodeNode.isClassSourceKnown(dep.getOriginClass());
    }

    static boolean isClassSourceKnown(JavaClass javaClass) {
        return javaClass.getSource().isPresent();
    }

    static boolean classesBelongToTheSamePackage(JavaClass first, JavaClass second) {
        return second.getPackage().equals(first.getPackage());
    }

    static boolean classesBelongToTheSamePackage(Dependency dependency) {
        return CodeNode.classesBelongToTheSamePackage(dependency.getOriginClass(), dependency.getTargetClass());
    }

    CodeNode(CodeMap map, int subprojectIndex) {
        super((MapModel)map);
        this.subprojectIndex = subprojectIndex;
    }

    void updateAnnotations(AnnotationMatcher annotationMatcher) {
        NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel((NodeModel)this);
        for (int row = attributes.getRowCount() - 1; row >= 0; --row) {
            if (!(attributes.getAttribute(row) instanceof AnnotationAttribute)) continue;
            attributes.getAttributes().remove(row);
            attributes.fireTableRowsDeleted((NodeModel)this, row, row);
        }
        if (!annotationMatcher.isEmpty()) {
            this.getAnnotations().forEach(annotation -> {
                String annotationName = ClassNode.nodeText(annotation.getRawType());
                annotation.getProperties().entrySet().stream().filter(attributeEntry -> annotationMatcher.matches((JavaAnnotation<?>)annotation, (String)attributeEntry.getKey())).forEach(attributeEntry -> this.addAnnotationAttributes(attributes, "@" + annotationName, (String)attributeEntry.getKey(), attributeEntry.getValue()));
                if (annotation.getProperties().isEmpty() && annotationMatcher.matches((HasName)annotation.getRawType())) {
                    this.addAnnotationAttributes(attributes, "@" + annotationName, "value", "");
                }
            });
            this.getInterfaces().forEach(javaInterface -> {
                JavaClass javaClass = javaInterface.toErasure();
                String interfaceName = ClassNode.nodeText(javaClass);
                if (annotationMatcher.matches((HasName)javaClass)) {
                    this.addAnnotationAttributes(attributes, "interface", "value", interfaceName);
                }
            });
        }
        this.getChildren().forEach(child -> ((CodeNode)((Object)child)).updateAnnotations(annotationMatcher));
    }

    private void addAnnotationAttributes(NodeAttributeTableModel attributes, String annotationName, String key, Object values) {
        Stream<Object> valueStream = values.getClass().isArray() ? Stream.of((Object[])values) : Stream.of(values);
        valueStream.forEach(value -> attributes.addRowNoUndo((NodeModel)this, (Attribute)new AnnotationAttribute(key.equals("value") ? annotationName : annotationName + "." + key, value)));
    }

    Set<? extends JavaAnnotation<? extends HasName>> getAnnotations() {
        return Collections.emptySet();
    }

    Set<JavaType> getInterfaces() {
        return Collections.emptySet();
    }

    public CodeMap getMap() {
        return (CodeMap)super.getMap();
    }

    public CodeNode getParentNode() {
        return (CodeNode)super.getParentNode();
    }

    String getCodeElementName() {
        return this.getCodeElement().getName();
    }

    void setIdWithIndex(String idWithoutIndex) {
        this.setID(this.idWithSubprojectIndex(idWithoutIndex));
    }

    String idWithSubprojectIndex(String idWithoutIndex) {
        return CodeNode.idWithSubprojectIndex(idWithoutIndex, this.subprojectIndex);
    }

    boolean belongsToSameSubproject(JavaClass javaClass) {
        return CodeNode.hasValidTopLevelClass(javaClass) && this.validClassBelongsToSameSubproject(javaClass);
    }

    private boolean validClassBelongsToSameSubproject(JavaClass javaClass) {
        int anotherSubprojectIndex = this.subprojectIndexOf(javaClass);
        return anotherSubprojectIndex == this.subprojectIndex;
    }

    int subprojectIndexOf(JavaClass javaClass) {
        return this.getMap().subprojectIndexOf(javaClass);
    }

    boolean belongsToOtherSubproject(JavaClass javaClass) {
        return CodeNode.hasValidTopLevelClass(javaClass) && !this.validClassBelongsToSameSubproject(javaClass);
    }

    abstract HasName getCodeElement();

    Set<CodeNode> findCyclicDependencies() {
        return Collections.emptySet();
    }

    abstract Stream<Dependency> getOutgoingDependencies();

    abstract Stream<Dependency> getIncomingDependencies();

    abstract String getUIIconName();

    Stream<Dependency> getIncomingAndOutgoingDependencies() {
        return Stream.concat(this.getIncomingDependencies(), this.getOutgoingDependencies());
    }

    public Stream<Dependency> getOutgoingDependenciesWithKnownTargets() {
        return this.getOutgoingDependencies().filter(CodeNode::isTargetSourceKnown);
    }

    public Stream<Dependency> getIncomingDependenciesWithKnownOrigins() {
        return this.getIncomingDependencies().filter(CodeNode::isOriginSourceKnown);
    }

    Stream<Dependency> getIncomingAndOutgoingDependenciesWithKnownTargets() {
        return Stream.concat(this.getIncomingDependenciesWithKnownOrigins(), this.getOutgoingDependenciesWithKnownTargets());
    }

    public Stream<Dependency> getOutgoingDependenciesWithKnownTargets(Filter filter) {
        return this.getOutgoingDependenciesWithKnownTargets().filter(dep -> this.getMap().getNodeByClass(dep.getOriginClass()).isVisible(filter));
    }

    public Stream<Dependency> getIncomingDependenciesWithKnownOrigins(Filter filter) {
        return this.getIncomingDependenciesWithKnownOrigins().filter(dep -> this.getMap().getNodeByClass(dep.getTargetClass()).isVisible(filter));
    }

    Stream<Dependency> getIncomingAndOutgoingDependenciesWithKnownTargets(Filter filter) {
        return Stream.concat(this.getIncomingDependenciesWithKnownOrigins(filter), this.getOutgoingDependenciesWithKnownTargets(filter));
    }

    public List<NamedIcon> getIcons() {
        UIIcon uiIcon = IconStoreFactory.ICON_STORE.getUIIcon(this.getUIIconName());
        return Collections.singletonList(uiIcon);
    }

    public Stream<CodeDependency> outgoingCodeDependenciesWithKnownTargets() {
        MemoizedCodeDependencies extension = this.getExtension(MemoizedCodeDependencies.class);
        if (extension != null) {
            return extension.outgoing();
        }
        if (this.getParentNode() == null || this.getParentNode().getChildCount() <= 40) {
            return this.collectOutgoingCodeDependenciesWithKnownTargets();
        }
        return this.memoizeCodeDependencies().outgoing();
    }

    private Stream<CodeDependency> collectOutgoingCodeDependenciesWithKnownTargets() {
        return ((Stream)this.getOutgoingDependenciesWithKnownTargets().parallel()).map(this.getMap()::toCodeDependency);
    }

    public Stream<CodeDependency> incomingCodeDependenciesWithKnownOrigins() {
        MemoizedCodeDependencies extension = this.getExtension(MemoizedCodeDependencies.class);
        if (extension != null) {
            return extension.incoming();
        }
        if (this.getParentNode() == null || this.getParentNode().getChildCount() <= 40) {
            return this.collectIncomingCodeDependenciesWithKnownOrigins();
        }
        return this.memoizeCodeDependencies().incoming();
    }

    MemoizedCodeDependencies memoizeCodeDependencies() {
        MemoizedCodeDependencies extension = new MemoizedCodeDependencies();
        this.addExtension(extension);
        return extension;
    }

    private Stream<CodeDependency> collectIncomingCodeDependenciesWithKnownOrigins() {
        return ((Stream)this.getIncomingDependenciesWithKnownOrigins().parallel()).map(this.getMap()::toCodeDependency);
    }

    public static Optional<String> classSourceLocationOf(JavaClass javaClass) {
        return javaClass.getSource().map(s -> {
            URI uri = s.getUri();
            String path = uri.getRawPath();
            String classLocation = path != null ? path : uri.getSchemeSpecificPart();
            String classSourceLocation = classLocation.substring(0, classLocation.length() - javaClass.getName().length() - ".class".length());
            return classSourceLocation;
        });
    }

    public <T extends IExtension> T getExtension(Class<T> clazz) {
        if (NodeLinks.class.equals(clazz)) {
            ModeController controller = Controller.getCurrentModeController();
            if (!controller.getModeName().equals("CodeExplorer")) {
                return null;
            }
            Configurable mapViewComponent = controller.getController().getMapViewManager().getMapViewConfiguration();
            if (mapViewComponent != null) {
                return (T)((Object)new CodeNodeLinks((CodeLinkController)controller.getExtension(LinkController.class), mapViewComponent, this));
            }
        }
        return (T)super.getExtension(clazz);
    }

    void setInitialFoldingState() {
        if (this.getParentNode().getChildCount() > 1 && this.getChildCount() > 0) {
            this.setFolded(true);
        }
    }

    private class MemoizedCodeDependencies
    implements IExtension {
        DependencyJudge judge;
        CodeDependency[] incoming;
        CodeDependency[] outgoing;

        MemoizedCodeDependencies() {
            this.update();
        }

        private void update() {
            DependencyJudge currentJudge = CodeNode.this.getMap().getJudge();
            if (this.judge != currentJudge) {
                this.judge = currentJudge;
                this.incoming = (CodeDependency[])CodeNode.this.collectIncomingCodeDependenciesWithKnownOrigins().toArray(CodeDependency[]::new);
                this.outgoing = (CodeDependency[])CodeNode.this.collectOutgoingCodeDependenciesWithKnownTargets().toArray(CodeDependency[]::new);
            }
        }

        Stream<CodeDependency> incoming() {
            this.update();
            return (Stream)Stream.of(this.incoming).parallel();
        }

        Stream<CodeDependency> outgoing() {
            this.update();
            return (Stream)Stream.of(this.outgoing).parallel();
        }
    }
}

