/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import java.awt.event.ActionEvent;
import java.util.Set;
import java.util.stream.Collectors;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.codeexplorer.map.AncestorsHider;
import org.freeplane.plugin.codeexplorer.map.DependencySelection;
import org.freeplane.plugin.codeexplorer.map.DependencySnapshotCondition;

class ShowSelectedClassesWithExternalDependenciesAction
extends AFreeplaneAction {
    public ShowSelectedClassesWithExternalDependenciesAction() {
        super("code.ShowSelectedClassesWithExternalDependenciesAction");
    }

    public void actionPerformed(ActionEvent e) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        DependencySelection dependencySelection = new DependencySelection(selection);
        Set<String> dependentNodeIDs = dependencySelection.getSelectedClasses().stream().map(dependencySelection.getMap()::getClassNodeId).collect(Collectors.toSet());
        if (dependentNodeIDs.isEmpty()) {
            return;
        }
        DependencySnapshotCondition condition = new DependencySnapshotCondition(dependentNodeIDs);
        Filter lastFilter = selection.getFilter();
        Filter filter = new Filter((ICondition)condition, false, true, lastFilter.areDescendantsShown(), false, null);
        FilterController filterController = FilterController.getCurrentFilterController();
        filterController.applyFilter(selection.getMap(), false, filter);
        if (!lastFilter.areAncestorsShown()) {
            AncestorsHider.hideAncestors();
        }
    }
}

