/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.task;

import com.tngtech.archunit.core.domain.JavaClass;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.task.LocationMatcher;

public class DirectoryMatcher
implements LocationMatcher {
    public static final DirectoryMatcher ALLOW_ALL = new DirectoryMatcher(Collections.emptyList(), Collections.emptyList());
    private final SortedMap<String, String> coreLocationsByPaths;
    private final Collection<File> locations;
    private final Collection<String> subpaths;

    public DirectoryMatcher(Collection<File> locations, Collection<String> subpaths) {
        this.locations = locations;
        this.subpaths = subpaths;
        this.coreLocationsByPaths = new TreeMap<String, String>();
        this.findDirectories((directory, location) -> this.coreLocationsByPaths.put(directory.toURI().getRawPath(), location.toURI().getRawPath()));
    }

    private void findDirectories(BiConsumer<File, File> consumer) {
        for (File location : this.locations) {
            if (location.isDirectory()) {
                for (String subPath : this.subpaths.isEmpty() ? this.defaultSubpaths(location) : this.subpaths) {
                    File directory = subPath.equals(".") ? location : new File(location, subPath);
                    if (!directory.isDirectory()) continue;
                    consumer.accept(directory, location);
                }
                continue;
            }
            consumer.accept(location, location);
        }
    }

    private List<String> defaultSubpaths(File location) {
        if (new File(location, "pom.xml").exists()) {
            return Collections.singletonList("target/classes");
        }
        if (new File(location, "build.gradle").exists()) {
            return Collections.singletonList("build/classes");
        }
        return Collections.singletonList(".");
    }

    @Override
    public Optional<String> coreLocationPath(JavaClass javaClass) {
        Optional<String> optionalPath = CodeNode.classSourceLocationOf(javaClass);
        return optionalPath.map(path -> this.coreLocationsByPaths.getOrDefault(path, (String)path));
    }

    public Collection<File> getImportedLocations() {
        ArrayList<File> importedLocations = new ArrayList<File>();
        this.findDirectories((importedLocation, location) -> importedLocations.add((File)importedLocation));
        return importedLocations;
    }

    public List<String> getFoundLocations(String location) {
        ArrayList<String> foundLocations = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.coreLocationsByPaths.tailMap(location).entrySet()) {
            if (!entry.getValue().equals(location)) break;
            foundLocations.add(entry.getKey());
        }
        return foundLocations;
    }
}

