/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.task;

import com.google.gson.annotations.SerializedName;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.importer.ClassFileImporter;
import com.tngtech.archunit.core.importer.Location;
import com.tngtech.archunit.thirdparty.com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.freeplane.core.util.LogUtils;
import org.freeplane.plugin.codeexplorer.task.AnnotationMatcher;
import org.freeplane.plugin.codeexplorer.task.CodeAttributeConfiguration;
import org.freeplane.plugin.codeexplorer.task.CodeExplorerConfiguration;
import org.freeplane.plugin.codeexplorer.task.CodeNodeUserContent;
import org.freeplane.plugin.codeexplorer.task.ConfigurationChange;
import org.freeplane.plugin.codeexplorer.task.DependencyJudge;
import org.freeplane.plugin.codeexplorer.task.DirectoryMatcher;
import org.freeplane.plugin.codeexplorer.task.ParsedConfiguration;

public class UserDefinedCodeExplorerConfiguration
implements CodeExplorerConfiguration {
    @SerializedName(value="projectName")
    private String projectName;
    @SerializedName(value="locations")
    private Set<File> projectLocations;
    @SerializedName(value="userContent")
    private final Map<String, SortedSet<CodeNodeUserContent>> userContent;
    @SerializedName(value="configurationRules", alternate={"dependencyJudgeRules"})
    private String configurationRules;
    private transient ParsedConfiguration parsedConfiguration;
    @SerializedName(value="attributeConfiguration")
    private CodeAttributeConfiguration attributeConfiguration;

    public UserDefinedCodeExplorerConfiguration() {
        this("", new ArrayList<File>(), "");
    }

    @VisibleForTesting
    UserDefinedCodeExplorerConfiguration(String projectName, List<File> locations, String dependencyJudgeRules) {
        this.projectName = projectName;
        this.projectLocations = locations.stream().map(File::getAbsolutePath).map(File::new).collect(Collectors.toCollection(LinkedHashSet::new));
        this.applyConfigurationRules("");
        if (!dependencyJudgeRules.isEmpty()) {
            try {
                this.applyConfigurationRules(dependencyJudgeRules);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.userContent = new TreeMap<String, SortedSet<CodeNodeUserContent>>();
        this.attributeConfiguration = new CodeAttributeConfiguration();
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void removeAllLocations() {
        this.projectLocations.clear();
    }

    public String getConfigurationRules() {
        return this.configurationRules;
    }

    void initialize() {
        try {
            this.userContent.values().stream().flatMap(Collection::stream).forEach(CodeNodeUserContent::initialize);
            this.applyConfigurationRules(this.configurationRules);
            if (this.attributeConfiguration == null) {
                this.attributeConfiguration = new CodeAttributeConfiguration();
            }
            this.attributeConfiguration.initialize();
        }
        catch (Exception e) {
            this.configurationRules = "";
        }
    }

    public ConfigurationChange applyConfigurationRules(String configurationRules) {
        ParsedConfiguration newConfiguration = new ParsedConfiguration(configurationRules);
        ConfigurationChange status = newConfiguration.configurationChange(this.parsedConfiguration);
        this.configurationRules = configurationRules;
        this.parsedConfiguration = newConfiguration;
        return status;
    }

    @Override
    public DependencyJudge getDependencyJudge() {
        return this.parsedConfiguration.judge();
    }

    @Override
    public AnnotationMatcher getAnnotationMatcher() {
        return this.parsedConfiguration.annotationMatcher();
    }

    @Override
    public JavaClasses importClasses() {
        DirectoryMatcher directoryMatcher = this.createLocationMatcher();
        Collection locations = directoryMatcher.getImportedLocations().stream().map(File::toURI).map(Location::of).collect(Collectors.toList());
        ClassFileImporter classFileImporter = new ClassFileImporter().withImportOption(this.parsedConfiguration.importOption());
        LogUtils.info((String)("Starting import from " + locations.size() + " locations"));
        JavaClasses importedClasses = classFileImporter.importLocations(locations);
        LogUtils.info((String)"Import done");
        return importedClasses;
    }

    @Override
    public DirectoryMatcher createLocationMatcher() {
        return this.parsedConfiguration.directoryMatcher(this.projectLocations);
    }

    public void addLocation(File file) {
        this.projectLocations.add(new File(file.getAbsolutePath()));
    }

    public void addLocation(String path) {
        this.addLocation(new File(path));
    }

    @Override
    public int countLocations() {
        return this.projectLocations.size();
    }

    public boolean containsLocation(String path) {
        return this.projectLocations.contains(new File(path).getAbsoluteFile());
    }

    public boolean removeLocation(String path) {
        return this.projectLocations.remove(new File(path).getAbsoluteFile());
    }

    public Collection<File> getLocations() {
        return this.projectLocations;
    }

    public void removeUserContent() {
        this.userContent.clear();
    }

    public void addUserContent(String location, CodeNodeUserContent content) {
        this.userContent.computeIfAbsent(location, x -> new TreeSet()).add(content);
    }

    public Map<String, SortedSet<CodeNodeUserContent>> getUserContent() {
        return this.userContent;
    }

    public CodeAttributeConfiguration getAttributeConfiguration() {
        return this.attributeConfiguration;
    }

    @Override
    public boolean canBeSaved() {
        return true;
    }
}

