/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.bugreport;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.resizer.UIComponentVisibilityDispatcher;
import org.freeplane.core.ui.sounds.SoundClipPlayer;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.ViewController;
import org.freeplane.plugin.bugreport.BugFormatter;
import org.freeplane.plugin.bugreport.BugReportDialogManager;
import org.freeplane.plugin.bugreport.IBugReportListener;
import org.freeplane.plugin.bugreport.ReportRegistry;

public class ReportGenerator
extends StreamHandler {
    private static final String BUGREPORT_USER_ID = "org.freeplane.plugin.bugreport.userid";
    private static final String REMOTE_LOG = "RemoteLog";
    private static final String NO_REPORTS_SENT_BEFORE = "no reports sent before";
    static final String LAST_BUG_REPORT_INFO = "last_bug_report_info";
    private static final String BUG_TRACKER_REFERENCE_URL = "https://www.freeplane.org/info/bugtracker.ref.txt";
    private static String BUG_TRACKER_URL = null;
    static boolean isDisabled = false;
    private static int errorCounter = 0;
    private static String info;
    private static final String OPTION = "org.freeplane.plugin.bugreport";
    private static ByteArrayOutputStream out;
    private static String version;
    private static String revision;
    private String hash = null;
    private String log = null;
    private MessageDigest md = null;
    private boolean isReportGenerationInProgress = false;
    private IBugReportListener bugReportListener;
    private JButton logButton;

    private static String toHexString(byte[] v) {
        String HEX_DIGITS = "0123456789abcdef";
        StringBuffer sb = new StringBuffer(v.length * 2);
        for (int i = 0; i < v.length; ++i) {
            int b = v[i] & 0xFF;
            sb.append("0123456789abcdef".charAt(b >>> 4)).append("0123456789abcdef".charAt(b & 0xF));
        }
        return sb.toString();
    }

    public IBugReportListener getBugReportListener() {
        return this.bugReportListener;
    }

    public void setBugReportListener(IBugReportListener bugReportListener) {
        this.bugReportListener = bugReportListener;
    }

    public ReportGenerator() {
        try {
            this.setEncoding("UTF-8");
        }
        catch (SecurityException securityException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.setFormatter(new BugFormatter());
        this.setLevel(Level.SEVERE);
    }

    private String calculateHash(String errorMessage) {
        String[] lines = errorMessage.split("\n");
        StringBuffer hashInput = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            String s = lines[i];
            if (!s.startsWith("\tat org.freeplane.") && !s.startsWith("missing key ")) continue;
            hashInput.append(s);
        }
        if (hashInput.length() == 0) {
            return null;
        }
        hashInput.append(version);
        hashInput.append(revision);
        try {
            return this.calculateHash(hashInput.toString().getBytes(this.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private String calculateHash(byte[] byteArray) {
        try {
            if (this.md == null) {
                this.md = MessageDigest.getInstance("MD5");
            }
            byte[] digest = this.md.digest(byteArray);
            return ReportGenerator.toHexString(digest);
        }
        catch (Exception e) {
            LogUtils.warn((Throwable)e);
            return null;
        }
    }

    private void createInfo() {
        if (info == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("freeplane_version = ");
            version = FreeplaneVersion.getVersion().toString();
            sb.append(version);
            sb.append("; freeplane_xml_version = ");
            sb.append("freeplane 1.11.5");
            revision = FreeplaneVersion.getVersion().getRevision();
            if (!revision.equals("")) {
                sb.append("\ngit revision = ");
                sb.append(revision);
            }
            sb.append("\njava_version = ");
            sb.append(System.getProperty("java.version"));
            sb.append("; os_name = ");
            sb.append(System.getProperty("os.name"));
            sb.append("; os_version = ");
            sb.append(System.getProperty("os.version"));
            sb.append('\n');
            info = sb.toString();
        }
    }

    private String getBugTrackerUrl() {
        if (BUG_TRACKER_URL != null) {
            return BUG_TRACKER_URL;
        }
        try {
            URL url = new URL(BUG_TRACKER_REFERENCE_URL);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream(), StandardCharsets.UTF_8));
            BUG_TRACKER_URL = in.readLine();
            return BUG_TRACKER_URL;
        }
        catch (Exception e) {
            isDisabled = true;
            return null;
        }
    }

    @Override
    public synchronized void publish(LogRecord record) {
        Controller controller = Controller.getCurrentController();
        if (controller == null) {
            return;
        }
        final ViewController viewController = controller.getViewController();
        if (viewController == null) {
            return;
        }
        if (out == null) {
            out = new ByteArrayOutputStream();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ReportGenerator.this.setOutputStream(out);
                    return null;
                }
            });
        }
        if (!this.isLoggable(record)) {
            return;
        }
        if (!this.isReportGenerationInProgress) {
            if (this.isExcluded(record)) {
                return;
            }
            this.isReportGenerationInProgress = true;
            viewController.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        errorCounter++;
                        if (TextUtils.getRawText((String)"internal_error.tooltip", null) != null) {
                            if (ReportGenerator.this.logButton == null) {
                                Icon errorIcon = ResourceController.getResourceController().getIcon("warning_icon");
                                ReportGenerator.this.logButton = new JButton();
                                ReportGenerator.this.logButton.addActionListener(new LogOpener());
                                ReportGenerator.this.logButton.setIcon(errorIcon);
                                String tooltip = TextUtils.getText((String)"internal_error.tooltip");
                                ReportGenerator.this.logButton.setToolTipText(tooltip);
                                viewController.addStatusComponent("internal_error", (Component)ReportGenerator.this.logButton);
                            }
                            ReportGenerator.this.logButton.setText(TextUtils.format((String)"errornumber", (Object[])new Object[]{errorCounter}));
                            JComponent statusBar = viewController.getStatusBar();
                            if (!statusBar.isVisible()) {
                                UIComponentVisibilityDispatcher.of((JComponent)statusBar).setVisible(true);
                            }
                            SoundClipPlayer.playSound((String)"error");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ReportGenerator.this.runSubmitAfterTimeout();
                }
            });
        }
        if (!isDisabled) {
            super.publish(record);
        }
    }

    private boolean isExcluded(LogRecord record) {
        Throwable thrown = record.getThrown();
        if (thrown == null) {
            return false;
        }
        StackTraceElement[] stackTrace = thrown.getStackTrace();
        if (stackTrace == null) {
            return false;
        }
        return this.classNameStartsWith(stackTrace, 0, "org.codehaus.groovy.runtime");
    }

    private boolean classNameStartsWith(StackTraceElement[] stackTrace, int position, String classNameStart) {
        if (stackTrace.length <= position) {
            return false;
        }
        StackTraceElement stackTraceElement = stackTrace[position];
        String className = stackTraceElement.getClassName();
        return className.startsWith(classNameStart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSubmit() {
        try {
            this.close();
            String errorMessage = out.toString(this.getEncoding());
            if (errorMessage.indexOf(this.getClass().getPackage().getName()) != -1) {
                System.err.println("don't send bug reports from bugreport plugin");
                return;
            }
            this.createInfo();
            this.hash = this.calculateHash(errorMessage);
            if (this.hash == null) {
                return;
            }
            String reportHeader = this.createReportHeader();
            StringBuilder sb = new StringBuilder();
            sb.append(reportHeader).append('\n').append("previous report : ");
            String lastReportInfo = ResourceController.getResourceController().getProperty(LAST_BUG_REPORT_INFO, NO_REPORTS_SENT_BEFORE);
            sb.append(lastReportInfo).append('\n');
            String userId = ResourceController.getResourceController().getProperty(BUGREPORT_USER_ID);
            if (userId.length() > 0) {
                sb.append("user : ").append(userId).append('\n');
            }
            sb.append(info);
            sb.append(errorMessage);
            this.log = sb.toString();
            if (this.log.equals("")) {
                return;
            }
            ReportRegistry register = ReportRegistry.getInstance();
            if (register.isReportRegistered(this.hash)) {
                return;
            }
            String option = this.showBugReportDialog();
            if ("org.freeplane.plugin.bugreport.allowed".equals(option)) {
                register.registerReport(this.hash, reportHeader);
                final LinkedHashMap<String, String> report = new LinkedHashMap<String, String>();
                report.put("hash", this.hash);
                report.put("log", this.log);
                report.put("version", version);
                report.put("revision", revision);
                String status = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        String status = ReportGenerator.this.sendReport(report);
                        return status;
                    }
                });
                if (this.bugReportListener != null && status != null) {
                    this.bugReportListener.onReportSent(report, status);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            LogUtils.severe((Throwable)e);
        }
        finally {
            out = null;
            this.isReportGenerationInProgress = false;
        }
    }

    private String createReportHeader() {
        SimpleDateFormat dateFormatGmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormatGmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        String time = dateFormatGmt.format(new Date());
        String currentReportInfo = "at " + time + " CMT,  hash " + this.hash;
        return currentReportInfo;
    }

    private String showBugReportDialog() {
        ResourceController resourceController = ResourceController.getResourceController();
        String option = resourceController.getProperty(OPTION, "org.freeplane.plugin.bugreport.ask");
        if (option.equals("org.freeplane.plugin.bugreport.ask")) {
            if (resourceController.getBooleanProperty("org.freeplane.plugin.bugreport.dialog.disabled") || GraphicsEnvironment.isHeadless()) {
                return "org.freeplane.plugin.bugreport.denied";
            }
            String question = TextUtils.getText((String)"org.freeplane.plugin.bugreport.question");
            if (!HtmlUtils.isHtml((String)question)) {
                question = HtmlUtils.plainToHTML((String)question);
            }
            Object[] options = new Object[]{TextUtils.getText((String)"org.freeplane.plugin.bugreport.always_agree"), TextUtils.getText((String)"org.freeplane.plugin.bugreport.agree"), TextUtils.getText((String)"org.freeplane.plugin.bugreport.deny"), TextUtils.getText((String)"org.freeplane.plugin.bugreport.always_deny")};
            String title = TextUtils.getText((String)"org.freeplane.plugin.bugreport.dialog.title");
            String reportName = TextUtils.getText((String)"org.freeplane.plugin.bugreport.report");
            int choice = BugReportDialogManager.showBugReportDialog(title, question, 1, options, options[1], reportName, this.log);
            switch (choice) {
                case 0: {
                    option = "org.freeplane.plugin.bugreport.allowed";
                    resourceController.setProperty(OPTION, option);
                    break;
                }
                case 1: {
                    option = "org.freeplane.plugin.bugreport.allowed";
                    break;
                }
                case 2: {
                    option = "org.freeplane.plugin.bugreport.denied";
                    break;
                }
                case 3: {
                    option = "org.freeplane.plugin.bugreport.denied";
                    resourceController.setProperty(OPTION, option);
                    break;
                }
                default: {
                    option = "org.freeplane.plugin.bugreport.denied";
                }
            }
        }
        return option;
    }

    private String sendReport(Map<String, String> reportFields) {
        String string;
        StringBuilder data = new StringBuilder();
        for (Map.Entry<String, String> entry : reportFields.entrySet()) {
            if (data.length() != 0) {
                data.append('&');
            }
            data.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            data.append('=');
            data.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        URL url = new URL(this.getBugTrackerUrl());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        String report = data.toString();
        try (OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);){
            wr.write(report);
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
        try {
            String line = rd.readLine();
            if (line != null) {
                System.out.println(line);
            }
            string = line;
        }
        catch (Throwable throwable) {
            try {
                try {
                    rd.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        rd.close();
        return string;
    }

    private void runSubmitAfterTimeout() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Controller.getCurrentController().getViewController().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!isDisabled) {
                            Thread submitterThread = new Thread((Runnable)new SubmitRunner(), ReportGenerator.REMOTE_LOG);
                            submitterThread.start();
                        } else {
                            ReportGenerator.this.isReportGenerationInProgress = false;
                        }
                    }
                });
            }
        }).start();
    }

    static {
        out = null;
    }

    private static class LogOpener
    implements ActionListener {
        private LogOpener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String freeplaneLogDirectoryPath = LogUtils.getLogDirectory();
            File file = new File(freeplaneLogDirectoryPath);
            if (file.isDirectory()) {
                ViewController viewController = Controller.getCurrentController().getViewController();
                try {
                    viewController.openDocument(file.toURL());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class SubmitRunner
    implements Runnable {
        @Override
        public void run() {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ReportGenerator.this.runSubmit();
                    return null;
                }
            });
        }
    }
}

