// Generated by gmmproc 2.66.6 -- DO NOT MODIFY!
#ifndef _GDKMM_SEAT_H
#define _GDKMM_SEAT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2015 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <vector>
#include <glibmm/object.h>
#include <gdkmm/cursor.h>
#include <gdkmm/device.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GdkSeat = struct _GdkSeat;
using GdkSeatClass = struct _GdkSeatClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gdk
{ class GDKMM_API Seat_Class; } // namespace Gdk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gdk
{
/** @addtogroup gdkmmEnums gdkmm Enums and Flags */

/** 
 *  @var SeatCapabilities SEAT_CAPABILITY_NONE
 * No input capabilities.
 * 
 *  @var SeatCapabilities SEAT_CAPABILITY_POINTER
 * The seat has a pointer (e.g. mouse).
 * 
 *  @var SeatCapabilities SEAT_CAPABILITY_TOUCH
 * The seat has touchscreen(s) attached.
 * 
 *  @var SeatCapabilities SEAT_CAPABILITY_TABLET_STYLUS
 * The seat has drawing tablet(s) attached.
 * 
 *  @var SeatCapabilities SEAT_CAPABILITY_KEYBOARD
 * The seat has keyboard(s) attached.
 * 
 *  @var SeatCapabilities SEAT_CAPABILITY_ALL_POINTING
 * The union of all pointing capabilities.
 * 
 *  @var SeatCapabilities SEAT_CAPABILITY_ALL
 * The union of all capabilities.
 * 
 *  @enum SeatCapabilities
 * 
 * Flags describing the seat capabilities.
 * 
 * @newin{3,20}
 *
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%SeatCapabilities operator|(SeatCapabilities, SeatCapabilities)</tt><br>
 * <tt>%SeatCapabilities operator&(SeatCapabilities, SeatCapabilities)</tt><br>
 * <tt>%SeatCapabilities operator^(SeatCapabilities, SeatCapabilities)</tt><br>
 * <tt>%SeatCapabilities operator~(SeatCapabilities)</tt><br>
 * <tt>%SeatCapabilities& operator|=(SeatCapabilities&, SeatCapabilities)</tt><br>
 * <tt>%SeatCapabilities& operator&=(SeatCapabilities&, SeatCapabilities)</tt><br>
 * <tt>%SeatCapabilities& operator^=(SeatCapabilities&, SeatCapabilities)</tt><br>
 */
enum SeatCapabilities
{
  SEAT_CAPABILITY_NONE = 0x0,
  SEAT_CAPABILITY_POINTER = 1 << 0,
  SEAT_CAPABILITY_TOUCH = 1 << 1,
  SEAT_CAPABILITY_TABLET_STYLUS = 1 << 2,
  SEAT_CAPABILITY_KEYBOARD = 1 << 3,
  SEAT_CAPABILITY_ALL_POINTING = 0x7,
  SEAT_CAPABILITY_ALL = 0xF
};

/** @ingroup gdkmmEnums */
inline SeatCapabilities operator|(SeatCapabilities lhs, SeatCapabilities rhs)
  { return static_cast<SeatCapabilities>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline SeatCapabilities operator&(SeatCapabilities lhs, SeatCapabilities rhs)
  { return static_cast<SeatCapabilities>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline SeatCapabilities operator^(SeatCapabilities lhs, SeatCapabilities rhs)
  { return static_cast<SeatCapabilities>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline SeatCapabilities operator~(SeatCapabilities flags)
  { return static_cast<SeatCapabilities>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline SeatCapabilities& operator|=(SeatCapabilities& lhs, SeatCapabilities rhs)
  { return (lhs = static_cast<SeatCapabilities>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline SeatCapabilities& operator&=(SeatCapabilities& lhs, SeatCapabilities rhs)
  { return (lhs = static_cast<SeatCapabilities>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline SeatCapabilities& operator^=(SeatCapabilities& lhs, SeatCapabilities rhs)
  { return (lhs = static_cast<SeatCapabilities>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class GDKMM_API Value<Gdk::SeatCapabilities> : public Glib::Value_Flags<Gdk::SeatCapabilities>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{


class GDKMM_API Display;
class GDKMM_API Window;

/** A Gdk::Seat object represents a collection of input devices that belong to a user.
 *
 * @newin{3,20}
 */

class GDKMM_API Seat : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Seat;
  using CppClassType = Seat_Class;
  using BaseObjectType = GdkSeat;
  using BaseClassType = GdkSeatClass;

  // noncopyable
  Seat(const Seat&) = delete;
  Seat& operator=(const Seat&) = delete;

private:  friend class Seat_Class;
  static CppClassType seat_class_;

protected:
  explicit Seat(const Glib::ConstructParams& construct_params);
  explicit Seat(GdkSeat* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Seat(Seat&& src) noexcept;
  Seat& operator=(Seat&& src) noexcept;

  ~Seat() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkSeat*       gobj()       { return reinterpret_cast<GdkSeat*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkSeat* gobj() const { return reinterpret_cast<GdkSeat*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkSeat* gobj_copy();

private:


protected:
  Seat();

public:
  /** For instance,<br>
   *   void on_grab_prepare(const Glib::RefPtr<Gdk::Window>& window);
   *
   * Type of the callback used to set up @a window so it can be
   * grabbed. A typical action would be ensuring the window is
   * visible, although there's room for other initialization actions.
   *
   * @param window The Gdk::Window being grabbed.
   *
   * @newin{3,20}
   */
  typedef sigc::slot<void, const Glib::RefPtr<Window>&> SlotGrabPrepare;

  
  /** Grabs the seat so that all events corresponding to the given @a capabilities
   * are passed to this application until the seat is ungrabbed with ungrab(),
   * or the window becomes hidden. This overrides any previous grab on the
   * seat by this client.
   * 
   * As a rule of thumb, if a grab is desired over Gdk::SEAT_CAPABILITY_POINTER,
   * all other "pointing" capabilities (eg. Gdk::SEAT_CAPABILITY_TOUCH) should
   * be grabbed too, so the user is able to interact with all of those while
   * the grab holds, you should thus use Gdk::SEAT_CAPABILITY_ALL_POINTING most
   * commonly.
   * 
   * Grabs are used for operations which need complete control over the
   * events corresponding to the given capabilities. For example in GTK+ this
   * is used for Drag and Drop operations, popup menus and such.
   * 
   * Note that if the event mask of a Gdk::Window has selected both button press
   * and button release events, or touch begin and touch end, then a press event
   * will cause an automatic grab until the button is released, equivalent to a
   * grab on the window with @a owner_events set to <tt>true</tt>. This is done because most
   * applications expect to receive paired press and release events.
   * 
   * If you set up anything at the time you take the grab that needs to be
   * cleaned up when the grab ends, you should handle the Gdk::EventGrabBroken
   * events that are emitted when the grab ends unvoluntarily.
   * 
   * @newin{3,20}
   * 
   * @param window The Gdk::Window which will own the grab.
   * @param capabilities Capabilities that will be grabbed.
   * @param owner_events If <tt>false</tt> then all device events are reported with respect to
   *  @a window and are only reported if selected by @a event_mask. If
   * <tt>true</tt> then pointer events for this application are reported
   * as normal, but pointer events outside this application are
   * reported with respect to @a window and only if selected by
   *  @a event_mask. In either mode, unreported events are discarded.
   * @param cursor The cursor to display while the grab is active. If
   * this is <tt>nullptr</tt> then the normal cursors are used for
   *  @a window and its descendants, and the cursor for @a window is used
   * elsewhere.
   * @param event The event that is triggering the grab, or <tt>nullptr</tt> if none
   * is available.
   * @param slot Function to
   * prepare the window to be grabbed, it can be <tt>nullptr</tt> if @a window is
   * visible before this call.
   * @return Gdk::GRAB_SUCCESS if the grab was successful.
   */
  GrabStatus grab(const Glib::RefPtr<Window>& window, SeatCapabilities capabilities, bool owner_events, const Glib::RefPtr<Cursor>& cursor =  Glib::RefPtr<Cursor>(), const GdkEvent* event =  nullptr, const SlotGrabPrepare& slot =  SlotGrabPrepare());

  
  /** Releases a grab added through grab().
   * 
   * @newin{3,20}
   */
  void ungrab();
  
  /** Returns the Gdk::Display this seat belongs to.
   * 
   * @return A Gdk::Display. This object is owned by GTK+
   * and must not be freed.
   */
  Glib::RefPtr<Display> get_display();
  
  /** Returns the Gdk::Display this seat belongs to.
   * 
   * @return A Gdk::Display. This object is owned by GTK+
   * and must not be freed.
   */
  Glib::RefPtr<const Display> get_display() const;
  
  /** Returns the capabilities this Gdk::Seat currently has.
   * 
   * @newin{3,20}
   * 
   * @return The seat capabilities.
   */
  SeatCapabilities get_capabilities() const;

 
  /** Returns the slave devices that match the given capabilities.
   * 
   * @newin{3,20}
   * 
   * @param capabilities Capabilities to get devices for.
   * @return A list of Gdk::Devices.
   */
  std::vector<Glib::RefPtr<Device>> get_slaves(SeatCapabilities capabilities);
 

  /** Returns the slave devices that match the given capabilities.
   * 
   * @newin{3,20}
   * 
   * @param capabilities Capabilities to get devices for.
   * @return A list of Gdk::Devices.
   */
  std::vector<Glib::RefPtr<const Device>> get_slaves(SeatCapabilities capabilities) const;

  
  /** Returns the master device that routes pointer events.
   * 
   * @newin{3,20}
   * 
   * @return A master Gdk::Device with pointer
   * capabilities. This object is owned by GTK+ and must not be freed.
   */
  Glib::RefPtr<Device> get_pointer();
  
  /** Returns the master device that routes pointer events.
   * 
   * @newin{3,20}
   * 
   * @return A master Gdk::Device with pointer
   * capabilities. This object is owned by GTK+ and must not be freed.
   */
  Glib::RefPtr<const Device> get_pointer() const;
  
  /** Returns the master device that routes keyboard events.
   * 
   * @newin{3,20}
   * 
   * @return A master Gdk::Device with keyboard
   * capabilities. This object is owned by GTK+ and must not be freed.
   */
  Glib::RefPtr<Device> get_keyboard();
  
  /** Returns the master device that routes keyboard events.
   * 
   * @newin{3,20}
   * 
   * @return A master Gdk::Device with keyboard
   * capabilities. This object is owned by GTK+ and must not be freed.
   */
  Glib::RefPtr<const Device> get_keyboard() const;

  // We use no_default_handler because GdkSeatClass is private.
 

  /**
   * @par Slot Prototype:
   * <tt>void on_my_%device_added(const Glib::RefPtr<Device>& device)</tt>
   *
   * Flags: Run Last
   *
   * The signal_device_added() signal is emitted when a new input
   * device is related to this seat.
   * 
   * @newin{3,20}
   * 
   * @param device The newly added Gdk::Device.
   */

  Glib::SignalProxy< void,const Glib::RefPtr<Device>& > signal_device_added();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%device_removed(const Glib::RefPtr<Device>& device)</tt>
   *
   * Flags: Run Last
   *
   * The signal_device_removed() signal is emitted when an
   * input device is removed (e.g.\ unplugged).
   * 
   * @newin{3,20}
   * 
   * @param device The just removed Gdk::Device.
   */

  Glib::SignalProxy< void,const Glib::RefPtr<Device>& > signal_device_removed();


  /** Gdk::Display of this seat.
   * 
   * @newin{3,20}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Display> > property_display() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gdk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::Seat
   */
  GDKMM_API
  Glib::RefPtr<Gdk::Seat> wrap(GdkSeat* object, bool take_copy = false);
}


#endif /* _GDKMM_SEAT_H */

