/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandler;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.client.node.NodeClient;
import org.opensearch.commons.alerting.action.AlertingActions;
import org.opensearch.commons.alerting.action.GetWorkflowAlertsRequest;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/opensearch/alerting/resthandler/RestGetWorkflowAlertsAction;", "Lorg/opensearch/rest/BaseRestHandler;", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getName", "", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/client/node/NodeClient;", "replacedRoutes", "", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "opensearch-alerting"})
public final class RestGetWorkflowAlertsAction
extends BaseRestHandler {
    private final Logger log = LogManager.getLogger(RestGetWorkflowAlertsAction.class);

    @NotNull
    public String getName() {
        return "get_workflow_alerts_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        Object[] objectArray = new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.GET, AlertingPlugin.WORKFLOW_BASE_URI + "/alerts")};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return new ArrayList();
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.log.debug(request.method() + " " + AlertingPlugin.WORKFLOW_BASE_URI + "/alerts");
        String sortString = request.param("sortString", "monitor_name.keyword");
        String sortOrder = request.param("sortOrder", "asc");
        String missing = request.param("missing");
        int size = request.paramAsInt("size", 20);
        int startIndex = request.paramAsInt("startIndex", 0);
        String searchString = request.param("searchString", "");
        String severityLevel = request.param("severityLevel", "ALL");
        String alertState = request.param("alertState", "ALL");
        String workflowId = request.param("workflowIds");
        String alertId = request.param("alertIds");
        boolean getAssociatedAlerts2 = Boolean.parseBoolean(request.param("getAssociatedAlerts", "false"));
        List workflowIds = new ArrayList();
        CharSequence charSequence = workflowId;
        if (!(charSequence == null || charSequence.length() == 0)) {
            workflowIds.add(workflowId);
        }
        List alertIds = new ArrayList();
        CharSequence charSequence2 = alertId;
        if (!(charSequence2 == null || charSequence2.length() == 0)) {
            alertIds.add(alertId);
        }
        Intrinsics.checkNotNullExpressionValue((Object)sortOrder, (String)"sortOrder");
        Intrinsics.checkNotNullExpressionValue((Object)sortString, (String)"sortString");
        Table table = new Table(sortOrder, sortString, missing, size, startIndex, searchString);
        List list = CollectionsKt.emptyList();
        Intrinsics.checkNotNullExpressionValue((Object)severityLevel, (String)"severityLevel");
        Intrinsics.checkNotNullExpressionValue((Object)alertState, (String)"alertState");
        GetWorkflowAlertsRequest getWorkflowAlertsRequest = new GetWorkflowAlertsRequest(table, severityLevel, alertState, null, null, list, workflowIds, alertIds, getAssociatedAlerts2);
        return arg_0 -> RestGetWorkflowAlertsAction.prepareRequest$lambda$0(client, getWorkflowAlertsRequest, arg_0);
    }

    private static final void prepareRequest$lambda$0(NodeClient $client, GetWorkflowAlertsRequest $getWorkflowAlertsRequest, RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$getWorkflowAlertsRequest, (String)"$getWorkflowAlertsRequest");
        $client.execute(AlertingActions.GET_WORKFLOW_ALERTS_ACTION_TYPE, (ActionRequest)$getWorkflowAlertsRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

