"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router) {
  const {
    commonService
  } = services;
  const payload = {
    path: _constants.NODE_API.API_CALLER,
    validate: {
      body: _configSchema.schema.nullable(_configSchema.schema.object({
        endpoint: _configSchema.schema.string(),
        data: _configSchema.schema.nullable(_configSchema.schema.any()),
        hideLog: _configSchema.schema.nullable(_configSchema.schema.boolean())
      })),
      query: _configSchema.schema.any()
    }
  };
  router.post(payload, commonService.apiCaller);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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