"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router) {
  const {
    managedIndexService
  } = services;
  router.get({
    path: _constants.NODE_API.MANAGED_INDICES,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string(),
        terms: _configSchema.schema.maybe(_configSchema.schema.any()),
        indices: _configSchema.schema.maybe(_configSchema.schema.any()),
        dataStreams: _configSchema.schema.maybe(_configSchema.schema.any()),
        showDataStreams: _configSchema.schema.boolean()
      })
    }
  }, managedIndexService.getManagedIndices);
  router.get({
    path: `${_constants.NODE_API.MANAGED_INDICES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, managedIndexService.getManagedIndex);
  router.post({
    path: _constants.NODE_API.RETRY,
    validate: {
      body: _configSchema.schema.any()
    }
  }, managedIndexService.retryManagedIndexPolicy);
  router.post({
    path: _constants.NODE_API.CHANGE_POLICY,
    validate: {
      body: _configSchema.schema.any()
    }
  }, managedIndexService.changePolicy);
  router.post({
    path: _constants.NODE_API.REMOVE_POLICY,
    validate: {
      body: _configSchema.schema.any()
    }
  }, managedIndexService.removePolicy);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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