/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.PtrUpdateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddressAttribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddressAttribute> {
    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIp").getter(AddressAttribute.getter(AddressAttribute::publicIp)).setter(AddressAttribute.setter(Builder::publicIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp").unmarshallLocationName("publicIp").build()}).build();
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationId").getter(AddressAttribute.getter(AddressAttribute::allocationId)).setter(AddressAttribute.setter(Builder::allocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("allocationId").build()}).build();
    private static final SdkField<String> PTR_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PtrRecord").getter(AddressAttribute.getter(AddressAttribute::ptrRecord)).setter(AddressAttribute.setter(Builder::ptrRecord)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PtrRecord").unmarshallLocationName("ptrRecord").build()}).build();
    private static final SdkField<PtrUpdateStatus> PTR_RECORD_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PtrRecordUpdate").getter(AddressAttribute.getter(AddressAttribute::ptrRecordUpdate)).setter(AddressAttribute.setter(Builder::ptrRecordUpdate)).constructor(PtrUpdateStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PtrRecordUpdate").unmarshallLocationName("ptrRecordUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_IP_FIELD, ALLOCATION_ID_FIELD, PTR_RECORD_FIELD, PTR_RECORD_UPDATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String publicIp;
    private final String allocationId;
    private final String ptrRecord;
    private final PtrUpdateStatus ptrRecordUpdate;

    private AddressAttribute(BuilderImpl builder) {
        this.publicIp = builder.publicIp;
        this.allocationId = builder.allocationId;
        this.ptrRecord = builder.ptrRecord;
        this.ptrRecordUpdate = builder.ptrRecordUpdate;
    }

    public final String publicIp() {
        return this.publicIp;
    }

    public final String allocationId() {
        return this.allocationId;
    }

    public final String ptrRecord() {
        return this.ptrRecord;
    }

    public final PtrUpdateStatus ptrRecordUpdate() {
        return this.ptrRecordUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ptrRecord());
        hashCode = 31 * hashCode + Objects.hashCode(this.ptrRecordUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressAttribute)) {
            return false;
        }
        AddressAttribute other = (AddressAttribute)obj;
        return Objects.equals(this.publicIp(), other.publicIp()) && Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.ptrRecord(), other.ptrRecord()) && Objects.equals(this.ptrRecordUpdate(), other.ptrRecordUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"AddressAttribute").add("PublicIp", (Object)this.publicIp()).add("AllocationId", (Object)this.allocationId()).add("PtrRecord", (Object)this.ptrRecord()).add("PtrRecordUpdate", (Object)this.ptrRecordUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublicIp": {
                return Optional.ofNullable(clazz.cast(this.publicIp()));
            }
            case "AllocationId": {
                return Optional.ofNullable(clazz.cast(this.allocationId()));
            }
            case "PtrRecord": {
                return Optional.ofNullable(clazz.cast(this.ptrRecord()));
            }
            case "PtrRecordUpdate": {
                return Optional.ofNullable(clazz.cast(this.ptrRecordUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddressAttribute, T> g) {
        return obj -> g.apply((AddressAttribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String publicIp;
        private String allocationId;
        private String ptrRecord;
        private PtrUpdateStatus ptrRecordUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(AddressAttribute model) {
            this.publicIp(model.publicIp);
            this.allocationId(model.allocationId);
            this.ptrRecord(model.ptrRecord);
            this.ptrRecordUpdate(model.ptrRecordUpdate);
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getPtrRecord() {
            return this.ptrRecord;
        }

        public final void setPtrRecord(String ptrRecord) {
            this.ptrRecord = ptrRecord;
        }

        @Override
        public final Builder ptrRecord(String ptrRecord) {
            this.ptrRecord = ptrRecord;
            return this;
        }

        public final PtrUpdateStatus.Builder getPtrRecordUpdate() {
            return this.ptrRecordUpdate != null ? this.ptrRecordUpdate.toBuilder() : null;
        }

        public final void setPtrRecordUpdate(PtrUpdateStatus.BuilderImpl ptrRecordUpdate) {
            this.ptrRecordUpdate = ptrRecordUpdate != null ? ptrRecordUpdate.build() : null;
        }

        @Override
        public final Builder ptrRecordUpdate(PtrUpdateStatus ptrRecordUpdate) {
            this.ptrRecordUpdate = ptrRecordUpdate;
            return this;
        }

        public AddressAttribute build() {
            return new AddressAttribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddressAttribute> {
        public Builder publicIp(String var1);

        public Builder allocationId(String var1);

        public Builder ptrRecord(String var1);

        public Builder ptrRecordUpdate(PtrUpdateStatus var1);

        default public Builder ptrRecordUpdate(Consumer<PtrUpdateStatus.Builder> ptrRecordUpdate) {
            return this.ptrRecordUpdate((PtrUpdateStatus)((PtrUpdateStatus.Builder)PtrUpdateStatus.builder().applyMutation(ptrRecordUpdate)).build());
        }
    }
}

