/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.util;

import java.util.Map;
import lombok.Generated;
import org.opensearch.common.ValidationException;
import org.opensearch.knn.index.KNNMethod;
import org.opensearch.knn.index.KNNMethodContext;
import org.opensearch.knn.index.util.KNNLibrary;

public abstract class AbstractKNNLibrary
implements KNNLibrary {
    protected final Map<String, KNNMethod> methods;
    protected final String version;

    @Override
    public KNNMethod getMethod(String methodName) {
        KNNMethod method = this.methods.get(methodName);
        if (method == null) {
            throw new IllegalArgumentException(String.format("Invalid method name: %s", methodName));
        }
        return method;
    }

    @Override
    public ValidationException validateMethod(KNNMethodContext knnMethodContext) {
        String methodName = knnMethodContext.getMethodComponent().getName();
        return this.getMethod(methodName).validate(knnMethodContext);
    }

    @Override
    public boolean isTrainingRequired(KNNMethodContext knnMethodContext) {
        String methodName = knnMethodContext.getMethodComponent().getName();
        return this.getMethod(methodName).isTrainingRequired(knnMethodContext);
    }

    @Override
    public Map<String, Object> getMethodAsMap(KNNMethodContext knnMethodContext) {
        KNNMethod knnMethod = this.methods.get(knnMethodContext.getMethodComponent().getName());
        if (knnMethod == null) {
            throw new IllegalArgumentException(String.format("Invalid method name: %s", knnMethodContext.getMethodComponent().getName()));
        }
        return knnMethod.getAsMap(knnMethodContext);
    }

    @Generated
    AbstractKNNLibrary(Map<String, KNNMethod> methods, String version) {
        this.methods = methods;
        this.version = version;
    }

    @Override
    @Generated
    public String getVersion() {
        return this.version;
    }
}

