"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const exposes = __importStar(require("../lib/exposes"));
const fromZigbee_1 = __importDefault(require("../converters/fromZigbee"));
const legacy = __importStar(require("../lib/legacy"));
const e = exposes.presets;
const ea = exposes.access;
const definitions = [
    {
        zigbeeModel: ['JAVISLOCK'],
        fingerprint: [{ modelID: 'doorlock_5001', manufacturerName: 'Lmiot' },
            { modelID: 'E321V000A03', manufacturerName: 'Vensi' }],
        model: 'JS-SLK2-ZB',
        vendor: 'JAVIS',
        description: 'Intelligent biometric digital lock',
        fromZigbee: [fromZigbee_1.default.javis_lock_report, fromZigbee_1.default.battery],
        toZigbee: [],
        exposes: [e.battery(), e.action(['unlock'])],
    },
    {
        zigbeeModel: ['JAVISSENSOR'],
        fingerprint: [{ modelID: 'TS0601', manufacturerName: '_TZE200_lgstepha' },
            { modelID: 'TS0601', manufacturerName: '_TZE200_kagkgk0i' },
            { modelID: 'TS0601', manufacturerName: '_TZE200_i0b1dbqu' }],
        model: 'JS-MC-SENSOR-ZB',
        vendor: 'JAVIS',
        description: 'Microwave sensor',
        fromZigbee: [legacy.fz.javis_microwave_sensor, fromZigbee_1.default.ignore_basic_report],
        toZigbee: [legacy.tz.javis_microwave_sensor],
        exposes: [e.occupancy(), e.illuminance_lux(),
            e.binary('led_enable', ea.STATE_SET, true, false).withDescription('Enabled LED'),
            e.enum('keep_time', ea.STATE_SET, ['0', '1', '2', '3', '4', '5', '6', '7'])
                .withDescription('PIR keep time 0:5s|1:30s|2:60s|3:180s|4:300s|5:600s|6:1200s|7:1800s'),
            e.enum('sensitivity', ea.STATE_SET, ['25', '50', '75', '100']),
            e.numeric('illuminance_calibration', ea.STATE_SET).withDescription('Illuminance calibration')
                .withValueMin(-10000).withValueMax(10000)],
    },
];
exports.default = definitions;
module.exports = definitions;
//# sourceMappingURL=javis.js.map