"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const exposes = __importStar(require("../lib/exposes"));
const utils = __importStar(require("../lib/utils"));
const reporting = __importStar(require("../lib/reporting"));
const fromZigbee_1 = __importDefault(require("../converters/fromZigbee"));
const toZigbee_1 = __importDefault(require("../converters/toZigbee"));
const e = exposes.presets;
const fzLocal = {
    BSD29: {
        cluster: '64529',
        type: ['attributeReport', 'readResponse'],
        convert: (model, msg, publish, options, meta) => {
            if (utils.hasAlreadyProcessedMessage(msg, model))
                return;
            const lookup = [
                { key: '28678', name: 'power', factor: 'acPower' },
                { key: '28677', name: 'voltage', factor: 'acVoltage' },
                { key: '28676', name: 'current', factor: 'acCurrent' },
            ];
            const payload = {};
            for (const entry of lookup) {
                if (msg.data.hasOwnProperty(entry.key)) {
                    const value = msg.data[entry.key] / 1000;
                    payload[entry.name] = value;
                }
            }
            return payload;
        },
    },
};
const definitions = [
    {
        zigbeeModel: ['CK-BL702-SWP-01(7020)'],
        model: 'BSD29/BSD59',
        vendor: 'Woolley',
        description: 'Zigbee 3.0 smart plug',
        fromZigbee: [fromZigbee_1.default.on_off_skip_duplicate_transaction, fzLocal.BSD29],
        toZigbee: [toZigbee_1.default.on_off],
        configure: async (device, coordinatorEndpoint, logger) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ['genOnOff']);
            await reporting.onOff(endpoint);
            device.powerSource = 'Mains (single phase)';
            device.save();
        },
        exposes: [e.power(), e.current(), e.voltage(), e.switch()],
    },
];
exports.default = definitions;
module.exports = definitions;
//# sourceMappingURL=woolley.js.map