"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AshWriter = void 0;
/* istanbul ignore file */
const debug_1 = __importDefault(require("debug"));
const stream_1 = require("stream");
const debug = (0, debug_1.default)('zigbee-herdsman:adapter:ember:uart:ash:writer');
class AshWriter extends stream_1.Readable {
    bytesToWrite;
    constructor(opts) {
        super(opts);
        this.bytesToWrite = [];
    }
    writeBytes() {
        const buffer = Buffer.from(this.bytesToWrite);
        this.bytesToWrite = [];
        debug(`>>>> [FRAME raw=${buffer.toString('hex')}]`);
        // this.push(buffer);
        this.emit('data', buffer);
    }
    writeByte(byte) {
        this.bytesToWrite.push(byte);
    }
    writeAvailable() {
        if (this.readableLength < this.readableHighWaterMark) {
            return true;
        }
        else {
            this.writeFlush();
            return false;
        }
    }
    /**
     * If there is anything to send, send to the port.
     */
    writeFlush() {
        if (this.bytesToWrite.length) {
            this.writeBytes();
        }
    }
    _read() {
    }
}
exports.AshWriter = AshWriter;
//# sourceMappingURL=writer.js.map