<?php
// phpcs:ignoreFile
/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 11.0-dev db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();
// Ensure any tables with a serial column with a value of 0 are created as
// expected.
if ($connection->databaseType() === 'mysql') {
  $sql_mode = $connection->query("SELECT @@sql_mode;")->fetchField();
  $connection->query("SET sql_mode = '$sql_mode,NO_AUTO_VALUE_ON_ZERO'");
}

$connection->schema()->createTable('access', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'mask' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('actions', array(
  'fields' => array(
    'aid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '0',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'parameters' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'description' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('actions')
->fields(array(
  'aid',
  'type',
  'callback',
  'parameters',
  'description',
))
->values(array(
  'aid' => '1',
  'type' => 'comment',
  'callback' => 'comment_unpublish_by_keyword_action',
  'parameters' => 'a:1:{s:8:"keywords";a:1:{i:0;s:6:"drupal";}}',
  'description' => 'Unpublish comment containing keyword(s)',
))
->values(array(
  'aid' => '2',
  'type' => 'node',
  'callback' => 'node_assign_owner_action',
  'parameters' => 'a:1:{s:9:"owner_uid";s:1:"2";}',
  'description' => 'Change the author of a post',
))
->values(array(
  'aid' => '3',
  'type' => 'node',
  'callback' => 'node_unpublish_by_keyword_action',
  'parameters' => 'a:1:{s:8:"keywords";a:1:{i:0;s:6:"drupal";}}',
  'description' => 'Unpublish post containing keyword(s)',
))
->values(array(
  'aid' => '4',
  'type' => 'system',
  'callback' => 'system_message_action',
  'parameters' => 'a:1:{s:7:"message";s:21:"Drupal migration test";}',
  'description' => 'Display a message to the user',
))
->values(array(
  'aid' => '5',
  'type' => 'system',
  'callback' => 'system_send_email_action',
  'parameters' => 'a:3:{s:9:"recipient";s:16:"test@example.com";s:7:"subject";s:21:"Drupal migration test";s:7:"message";s:21:"Drupal migration test";}',
  'description' => 'Send e-mail',
))
->values(array(
  'aid' => '6',
  'type' => 'system',
  'callback' => 'system_goto_action',
  'parameters' => 'a:1:{s:3:"url";s:22:"https://www.drupal.org";}',
  'description' => 'Redirect to URL',
))
->values(array(
  'aid' => 'comment_publish_action',
  'type' => 'comment',
  'callback' => 'comment_publish_action',
  'parameters' => '',
  'description' => 'Publish comment',
))
->values(array(
  'aid' => 'comment_unpublish_action',
  'type' => 'comment',
  'callback' => 'comment_unpublish_action',
  'parameters' => '',
  'description' => 'Unpublish comment',
))
->values(array(
  'aid' => 'imagecache_flush_action',
  'type' => 'node',
  'callback' => 'imagecache_flush_action',
  'parameters' => '',
  'description' => "ImageCache: Flush ALL presets for this node's filefield images",
))
->values(array(
  'aid' => 'imagecache_generate_all_action',
  'type' => 'node',
  'callback' => 'imagecache_generate_all_action',
  'parameters' => '',
  'description' => "ImageCache: Generate ALL presets for this node's filefield images",
))
->values(array(
  'aid' => 'node_make_sticky_action',
  'type' => 'node',
  'callback' => 'node_make_sticky_action',
  'parameters' => '',
  'description' => 'Make post sticky',
))
->values(array(
  'aid' => 'node_make_unsticky_action',
  'type' => 'node',
  'callback' => 'node_make_unsticky_action',
  'parameters' => '',
  'description' => 'Make post unsticky',
))
->values(array(
  'aid' => 'node_promote_action',
  'type' => 'node',
  'callback' => 'node_promote_action',
  'parameters' => '',
  'description' => 'Promote post to front page',
))
->values(array(
  'aid' => 'node_publish_action',
  'type' => 'node',
  'callback' => 'node_publish_action',
  'parameters' => '',
  'description' => 'Publish post',
))
->values(array(
  'aid' => 'node_save_action',
  'type' => 'node',
  'callback' => 'node_save_action',
  'parameters' => '',
  'description' => 'Save post',
))
->values(array(
  'aid' => 'node_unpromote_action',
  'type' => 'node',
  'callback' => 'node_unpromote_action',
  'parameters' => '',
  'description' => 'Remove post from front page',
))
->values(array(
  'aid' => 'node_unpublish_action',
  'type' => 'node',
  'callback' => 'node_unpublish_action',
  'parameters' => '',
  'description' => 'Unpublish post',
))
->values(array(
  'aid' => 'user_block_ip_action',
  'type' => 'user',
  'callback' => 'user_block_ip_action',
  'parameters' => '',
  'description' => 'Ban IP address of current user',
))
->values(array(
  'aid' => 'user_block_user_action',
  'type' => 'user',
  'callback' => 'user_block_user_action',
  'parameters' => '',
  'description' => 'Block current user',
))
->execute();
$connection->schema()->createTable('actions_aid', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('actions_aid')
->fields(array(
  'aid',
))
->values(array(
  'aid' => '1',
))
->values(array(
  'aid' => '2',
))
->values(array(
  'aid' => '3',
))
->values(array(
  'aid' => '4',
))
->values(array(
  'aid' => '5',
))
->values(array(
  'aid' => '6',
))
->execute();
$connection->schema()->createTable('aggregator_category', array(
  'fields' => array(
    'cid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'block' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'unique keys' => array(
    'title' => array(
      'title',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('aggregator_category_feed', array(
  'fields' => array(
    'fid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'cid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
    'fid',
  ),
  'indexes' => array(
    'fid' => array(
      'fid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('aggregator_category_item', array(
  'fields' => array(
    'iid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'cid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
    'iid',
  ),
  'indexes' => array(
    'iid' => array(
      'iid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('aggregator_feed', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'url' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'refresh' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'checked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'link' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'image' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'etag' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'modified' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'block' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'unique keys' => array(
    'url' => array(
      'url',
    ),
    'title' => array(
      'title',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('aggregator_item', array(
  'fields' => array(
    'iid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'fid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'link' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'author' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'guid' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'iid',
  ),
  'indexes' => array(
    'fid' => array(
      'fid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('authmap', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'authname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('batch', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'token' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'batch' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('blocks', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '0',
    ),
    'theme' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'region' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'custom' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'throttle' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'visibility' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'pages' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('blocks')
->fields(array(
  'bid',
  'module',
  'delta',
  'theme',
  'status',
  'weight',
  'region',
  'custom',
  'throttle',
  'visibility',
  'pages',
  'title',
  'cache',
))
->values(array(
  'bid' => '1',
  'module' => 'user',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-10',
  'region' => 'left',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => "<front>\r\nnode/1\nblog/*",
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '2',
  'module' => 'user',
  'delta' => '1',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-11',
  'region' => 'left',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => 'zu - Navigation',
  'cache' => '-1',
))
->values(array(
  'bid' => '3',
  'module' => 'system',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-5',
  'region' => 'footer',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => 'node/1',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '4',
  'module' => 'comment',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-9',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '5',
  'module' => 'menu',
  'delta' => 'primary-links',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-5',
  'region' => 'header',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '6',
  'module' => 'menu',
  'delta' => 'secondary-links',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-8',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '7',
  'module' => 'node',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-7',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '8',
  'module' => 'user',
  'delta' => '2',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-11',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '9',
  'module' => 'user',
  'delta' => '3',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-10',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '16',
  'module' => 'profile',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-5',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '5',
))
->values(array(
  'bid' => '17',
  'module' => 'event',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-3',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '18',
  'module' => 'event',
  'delta' => '1',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '0',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '19',
  'module' => 'event',
  'delta' => 'event-upcoming-event',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-1',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '20',
  'module' => 'book',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-4',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '5',
))
->values(array(
  'bid' => '21',
  'module' => 'locale',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '0',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '22',
  'module' => 'forum',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-8',
  'region' => 'left',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '23',
  'module' => 'forum',
  'delta' => '1',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-9',
  'region' => 'left',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '24',
  'module' => 'statistics',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '0',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '25',
  'module' => 'search',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '0',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->execute();
$connection->schema()->createTable('blocks_roles', array(
  'fields' => array(
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'module',
    'delta',
    'rid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('blocks_roles')
->fields(array(
  'module',
  'delta',
  'rid',
))
->values(array(
  'module' => 'user',
  'delta' => '2',
  'rid' => '2',
))
->values(array(
  'module' => 'user',
  'delta' => '3',
  'rid' => '3',
))
->execute();
$connection->schema()->createTable('boxes', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'info' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'format' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_block', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_bootstrap', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'checksum_invalidations' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'checksum_deletions' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_config', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'checksum_invalidations' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'checksum_deletions' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_content', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_discovery', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'checksum_invalidations' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'checksum_deletions' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_filter', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_form', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_menu', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_page', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cachetags', array(
  'fields' => array(
    'tag' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'invalidations' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'deletions' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'tag',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('comments', array(
  'fields' => array(
    'cid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'pid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'subject' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'comment' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'format' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'thread' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '60',
    ),
    'mail' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '64',
    ),
    'homepage' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'pid' => array(
      'pid',
    ),
    'comment_uid' => array(
      'uid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('comments')
->fields(array(
  'cid',
  'pid',
  'nid',
  'uid',
  'subject',
  'comment',
  'hostname',
  'timestamp',
  'status',
  'format',
  'thread',
  'name',
  'mail',
  'homepage',
))
->values(array(
  'cid' => '4',
  'pid' => '0',
  'nid' => '19',
  'uid' => '1',
  'subject' => 'Subject 1',
  'comment' => 'Comment 1',
  'hostname' => '127.0.0.1',
  'timestamp' => '1501955780',
  'status' => '0',
  'format' => '1',
  'thread' => '01/',
  'name' => 'root',
  'mail' => '',
  'homepage' => '',
))
->values(array(
  'cid' => '5',
  'pid' => '4',
  'nid' => '19',
  'uid' => '1',
  'subject' => 'Subject 2',
  'comment' => 'Comment 2',
  'hostname' => '127.0.0.1',
  'timestamp' => '1501955792',
  'status' => '0',
  'format' => '1',
  'thread' => '01.00/',
  'name' => 'root',
  'mail' => '',
  'homepage' => '',
))
->values(array(
  'cid' => '6',
  'pid' => '5',
  'nid' => '19',
  'uid' => '1',
  'subject' => 'Subject 3',
  'comment' => 'Comment 3',
  'hostname' => '127.0.0.1',
  'timestamp' => '1501955803',
  'status' => '0',
  'format' => '1',
  'thread' => '01.00.00/',
  'name' => 'root',
  'mail' => '',
  'homepage' => '',
))
->execute();
$connection->schema()->createTable('config', array(
  'fields' => array(
    'collection' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'collection',
    'name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('config')
->fields(array(
  'collection',
  'name',
  'data',
))
->values(array(
  'collection' => '',
  'name' => 'system.file',
  'data' => 'a:1:{s:4:"path";a:1:{s:9:"temporary";s:4:"/tmp";}}',
))
->execute();
$connection->schema()->createTable('content_field_company', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_company_nid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'vid',
    'delta',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
    'field_company_nid' => array(
      'field_company_nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('content_field_image', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_image_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_image_list' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_image_data' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_field_image')
->fields(array(
  'vid',
  'nid',
  'field_image_fid',
  'field_image_list',
  'field_image_data',
))
->values(array(
  'vid' => '1',
  'nid' => '1',
  'field_image_fid' => '2',
  'field_image_list' => '1',
  'field_image_data' => 'a:2:{s:3:"alt";s:0:"";s:5:"title";s:0:"";}',
))
->values(array(
  'vid' => '2',
  'nid' => '2',
  'field_image_fid' => NULL,
  'field_image_list' => NULL,
  'field_image_data' => NULL,
))
->values(array(
  'vid' => '3',
  'nid' => '1',
  'field_image_fid' => '2',
  'field_image_list' => '1',
  'field_image_data' => 'a:2:{s:3:"alt";s:0:"";s:5:"title";s:0:"";}',
))
->values(array(
  'vid' => '5',
  'nid' => '1',
  'field_image_fid' => '2',
  'field_image_list' => '1',
  'field_image_data' => 'a:2:{s:3:"alt";s:0:"";s:5:"title";s:0:"";}',
))
->values(array(
  'vid' => '2001',
  'nid' => '1',
  'field_image_fid' => '2',
  'field_image_list' => '1',
  'field_image_data' => 'a:2:{s:3:"alt";s:0:"";s:5:"title";s:0:"";}',
))
->execute();
$connection->schema()->createTable('content_group', array(
  'fields' => array(
    'group_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => 'standard',
    ),
    'type_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'group_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'settings' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'type_name',
    'group_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('content_group_fields', array(
  'fields' => array(
    'type_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'group_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'field_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'type_name',
    'group_name',
    'field_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('content_node_field', array(
  'fields' => array(
    'field_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '127',
      'default' => '',
    ),
    'global_settings' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'required' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'multiple' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'db_storage' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '127',
      'default' => '',
    ),
    'db_columns' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'active' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'field_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_node_field')
->fields(array(
  'field_name',
  'type',
  'global_settings',
  'required',
  'multiple',
  'db_storage',
  'module',
  'db_columns',
  'active',
  'locked',
))
->values(array(
  'field_name' => 'field_commander',
  'type' => 'userreference',
  'global_settings' => 'a:2:{s:19:"referenceable_roles";a:4:{i:2;i:2;i:3;i:0;i:4;i:0;i:5;i:0;}s:20:"referenceable_status";s:0:"";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'userreference',
  'db_columns' => 'a:1:{s:3:"uid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;s:5:"index";b:1;}}',
  'active' => '0',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_company',
  'type' => 'nodereference',
  'global_settings' => 'a:1:{s:19:"referenceable_types";a:10:{s:7:"company";s:7:"company";s:7:"article";i:0;s:8:"employee";i:0;s:5:"forum";i:0;s:10:"test_event";i:0;s:9:"test_page";i:0;s:11:"test_planet";i:0;s:10:"test_story";i:0;s:7:"sponsor";i:0;s:5:"story";i:0;}}',
  'required' => '0',
  'multiple' => '1',
  'db_storage' => '0',
  'module' => 'nodereference',
  'db_columns' => 'a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;s:5:"index";b:1;}}',
  'active' => '0',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_company_2',
  'type' => 'nodereference',
  'global_settings' => 'a:1:{s:19:"referenceable_types";a:10:{s:7:"company";s:7:"company";s:7:"article";i:0;s:8:"employee";i:0;s:5:"forum";i:0;s:10:"test_event";i:0;s:9:"test_page";i:0;s:11:"test_planet";i:0;s:10:"test_story";i:0;s:7:"sponsor";i:0;s:5:"story";i:0;}}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'nodereference',
  'db_columns' => 'a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;s:5:"index";b:1;}}',
  'active' => '0',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_company_3',
  'type' => 'nodereference',
  'global_settings' => 'a:1:{s:19:"referenceable_types";a:10:{s:7:"company";s:7:"company";s:7:"article";i:0;s:8:"employee";i:0;s:5:"forum";i:0;s:10:"test_event";i:0;s:9:"test_page";i:0;s:11:"test_planet";i:0;s:10:"test_story";i:0;s:7:"sponsor";i:0;s:5:"story";i:0;}}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'nodereference',
  'db_columns' => 'a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;s:5:"index";b:1;}}',
  'active' => '0',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_forums',
  'type' => 'text',
  'global_settings' => 'a:4:{s:15:"text_processing";s:1:"0";s:10:"max_length";s:0:"";s:14:"allowed_values";s:0:"";s:18:"allowed_values_php";s:0:"";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'text',
  'db_columns' => 'a:1:{s:5:"value";a:5:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;s:8:"sortable";b:1;s:5:"views";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_sync',
  'type' => 'email',
  'global_settings' => 'a:0:{}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'email',
  'db_columns' => 'a:1:{s:5:"email";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->execute();
$connection->schema()->createTable('content_node_field_instance', array(
  'fields' => array(
    'field_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'type_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'widget_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'widget_settings' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'display_settings' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'widget_module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '127',
      'default' => '',
    ),
    'widget_active' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'field_name',
    'type_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_node_field_instance')
->fields(array(
  'field_name',
  'type_name',
  'weight',
  'label',
  'widget_type',
  'widget_settings',
  'display_settings',
  'description',
  'widget_module',
  'widget_active',
))
->values(array(
  'field_name' => 'field_commander',
  'type_name' => 'employee',
  'weight' => '32',
  'label' => 'Commanding Officer',
  'widget_type' => 'userreference_select',
  'widget_settings' => 'a:5:{s:18:"autocomplete_match";s:8:"contains";s:4:"size";i:60;s:12:"reverse_link";i:0;s:13:"default_value";a:1:{i:0;a:1:{s:3:"uid";s:0:"";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:5:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => '',
  'widget_module' => 'userreference',
  'widget_active' => '0',
))
->values(array(
  'field_name' => 'field_company',
  'type_name' => 'employee',
  'weight' => '31',
  'label' => 'Company',
  'widget_type' => 'nodereference_select',
  'widget_settings' => 'a:4:{s:18:"autocomplete_match";s:8:"contains";s:4:"size";i:60;s:13:"default_value";a:1:{i:0;a:1:{s:3:"nid";s:0:"";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:5:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:5:"plain";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => '',
  'widget_module' => 'nodereference',
  'widget_active' => '0',
))
->values(array(
  'field_name' => 'field_company_2',
  'type_name' => 'employee',
  'weight' => '33',
  'label' => 'Company 2',
  'widget_type' => 'nodereference_buttons',
  'widget_settings' => 'a:4:{s:18:"autocomplete_match";s:8:"contains";s:4:"size";i:60;s:13:"default_value";a:1:{i:0;a:1:{s:3:"nid";s:0:"";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:5:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => '',
  'widget_module' => 'nodereference',
  'widget_active' => '0',
))
->values(array(
  'field_name' => 'field_company_3',
  'type_name' => 'employee',
  'weight' => '34',
  'label' => 'Company 3',
  'widget_type' => 'nodereference_autocomplete',
  'widget_settings' => 'a:4:{s:18:"autocomplete_match";s:8:"contains";s:4:"size";s:2:"60";s:13:"default_value";a:1:{i:0;a:2:{s:3:"nid";N;s:14:"_error_element";s:50:"default_value_widget][field_company_3][0][nid][nid";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:5:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => '',
  'widget_module' => 'nodereference',
  'widget_active' => '0',
))
->values(array(
  'field_name' => 'field_forums',
  'type_name' => 'forum',
  'weight' => '31',
  'label' => 'forums',
  'widget_type' => 'text_textfield',
  'widget_settings' => 'a:4:{s:4:"rows";i:5;s:4:"size";s:2:"60";s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:0:"";s:14:"_error_element";s:44:"default_value_widget][field_forums][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:6:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:2;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:3;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => '',
  'widget_module' => 'text',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_sync',
  'type_name' => 'employee',
  'weight' => '35',
  'label' => 'email_sync',
  'widget_type' => 'email_textfield',
  'widget_settings' => 'a:3:{s:4:"size";s:2:"60";s:13:"default_value";a:1:{i:0;a:1:{s:5:"email";s:0:"";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:2;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:3;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => '',
  'widget_module' => 'email',
  'widget_active' => '1',
))
->execute();
$connection->schema()->createTable('content_type_employee', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_commander_uid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_company_2_nid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_company_3_nid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_sync_email' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
    'field_commander_uid' => array(
      'field_commander_uid',
    ),
    'field_company_2_nid' => array(
      'field_company_2_nid',
    ),
    'field_company_3_nid' => array(
      'field_company_3_nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('content_type_forum', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_forums_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_type_forum')
->fields(array(
  'vid',
  'nid',
  'field_forums_value',
))
->values(array(
  'vid' => '23',
  'nid' => '20',
  'field_forums_value' => 'green',
))
->execute();
$connection->schema()->createTable('date_format_locale', array(
  'fields' => array(
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '200',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
    ),
  ),
  'primary key' => array(
    'type',
    'language',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('date_format_types', array(
  'fields' => array(
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '200',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('date_format_types')
->fields(array(
  'type',
  'title',
  'locked',
))
->values(array(
  'type' => 'long',
  'title' => 'Long',
  'locked' => '1',
))
->values(array(
  'type' => 'medium',
  'title' => 'Medium',
  'locked' => '1',
))
->values(array(
  'type' => 'short',
  'title' => 'Short',
  'locked' => '1',
))
->execute();
$connection->schema()->createTable('date_formats', array(
  'fields' => array(
    'dfid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '200',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'dfid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('date_formats')
->fields(array(
  'dfid',
  'format',
  'type',
  'locked',
))
->values(array(
  'dfid' => '1',
  'format' => 'Y-m-d H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '2',
  'format' => 'm/d/Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '3',
  'format' => 'd/m/Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '4',
  'format' => 'Y/m/d - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '5',
  'format' => 'd.m.Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '6',
  'format' => 'm/d/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '7',
  'format' => 'd/m/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '8',
  'format' => 'Y/m/d - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '9',
  'format' => 'M j Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '10',
  'format' => 'j M Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '11',
  'format' => 'Y M j - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '12',
  'format' => 'M j Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '13',
  'format' => 'j M Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '14',
  'format' => 'Y M j - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '15',
  'format' => 'D, Y-m-d H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '16',
  'format' => 'D, m/d/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '17',
  'format' => 'D, d/m/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '18',
  'format' => 'D, Y/m/d - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '19',
  'format' => 'F j, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '20',
  'format' => 'j F, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '21',
  'format' => 'Y, F j - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '22',
  'format' => 'D, m/d/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '23',
  'format' => 'D, d/m/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '24',
  'format' => 'D, Y/m/d - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '25',
  'format' => 'F j, Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '26',
  'format' => 'j F Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '27',
  'format' => 'Y, F j - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '28',
  'format' => 'j. F Y - G:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '29',
  'format' => 'l, F j, Y - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '30',
  'format' => 'l, j F, Y - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '31',
  'format' => 'l, Y,  F j - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '32',
  'format' => 'l, F j, Y - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '33',
  'format' => 'l, j F Y - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '34',
  'format' => 'l, Y,  F j - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '35',
  'format' => 'l, j. F Y - G:i',
  'type' => 'long',
  'locked' => '1',
))
->execute();
$connection->schema()->createTable('event', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'event_start' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ),
    'event_end' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ),
    'timezone' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'start_in_dst' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'end_in_dst' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'has_time' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'has_end_date' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('event_timezones', array(
  'fields' => array(
    'timezone' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'offset' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
      'default' => '00:00:00',
    ),
    'offset_dst' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
      'default' => '00:00:00',
    ),
    'dst_region' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'is_dst' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'timezone',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('event_timezones')
->fields(array(
  'timezone',
  'name',
  'offset',
  'offset_dst',
  'dst_region',
  'is_dst',
))
->values(array(
  'timezone' => '1',
  'name' => 'Africa/Addis Ababa',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '2',
  'name' => 'Africa/Algiers',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '3',
  'name' => 'Africa/Asmera',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '4',
  'name' => 'Africa/Bangui',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '5',
  'name' => 'Africa/Blantyre',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '6',
  'name' => 'Africa/Brazzaville',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '7',
  'name' => 'Africa/Bujumbura',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '8',
  'name' => 'Africa/Cairo',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '1',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '9',
  'name' => 'Africa/Ceuta',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '1',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '10',
  'name' => 'Africa/Dar es Salaam',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '11',
  'name' => 'Africa/Djibouti',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '12',
  'name' => 'Africa/Douala',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '13',
  'name' => 'Africa/Gaborone',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '14',
  'name' => 'Africa/Harare',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '15',
  'name' => 'Africa/Johannesburg',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '16',
  'name' => 'Africa/Kampala',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '17',
  'name' => 'Africa/Khartoum',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '18',
  'name' => 'Africa/Kigali',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '19',
  'name' => 'Africa/Kinshasa',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '20',
  'name' => 'Africa/Lagos',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '21',
  'name' => 'Africa/Libreville',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '22',
  'name' => 'Africa/Luanda',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '23',
  'name' => 'Africa/Lubumbashi',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '24',
  'name' => 'Africa/Lusaka',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '25',
  'name' => 'Africa/Malabo',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '26',
  'name' => 'Africa/Maputo',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '27',
  'name' => 'Africa/Maseru',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '28',
  'name' => 'Africa/Mbabane',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '29',
  'name' => 'Africa/Mogadishu',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '30',
  'name' => 'Africa/Nairobi',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '31',
  'name' => 'Africa/Ndjamena',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '32',
  'name' => 'Africa/Niamey',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '33',
  'name' => 'Africa/Porto-Novo',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '34',
  'name' => 'Africa/Tripoli',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '35',
  'name' => 'Africa/Tunis',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '36',
  'name' => 'Africa/Windhoek',
  'offset' => '02:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '2',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '37',
  'name' => 'America/Adak',
  'offset' => '-10:00:00',
  'offset_dst' => '-09:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '38',
  'name' => 'America/Anchorage',
  'offset' => '-09:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '39',
  'name' => 'America/Anguilla',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '40',
  'name' => 'America/Antigua',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '41',
  'name' => 'America/Araguaina',
  'offset' => '-02:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '17',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '42',
  'name' => 'America/Aruba',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '43',
  'name' => 'America/Asuncion',
  'offset' => '-03:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '20',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '44',
  'name' => 'America/Atka',
  'offset' => '-10:00:00',
  'offset_dst' => '-09:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '45',
  'name' => 'America/Barbados',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '46',
  'name' => 'America/Belem',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '47',
  'name' => 'America/Belize',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '48',
  'name' => 'America/Boa Vista',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '49',
  'name' => 'America/Bogota',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '50',
  'name' => 'America/Boise',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '51',
  'name' => 'America/Buenos Aires',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '52',
  'name' => 'America/Cambridge Bay',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '53',
  'name' => 'America/Cancun',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '54',
  'name' => 'America/Caracas',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '55',
  'name' => 'America/Catamarca',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '56',
  'name' => 'America/Cayenne',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '57',
  'name' => 'America/Cayman',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '58',
  'name' => 'America/Chicago',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '59',
  'name' => 'America/Chihuahua',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '60',
  'name' => 'America/Cordoba',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '61',
  'name' => 'America/Costa Rica',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '62',
  'name' => 'America/Cuiaba',
  'offset' => '-03:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '17',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '63',
  'name' => 'America/Curacao',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '64',
  'name' => 'America/Dawson',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '65',
  'name' => 'America/Dawson Creek',
  'offset' => '-07:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '66',
  'name' => 'America/Denver',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '67',
  'name' => 'America/Detroit',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '68',
  'name' => 'America/Dominica',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '69',
  'name' => 'America/Edmonton',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '70',
  'name' => 'America/Eirunepe',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '71',
  'name' => 'America/El Salvador',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '72',
  'name' => 'America/Ensenada',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '73',
  'name' => 'America/Fort Wayne',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '74',
  'name' => 'America/Fortaleza',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '75',
  'name' => 'America/Glace Bay',
  'offset' => '-04:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '76',
  'name' => 'America/Godthab',
  'offset' => '-03:00:00',
  'offset_dst' => '-02:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '77',
  'name' => 'America/Goose Bay',
  'offset' => '-04:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '78',
  'name' => 'America/Grand Turk',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '16',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '79',
  'name' => 'America/Grenada',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '80',
  'name' => 'America/Guadeloupe',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '81',
  'name' => 'America/Guatemala',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '82',
  'name' => 'America/Guayaquil',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '83',
  'name' => 'America/Guyana',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '84',
  'name' => 'America/Halifax',
  'offset' => '-04:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '85',
  'name' => 'America/Havana',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '16',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '86',
  'name' => 'America/Hermosillo',
  'offset' => '-07:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '87',
  'name' => 'America/Indiana/Indianapolis',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '88',
  'name' => 'America/Indiana/Knox',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '89',
  'name' => 'America/Indiana/Marengo',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '90',
  'name' => 'America/Indiana/Vevay',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '91',
  'name' => 'America/Indianapolis',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '92',
  'name' => 'America/Inuvik',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '93',
  'name' => 'America/Iqaluit',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '94',
  'name' => 'America/Jamaica',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '95',
  'name' => 'America/Jujuy',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '96',
  'name' => 'America/Juneau',
  'offset' => '-09:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '97',
  'name' => 'America/Kentucky/Louisville',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '98',
  'name' => 'America/Kentucky/Monticello',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '99',
  'name' => 'America/Knox IN',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '100',
  'name' => 'America/La Paz',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '101',
  'name' => 'America/Lima',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '102',
  'name' => 'America/Los Angeles',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '103',
  'name' => 'America/Louisville',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '104',
  'name' => 'America/Maceio',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '105',
  'name' => 'America/Managua',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '106',
  'name' => 'America/Manaus',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '107',
  'name' => 'America/Martinique',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '108',
  'name' => 'America/Mazatlan',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '109',
  'name' => 'America/Mendoza',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '110',
  'name' => 'America/Menominee',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '111',
  'name' => 'America/Merida',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '112',
  'name' => 'America/Mexico City',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '113',
  'name' => 'America/Miquelon',
  'offset' => '-03:00:00',
  'offset_dst' => '-02:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '114',
  'name' => 'America/Monterrey',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '115',
  'name' => 'America/Montevideo',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '116',
  'name' => 'America/Montreal',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '117',
  'name' => 'America/Montserrat',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '118',
  'name' => 'America/Nassau',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '119',
  'name' => 'America/New York',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '120',
  'name' => 'America/Nipigon',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '121',
  'name' => 'America/Nome',
  'offset' => '-09:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '122',
  'name' => 'America/Noronha',
  'offset' => '-02:00:00',
  'offset_dst' => '-02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '123',
  'name' => 'America/Panama',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '124',
  'name' => 'America/Pangnirtung',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '125',
  'name' => 'America/Paramaribo',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '126',
  'name' => 'America/Phoenix',
  'offset' => '-07:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '127',
  'name' => 'America/Port-au-Prince',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '128',
  'name' => 'America/Port of Spain',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '129',
  'name' => 'America/Porto Acre',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '130',
  'name' => 'America/Porto Velho',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '131',
  'name' => 'America/Puerto Rico',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '132',
  'name' => 'America/Rainy River',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '133',
  'name' => 'America/Rankin Inlet',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '134',
  'name' => 'America/Recife',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '135',
  'name' => 'America/Regina',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '136',
  'name' => 'America/Rio Branco',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '137',
  'name' => 'America/Rosario',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '138',
  'name' => 'America/Santiago',
  'offset' => '-03:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '139',
  'name' => 'America/Santo Domingo',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '140',
  'name' => 'America/Sao Paulo',
  'offset' => '-02:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '141',
  'name' => 'America/Scoresbysund',
  'offset' => '-01:00:00',
  'offset_dst' => '00:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '142',
  'name' => 'America/Shiprock',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '143',
  'name' => 'America/St Johns',
  'offset' => '-03:30:00',
  'offset_dst' => '-02:30:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '144',
  'name' => 'America/St Kitts',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '145',
  'name' => 'America/St Lucia',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '146',
  'name' => 'America/St Thomas',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '147',
  'name' => 'America/St Vincent',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '148',
  'name' => 'America/Swift Current',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '149',
  'name' => 'America/Tegucigalpa',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '150',
  'name' => 'America/Thule',
  'offset' => '-04:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '151',
  'name' => 'America/Thunder Bay',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '152',
  'name' => 'America/Tijuana',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '153',
  'name' => 'America/Tortola',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '154',
  'name' => 'America/Vancouver',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '155',
  'name' => 'America/Virgin',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '156',
  'name' => 'America/Whitehorse',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '157',
  'name' => 'America/Winnipeg',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '158',
  'name' => 'America/Yakutat',
  'offset' => '-09:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '159',
  'name' => 'America/Yellowknife',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '160',
  'name' => 'Antarctica/Casey',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '161',
  'name' => 'Antarctica/Davis',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '162',
  'name' => 'Antarctica/DumontDUrville',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '163',
  'name' => 'Antarctica/Mawson',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '164',
  'name' => 'Antarctica/McMurdo',
  'offset' => '13:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '11',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '165',
  'name' => 'Antarctica/Palmer',
  'offset' => '-03:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '18',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '166',
  'name' => 'Antarctica/South Pole',
  'offset' => '13:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '11',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '167',
  'name' => 'Antarctica/Syowa',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '168',
  'name' => 'Antarctica/Vostok',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '169',
  'name' => 'Arctic/Longyearbyen',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '14',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '170',
  'name' => 'Asia/Aden',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '171',
  'name' => 'Asia/Almaty',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '172',
  'name' => 'Asia/Amman',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '8',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '173',
  'name' => 'Asia/Anadyr',
  'offset' => '12:00:00',
  'offset_dst' => '13:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '174',
  'name' => 'Asia/Aqtau',
  'offset' => '04:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '175',
  'name' => 'Asia/Aqtobe',
  'offset' => '05:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '176',
  'name' => 'Asia/Ashgabat',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '177',
  'name' => 'Asia/Ashkhabad',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '178',
  'name' => 'Asia/Baghdad',
  'offset' => '03:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '4',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '179',
  'name' => 'Asia/Bahrain',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '180',
  'name' => 'Asia/Baku',
  'offset' => '04:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '181',
  'name' => 'Asia/Bangkok',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '182',
  'name' => 'Asia/Beirut',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '6',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '183',
  'name' => 'Asia/Bishkek',
  'offset' => '05:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '6',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '184',
  'name' => 'Asia/Brunei',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '185',
  'name' => 'Asia/Calcutta',
  'offset' => '05:30:00',
  'offset_dst' => '05:30:30',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '186',
  'name' => 'Asia/Chungking',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '187',
  'name' => 'Asia/Colombo',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '188',
  'name' => 'Asia/Dacca',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '189',
  'name' => 'Asia/Damascus',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '4',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '190',
  'name' => 'Asia/Dhaka',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '191',
  'name' => 'Asia/Dili',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '192',
  'name' => 'Asia/Dubai',
  'offset' => '04:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '193',
  'name' => 'Asia/Dushanbe',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '194',
  'name' => 'Asia/Gaza',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '7',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '195',
  'name' => 'Asia/Harbin',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '196',
  'name' => 'Asia/Hong Kong',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '197',
  'name' => 'Asia/Hovd',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '198',
  'name' => 'Asia/Irkutsk',
  'offset' => '08:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '199',
  'name' => 'Asia/Istanbul',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '200',
  'name' => 'Asia/Jakarta',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '201',
  'name' => 'Asia/Jayapura',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '202',
  'name' => 'Asia/Jerusalem',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '5',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '203',
  'name' => 'Asia/Kabul',
  'offset' => '04:30:00',
  'offset_dst' => '04:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '204',
  'name' => 'Asia/Kamchatka',
  'offset' => '12:00:00',
  'offset_dst' => '13:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '205',
  'name' => 'Asia/Karachi',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '206',
  'name' => 'Asia/Kashgar',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '207',
  'name' => 'Asia/Katmandu',
  'offset' => '05:45:00',
  'offset_dst' => '05:45:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '208',
  'name' => 'Asia/Krasnoyarsk',
  'offset' => '07:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '209',
  'name' => 'Asia/Kuala Lumpur',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '210',
  'name' => 'Asia/Kuching',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '211',
  'name' => 'Asia/Kuwait',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '212',
  'name' => 'Asia/Macao',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '213',
  'name' => 'Asia/Magadan',
  'offset' => '11:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '214',
  'name' => 'Asia/Manila',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '215',
  'name' => 'Asia/Muscat',
  'offset' => '04:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '216',
  'name' => 'Asia/Nicosia',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '217',
  'name' => 'Asia/Novosibirsk',
  'offset' => '06:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '218',
  'name' => 'Asia/Omsk',
  'offset' => '06:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '219',
  'name' => 'Asia/Phnom Penh',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '220',
  'name' => 'Asia/Pyongyang',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '221',
  'name' => 'Asia/Qatar',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '222',
  'name' => 'Asia/Rangoon',
  'offset' => '06:30:00',
  'offset_dst' => '06:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '223',
  'name' => 'Asia/Riyadh',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '224',
  'name' => 'Asia/Riyadh87',
  'offset' => '03:07:04',
  'offset_dst' => '03:07:04',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '225',
  'name' => 'Asia/Riyadh88',
  'offset' => '03:07:04',
  'offset_dst' => '03:07:04',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '226',
  'name' => 'Asia/Riyadh89',
  'offset' => '03:07:04',
  'offset_dst' => '03:07:04',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '227',
  'name' => 'Asia/Saigon',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '228',
  'name' => 'Asia/Samarkand',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '229',
  'name' => 'Asia/Seoul',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '230',
  'name' => 'Asia/Shanghai',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '231',
  'name' => 'Asia/Singapore',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '232',
  'name' => 'Asia/Taipei',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '233',
  'name' => 'Asia/Tashkent',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '234',
  'name' => 'Asia/Tbilisi',
  'offset' => '04:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '235',
  'name' => 'Asia/Tehran',
  'offset' => '03:30:00',
  'offset_dst' => '04:30:00',
  'dst_region' => '8',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '236',
  'name' => 'Asia/Tel Aviv',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '5',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '237',
  'name' => 'Asia/Thimbu',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '238',
  'name' => 'Asia/Thimphu',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '239',
  'name' => 'Asia/Tokyo',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '240',
  'name' => 'Asia/Ujung Pandang',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '241',
  'name' => 'Asia/Ulaanbaatar',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '242',
  'name' => 'Asia/Ulan Bator',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '243',
  'name' => 'Asia/Urumqi',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '244',
  'name' => 'Asia/Vientiane',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '245',
  'name' => 'Asia/Vladivostok',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '246',
  'name' => 'Asia/Yakutsk',
  'offset' => '09:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '247',
  'name' => 'Asia/Yekaterinburg',
  'offset' => '05:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '248',
  'name' => 'Asia/Yerevan',
  'offset' => '04:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '249',
  'name' => 'Atlantic/Azores',
  'offset' => '-01:00:00',
  'offset_dst' => '00:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '250',
  'name' => 'Atlantic/Bermuda',
  'offset' => '-04:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '251',
  'name' => 'Atlantic/Canary',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '252',
  'name' => 'Atlantic/Cape Verde',
  'offset' => '-01:00:00',
  'offset_dst' => '-01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '253',
  'name' => 'Atlantic/Faeroe',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '254',
  'name' => 'Atlantic/Jan Mayen',
  'offset' => '-01:00:00',
  'offset_dst' => '-01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '255',
  'name' => 'Atlantic/Madeira',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '256',
  'name' => 'Atlantic/South Georgia',
  'offset' => '-02:00:00',
  'offset_dst' => '-02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '257',
  'name' => 'Atlantic/Stanley',
  'offset' => '-03:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '19',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '258',
  'name' => 'Australia/ACT',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '259',
  'name' => 'Australia/Adelaide',
  'offset' => '10:30:00',
  'offset_dst' => '09:30:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '260',
  'name' => 'Australia/Brisbane',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '261',
  'name' => 'Australia/Broken Hill',
  'offset' => '10:30:00',
  'offset_dst' => '09:30:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '262',
  'name' => 'Australia/Canberra',
  'offset' => '11:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '263',
  'name' => 'Australia/Darwin',
  'offset' => '09:30:00',
  'offset_dst' => '09:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '264',
  'name' => 'Australia/Hobart',
  'offset' => '11:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '10',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '265',
  'name' => 'Australia/LHI',
  'offset' => '11:00:00',
  'offset_dst' => '10:30:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '266',
  'name' => 'Australia/Lindeman',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '267',
  'name' => 'Australia/Lord Howe',
  'offset' => '11:00:00',
  'offset_dst' => '10:30:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '268',
  'name' => 'Australia/Melbourne',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '10',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '269',
  'name' => 'Australia/NSW',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '270',
  'name' => 'Australia/North',
  'offset' => '09:30:00',
  'offset_dst' => '09:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '271',
  'name' => 'Australia/Perth',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '272',
  'name' => 'Australia/Queensland',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '273',
  'name' => 'Australia/South',
  'offset' => '10:30:00',
  'offset_dst' => '09:30:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '274',
  'name' => 'Australia/Sydney',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '10',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '275',
  'name' => 'Australia/Tasmania',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '276',
  'name' => 'Australia/Victoria',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '277',
  'name' => 'Australia/West',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '278',
  'name' => 'Australia/Yancowinna',
  'offset' => '10:30:00',
  'offset_dst' => '09:30:00',
  'dst_region' => '10',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '279',
  'name' => 'Brazil/Acre',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '280',
  'name' => 'Brazil/DeNoronha',
  'offset' => '-02:00:00',
  'offset_dst' => '-02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '281',
  'name' => 'Brazil/East',
  'offset' => '-02:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '17',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '282',
  'name' => 'Brazil/West',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '285',
  'name' => 'Canada/Atlantic',
  'offset' => '-04:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '286',
  'name' => 'Canada/Central',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '287',
  'name' => 'Canada/Central-Saskatchewan',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '288',
  'name' => 'Canada/Eastern',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '289',
  'name' => 'Canada/Mountain',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '290',
  'name' => 'Canada/Newfoundland',
  'offset' => '-03:30:00',
  'offset_dst' => '-02:30:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '291',
  'name' => 'Canada/Pacific',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '292',
  'name' => 'Canada/Saskatchewan',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '293',
  'name' => 'Canada/Yukon',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '294',
  'name' => 'Chile/Continental',
  'offset' => '-03:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '18',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '295',
  'name' => 'Chile/EasterIsland',
  'offset' => '-05:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '18',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '296',
  'name' => 'Cuba',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '16',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '298',
  'name' => 'EST',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '300',
  'name' => 'Egypt',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '1',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '301',
  'name' => 'Eire',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '302',
  'name' => 'Etc/GMT-1',
  'offset' => '-01:00:00',
  'offset_dst' => '-01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '303',
  'name' => 'Etc/GMT-10',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '304',
  'name' => 'Etc/GMT-11',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '305',
  'name' => 'Etc/GMT-12',
  'offset' => '-12:00:00',
  'offset_dst' => '-12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '306',
  'name' => 'Etc/GMT-2',
  'offset' => '-02:00:00',
  'offset_dst' => '-02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '307',
  'name' => 'Etc/GMT-3',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '308',
  'name' => 'Etc/GMT-4',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '309',
  'name' => 'Etc/GMT-5',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '310',
  'name' => 'Etc/GMT-6',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '311',
  'name' => 'Etc/GMT-7',
  'offset' => '-07:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '312',
  'name' => 'Etc/GMT-8',
  'offset' => '-08:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '313',
  'name' => 'Etc/GMT-9',
  'offset' => '-09:00:00',
  'offset_dst' => '-09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '314',
  'name' => 'Etc/GMT+1',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '315',
  'name' => 'Etc/GMT+10',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '316',
  'name' => 'Etc/GMT+11',
  'offset' => '11:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '317',
  'name' => 'Etc/GMT+12',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '318',
  'name' => 'Etc/GMT+13',
  'offset' => '13:00:00',
  'offset_dst' => '13:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '319',
  'name' => 'Etc/GMT+14',
  'offset' => '14:00:00',
  'offset_dst' => '14:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '320',
  'name' => 'Etc/GMT+2',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '321',
  'name' => 'Etc/GMT+3',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '322',
  'name' => 'Etc/GMT+4',
  'offset' => '04:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '323',
  'name' => 'Etc/GMT+5',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '324',
  'name' => 'Etc/GMT+6',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '325',
  'name' => 'Etc/GMT+7',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '326',
  'name' => 'Etc/GMT+8',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '327',
  'name' => 'Etc/GMT+9',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '328',
  'name' => 'Europe/Amsterdam',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '329',
  'name' => 'Europe/Andorra',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '330',
  'name' => 'Europe/Athens',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '331',
  'name' => 'Europe/Belfast',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '332',
  'name' => 'Europe/Belgrade',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '333',
  'name' => 'Europe/Berlin',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '334',
  'name' => 'Europe/Bratislava',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '335',
  'name' => 'Europe/Brussels',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '336',
  'name' => 'Europe/Bucharest',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '337',
  'name' => 'Europe/Budapest',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '338',
  'name' => 'Europe/Chisinau',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '339',
  'name' => 'Europe/Copenhagen',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '340',
  'name' => 'Europe/Dublin',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '341',
  'name' => 'Europe/Gibraltar',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '342',
  'name' => 'Europe/Helsinki',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '343',
  'name' => 'Europe/Istanbul',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '344',
  'name' => 'Europe/Kaliningrad',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '345',
  'name' => 'Europe/Kiev',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '346',
  'name' => 'Europe/Lisbon',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '347',
  'name' => 'Europe/Ljubljana',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '348',
  'name' => 'Europe/London',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '349',
  'name' => 'Europe/Luxembourg',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '350',
  'name' => 'Europe/Madrid',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '351',
  'name' => 'Europe/Malta',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '352',
  'name' => 'Europe/Minsk',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '353',
  'name' => 'Europe/Monaco',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '354',
  'name' => 'Europe/Moscow',
  'offset' => '03:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '14',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '355',
  'name' => 'Europe/Nicosia',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '356',
  'name' => 'Europe/Oslo',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '357',
  'name' => 'Europe/Paris',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '358',
  'name' => 'Europe/Prague',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '359',
  'name' => 'Europe/Riga',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '360',
  'name' => 'Europe/Rome',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '361',
  'name' => 'Europe/Samara',
  'offset' => '04:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '362',
  'name' => 'Europe/San Marino',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '363',
  'name' => 'Europe/Sarajevo',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '364',
  'name' => 'Europe/Simferopol',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '365',
  'name' => 'Europe/Skopje',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '366',
  'name' => 'Europe/Sofia',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '367',
  'name' => 'Europe/Stockholm',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '368',
  'name' => 'Europe/Tallinn',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '369',
  'name' => 'Europe/Tirane',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '370',
  'name' => 'Europe/Tiraspol',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '371',
  'name' => 'Europe/Uzhgorod',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '372',
  'name' => 'Europe/Vaduz',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '373',
  'name' => 'Europe/Vatican',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '374',
  'name' => 'Europe/Vienna',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '375',
  'name' => 'Europe/Vilnius',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '376',
  'name' => 'Europe/Warsaw',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '377',
  'name' => 'Europe/Zagreb',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '378',
  'name' => 'Europe/Zaporozhye',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '379',
  'name' => 'Europe/Zurich',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '380',
  'name' => 'GB',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '381',
  'name' => 'GB-Eire',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '383',
  'name' => 'Hongkong',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '384',
  'name' => 'Indian/Antananarivo',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '385',
  'name' => 'Indian/Chagos',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '386',
  'name' => 'Indian/Christmas',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '387',
  'name' => 'Indian/Cocos',
  'offset' => '06:30:00',
  'offset_dst' => '06:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '388',
  'name' => 'Indian/Comoro',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '389',
  'name' => 'Indian/Kerguelen',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '390',
  'name' => 'Indian/Mahe',
  'offset' => '04:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '391',
  'name' => 'Indian/Maldives',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '392',
  'name' => 'Indian/Mauritius',
  'offset' => '04:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '393',
  'name' => 'Indian/Mayotte',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '394',
  'name' => 'Indian/Reunion',
  'offset' => '04:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '395',
  'name' => 'Iran',
  'offset' => '03:30:00',
  'offset_dst' => '04:30:00',
  'dst_region' => '8',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '396',
  'name' => 'Israel',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '5',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '397',
  'name' => 'Jamaica',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '398',
  'name' => 'Japan',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '399',
  'name' => 'Kwajalein',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '400',
  'name' => 'Libya',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '404',
  'name' => 'Mexico/BajaNorte',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '405',
  'name' => 'Mexico/BajaSur',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '406',
  'name' => 'Mexico/General',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '407',
  'name' => 'Mideast/Riyadh87',
  'offset' => '03:07:04',
  'offset_dst' => '03:07:04',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '408',
  'name' => 'Mideast/Riyadh88',
  'offset' => '03:07:04',
  'offset_dst' => '03:07:04',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '409',
  'name' => 'Mideast/Riyadh89',
  'offset' => '03:07:04',
  'offset_dst' => '03:07:04',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '410',
  'name' => 'NZ',
  'offset' => '13:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '11',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '412',
  'name' => 'Navajo',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '415',
  'name' => 'Pacific/Apia',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '416',
  'name' => 'Pacific/Auckland',
  'offset' => '13:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '417',
  'name' => 'Pacific/Chatham',
  'offset' => '13:45:00',
  'offset_dst' => '12:45:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '418',
  'name' => 'Pacific/Easter',
  'offset' => '-05:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '419',
  'name' => 'Pacific/Efate',
  'offset' => '11:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '420',
  'name' => 'Pacific/Enderbury',
  'offset' => '13:00:00',
  'offset_dst' => '13:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '421',
  'name' => 'Pacific/Fakaofo',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '422',
  'name' => 'Pacific/Fiji',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '423',
  'name' => 'Pacific/Funafuti',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '424',
  'name' => 'Pacific/Galapagos',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '425',
  'name' => 'Pacific/Gambier',
  'offset' => '-09:00:00',
  'offset_dst' => '-09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '426',
  'name' => 'Pacific/Guadalcanal',
  'offset' => '11:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '427',
  'name' => 'Pacific/Guam',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '428',
  'name' => 'Pacific/Honolulu',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '429',
  'name' => 'Pacific/Johnston',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '430',
  'name' => 'Pacific/Kiritimati',
  'offset' => '14:00:00',
  'offset_dst' => '14:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '431',
  'name' => 'Pacific/Kosrae',
  'offset' => '11:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '432',
  'name' => 'Pacific/Kwajalein',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '433',
  'name' => 'Pacific/Majuro',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '434',
  'name' => 'Pacific/Marquesas',
  'offset' => '-09:30:00',
  'offset_dst' => '-09:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '435',
  'name' => 'Pacific/Midway',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '436',
  'name' => 'Pacific/Nauru',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '437',
  'name' => 'Pacific/Niue',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '438',
  'name' => 'Pacific/Norfolk',
  'offset' => '11:30:00',
  'offset_dst' => '11:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '439',
  'name' => 'Pacific/Noumea',
  'offset' => '11:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '440',
  'name' => 'Pacific/Pago Pago',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '441',
  'name' => 'Pacific/Palau',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '442',
  'name' => 'Pacific/Pitcairn',
  'offset' => '-08:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '443',
  'name' => 'Pacific/Ponape',
  'offset' => '11:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '444',
  'name' => 'Pacific/Port Moresby',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '445',
  'name' => 'Pacific/Rarotonga',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '446',
  'name' => 'Pacific/Saipan',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '447',
  'name' => 'Pacific/Samoa',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '448',
  'name' => 'Pacific/Tahiti',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '449',
  'name' => 'Pacific/Tarawa',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '450',
  'name' => 'Pacific/Tongatapu',
  'offset' => '13:00:00',
  'offset_dst' => '13:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '451',
  'name' => 'Pacific/Truk',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '452',
  'name' => 'Pacific/Wake',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '453',
  'name' => 'Pacific/Wallis',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '454',
  'name' => 'Pacific/Yap',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '455',
  'name' => 'Poland',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '456',
  'name' => 'Portugal',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '459',
  'name' => 'Singapore',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '473',
  'name' => 'Turkey',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '474',
  'name' => 'US/Alaska',
  'offset' => '-09:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '475',
  'name' => 'US/Aleutian',
  'offset' => '-10:00:00',
  'offset_dst' => '-09:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '476',
  'name' => 'US/Arizona',
  'offset' => '-07:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '477',
  'name' => 'US/Central',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '478',
  'name' => 'US/East-Indiana',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '479',
  'name' => 'US/Eastern',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '480',
  'name' => 'US/Hawaii',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '481',
  'name' => 'US/Indiana-Starke',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '482',
  'name' => 'US/Michigan',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '483',
  'name' => 'US/Mountain',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '484',
  'name' => 'US/Pacific',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '485',
  'name' => 'US/Samoa',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '486',
  'name' => 'Pacific/French Polynesia-Marquesas Islands',
  'offset' => '-09:30:00',
  'offset_dst' => '-09:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '487',
  'name' => 'Etc/GMT',
  'offset' => '00:00:00',
  'offset_dst' => '00:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->execute();
$connection->schema()->createTable('files', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'filepath' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'filemime' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'filesize' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('files')
->fields(array(
  'fid',
  'uid',
  'filename',
  'filepath',
  'filemime',
  'filesize',
  'status',
  'timestamp',
))
->values(array(
  'fid' => '5',
  'uid' => '1',
  'filename' => 'html-1.txt',
  'filepath' => 'core/tests/fixtures/files/html-1.txt',
  'filemime' => 'text/plain',
  'filesize' => '24',
  'status' => '1',
  'timestamp' => '1420858106',
))
->execute();
$connection->schema()->createTable('filter_formats', array(
  'fields' => array(
    'format' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'roles' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'format',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('filter_formats')
->fields(array(
  'format',
  'name',
  'roles',
  'cache',
))
->values(array(
  'format' => '1',
  'name' => 'Filtered HTML',
  'roles' => ',1,2,',
  'cache' => '1',
))
->values(array(
  'format' => '2',
  'name' => 'Full HTML',
  'roles' => '3',
  'cache' => '1',
))
->values(array(
  'format' => '3',
  'name' => 'Escape HTML Filter',
  'roles' => '',
  'cache' => '1',
))
->values(array(
  'format' => '4',
  'name' => 'PHP Code',
  'roles' => ',3,4,5,',
  'cache' => '0',
))
->execute();
$connection->schema()->createTable('filters', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'format' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('filters')
->fields(array(
  'fid',
  'format',
  'module',
  'delta',
  'weight',
))
->values(array(
  'fid' => '1',
  'format' => '1',
  'module' => 'filter',
  'delta' => '2',
  'weight' => '0',
))
->values(array(
  'fid' => '2',
  'format' => '1',
  'module' => 'filter',
  'delta' => '0',
  'weight' => '1',
))
->values(array(
  'fid' => '3',
  'format' => '1',
  'module' => 'filter',
  'delta' => '1',
  'weight' => '2',
))
->values(array(
  'fid' => '4',
  'format' => '1',
  'module' => 'filter',
  'delta' => '3',
  'weight' => '10',
))
->values(array(
  'fid' => '5',
  'format' => '2',
  'module' => 'filter',
  'delta' => '2',
  'weight' => '0',
))
->values(array(
  'fid' => '6',
  'format' => '2',
  'module' => 'filter',
  'delta' => '1',
  'weight' => '1',
))
->values(array(
  'fid' => '7',
  'format' => '2',
  'module' => 'filter',
  'delta' => '3',
  'weight' => '10',
))
->values(array(
  'fid' => '8',
  'format' => '6',
  'module' => 'filter',
  'delta' => '2',
  'weight' => '0',
))
->values(array(
  'fid' => '9',
  'format' => '6',
  'module' => 'filter',
  'delta' => '0',
  'weight' => '1',
))
->values(array(
  'fid' => '10',
  'format' => '6',
  'module' => 'filter',
  'delta' => '1',
  'weight' => '2',
))
->values(array(
  'fid' => '11',
  'format' => '6',
  'module' => 'filter',
  'delta' => '3',
  'weight' => '10',
))
->values(array(
  'fid' => '16',
  'format' => '4',
  'module' => 'php',
  'delta' => '0',
  'weight' => '10',
))
->execute();
$connection->schema()->createTable('flood', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'event' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('forum', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'tid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
    'tid' => array(
      'tid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('forum')
->fields(array(
  'nid',
  'vid',
  'tid',
))
->values(array(
  'nid' => '19',
  'vid' => '22',
  'tid' => '8',
))
->values(array(
  'nid' => '20',
  'vid' => '23',
  'tid' => '10',
))
->execute();
$connection->schema()->createTable('history', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'uid',
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('history')
->fields(array(
  'uid',
  'nid',
  'timestamp',
))
->values(array(
  'uid' => '1',
  'nid' => '4',
  'timestamp' => '1675400063',
))
->values(array(
  'uid' => '1',
  'nid' => '8',
  'timestamp' => '1675400045',
))
->values(array(
  'uid' => '1',
  'nid' => '19',
  'timestamp' => '1687738850',
))
->values(array(
  'uid' => '1',
  'nid' => '20',
  'timestamp' => '1679803849',
))
->values(array(
  'uid' => '1',
  'nid' => '21',
  'timestamp' => '1675400003',
))
->execute();
$connection->schema()->createTable('imagecache_action', array(
  'fields' => array(
    'actionid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'presetid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'action' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'data' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'actionid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('imagecache_action')
->fields(array(
  'actionid',
  'presetid',
  'weight',
  'module',
  'action',
  'data',
))
->values(array(
  'actionid' => '3',
  'presetid' => '1',
  'weight' => '0',
  'module' => 'imagecache',
  'action' => 'imagecache_scale_and_crop',
  'data' => 'a:2:{s:5:"width";s:4:"100%";s:6:"height";s:4:"100%";}',
))
->values(array(
  'actionid' => '4',
  'presetid' => '2',
  'weight' => '0',
  'module' => 'imagecache',
  'action' => 'imagecache_crop',
  'data' => 'a:4:{s:5:"width";s:3:"555";s:6:"height";s:4:"5555";s:7:"xoffset";s:6:"center";s:7:"yoffset";s:6:"center";}',
))
->values(array(
  'actionid' => '5',
  'presetid' => '2',
  'weight' => '0',
  'module' => 'imagecache',
  'action' => 'imagecache_resize',
  'data' => 'a:2:{s:5:"width";s:3:"55%";s:6:"height";s:3:"55%";}',
))
->values(array(
  'actionid' => '6',
  'presetid' => '2',
  'weight' => '0',
  'module' => 'imagecache',
  'action' => 'imagecache_rotate',
  'data' => 'a:3:{s:7:"degrees";s:2:"55";s:6:"random";i:0;s:7:"bgcolor";s:0:"";}',
))
->values(array(
  'actionid' => '7',
  'presetid' => '2',
  'weight' => '0',
  'module' => 'imagecache',
  'action' => '',
  'data' => 'a:3:{s:7:"degrees";s:2:"55";s:6:"random";i:0;s:7:"bgcolor";s:0:"";}',
))
->execute();
$connection->schema()->createTable('imagecache_preset', array(
  'fields' => array(
    'presetid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'presetname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'presetid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('imagecache_preset')
->fields(array(
  'presetid',
  'presetname',
))
->values(array(
  'presetid' => '1',
  'presetname' => 'slackjaw_boys',
))
->values(array(
  'presetid' => '2',
  'presetname' => 'big_blue_cheese',
))
->execute();
$connection->schema()->createTable('menu_custom', array(
  'fields' => array(
    'menu_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'menu_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_custom')
->fields(array(
  'menu_name',
  'title',
  'description',
))
->values(array(
  'menu_name' => 'navigation',
  'title' => 'Navigation',
  'description' => 'The navigation menu is provided by Drupal and is the main interactive menu for any site. It is usually the only menu that contains personalized links for authenticated users, and is often not even visible to anonymous users.',
))
->values(array(
  'menu_name' => 'primary-links',
  'title' => 'Primary links',
  'description' => 'Primary links are often used at the theme layer to show the major sections of a site. A typical representation for primary links would be tabs along the top.',
))
->values(array(
  'menu_name' => 'secondary-links',
  'title' => 'Secondary links',
  'description' => 'Secondary links are often used for pages like legal notices, contact details, and other secondary navigation items that play a lesser role than primary links',
))
->execute();
$connection->schema()->createTable('menu_links', array(
  'fields' => array(
    'menu_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'mlid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'plid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'link_path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'router_path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'link_title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'options' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => 'system',
    ),
    'hidden' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'external' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'has_children' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'expanded' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'depth' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'customized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'p1' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p2' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p3' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p4' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p5' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p6' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p7' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p8' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p9' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'updated' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'mlid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_links')
->fields(array(
  'menu_name',
  'mlid',
  'plid',
  'link_path',
  'router_path',
  'link_title',
  'options',
  'module',
  'hidden',
  'external',
  'has_children',
  'expanded',
  'weight',
  'depth',
  'customized',
  'p1',
  'p2',
  'p3',
  'p4',
  'p5',
  'p6',
  'p7',
  'p8',
  'p9',
  'updated',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '141',
  'plid' => '0',
  'link_path' => 'node',
  'router_path' => 'node',
  'link_title' => 'Content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '141',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '142',
  'plid' => '0',
  'link_path' => 'rss.xml',
  'router_path' => 'rss.xml',
  'link_title' => 'RSS feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '142',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '143',
  'plid' => '0',
  'link_path' => 'batch',
  'router_path' => 'batch',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '143',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '144',
  'plid' => '0',
  'link_path' => 'admin',
  'router_path' => 'admin',
  'link_title' => 'Administer',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '9',
  'depth' => '1',
  'customized' => '0',
  'p1' => '144',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '147',
  'plid' => '0',
  'link_path' => 'logout',
  'router_path' => 'logout',
  'link_title' => 'Log out',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '147',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '148',
  'plid' => '0',
  'link_path' => 'user',
  'router_path' => 'user',
  'link_title' => 'User account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '148',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '150',
  'plid' => '0',
  'link_path' => 'node/%',
  'router_path' => 'node/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '150',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '153',
  'plid' => '0',
  'link_path' => 'taxonomy/autocomplete',
  'router_path' => 'taxonomy/autocomplete',
  'link_title' => 'Autocomplete taxonomy',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '153',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '155',
  'plid' => '144',
  'link_path' => 'admin/compact',
  'router_path' => 'admin/compact',
  'link_title' => 'Compact mode',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '155',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '156',
  'plid' => '0',
  'link_path' => 'filter/tips',
  'router_path' => 'filter/tips',
  'link_title' => 'Compose tips',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '156',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '157',
  'plid' => '144',
  'link_path' => 'admin/content',
  'router_path' => 'admin/content',
  'link_title' => 'Content management',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:27:\"Manage your site's content.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '158',
  'plid' => '0',
  'link_path' => 'node/add',
  'router_path' => 'node/add',
  'link_title' => 'Create content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '1',
  'customized' => '0',
  'p1' => '158',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '159',
  'plid' => '0',
  'link_path' => 'comment/delete',
  'router_path' => 'comment/delete',
  'link_title' => 'Delete comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '159',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '160',
  'plid' => '0',
  'link_path' => 'comment/edit',
  'router_path' => 'comment/edit',
  'link_title' => 'Edit comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '160',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '161',
  'plid' => '0',
  'link_path' => 'system/files',
  'router_path' => 'system/files',
  'link_title' => 'File download',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '161',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '165',
  'plid' => '144',
  'link_path' => 'admin/reports',
  'router_path' => 'admin/reports',
  'link_title' => 'Reports',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:59:"View reports from system logs and other status information.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '166',
  'plid' => '144',
  'link_path' => 'admin/build',
  'router_path' => 'admin/build',
  'link_title' => 'Site building',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:38:"Control how your site looks and feels.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '167',
  'plid' => '144',
  'link_path' => 'admin/settings',
  'router_path' => 'admin/settings',
  'link_title' => 'Site configuration',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:40:"Adjust basic site configuration options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '169',
  'plid' => '0',
  'link_path' => 'user/autocomplete',
  'router_path' => 'user/autocomplete',
  'link_title' => 'User autocomplete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '169',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '170',
  'plid' => '144',
  'link_path' => 'admin/user',
  'router_path' => 'admin/user',
  'link_title' => 'User management',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:61:\"Manage your site's users, groups and access to site features.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '172',
  'plid' => '0',
  'link_path' => 'user/%',
  'router_path' => 'user/%',
  'link_title' => 'My account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '172',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '175',
  'plid' => '170',
  'link_path' => 'admin/user/rules',
  'router_path' => 'admin/user/rules',
  'link_title' => 'Access rules',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:80:"List and create rules to disallow usernames, e-mail addresses, and IP addresses.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '175',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '176',
  'plid' => '167',
  'link_path' => 'admin/settings/actions',
  'router_path' => 'admin/settings/actions',
  'link_title' => 'Actions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Manage the actions defined for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '176',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '177',
  'plid' => '167',
  'link_path' => 'admin/settings/admin',
  'router_path' => 'admin/settings/admin',
  'link_title' => 'Administration theme',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:55:"Settings for how your administrative pages should look.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '177',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '178',
  'plid' => '158',
  'link_path' => 'node/add/article',
  'router_path' => 'node/add/article',
  'link_title' => 'Article',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:34:"An <em>article</em>, content type.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '178',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '179',
  'plid' => '166',
  'link_path' => 'admin/build/block',
  'router_path' => 'admin/build/block',
  'link_title' => 'Blocks',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:79:\"Configure what block content appears in your site's sidebars and other regions.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '179',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '180',
  'plid' => '167',
  'link_path' => 'admin/settings/clean-urls',
  'router_path' => 'admin/settings/clean-urls',
  'link_title' => 'Clean URLs',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Enable or disable clean URLs for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '180',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '181',
  'plid' => '157',
  'link_path' => 'admin/content/comment',
  'router_path' => 'admin/content/comment',
  'link_title' => 'Comments',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:61:"List and edit site comments and the comment moderation queue.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '181',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '182',
  'plid' => '158',
  'link_path' => 'node/add/company',
  'router_path' => 'node/add/company',
  'link_title' => 'Company',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Company node type";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '182',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '184',
  'plid' => '157',
  'link_path' => 'admin/content/node',
  'router_path' => 'admin/content/node',
  'link_title' => 'Content',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:43:\"View, edit, and delete your site's content.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '184',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '185',
  'plid' => '157',
  'link_path' => 'admin/content/types',
  'router_path' => 'admin/content/types',
  'link_title' => 'Content types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:82:"Manage posts by content type, including default status, front page promotion, etc.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '185',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '186',
  'plid' => '167',
  'link_path' => 'admin/settings/date-time',
  'router_path' => 'admin/settings/date-time',
  'link_title' => 'Date and time',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:89:\"Settings for how Drupal displays date and time, as well as the system's default timezone.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '186',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '187',
  'plid' => '0',
  'link_path' => 'node/%/delete',
  'router_path' => 'node/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '1',
  'customized' => '0',
  'p1' => '187',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '188',
  'plid' => '172',
  'link_path' => 'user/%/delete',
  'router_path' => 'user/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '172',
  'p2' => '188',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '189',
  'plid' => '158',
  'link_path' => 'node/add/employee',
  'router_path' => 'node/add/employee',
  'link_title' => 'Employee',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:18:"Employee node type";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '189',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '190',
  'plid' => '167',
  'link_path' => 'admin/settings/error-reporting',
  'router_path' => 'admin/settings/error-reporting',
  'link_title' => 'Error reporting',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:93:"Control how Drupal deals with errors including 403/404 errors as well as PHP error reporting.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '190',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '192',
  'plid' => '167',
  'link_path' => 'admin/settings/file-system',
  'router_path' => 'admin/settings/file-system',
  'link_title' => 'File system',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:68:"Tell Drupal where to store uploaded files and how they are accessed.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '192',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '194',
  'plid' => '167',
  'link_path' => 'admin/settings/image-toolkit',
  'router_path' => 'admin/settings/image-toolkit',
  'link_title' => 'Image toolkit',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:74:"Choose which image toolkit to use if you have installed optional toolkits.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '194',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '195',
  'plid' => '167',
  'link_path' => 'admin/settings/filters',
  'router_path' => 'admin/settings/filters',
  'link_title' => 'Input formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:127:"Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '195',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '196',
  'plid' => '167',
  'link_path' => 'admin/settings/logging',
  'router_path' => 'admin/settings/logging',
  'link_title' => 'Logging and alerts',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:156:\"Settings for logging and alerts modules. Various modules can route Drupal's system events to different destination, such as syslog, database, email, ...etc.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '196',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '197',
  'plid' => '166',
  'link_path' => 'admin/build/menu',
  'router_path' => 'admin/build/menu',
  'link_title' => 'Menus',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:116:\"Control your site's navigation menu, primary links and secondary links, as well as rename and reorganize menu items.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '197',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '202',
  'plid' => '166',
  'link_path' => 'admin/build/modules',
  'router_path' => 'admin/build/modules',
  'link_title' => 'Modules',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Enable or disable add-on modules for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '202',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '203',
  'plid' => '167',
  'link_path' => 'admin/settings/performance',
  'router_path' => 'admin/settings/performance',
  'link_title' => 'Performance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:101:"Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '203',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '204',
  'plid' => '170',
  'link_path' => 'admin/user/permissions',
  'router_path' => 'admin/user/permissions',
  'link_title' => 'Permissions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '204',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '205',
  'plid' => '157',
  'link_path' => 'admin/content/node-settings',
  'router_path' => 'admin/content/node-settings',
  'link_title' => 'Post settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:126:"Control posting behavior, such as teaser length, requiring previews before posting, and the number of posts on the front page.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '205',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '207',
  'plid' => '157',
  'link_path' => 'admin/content/rss-publishing',
  'router_path' => 'admin/content/rss-publishing',
  'link_title' => 'RSS publishing',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:92:"Configure the number of items per feed and whether feeds should be titles/teasers/full-text.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '207',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '208',
  'plid' => '0',
  'link_path' => 'comment/reply/%',
  'router_path' => 'comment/reply/%',
  'link_title' => 'Reply to comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '208',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '209',
  'plid' => '170',
  'link_path' => 'admin/user/roles',
  'router_path' => 'admin/user/roles',
  'link_title' => 'Roles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"List, edit, or add user roles.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '209',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '210',
  'plid' => '167',
  'link_path' => 'admin/settings/site-information',
  'router_path' => 'admin/settings/site-information',
  'link_title' => 'Site information',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:107:"Change basic site information, such as the site name, slogan, e-mail address, mission, front page and more.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '210',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '211',
  'plid' => '167',
  'link_path' => 'admin/settings/site-maintenance',
  'router_path' => 'admin/settings/site-maintenance',
  'link_title' => 'Site maintenance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:63:"Take the site off-line for maintenance or bring it back online.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '211',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '212',
  'plid' => '158',
  'link_path' => 'node/add/sponsor',
  'router_path' => 'node/add/sponsor',
  'link_title' => 'Sponsor',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Sponsor node type";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '212',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '213',
  'plid' => '165',
  'link_path' => 'admin/reports/status',
  'router_path' => 'admin/reports/status',
  'link_title' => 'Status report',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:74:\"Get a status report about your site's operation and any detected problems.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '213',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '214',
  'plid' => '157',
  'link_path' => 'admin/content/taxonomy',
  'router_path' => 'admin/content/taxonomy',
  'link_title' => 'Taxonomy',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:67:"Manage tagging, categorization, and classification of your content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '214',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '215',
  'plid' => '0',
  'link_path' => 'taxonomy/term/%',
  'router_path' => 'taxonomy/term/%',
  'link_title' => 'Taxonomy term',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '215',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '216',
  'plid' => '166',
  'link_path' => 'admin/build/themes',
  'router_path' => 'admin/build/themes',
  'link_title' => 'Themes',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:57:"Change which theme your site uses or allows users to set.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '216',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '217',
  'plid' => '170',
  'link_path' => 'admin/user/settings',
  'router_path' => 'admin/user/settings',
  'link_title' => 'User settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:101:"Configure default behavior of users, including registration requirements, e-mails, and user pictures.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '217',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '218',
  'plid' => '170',
  'link_path' => 'admin/user/user',
  'router_path' => 'admin/user/user',
  'link_title' => 'Users',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:26:"List, add, and edit users.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '218',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '219',
  'plid' => '195',
  'link_path' => 'admin/settings/filters/%',
  'router_path' => 'admin/settings/filters/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '195',
  'p4' => '219',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '221',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/article',
  'router_path' => 'admin/content/node-type/article',
  'link_title' => 'Article',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '221',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '222',
  'plid' => '180',
  'link_path' => 'admin/settings/clean-urls/check',
  'router_path' => 'admin/settings/clean-urls/check',
  'link_title' => 'Clean URL check',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '180',
  'p4' => '222',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '223',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/company',
  'router_path' => 'admin/content/node-type/company',
  'link_title' => 'Company',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '223',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '224',
  'plid' => '176',
  'link_path' => 'admin/settings/actions/configure',
  'router_path' => 'admin/settings/actions/configure',
  'link_title' => 'Configure an advanced action',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '176',
  'p4' => '224',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '225',
  'plid' => '179',
  'link_path' => 'admin/build/block/configure',
  'router_path' => 'admin/build/block/configure',
  'link_title' => 'Configure block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '179',
  'p4' => '225',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '226',
  'plid' => '166',
  'link_path' => 'admin/build/menu-customize/%',
  'router_path' => 'admin/build/menu-customize/%',
  'link_title' => 'Customize menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '226',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '227',
  'plid' => '186',
  'link_path' => 'admin/settings/date-time/lookup',
  'router_path' => 'admin/settings/date-time/lookup',
  'link_title' => 'Date and time lookup',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '186',
  'p4' => '227',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '228',
  'plid' => '179',
  'link_path' => 'admin/build/block/delete',
  'router_path' => 'admin/build/block/delete',
  'link_title' => 'Delete block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '179',
  'p4' => '228',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '230',
  'plid' => '195',
  'link_path' => 'admin/settings/filters/delete',
  'router_path' => 'admin/settings/filters/delete',
  'link_title' => 'Delete input format',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '195',
  'p4' => '230',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '231',
  'plid' => '175',
  'link_path' => 'admin/user/rules/delete',
  'router_path' => 'admin/user/rules/delete',
  'link_title' => 'Delete rule',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '175',
  'p4' => '231',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '233',
  'plid' => '209',
  'link_path' => 'admin/user/roles/edit',
  'router_path' => 'admin/user/roles/edit',
  'link_title' => 'Edit role',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '209',
  'p4' => '233',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '234',
  'plid' => '175',
  'link_path' => 'admin/user/rules/edit',
  'router_path' => 'admin/user/rules/edit',
  'link_title' => 'Edit rule',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '175',
  'p4' => '234',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '235',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/employee',
  'router_path' => 'admin/content/node-type/employee',
  'link_title' => 'Employee',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '235',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '236',
  'plid' => '214',
  'link_path' => 'admin/content/taxonomy/%',
  'router_path' => 'admin/content/taxonomy/%',
  'link_title' => 'List terms',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '214',
  'p4' => '236',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '241',
  'plid' => '213',
  'link_path' => 'admin/reports/status/php',
  'router_path' => 'admin/reports/status/php',
  'link_title' => 'PHP',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '213',
  'p4' => '241',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '243',
  'plid' => '205',
  'link_path' => 'admin/content/node-settings/rebuild',
  'router_path' => 'admin/content/node-settings/rebuild',
  'link_title' => 'Rebuild permissions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '205',
  'p4' => '243',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '244',
  'plid' => '176',
  'link_path' => 'admin/settings/actions/orphan',
  'router_path' => 'admin/settings/actions/orphan',
  'link_title' => 'Remove orphans',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '176',
  'p4' => '244',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '245',
  'plid' => '213',
  'link_path' => 'admin/reports/status/run-cron',
  'router_path' => 'admin/reports/status/run-cron',
  'link_title' => 'Run cron',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '213',
  'p4' => '245',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '246',
  'plid' => '213',
  'link_path' => 'admin/reports/status/sql',
  'router_path' => 'admin/reports/status/sql',
  'link_title' => 'SQL',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '213',
  'p4' => '246',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '247',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/sponsor',
  'router_path' => 'admin/content/node-type/sponsor',
  'link_title' => 'Sponsor',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '247',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '249',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/article/delete',
  'router_path' => 'admin/content/node-type/article/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '249',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '250',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/company/delete',
  'router_path' => 'admin/content/node-type/company/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '250',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '251',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/employee/delete',
  'router_path' => 'admin/content/node-type/employee/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '251',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '252',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/sponsor/delete',
  'router_path' => 'admin/content/node-type/sponsor/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '252',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '257',
  'plid' => '176',
  'link_path' => 'admin/settings/actions/delete/%',
  'router_path' => 'admin/settings/actions/delete/%',
  'link_title' => 'Delete action',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Delete an action.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '176',
  'p4' => '257',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '260',
  'plid' => '0',
  'link_path' => 'admin/build/menu-customize/%/delete',
  'router_path' => 'admin/build/menu-customize/%/delete',
  'link_title' => 'Delete menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '260',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '262',
  'plid' => '214',
  'link_path' => 'admin/content/taxonomy/edit/term',
  'router_path' => 'admin/content/taxonomy/edit/term',
  'link_title' => 'Edit term',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '214',
  'p4' => '262',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '263',
  'plid' => '179',
  'link_path' => 'admin/build/block/list/js',
  'router_path' => 'admin/build/block/list/js',
  'link_title' => 'JavaScript List Form',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '179',
  'p4' => '263',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '264',
  'plid' => '202',
  'link_path' => 'admin/build/modules/list/confirm',
  'router_path' => 'admin/build/modules/list/confirm',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '202',
  'p4' => '264',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '266',
  'plid' => '0',
  'link_path' => 'user/reset/%/%/%',
  'router_path' => 'user/reset/%/%/%',
  'link_title' => 'Reset password',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '266',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '267',
  'plid' => '202',
  'link_path' => 'admin/build/modules/uninstall/confirm',
  'router_path' => 'admin/build/modules/uninstall/confirm',
  'link_title' => 'Uninstall',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '202',
  'p4' => '267',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '269',
  'plid' => '0',
  'link_path' => 'node/%/revisions/%/delete',
  'router_path' => 'node/%/revisions/%/delete',
  'link_title' => 'Delete earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '269',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '270',
  'plid' => '0',
  'link_path' => 'node/%/revisions/%/revert',
  'router_path' => 'node/%/revisions/%/revert',
  'link_title' => 'Revert to earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '270',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '271',
  'plid' => '0',
  'link_path' => 'node/%/revisions/%/view',
  'router_path' => 'node/%/revisions/%/view',
  'link_title' => 'Revisions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '271',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '273',
  'plid' => '197',
  'link_path' => 'admin/build/menu/item/%/delete',
  'router_path' => 'admin/build/menu/item/%/delete',
  'link_title' => 'Delete menu item',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '197',
  'p4' => '273',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '276',
  'plid' => '197',
  'link_path' => 'admin/build/menu/item/%/edit',
  'router_path' => 'admin/build/menu/item/%/edit',
  'link_title' => 'Edit menu item',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '197',
  'p4' => '276',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '277',
  'plid' => '214',
  'link_path' => 'admin/content/taxonomy/edit/vocabulary/%',
  'router_path' => 'admin/content/taxonomy/edit/vocabulary/%',
  'link_title' => 'Edit vocabulary',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '214',
  'p4' => '277',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '278',
  'plid' => '197',
  'link_path' => 'admin/build/menu/item/%/reset',
  'router_path' => 'admin/build/menu/item/%/reset',
  'link_title' => 'Reset menu item',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '197',
  'p4' => '278',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '309',
  'plid' => '158',
  'link_path' => 'node/add/story',
  'router_path' => 'node/add/story',
  'link_title' => 'Story',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '309',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '310',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/story',
  'router_path' => 'admin/content/node-type/story',
  'link_title' => 'Story',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '310',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '311',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/delete',
  'router_path' => 'admin/content/node-type/story/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '311',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '394',
  'plid' => '166',
  'link_path' => 'admin/build/path',
  'router_path' => 'admin/build/path',
  'link_title' => 'URL aliases',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:46:\"Change your site's URL paths by aliasing them.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '394',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '395',
  'plid' => '394',
  'link_path' => 'admin/build/path/delete',
  'router_path' => 'admin/build/path/delete',
  'link_title' => 'Delete alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '394',
  'p4' => '395',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '396',
  'plid' => '394',
  'link_path' => 'admin/build/path/edit',
  'router_path' => 'admin/build/path/edit',
  'link_title' => 'Edit alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '394',
  'p4' => '396',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '441',
  'plid' => '0',
  'link_path' => 'forum',
  'router_path' => 'forum',
  'link_title' => 'Forums',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '441',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '443',
  'plid' => '158',
  'link_path' => 'node/add/forum',
  'router_path' => 'node/add/forum',
  'link_title' => 'Forum topic',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:85:"A <em>forum topic</em> is the initial post to a new discussion thread within a forum.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '443',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '444',
  'plid' => '157',
  'link_path' => 'admin/content/forum',
  'router_path' => 'admin/content/forum',
  'link_title' => 'Forums',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:61:"Control forums and their hierarchy and change forum settings.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '444',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '450',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/forum',
  'router_path' => 'admin/content/node-type/forum',
  'link_title' => 'Forum topic',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '450',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '451',
  'plid' => '444',
  'link_path' => 'admin/content/forum/edit/%',
  'router_path' => 'admin/content/forum/edit/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '444',
  'p4' => '451',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '452',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/forum/delete',
  'router_path' => 'admin/content/node-type/forum/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '452',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '453',
  'plid' => '444',
  'link_path' => 'admin/content/forum/edit/container/%',
  'router_path' => 'admin/content/forum/edit/container/%',
  'link_title' => 'Edit container',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '444',
  'p4' => '453',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '454',
  'plid' => '444',
  'link_path' => 'admin/content/forum/edit/forum/%',
  'router_path' => 'admin/content/forum/edit/forum/%',
  'link_title' => 'Edit forum',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '444',
  'p4' => '454',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '464',
  'plid' => '158',
  'link_path' => 'node/add/page',
  'router_path' => 'node/add/page',
  'link_title' => 'Page',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '464',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '465',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/page',
  'router_path' => 'admin/content/node-type/page',
  'link_title' => 'Page',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '465',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '466',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/page/delete',
  'router_path' => 'admin/content/node-type/page/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '466',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '472',
  'plid' => '0',
  'link_path' => 'search',
  'router_path' => 'search',
  'link_title' => 'Search',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '472',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '474',
  'plid' => '167',
  'link_path' => 'admin/settings/search',
  'router_path' => 'admin/settings/search',
  'link_title' => 'Search settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:66:"Configure relevance settings for search and other indexing options";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '474',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '476',
  'plid' => '165',
  'link_path' => 'admin/reports/search',
  'router_path' => 'admin/reports/search',
  'link_title' => 'Top search phrases',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:33:"View most popular search phrases.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '476',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '477',
  'plid' => '474',
  'link_path' => 'admin/settings/search/wipe',
  'router_path' => 'admin/settings/search/wipe',
  'link_title' => 'Clear index',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '474',
  'p4' => '477',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '478',
  'plid' => '0',
  'link_path' => 'content/js_add_more',
  'router_path' => 'content/js_add_more',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '478',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '479',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/employee/fields/field_sync/remove',
  'router_path' => 'admin/content/node-type/employee/fields/field_sync/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '479',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '480',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/forum/fields/field_forums/remove',
  'router_path' => 'admin/content/node-type/forum/fields/field_forums/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '480',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '481',
  'plid' => '0',
  'link_path' => 'upload/js',
  'router_path' => 'upload/js',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '481',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '482',
  'plid' => '167',
  'link_path' => 'admin/settings/uploads',
  'router_path' => 'admin/settings/uploads',
  'link_title' => 'File uploads',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Control how files may be attached to content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '482',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->execute();
$connection->schema()->createTable('menu_router', array(
  'fields' => array(
    'path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'load_functions' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'to_arg_functions' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'access_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'access_arguments' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'page_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'page_arguments' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'fit' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'number_parts' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tab_parent' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'tab_root' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title_arguments' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'block_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'position' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'file' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'path',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_router')
->fields(array(
  'path',
  'load_functions',
  'to_arg_functions',
  'access_callback',
  'access_arguments',
  'page_callback',
  'page_arguments',
  'fit',
  'number_parts',
  'tab_parent',
  'tab_root',
  'title',
  'title_callback',
  'title_arguments',
  'type',
  'block_callback',
  'description',
  'position',
  'weight',
  'file',
))
->values(array(
  'path' => 'admin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_main_admin_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'admin',
  'title' => 'Administer',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '9',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/build',
  'title' => 'Site building',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control how your site looks and feels.',
  'position' => 'right',
  'weight' => '-10',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/block',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block',
  'title' => 'Blocks',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Configure what block content appears in your site's sidebars and other regions.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/block',
  'tab_root' => 'admin/build/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"block_admin_configure";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block/configure',
  'title' => 'Configure block',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:16:"block_box_delete";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block/delete',
  'title' => 'Delete block',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/block',
  'tab_root' => 'admin/build/block',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/bluemarine',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/bluemarine/bluemarine.info";s:4:"name";s:10:"bluemarine";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:11:{s:4:"name";s:10:"Bluemarine";s:11:"description";s:66:"Table-based multi-column theme with a marine and ash color scheme.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/bluemarine/script.js";}s:10:"screenshot";s:32:"themes/bluemarine/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:10:"bluemarine";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Bluemarine',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/chameleon',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:31:"themes/chameleon/chameleon.info";s:4:"name";s:9:"chameleon";s:4:"type";s:5:"theme";s:5:"owner";s:32:"themes/chameleon/chameleon.theme";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:10:{s:4:"name";s:9:"Chameleon";s:11:"description";s:42:"Minimalist tabled theme with light colors.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:8:"features";a:4:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"scripts";a:1:{s:9:"script.js";s:26:"themes/chameleon/script.js";}s:10:"screenshot";s:31:"themes/chameleon/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:9:"chameleon";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Chameleon',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:11:{s:4:"name";s:7:"Garland";s:11:"description";s:66:"Tableless, recolorable, multi-column, fluid width theme (default).";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:24:"themes/garland/script.js";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/js',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display_js',
  'page_arguments' => 'a:0:{}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block/list/js',
  'title' => 'JavaScript List Form',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/marvin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:35:"themes/chameleon/marvin/marvin.info";s:4:"name";s:6:"marvin";s:4:"type";s:5:"theme";s:5:"owner";s:0:"";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:11:{s:4:"name";s:6:"Marvin";s:11:"description";s:31:"Boxy tabled theme in all grays.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"base theme";s:9:"chameleon";s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/chameleon/marvin/script.js";}s:10:"screenshot";s:38:"themes/chameleon/marvin/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:10:"base_theme";s:9:"chameleon";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:6:"marvin";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Marvin',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/minnelli',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":13:{s:8:"filename";s:37:"themes/garland/minnelli/minnelli.info";s:4:"name";s:8:"minnelli";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:12:{s:4:"name";s:8:"Minnelli";s:11:"description";s:56:"Tableless, recolorable, multi-column, fixed width theme.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"base theme";s:7:"garland";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/garland/minnelli/script.js";}s:10:"screenshot";s:38:"themes/garland/minnelli/screenshot.png";s:3:"php";s:5:"4.3.5";s:6:"engine";s:11:"phptemplate";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:6:"engine";s:11:"phptemplate";s:10:"base_theme";s:7:"garland";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:8:"minnelli";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Minnelli',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/pushbutton',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/pushbutton/pushbutton.info";s:4:"name";s:10:"pushbutton";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:11:{s:4:"name";s:10:"Pushbutton";s:11:"description";s:52:"Tabled, multi-column theme in blue and orange tones.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/pushbutton/script.js";}s:10:"screenshot";s:32:"themes/pushbutton/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:10:"pushbutton";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Pushbutton',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_overview_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu',
  'title' => 'Menus',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Control your site's navigation menu, primary links and secondary links, as well as rename and reorganize menu items.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:3;}',
  'fit' => '14',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'Customize menu',
  'title_callback' => 'menu_overview_title',
  'title_arguments' => 'a:1:{i:0;i:3;}',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%/add',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:3:"add";i:2;N;i:3;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/menu-customize/%',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'Add item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%/delete',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_delete_menu_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu-customize/%/delete',
  'title' => 'Delete menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%/edit',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:14:"menu_edit_menu";i:1;s:4:"edit";i:2;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/menu-customize/%',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'Edit menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%/list',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/menu-customize/%',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'List items',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"menu_edit_menu";i:1;s:3:"add";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/menu',
  'tab_root' => 'admin/build/menu',
  'title' => 'Add menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/item/%/delete',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_item_delete_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'fit' => '61',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu/item/%/delete',
  'title' => 'Delete menu item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/item/%/edit',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:4:"edit";i:2;i:4;i:3;N;}',
  'fit' => '61',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu/item/%/edit',
  'title' => 'Edit menu item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/item/%/reset',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"menu_reset_item_confirm";i:1;i:4;}',
  'fit' => '61',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu/item/%/reset',
  'title' => 'Reset menu item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_overview_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/menu',
  'tab_root' => 'admin/build/menu',
  'title' => 'List menus',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"menu_configure";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/menu',
  'tab_root' => 'admin/build/menu',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/modules',
  'title' => 'Modules',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Enable or disable add-on modules for your site.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/modules',
  'tab_root' => 'admin/build/modules',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules/list/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/modules/list/confirm',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules/uninstall',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/modules',
  'tab_root' => 'admin/build/modules',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules/uninstall/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/modules/uninstall/confirm',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/path',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/path',
  'title' => 'URL aliases',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Change your site's URL paths by aliasing them.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/path/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/path',
  'tab_root' => 'admin/build/path',
  'title' => 'Add alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/path/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"path_admin_delete_confirm";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/path/delete',
  'title' => 'Delete alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/path/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/path/edit',
  'title' => 'Edit alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/path/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/path',
  'tab_root' => 'admin/build/path',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"system_themes_form";i:1;N;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/themes',
  'title' => 'Themes',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Change which theme your site uses or allows users to set.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/select',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"system_themes_form";i:1;N;}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/themes',
  'tab_root' => 'admin/build/themes',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => 'Select the default theme.',
  'position' => '',
  'weight' => '-1',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/themes',
  'tab_root' => 'admin/build/themes',
  'title' => 'Configure',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/bluemarine',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/bluemarine/bluemarine.info";s:4:"name";s:10:"bluemarine";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:11:{s:4:"name";s:10:"Bluemarine";s:11:"description";s:66:"Table-based multi-column theme with a marine and ash color scheme.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/bluemarine/script.js";}s:10:"screenshot";s:32:"themes/bluemarine/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:10:"bluemarine";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Bluemarine',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/chameleon',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:31:"themes/chameleon/chameleon.info";s:4:"name";s:9:"chameleon";s:4:"type";s:5:"theme";s:5:"owner";s:32:"themes/chameleon/chameleon.theme";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:10:{s:4:"name";s:9:"Chameleon";s:11:"description";s:42:"Minimalist tabled theme with light colors.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:8:"features";a:4:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"scripts";a:1:{s:9:"script.js";s:26:"themes/chameleon/script.js";}s:10:"screenshot";s:31:"themes/chameleon/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:9:"chameleon";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Chameleon',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:11:{s:4:"name";s:7:"Garland";s:11:"description";s:66:"Tableless, recolorable, multi-column, fluid width theme (default).";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:24:"themes/garland/script.js";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:7:"garland";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/global',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Global settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-1',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/marvin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:35:"themes/chameleon/marvin/marvin.info";s:4:"name";s:6:"marvin";s:4:"type";s:5:"theme";s:5:"owner";s:0:"";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:11:{s:4:"name";s:6:"Marvin";s:11:"description";s:31:"Boxy tabled theme in all grays.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"base theme";s:9:"chameleon";s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/chameleon/marvin/script.js";}s:10:"screenshot";s:38:"themes/chameleon/marvin/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:10:"base_theme";s:9:"chameleon";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:6:"marvin";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Marvin',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/minnelli',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":13:{s:8:"filename";s:37:"themes/garland/minnelli/minnelli.info";s:4:"name";s:8:"minnelli";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:12:{s:4:"name";s:8:"Minnelli";s:11:"description";s:56:"Tableless, recolorable, multi-column, fixed width theme.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"base theme";s:7:"garland";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/garland/minnelli/script.js";}s:10:"screenshot";s:38:"themes/garland/minnelli/screenshot.png";s:3:"php";s:5:"4.3.5";s:6:"engine";s:11:"phptemplate";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:6:"engine";s:11:"phptemplate";s:10:"base_theme";s:7:"garland";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:8:"minnelli";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Minnelli',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/pushbutton',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/pushbutton/pushbutton.info";s:4:"name";s:10:"pushbutton";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:11:{s:4:"name";s:10:"Pushbutton";s:11:"description";s:52:"Tabled, multi-column theme in blue and orange tones.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/pushbutton/script.js";}s:10:"screenshot";s:32:"themes/pushbutton/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:10:"pushbutton";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Pushbutton',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/by-module',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_by_module',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'By module',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/by-task',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_main_admin_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'By task',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/compact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_compact_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/compact',
  'title' => 'Compact mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/content',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/content',
  'title' => 'Content management',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Manage your site's content.",
  'position' => 'left',
  'weight' => '-10',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/comment',
  'title' => 'Comments',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'List and edit site comments and the comment moderation queue.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment/approval',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:1:{i:0;s:8:"approval";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/comment',
  'tab_root' => 'admin/content/comment',
  'title' => 'Approval queue',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment/new',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/comment',
  'tab_root' => 'admin/content/comment',
  'title' => 'Published comments',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/forum',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"forum_overview";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/forum',
  'title' => 'Forums',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control forums and their hierarchy and change forum settings.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/content/forum/add/container',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:1:{i:0;s:9:"container";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/forum',
  'tab_root' => 'admin/content/forum',
  'title' => 'Add container',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/content/forum/add/forum',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:1:{i:0;s:5:"forum";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/forum',
  'tab_root' => 'admin/content/forum',
  'title' => 'Add forum',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/content/forum/edit/%',
  'load_functions' => 'a:1:{i:4;s:15:"forum_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:0:{}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/forum/edit/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/content/forum/edit/container/%',
  'load_functions' => 'a:1:{i:5;s:15:"forum_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:2:{i:0;s:9:"container";i:1;i:5;}',
  'fit' => '62',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/content/forum/edit/container/%',
  'title' => 'Edit container',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/content/forum/edit/forum/%',
  'load_functions' => 'a:1:{i:5;s:15:"forum_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:2:{i:0;s:5:"forum";i:1;i:5;}',
  'fit' => '62',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/content/forum/edit/forum/%',
  'title' => 'Edit forum',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/content/forum/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"forum_overview";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/forum',
  'tab_root' => 'admin/content/forum',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/content/forum/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"forum_admin_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/forum',
  'tab_root' => 'admin/content/forum',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/content/node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer nodes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "View, edit, and delete your site's content.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer nodes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"node_configure";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-settings',
  'title' => 'Post settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control posting behavior, such as teaser length, requiring previews before posting, and the number of posts on the front page.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-settings/rebuild',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"node_configure_rebuild_confirm";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-settings/rebuild',
  'title' => 'Rebuild permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"article";s:4:"name";s:7:"Article";s:6:"module";s:4:"node";s:11:"description";s:34:"An <em>article</em>, content type.";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:5:"Title";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"1";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:5:"story";}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Article',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"article";s:4:"name";s:7:"Article";s:6:"module";s:4:"node";s:11:"description";s:34:"An <em>article</em>, content type.";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:5:"Title";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"1";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:5:"story";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/article/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:7:"article";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/article',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"article";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/article/display',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"article";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/article/display',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/display/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"article";i:2;s:6:"search";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/article/display',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Search',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"article";s:4:"name";s:7:"Article";s:6:"module";s:4:"node";s:11:"description";s:34:"An <em>article</em>, content type.";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:5:"Title";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"1";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:5:"story";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/article',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:7:"article";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/article',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"company";s:4:"name";s:7:"Company";s:6:"module";s:4:"node";s:11:"description";s:17:"Company node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:11:"Description";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"0";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:7:"company";}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Company',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"company";s:4:"name";s:7:"Company";s:6:"module";s:4:"node";s:11:"description";s:17:"Company node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:11:"Description";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"0";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:7:"company";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/company/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:7:"company";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/company',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"company";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/company/display',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"company";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/company/display',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/display/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"company";i:2;s:6:"search";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/company/display',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Search',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"company";s:4:"name";s:7:"Company";s:6:"module";s:4:"node";s:11:"description";s:17:"Company node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:11:"Description";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"0";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:7:"company";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/company',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:7:"company";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/company',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:8:"employee";s:4:"name";s:8:"Employee";s:6:"module";s:4:"node";s:11:"description";s:18:"Employee node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:3:"Bio";s:14:"min_word_count";s:2:"20";s:6:"custom";s:1:"0";s:8:"modified";s:1:"0";s:6:"locked";s:1:"0";s:9:"orig_type";s:8:"employee";}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Employee',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":14:{s:4:"type";s:8:"employee";s:4:"name";s:8:"Employee";s:6:"module";s:4:"node";s:11:"description";s:18:"Employee node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:3:"Bio";s:14:"min_word_count";s:2:"20";s:6:"custom";s:1:"0";s:8:"modified";s:1:"0";s:6:"locked";s:1:"0";s:9:"orig_type";s:8:"employee";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/employee/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:8:"employee";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/employee',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:8:"employee";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/employee/display',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:8:"employee";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/employee/display',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee/display/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:8:"employee";i:2;s:6:"search";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/employee/display',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Search',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:8:"employee";s:4:"name";s:8:"Employee";s:6:"module";s:4:"node";s:11:"description";s:18:"Employee node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:3:"Bio";s:14:"min_word_count";s:2:"20";s:6:"custom";s:1:"0";s:8:"modified";s:1:"0";s:6:"locked";s:1:"0";s:9:"orig_type";s:8:"employee";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/employee',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:8:"employee";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/employee',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee/fields/field_sync',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:8:"employee";i:2;s:10:"field_sync";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/employee/fields',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'email_sync',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee/fields/field_sync/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:8:"employee";i:2;s:10:"field_sync";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/employee/fields/field_sync/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/forum',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":15:{s:4:"name";s:11:"Forum topic";s:6:"module";s:5:"forum";s:11:"description";s:85:"A <em>forum topic</em> is the initial post to a new discussion thread within a forum.";s:11:"title_label";s:7:"Subject";s:4:"type";s:5:"forum";s:9:"has_title";b:1;s:8:"has_body";b:1;s:10:"body_label";s:4:"Body";s:4:"help";s:0:"";s:14:"min_word_count";i:0;s:6:"custom";b:0;s:8:"modified";b:0;s:6:"locked";b:1;s:9:"orig_type";s:5:"forum";s:6:"is_new";b:1;}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/forum',
  'title' => 'Forum topic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/forum/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":15:{s:4:"name";s:11:"Forum topic";s:6:"module";s:5:"forum";s:11:"description";s:85:"A <em>forum topic</em> is the initial post to a new discussion thread within a forum.";s:11:"title_label";s:7:"Subject";s:4:"type";s:5:"forum";s:9:"has_title";b:1;s:8:"has_body";b:1;s:10:"body_label";s:4:"Body";s:4:"help";s:0:"";s:14:"min_word_count";i:0;s:6:"custom";b:0;s:8:"modified";b:0;s:6:"locked";b:1;s:9:"orig_type";s:5:"forum";s:6:"is_new";b:1;}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/forum/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/forum/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:5:"forum";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/forum',
  'tab_root' => 'admin/content/node-type/forum',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/forum/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:5:"forum";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/forum/display',
  'tab_root' => 'admin/content/node-type/forum',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/forum/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:5:"forum";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/forum/display',
  'tab_root' => 'admin/content/node-type/forum',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/forum/display/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:5:"forum";i:2;s:6:"search";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/forum/display',
  'tab_root' => 'admin/content/node-type/forum',
  'title' => 'Search',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/forum/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":15:{s:4:"name";s:11:"Forum topic";s:6:"module";s:5:"forum";s:11:"description";s:85:"A <em>forum topic</em> is the initial post to a new discussion thread within a forum.";s:11:"title_label";s:7:"Subject";s:4:"type";s:5:"forum";s:9:"has_title";b:1;s:8:"has_body";b:1;s:10:"body_label";s:4:"Body";s:4:"help";s:0:"";s:14:"min_word_count";i:0;s:6:"custom";b:0;s:8:"modified";b:0;s:6:"locked";b:1;s:9:"orig_type";s:5:"forum";s:6:"is_new";b:1;}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/forum',
  'tab_root' => 'admin/content/node-type/forum',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/forum/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:5:"forum";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/forum',
  'tab_root' => 'admin/content/node-type/forum',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/forum/fields/field_forums',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"forum";i:2;s:12:"field_forums";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/forum/fields',
  'tab_root' => 'admin/content/node-type/forum',
  'title' => 'forums',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/forum/fields/field_forums/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"forum";i:2;s:12:"field_forums";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/forum/fields/field_forums/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/page',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:4:\"page\";s:4:\"name\";s:4:\"Page\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:4:\"page\";}}",
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/page',
  'title' => 'Page',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/page/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:24:\"node_type_delete_confirm\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:4:\"page\";s:4:\"name\";s:4:\"Page\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:4:\"page\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/page/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/page/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:4:"page";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/page',
  'tab_root' => 'admin/content/node-type/page',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/page/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:4:"page";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/page/display',
  'tab_root' => 'admin/content/node-type/page',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/page/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:4:"page";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/page/display',
  'tab_root' => 'admin/content/node-type/page',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/page/display/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:4:"page";i:2;s:6:"search";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/page/display',
  'tab_root' => 'admin/content/node-type/page',
  'title' => 'Search',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/page/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:4:\"page\";s:4:\"name\";s:4:\"Page\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:4:\"page\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/page',
  'tab_root' => 'admin/content/node-type/page',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/page/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:4:"page";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/page',
  'tab_root' => 'admin/content/node-type/page',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/sponsor',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"sponsor";s:4:"name";s:7:"Sponsor";s:6:"module";s:4:"node";s:11:"description";s:17:"Sponsor node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"0";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:0:"";}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'Sponsor',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/sponsor/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"sponsor";s:4:"name";s:7:"Sponsor";s:6:"module";s:4:"node";s:11:"description";s:17:"Sponsor node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"0";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:0:"";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/sponsor/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/sponsor/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:7:"sponsor";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/sponsor',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/sponsor/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"sponsor";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/sponsor/display',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/sponsor/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"sponsor";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/sponsor/display',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/sponsor/display/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"sponsor";i:2;s:6:"search";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/sponsor/display',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'Search',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/sponsor/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"sponsor";s:4:"name";s:7:"Sponsor";s:6:"module";s:4:"node";s:11:"description";s:17:"Sponsor node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"0";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:0:"";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/sponsor',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/sponsor/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:7:"sponsor";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/sponsor',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:5:\"story\";s:4:\"name\";s:5:\"Story\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:5:\"story\";}}",
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Story',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:24:\"node_type_delete_confirm\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:5:\"story\";s:4:\"name\";s:5:\"Story\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:5:\"story\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:5:"story";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/story',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:5:"story";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/display',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:5:"story";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/display',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/display/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:5:"story";i:2;s:6:"search";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/display',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Search',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:5:\"story\";s:4:\"name\";s:5:\"Story\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:5:\"story\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/story',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/story/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:5:"story";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/story',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node/overview',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer nodes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/node',
  'tab_root' => 'admin/content/node',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/rss-publishing',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_rss_feeds_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/rss-publishing',
  'title' => 'RSS publishing',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Configure the number of items per feed and whether feeds should be titles/teasers/full-text.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"taxonomy_overview_vocabularies";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/taxonomy',
  'title' => 'Taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Manage tagging, categorization, and classification of your content.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/%',
  'load_functions' => 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}',
  'fit' => '14',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/taxonomy/%',
  'title' => 'List terms',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/%/add/term',
  'load_functions' => 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'taxonomy_add_term_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '59',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/taxonomy/%',
  'tab_root' => 'admin/content/taxonomy/%',
  'title' => 'Add term',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/%/list',
  'load_functions' => 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/taxonomy/%',
  'tab_root' => 'admin/content/taxonomy/%',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/add/vocabulary',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"taxonomy_form_vocabulary";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/taxonomy',
  'tab_root' => 'admin/content/taxonomy',
  'title' => 'Add vocabulary',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/edit/term',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'taxonomy_admin_term_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/taxonomy/edit/term',
  'title' => 'Edit term',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/edit/vocabulary/%',
  'load_functions' => 'a:1:{i:5;s:24:"taxonomy_vocabulary_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'taxonomy_admin_vocabulary_edit',
  'page_arguments' => 'a:1:{i:0;i:5;}',
  'fit' => '62',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/content/taxonomy/edit/vocabulary/%',
  'title' => 'Edit vocabulary',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/taxonomy/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"taxonomy_overview_vocabularies";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/taxonomy',
  'tab_root' => 'admin/content/taxonomy',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/content/types',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'content_types_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/types',
  'title' => 'Content types',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Manage posts by content type, including default status, front page promotion, etc.',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/types/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"node_type_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/types',
  'tab_root' => 'admin/content/types',
  'title' => 'Add content type',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/types/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'content_fields_list',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/types',
  'tab_root' => 'admin/content/types',
  'title' => 'Fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/types/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'content_types_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/types',
  'tab_root' => 'admin/content/types',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/reports',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/reports',
  'title' => 'Reports',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'View reports from system logs and other status information.',
  'position' => 'left',
  'weight' => '5',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'dblog_top',
  'page_arguments' => 'a:1:{i:0;s:6:"search";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/search',
  'title' => 'Top search phrases',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'View most popular search phrases.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/dblog/dblog.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_status',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status',
  'title' => 'Status report',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Get a status report about your site's operation and any detected problems.",
  'position' => '',
  'weight' => '10',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/php',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_php',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/php',
  'title' => 'PHP',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/run-cron',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_run_cron',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/run-cron',
  'title' => 'Run cron',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/sql',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_sql',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/sql',
  'title' => 'SQL',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_settings_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/settings',
  'title' => 'Site configuration',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Adjust basic site configuration options.',
  'position' => 'right',
  'weight' => '-5',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/actions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/actions',
  'title' => 'Actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/actions/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_actions_configure";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/actions/configure',
  'title' => 'Configure an advanced action',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/actions/delete/%',
  'load_functions' => 'a:1:{i:4;s:12:"actions_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"system_actions_delete_form";i:1;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/actions/delete/%',
  'title' => 'Delete action',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => 'Delete an action.',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/actions/manage',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/actions',
  'tab_root' => 'admin/settings/actions',
  'title' => 'Manage actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '-2',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/actions/orphan',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_remove_orphans',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/actions/orphan',
  'title' => 'Remove orphans',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/admin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_admin_theme_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/admin',
  'title' => 'Administration theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => 'system_admin_theme_settings',
  'description' => 'Settings for how your administrative pages should look.',
  'position' => 'left',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/clean-urls',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_clean_url_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/clean-urls',
  'title' => 'Clean URLs',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Enable or disable clean URLs for your site.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/clean-urls/check',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_json',
  'page_arguments' => 'a:1:{i:0;a:1:{s:6:"status";b:1;}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/clean-urls/check',
  'title' => 'Clean URL check',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/settings/date-time',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_date_time_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/date-time',
  'title' => 'Date and time',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Settings for how Drupal displays date and time, as well as the system's default timezone.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/date-time/lookup',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_date_time_lookup',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/date-time/lookup',
  'title' => 'Date and time lookup',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/error-reporting',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:31:"system_error_reporting_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/error-reporting',
  'title' => 'Error reporting',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control how Drupal deals with errors including 403/404 errors as well as PHP error reporting.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/file-system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_file_system_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/file-system',
  'title' => 'File system',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Tell Drupal where to store uploaded files and how they are accessed.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/filters',
  'title' => 'Input formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/%',
  'load_functions' => 'a:1:{i:3;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '14',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/filters/%',
  'title' => '',
  'title_callback' => 'filter_admin_format_title',
  'title_arguments' => 'a:1:{i:0;i:3;}',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/%/configure',
  'load_functions' => 'a:1:{i:3;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_configure_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/filters/%',
  'tab_root' => 'admin/settings/filters/%',
  'title' => 'Configure',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/%/edit',
  'load_functions' => 'a:1:{i:3;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/filters/%',
  'tab_root' => 'admin/settings/filters/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/%/order',
  'load_functions' => 'a:1:{i:3;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_order_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/filters/%',
  'tab_root' => 'admin/settings/filters/%',
  'title' => 'Rearrange',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/filters',
  'tab_root' => 'admin/settings/filters',
  'title' => 'Add input format',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"filter_admin_delete";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/filters/delete',
  'title' => 'Delete input format',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/filters/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/filters',
  'tab_root' => 'admin/settings/filters',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/settings/image-toolkit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:29:"system_image_toolkit_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/image-toolkit',
  'title' => 'Image toolkit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Choose which image toolkit to use if you have installed optional toolkits.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/logging',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_logging_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/logging',
  'title' => 'Logging and alerts',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Settings for logging and alerts modules. Various modules can route Drupal's system events to different destination, such as syslog, database, email, ...etc.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/performance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_performance_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/performance',
  'title' => 'Performance',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer search";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"search_admin_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/search',
  'title' => 'Search settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Configure relevance settings for search and other indexing options',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/search/search.admin.inc',
))
->values(array(
  'path' => 'admin/settings/search/wipe',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer search";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"search_wipe_confirm";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/search/wipe',
  'title' => 'Clear index',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/search/search.admin.inc',
))
->values(array(
  'path' => 'admin/settings/site-information',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_site_information_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/site-information',
  'title' => 'Site information',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Change basic site information, such as the site name, slogan, e-mail address, mission, front page and more.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/site-maintenance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_site_maintenance_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/site-maintenance',
  'title' => 'Site maintenance',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Take the site off-line for maintenance or bring it back online.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/settings/uploads',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"upload_admin_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/uploads',
  'title' => 'File uploads',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control how files may be attached to content.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/upload/upload.admin.inc',
))
->values(array(
  'path' => 'admin/user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/user',
  'title' => 'User management',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Manage your site's users, groups and access to site features.",
  'position' => 'left',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/user/permissions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:15:"user_admin_perm";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/permissions',
  'title' => 'Permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Determine access to features by selecting permissions for roles.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/roles',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_new_role";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/roles',
  'title' => 'Roles',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'List, edit, or add user roles.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/roles/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:15:"user_admin_role";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/roles/edit',
  'title' => 'Edit role',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/rules',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/rules',
  'title' => 'Access rules',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'List and create rules to disallow usernames, e-mail addresses, and IP addresses.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/rules/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access_add',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/rules',
  'tab_root' => 'admin/user/rules',
  'title' => 'Add rule',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/rules/check',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access_check',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/rules',
  'tab_root' => 'admin/user/rules',
  'title' => 'Check rules',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/rules/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"user_admin_access_delete_confirm";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/rules/delete',
  'title' => 'Delete rule',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/rules/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/rules/edit',
  'title' => 'Edit rule',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/rules/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/rules',
  'tab_root' => 'admin/user/rules',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/settings',
  'title' => 'User settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Configure default behavior of users, including registration requirements, e-mails, and user pictures.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/user',
  'title' => 'Users',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'List, add, and edit users.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/user/create',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:6:"create";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/user',
  'tab_root' => 'admin/user/user',
  'title' => 'Add user',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/user/user/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/user',
  'tab_root' => 'admin/user/user',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'batch',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'system_batch_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'batch',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'comment/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_delete',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'comment/delete',
  'title' => 'Delete comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'comment/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:13:"post comments";}',
  'page_callback' => 'comment_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'comment/edit',
  'title' => 'Edit comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.pages.inc',
))
->values(array(
  'path' => 'comment/reply/%',
  'load_functions' => 'a:1:{i:2;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:2;}',
  'page_callback' => 'comment_reply',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '6',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'comment/reply/%',
  'title' => 'Reply to comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.pages.inc',
))
->values(array(
  'path' => 'content/js_add_more',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'content_add_more_js',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'content/js_add_more',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.node_form.inc',
))
->values(array(
  'path' => 'filter/tips',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'filter_tips_long',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'filter/tips',
  'title' => 'Compose tips',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '20',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.pages.inc',
))
->values(array(
  'path' => 'forum',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'forum_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'forum',
  'title' => 'Forums',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '20',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.pages.inc',
))
->values(array(
  'path' => 'logout',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_logged_in',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_logout',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'logout',
  'title' => 'Log out',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_page_default',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'node',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'node/%',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '2',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'node/%',
  'title' => '',
  'title_callback' => 'node_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'node/%/delete',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"delete";i:1;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"node_delete_confirm";i:1;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/%/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/edit',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"update";i:1;i:1;}',
  'page_callback' => 'node_page_edit',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_revision_overview',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/delete',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"delete";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_delete_confirm";i:1;i:1;}',
  'fit' => '21',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/delete',
  'title' => 'Delete earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/revert',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"update";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_revert_confirm";i:1;i:1;}',
  'fit' => '21',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/revert',
  'title' => 'Revert to earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/view',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_show',
  'page_arguments' => 'a:3:{i:0;i:1;i:1;N;i:2;b:1;}',
  'fit' => '21',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/view',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'node/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => '',
))
->values(array(
  'path' => 'node/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_node_add_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'node_add_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'node/add',
  'title' => 'Create content',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/article',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:7:"article";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/article',
  'title' => 'Article',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'An <em>article</em>, content type.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/company',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:7:"company";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/company',
  'title' => 'Company',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Company node type',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/employee',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:8:"employee";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/employee',
  'title' => 'Employee',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Employee node type',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/forum',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:5:"forum";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/forum',
  'title' => 'Forum topic',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'A <em>forum topic</em> is the initial post to a new discussion thread within a forum.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/page',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:4:"page";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/page',
  'title' => 'Page',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/sponsor',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:7:"sponsor";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/sponsor',
  'title' => 'Sponsor',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Sponsor node type',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/story',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:5:"story";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/story',
  'title' => 'Story',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'rss.xml',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_feed',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'rss.xml',
  'title' => 'RSS feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"search content";}',
  'page_callback' => 'search_view',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'search',
  'title' => 'Search',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '20',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/search/search.pages.inc',
))
->values(array(
  'path' => 'search/node/%',
  'load_functions' => 'a:1:{i:2;N;}',
  'to_arg_functions' => 'a:1:{i:2;s:16:"menu_tail_to_arg";}',
  'access_callback' => '_search_menu',
  'access_arguments' => 'a:1:{i:0;s:4:"node";}',
  'page_callback' => 'search_view',
  'page_arguments' => 'a:1:{i:0;s:4:"node";}',
  'fit' => '6',
  'number_parts' => '3',
  'tab_parent' => 'search',
  'tab_root' => 'search',
  'title' => '',
  'title_callback' => 'module_invoke',
  'title_arguments' => 'a:4:{i:0;s:4:"node";i:1;s:6:"search";i:2;s:4:"name";i:3;b:1;}',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/search/search.pages.inc',
))
->values(array(
  'path' => 'search/user/%',
  'load_functions' => 'a:1:{i:2;N;}',
  'to_arg_functions' => 'a:1:{i:2;s:16:"menu_tail_to_arg";}',
  'access_callback' => '_search_menu',
  'access_arguments' => 'a:1:{i:0;s:4:"user";}',
  'page_callback' => 'search_view',
  'page_arguments' => 'a:1:{i:0;s:4:"user";}',
  'fit' => '6',
  'number_parts' => '3',
  'tab_parent' => 'search',
  'tab_root' => 'search',
  'title' => '',
  'title_callback' => 'module_invoke',
  'title_arguments' => 'a:4:{i:0;s:4:"user";i:1;s:6:"search";i:2;s:4:"name";i:3;b:1;}',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/search/search.pages.inc',
))
->values(array(
  'path' => 'system/files',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:1:{i:0;s:19:"view uploaded files";}',
  'page_callback' => 'file_download',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'system/files',
  'title' => 'File download',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'taxonomy/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_autocomplete',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/autocomplete',
  'title' => 'Autocomplete taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.pages.inc',
))
->values(array(
  'path' => 'taxonomy/term/%',
  'load_functions' => 'a:1:{i:2;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_term_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '6',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'Taxonomy term',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.pages.inc',
))
->values(array(
  'path' => 'upload/js',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:12:"upload files";}',
  'page_callback' => 'upload_js',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'upload/js',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'user',
  'title' => 'User account',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%',
  'load_functions' => 'a:1:{i:1;s:22:"user_uid_optional_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:24:"user_uid_optional_to_arg";}',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '2',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'user/%',
  'title' => 'My account',
  'title_callback' => 'user_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/delete',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_delete_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"user_confirm_delete";i:1;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'user/%/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_edit_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_edit',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit/account',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_edit_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_edit',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '11',
  'number_parts' => '4',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => 'Account',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"access user profiles";}',
  'page_callback' => 'user_autocomplete',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'user/autocomplete',
  'title' => 'User autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/login',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_anonymous',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Log in',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/password',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_anonymous',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:9:"user_pass";}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Request new password',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/register',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_register_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:13:"user_register";}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Create new account',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/reset/%/%/%',
  'load_functions' => 'a:3:{i:2;N;i:3;N;i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:15:"user_pass_reset";i:1;i:2;i:2;i:3;i:3;i:4;}',
  'fit' => '24',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'user/reset/%/%/%',
  'title' => 'Reset password',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
))
->execute();
$connection->schema()->createTable('node', array(
  'fields' => array(
    'nid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'comment' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'promote' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'moderate' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tnid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'translate' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node')
->fields(array(
  'nid',
  'vid',
  'type',
  'language',
  'title',
  'uid',
  'status',
  'created',
  'changed',
  'comment',
  'promote',
  'moderate',
  'sticky',
  'tnid',
  'translate',
))
->values(array(
  'nid' => '19',
  'vid' => '22',
  'type' => 'forum',
  'language' => '',
  'title' => 'New Forum Topic',
  'uid' => '1',
  'status' => '1',
  'created' => '1501955771',
  'changed' => '1501955771',
  'comment' => '2',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '20',
  'vid' => '23',
  'type' => 'forum',
  'language' => '',
  'title' => 'Earth topic 1',
  'uid' => '1',
  'status' => '1',
  'created' => '1679803825',
  'changed' => '1679803825',
  'comment' => '2',
  'promote' => '0',
  'moderate' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->execute();
$connection->schema()->createTable('node_access', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'gid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'realm' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'grant_view' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'grant_update' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'grant_delete' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
    'gid',
    'realm',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_access')
->fields(array(
  'nid',
  'gid',
  'realm',
  'grant_view',
  'grant_update',
  'grant_delete',
))
->values(array(
  'nid' => '0',
  'gid' => '0',
  'realm' => 'all',
  'grant_view' => '1',
  'grant_update' => '0',
  'grant_delete' => '0',
))
->execute();
$connection->schema()->createTable('node_comment_statistics', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'last_comment_timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'last_comment_name' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '60',
    ),
    'last_comment_uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'comment_count' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'indexes' => array(
    'comment_count' => array(
      'comment_count',
    ),
    'last_comment_uid' => array(
      'last_comment_uid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_comment_statistics')
->fields(array(
  'nid',
  'last_comment_timestamp',
  'last_comment_name',
  'last_comment_uid',
  'comment_count',
))
->values(array(
  'nid' => '0',
  'last_comment_timestamp' => '1468384735',
  'last_comment_name' => NULL,
  'last_comment_uid' => '1',
  'comment_count' => '0',
))
->values(array(
  'nid' => '19',
  'last_comment_timestamp' => '1501955803',
  'last_comment_name' => '',
  'last_comment_uid' => '1',
  'comment_count' => '3',
))
->values(array(
  'nid' => '20',
  'last_comment_timestamp' => '1679803825',
  'last_comment_name' => NULL,
  'last_comment_uid' => '1',
  'comment_count' => '0',
))
->execute();
$connection->schema()->createTable('node_counter', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'totalcount' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'daycount' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_counter')
->fields(array(
  'nid',
  'totalcount',
  'daycount',
  'timestamp',
))
->values(array(
  'nid' => '19',
  'totalcount' => '5',
  'daycount' => '5',
  'timestamp' => '1675403296',
))
->execute();
$connection->schema()->createTable('node_revisions', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'body' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'teaser' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'log' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'format' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_revisions')
->fields(array(
  'nid',
  'vid',
  'uid',
  'title',
  'body',
  'teaser',
  'log',
  'timestamp',
  'format',
))
->values(array(
  'nid' => '19',
  'vid' => '22',
  'uid' => '1',
  'title' => 'New Forum Topic',
  'body' => 'New Forum Body',
  'teaser' => 'New Forum Body',
  'log' => '',
  'timestamp' => '1501955771',
  'format' => '1',
))
->values(array(
  'nid' => '20',
  'vid' => '23',
  'uid' => '1',
  'title' => 'Earth topic 1',
  'body' => 'Foo',
  'teaser' => 'Foo',
  'log' => '',
  'timestamp' => '1679803825',
  'format' => '1',
))
->execute();
$connection->schema()->createTable('node_type', array(
  'fields' => array(
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'help' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'has_title' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'title_label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'has_body' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body_label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'min_word_count' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'custom' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'modified' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'orig_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_type')
->fields(array(
  'type',
  'name',
  'module',
  'description',
  'help',
  'has_title',
  'title_label',
  'has_body',
  'body_label',
  'min_word_count',
  'custom',
  'modified',
  'locked',
  'orig_type',
))
->values(array(
  'type' => 'article',
  'name' => 'Article',
  'module' => 'node',
  'description' => 'An <em>article</em>, content type.',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'has_body' => '1',
  'body_label' => 'Body',
  'min_word_count' => '0',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'orig_type' => 'story',
))
->values(array(
  'type' => 'company',
  'name' => 'Company',
  'module' => 'node',
  'description' => 'Company node type',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Name',
  'has_body' => '1',
  'body_label' => 'Description',
  'min_word_count' => '0',
  'custom' => '0',
  'modified' => '1',
  'locked' => '0',
  'orig_type' => 'company',
))
->values(array(
  'type' => 'employee',
  'name' => 'Employee',
  'module' => 'node',
  'description' => 'Employee node type',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Name',
  'has_body' => '1',
  'body_label' => 'Bio',
  'min_word_count' => '20',
  'custom' => '0',
  'modified' => '0',
  'locked' => '0',
  'orig_type' => 'employee',
))
->values(array(
  'type' => 'forum',
  'name' => 'Forum topic',
  'module' => 'forum',
  'description' => 'A <em>forum topic</em> is the initial post to a new discussion thread within a forum.',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Subject',
  'has_body' => '1',
  'body_label' => 'Body',
  'min_word_count' => '0',
  'custom' => '0',
  'modified' => '0',
  'locked' => '1',
  'orig_type' => 'forum',
))
->values(array(
  'type' => 'page',
  'name' => 'Page',
  'module' => 'node',
  'description' => "A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.",
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'has_body' => '1',
  'body_label' => 'Body',
  'min_word_count' => '0',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'orig_type' => 'page',
))
->values(array(
  'type' => 'sponsor',
  'name' => 'Sponsor',
  'module' => 'node',
  'description' => 'Sponsor node type',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Name',
  'has_body' => '1',
  'body_label' => 'Body',
  'min_word_count' => '0',
  'custom' => '0',
  'modified' => '1',
  'locked' => '0',
  'orig_type' => '',
))
->values(array(
  'type' => 'story',
  'name' => 'Story',
  'module' => 'node',
  'description' => "A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.",
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'has_body' => '1',
  'body_label' => 'Body',
  'min_word_count' => '0',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'orig_type' => 'story',
))
->execute();
$connection->schema()->createTable('permission', array(
  'fields' => array(
    'pid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'perm' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'tid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'pid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('permission')
->fields(array(
  'pid',
  'rid',
  'perm',
  'tid',
))
->values(array(
  'pid' => '1',
  'rid' => '1',
  'perm' => 'access content, migrate test anonymous permission',
  'tid' => '0',
))
->values(array(
  'pid' => '2',
  'rid' => '2',
  'perm' => 'access comments, access content, post comments, post comments without approval, migrate test authenticated permission',
  'tid' => '0',
))
->execute();
$connection->schema()->createTable('role', array(
  'fields' => array(
    'rid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'rid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('role')
->fields(array(
  'rid',
  'name',
))
->values(array(
  'rid' => '1',
  'name' => 'anonymous user',
))
->values(array(
  'rid' => '2',
  'name' => 'authenticated user',
))
->execute();
$connection->schema()->createTable('search_dataset', array(
  'fields' => array(
    'sid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '16',
    ),
    'data' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'reindex' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'unique keys' => array(
    'sid_type' => array(
      'sid',
      'type',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('search_dataset')
->fields(array(
  'sid',
  'type',
  'data',
  'reindex',
))
->values(array(
  'sid' => '19',
  'type' => 'node',
  'data' => ' new forum topic new forum body subject 1 comment 1 subject 2 comment 2 subject 3 comment 3  general discussion  ',
  'reindex' => '0',
))
->execute();
$connection->schema()->createTable('search_index', array(
  'fields' => array(
    'word' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '50',
      'default' => '',
    ),
    'sid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '16',
    ),
    'score' => array(
      'type' => 'float',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'unique keys' => array(
    'word_sid_type' => array(
      'word',
      'sid',
      'type',
    ),
  ),
  'indexes' => array(
    'sid_type' => array(
      'sid',
      'type',
    ),
    'word' => array(
      'word',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('search_index')
->fields(array(
  'word',
  'sid',
  'type',
  'score',
))
->values(array(
  'word' => 'new',
  'sid' => '19',
  'type' => 'node',
  'score' => '27',
))
->values(array(
  'word' => 'forum',
  'sid' => '19',
  'type' => 'node',
  'score' => '27',
))
->values(array(
  'word' => 'topic',
  'sid' => '19',
  'type' => 'node',
  'score' => '26',
))
->values(array(
  'word' => 'body',
  'sid' => '19',
  'type' => 'node',
  'score' => '1',
))
->values(array(
  'word' => 'subject',
  'sid' => '19',
  'type' => 'node',
  'score' => '57',
))
->values(array(
  'word' => '1',
  'sid' => '19',
  'type' => 'node',
  'score' => '20',
))
->values(array(
  'word' => 'comment',
  'sid' => '19',
  'type' => 'node',
  'score' => '3',
))
->values(array(
  'word' => '2',
  'sid' => '19',
  'type' => 'node',
  'score' => '20',
))
->values(array(
  'word' => '3',
  'sid' => '19',
  'type' => 'node',
  'score' => '20',
))
->values(array(
  'word' => 'general',
  'sid' => '19',
  'type' => 'node',
  'score' => '4',
))
->values(array(
  'word' => 'discussion',
  'sid' => '19',
  'type' => 'node',
  'score' => '4',
))
->execute();
$connection->schema()->createTable('search_node_links', array(
  'fields' => array(
    'sid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '16',
      'default' => '',
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'caption' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'sid',
    'type',
    'nid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('search_total', array(
  'fields' => array(
    'word' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '50',
      'default' => '',
    ),
    'count' => array(
      'type' => 'float',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'word',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('search_total')
->fields(array(
  'word',
  'count',
))
->values(array(
  'word' => '1',
  'count' => '0.0211893',
))
->values(array(
  'word' => '2',
  'count' => '0.0211893',
))
->values(array(
  'word' => '3',
  'count' => '0.0211893',
))
->values(array(
  'word' => 'body',
  'count' => '0.30103',
))
->values(array(
  'word' => 'comment',
  'count' => '0.124939',
))
->values(array(
  'word' => 'discussion',
  'count' => '0.09691',
))
->values(array(
  'word' => 'forum',
  'count' => '0.0157943',
))
->values(array(
  'word' => 'general',
  'count' => '0.09691',
))
->values(array(
  'word' => 'new',
  'count' => '0.0157943',
))
->values(array(
  'word' => 'subject',
  'count' => '0.00755314',
))
->values(array(
  'word' => 'topic',
  'count' => '0.0163904',
))
->execute();
$connection->schema()->createTable('semaphore', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'value' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'expire' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '10',
      'scale' => '0',
    ),
  ),
  'primary key' => array(
    'name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('sessions', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'sid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'session' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'sid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('system', array(
  'fields' => array(
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'owner' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'throttle' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'bootstrap' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'schema_version' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '-1',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'info' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'filename',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('system')
->fields(array(
  'filename',
  'name',
  'type',
  'owner',
  'status',
  'throttle',
  'bootstrap',
  'schema_version',
  'weight',
  'info',
))
->values(array(
  'filename' => 'modules/aggregator/aggregator.module',
  'name' => 'aggregator',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:10:"Aggregator";s:11:"description";s:57:"Aggregates syndicated content (RSS, RDF, and Atom feeds).";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/block/block.module',
  'name' => 'block',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:5:"Block";s:11:"description";s:62:"Controls the boxes that are displayed around the main content.";s:7:"package";s:15:"Core - required";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/blog/blog.module',
  'name' => 'blog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"Blog";s:11:"description";s:69:"Enables keeping easily and regularly updated user web pages or blogs.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/blogapi/blogapi.module',
  'name' => 'blogapi',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:8:"Blog API";s:11:"description";s:79:"Allows users to post content using applications that support XML-RPC blog APIs.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/book/book.module',
  'name' => 'book',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"Book";s:11:"description";s:63:"Allows users to structure site pages in a hierarchy or outline.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/color/color.module',
  'name' => 'color',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:5:"Color";s:11:"description";s:61:"Allows the user to change the color scheme of certain themes.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/comment/comment.module',
  'name' => 'comment',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6005',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:7:"Comment";s:11:"description";s:57:"Allows users to comment on and discuss published content.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/contact/contact.module',
  'name' => 'contact',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:7:"Contact";s:11:"description";s:61:"Enables the use of both personal and site-wide contact forms.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/dblog/dblog.module',
  'name' => 'dblog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:16:"Database logging";s:11:"description";s:47:"Logs and records system events to the database.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/filter/filter.module',
  'name' => 'filter',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:6:"Filter";s:11:"description";s:60:"Handles the filtering of content in preparation for display.";s:7:"package";s:15:"Core - required";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/forum/forum.module',
  'name' => 'forum',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6000',
  'weight' => '1',
  'info' => 'a:8:{s:4:"name";s:5:"Forum";s:11:"description";s:50:"Enables threaded discussions about general topics.";s:12:"dependencies";a:2:{i:0;s:8:"taxonomy";i:1;s:7:"comment";}s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/help/help.module',
  'name' => 'help',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"Help";s:11:"description";s:35:"Manages the display of online help.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/locale/locale.module',
  'name' => 'locale',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:6:"Locale";s:11:"description";s:119:"Adds language handling functionality and enables the translation of the user interface to languages other than English.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/menu/menu.module',
  'name' => 'menu',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6000',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"Menu";s:11:"description";s:60:"Allows administrators to customize the site navigation menu.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/node/node.module',
  'name' => 'node',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"Node";s:11:"description";s:66:"Allows content to be submitted to the site and displayed on pages.";s:7:"package";s:15:"Core - required";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/openid/openid.module',
  'name' => 'openid',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:6:"OpenID";s:11:"description";s:48:"Allows users to log into your site using OpenID.";s:7:"version";s:4:"6.38";s:7:"package";s:15:"Core - optional";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/path/path.module',
  'name' => 'path',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"Path";s:11:"description";s:28:"Allows users to rename URLs.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/php/php.module',
  'name' => 'php',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:10:"PHP filter";s:11:"description";s:50:"Allows embedded PHP code/snippets to be evaluated.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/ping/ping.module',
  'name' => 'ping',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"Ping";s:11:"description";s:51:"Alerts other sites when your site has been updated.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/poll/poll.module',
  'name' => 'poll',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"Poll";s:11:"description";s:95:"Allows your site to capture votes on different topics in the form of multiple choice questions.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/profile/profile.module',
  'name' => 'profile',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:7:"Profile";s:11:"description";s:36:"Supports configurable user profiles.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/search/search.module',
  'name' => 'search',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:6:"Search";s:11:"description";s:36:"Enables site-wide keyword searching.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/statistics/statistics.module',
  'name' => 'statistics',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:10:"Statistics";s:11:"description";s:37:"Logs access statistics for your site.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/syslog/syslog.module',
  'name' => 'syslog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:6:"Syslog";s:11:"description";s:41:"Logs and records system events to syslog.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/system/system.module',
  'name' => 'system',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6056',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:6:"System";s:11:"description";s:54:"Handles general site configuration for administrators.";s:7:"package";s:15:"Core - required";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/taxonomy/taxonomy.module',
  'name' => 'taxonomy',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:8:"Taxonomy";s:11:"description";s:38:"Enables the categorization of content.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/throttle/throttle.module',
  'name' => 'throttle',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:8:"Throttle";s:11:"description";s:66:"Handles the auto-throttling mechanism, to control site congestion.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/tracker/tracker.module',
  'name' => 'tracker',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:7:"Tracker";s:11:"description";s:43:"Enables tracking of recent posts for users.";s:12:"dependencies";a:1:{i:0;s:7:"comment";}s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/translation/translation.module',
  'name' => 'translation',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:19:"Content translation";s:11:"description";s:57:"Allows content to be translated into different languages.";s:12:"dependencies";a:1:{i:0;s:6:"locale";}s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/trigger/trigger.module',
  'name' => 'trigger',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:7:"Trigger";s:11:"description";s:90:"Enables actions to be fired on certain system events, such as when new content is created.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/update/update.module',
  'name' => 'update',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:13:"Update status";s:11:"description";s:88:"Checks the status of available updates for Drupal and your installed modules and themes.";s:7:"version";s:4:"6.38";s:7:"package";s:15:"Core - optional";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/upload/upload.module',
  'name' => 'upload',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:6:"Upload";s:11:"description";s:51:"Allows users to upload and attach files to content.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'modules/user/user.module',
  'name' => 'user',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"User";s:11:"description";s:47:"Manages the user registration and login system.";s:7:"package";s:15:"Core - required";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/content.module',
  'name' => 'content',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6010',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:7:"Content";s:11:"description";s:50:"Allows administrators to define new content types.";s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/content_copy/content_copy.module',
  'name' => 'content_copy',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:12:"Content Copy";s:11:"description";s:51:"Enables ability to import/export field definitions.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/content_multigroup/content_multigroup.module',
  'name' => 'content_multigroup',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:18:"Content Multigroup";s:11:"description";s:81:"Combine multiple CCK fields into repeating field collections that work in unison.";s:12:"dependencies";a:2:{i:0;s:7:"content";i:1;s:10:"fieldgroup";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/content_permissions/content_permissions.module',
  'name' => 'content_permissions',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:19:"Content Permissions";s:11:"description";s:43:"Set field-level permissions for CCK fields.";s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/fieldgroup/fieldgroup.module',
  'name' => 'fieldgroup',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:10:"Fieldgroup";s:11:"description";s:37:"Create display groups for CCK fields.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/nodereference/nodereference.module',
  'name' => 'nodereference',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:14:"Node Reference";s:11:"description";s:59:"Defines a field type for referencing one node from another.";s:12:"dependencies";a:3:{i:0;s:7:"content";i:1;s:4:"text";i:2;s:13:"optionwidgets";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/number/number.module',
  'name' => 'number',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:6:"Number";s:11:"description";s:28:"Defines numeric field types.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/optionwidgets/optionwidgets.module',
  'name' => 'optionwidgets',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:14:"Option Widgets";s:11:"description";s:82:"Defines selection, check box and radio button widgets for text and numeric fields.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/text/text.module',
  'name' => 'text',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6003',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:4:"Text";s:11:"description";s:32:"Defines simple text field types.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/modules/userreference/userreference.module',
  'name' => 'userreference',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:14:"User Reference";s:11:"description";s:56:"Defines a field type for referencing a user from a node.";s:12:"dependencies";a:3:{i:0;s:7:"content";i:1;s:4:"text";i:2;s:13:"optionwidgets";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/cck/tests/content_test.module',
  'name' => 'content_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:12:"Content Test";s:11:"description";s:20:"Test module for CCK.";s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:12:"dependencies";a:1:{i:0;s:6:"schema";}s:6:"hidden";b:1;s:5:"files";a:1:{i:0;s:19:"content_test.module";}s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date/date.module',
  'name' => 'date',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6005',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Date";s:11:"description";s:41:"Defines CCK date/time fields and widgets.";s:12:"dependencies";a:3:{i:0;s:7:"content";i:1;s:8:"date_api";i:2;s:13:"date_timezone";}s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-2.8";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1326285938";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_api.module',
  'name' => 'date_api',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6006',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"Date API";s:11:"description";s:45:"A Date API that can be used by other modules.";s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-2.8";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1326285938";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_timezone/date_timezone.module',
  'name' => 'date_timezone',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '5200',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:13:"Date Timezone";s:11:"description";s:111:"Needed when using Date API. Overrides site and user timezone handling to set timezone names instead of offsets.";s:7:"package";s:9:"Date/Time";s:12:"dependencies";a:1:{i:0;s:8:"date_api";}s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-2.8";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1326285938";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/email/email.module',
  'name' => 'email',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:5:"Email";s:11:"description";s:35:"Defines an email field type for cck";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-1.4";s:7:"project";s:5:"email";s:9:"datestamp";s:10:"1354093658";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/event/event.module',
  'name' => 'event',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6005',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:5:"Event";s:11:"description";s:44:"Calendaring API, calendar display and export";s:7:"package";s:5:"Event";s:4:"core";s:3:"6.x";s:7:"version";s:11:"6.x-2.x-dev";s:7:"project";s:5:"event";s:9:"datestamp";s:10:"1425082685";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/filefield/filefield.module',
  'name' => 'filefield',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6104',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:9:"FileField";s:11:"description";s:26:"Defines a file field type.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:3:"php";s:3:"5.0";s:7:"version";s:8:"6.x-3.14";s:7:"project";s:9:"filefield";s:9:"datestamp";s:10:"1456327142";s:10:"dependents";a:0:{}}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n.module',
  'name' => 'i18n',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:20:"Internationalization";s:11:"description";s:49:"Extends Drupal support for multilingual features.";s:12:"dependencies";a:2:{i:0;s:6:"locale";i:1;s:11:"translation";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18nblocks/i18nblocks.module',
  'name' => 'i18nblocks',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:17:"Block translation";s:11:"description";s:50:"Enables multilingual blocks and block translation.";s:12:"dependencies";a:2:{i:0;s:4:"i18n";i:1;s:11:"i18nstrings";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18ncck/i18ncck.module',
  'name' => 'i18ncck',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:15:"CCK translation";s:11:"description";s:56:"Supports translatable custom CCK fields and fieldgroups.";s:12:"dependencies";a:3:{i:0;s:4:"i18n";i:1;s:7:"content";i:2;s:11:"i18nstrings";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18ncontent/i18ncontent.module',
  'name' => 'i18ncontent',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:24:"Content type translation";s:11:"description";s:99:"Add multilingual options for content and translate related strings: name, description, help text...";s:12:"dependencies";a:1:{i:0;s:11:"i18nstrings";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18nmenu/i18nmenu.module',
  'name' => 'i18nmenu',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:16:"Menu translation";s:11:"description";s:40:"Supports translatable custom menu items.";s:12:"dependencies";a:4:{i:0;s:4:"i18n";i:1;s:4:"menu";i:2;s:10:"i18nblocks";i:3;s:11:"i18nstrings";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18npoll/i18npoll.module',
  'name' => 'i18npoll',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:14:"Poll aggregate";s:11:"description";s:45:"Aggregates poll results for all translations.";s:12:"dependencies";a:2:{i:0;s:11:"translation";i:1;s:4:"poll";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18nprofile/i18nprofile.module',
  'name' => 'i18nprofile',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:19:"Profile translation";s:11:"description";s:36:"Enables multilingual profile fields.";s:12:"dependencies";a:2:{i:0;s:7:"profile";i:1;s:11:"i18nstrings";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18nstrings/i18nstrings.module',
  'name' => 'i18nstrings',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:18:"String translation";s:11:"description";s:57:"Provides support for translation of user defined strings.";s:12:"dependencies";a:1:{i:0;s:6:"locale";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18nsync/i18nsync.module',
  'name' => 'i18nsync',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:24:"Synchronize translations";s:11:"description";s:74:"Synchronizes taxonomy and fields accross translations of the same content.";s:12:"dependencies";a:1:{i:0;s:4:"i18n";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18ntaxonomy/i18ntaxonomy.module',
  'name' => 'i18ntaxonomy',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:20:"Taxonomy translation";s:11:"description";s:30:"Enables multilingual taxonomy.";s:12:"dependencies";a:3:{i:0;s:4:"i18n";i:1;s:8:"taxonomy";i:2;s:11:"i18nstrings";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/tests/i18n_test.module',
  'name' => 'i18n_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:26:"Internationalization tests";s:11:"description";s:55:"Helper module for testing i18n (do not enable manually)";s:12:"dependencies";a:3:{i:0;s:6:"locale";i:1;s:11:"translation";i:2;s:4:"i18n";}s:7:"package";s:7:"Testing";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/imageapi/imageapi.module',
  'name' => 'imageapi',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"ImageAPI";s:11:"description";s:38:"ImageAPI supporting multiple toolkits.";s:7:"package";s:10:"ImageCache";s:4:"core";s:3:"6.x";s:3:"php";s:3:"5.1";s:7:"version";s:13:"6.x-1.9+4-dev";s:7:"project";s:8:"imageapi";s:9:"datestamp";s:10:"1380582658";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}}',
))
->values(array(
  'filename' => 'sites/all/modules/imagecache/imagecache.module',
  'name' => 'imagecache',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"ImageCache";s:11:"description";s:36:"Dynamic image manipulator and cache.";s:7:"package";s:10:"ImageCache";s:12:"dependencies";a:1:{i:0;s:8:"imageapi";}s:4:"core";s:3:"6.x";s:7:"version";s:18:"6.x-2.0-rc1+16-dev";s:7:"project";s:10:"imagecache";s:9:"datestamp";s:10:"1380582680";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/imagefield/imagefield.module',
  'name' => 'imagefield',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6006',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"ImageField";s:11:"description";s:28:"Defines an image field type.";s:4:"core";s:3:"6.x";s:12:"dependencies";a:2:{i:0;s:7:"content";i:1;s:9:"filefield";}s:7:"package";s:3:"CCK";s:7:"version";s:7:"6.x-3.3";s:7:"project";s:10:"imagefield";s:9:"datestamp";s:10:"1273102211";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/nodereference_url/nodereference_url.module',
  'name' => 'nodereference_url',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:25:"Node Reference URL Widget";s:11:"description";s:99:"Adds an additional widget to the CCK Node Reference field that prepopulates a reference by the URL.";s:12:"dependencies";a:1:{i:0;s:13:"nodereference";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'sites/all/modules/variable/variable_admin/variable_admin.module',
  'name' => 'variable_admin',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:14:"Variable admin";s:11:"description";s:23:"Variable API - Admin UI";s:4:"core";s:3:"6.x";s:7:"version";s:11:"6.x-1.x-dev";s:7:"project";s:8:"variable";s:9:"datestamp";s:10:"1406295528";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'themes/bluemarine/bluemarine.info',
  'name' => 'bluemarine',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:10:"Bluemarine";s:11:"description";s:66:"Table-based multi-column theme with a marine and ash color scheme.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/bluemarine/script.js";}s:10:"screenshot";s:32:"themes/bluemarine/screenshot.png";s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'themes/chameleon/chameleon.info',
  'name' => 'chameleon',
  'type' => 'theme',
  'owner' => 'themes/chameleon/chameleon.theme',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:9:"Chameleon";s:11:"description";s:42:"Minimalist tabled theme with light colors.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:8:"features";a:4:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"scripts";a:1:{s:9:"script.js";s:26:"themes/chameleon/script.js";}s:10:"screenshot";s:31:"themes/chameleon/screenshot.png";s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'themes/chameleon/marvin/marvin.info',
  'name' => 'marvin',
  'type' => 'theme',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:6:"Marvin";s:11:"description";s:31:"Boxy tabled theme in all grays.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"base theme";s:9:"chameleon";s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/chameleon/marvin/script.js";}s:10:"screenshot";s:38:"themes/chameleon/marvin/screenshot.png";s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'themes/garland/garland.info',
  'name' => 'garland',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:7:"Garland";s:11:"description";s:66:"Tableless, recolorable, multi-column, fluid width theme (default).";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:24:"themes/garland/script.js";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"4.3.5";}',
))
->values(array(
  'filename' => 'themes/garland/minnelli/minnelli.info',
  'name' => 'minnelli',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:8:"Minnelli";s:11:"description";s:56:"Tableless, recolorable, multi-column, fixed width theme.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"base theme";s:7:"garland";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/garland/minnelli/script.js";}s:10:"screenshot";s:38:"themes/garland/minnelli/screenshot.png";s:3:"php";s:5:"4.3.5";s:6:"engine";s:11:"phptemplate";}',
))
->values(array(
  'filename' => 'themes/pushbutton/pushbutton.info',
  'name' => 'pushbutton',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:10:"Pushbutton";s:11:"description";s:52:"Tabled, multi-column theme in blue and orange tones.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/pushbutton/script.js";}s:10:"screenshot";s:32:"themes/pushbutton/screenshot.png";s:3:"php";s:5:"4.3.5";}',
))
->execute();
$connection->schema()->createTable('term_data', array(
  'fields' => array(
    'tid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'tid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('term_data')
->fields(array(
  'tid',
  'vid',
  'name',
  'description',
  'weight',
))
->values(array(
  'tid' => '8',
  'vid' => '7',
  'name' => 'General discussion',
  'description' => '',
  'weight' => '2',
))
->values(array(
  'tid' => '9',
  'vid' => '7',
  'name' => 'Earth',
  'description' => '',
  'weight' => '0',
))
->values(array(
  'tid' => '10',
  'vid' => '7',
  'name' => 'Birds',
  'description' => '',
  'weight' => '0',
))
->values(array(
  'tid' => '11',
  'vid' => '8',
  'name' => 'Oak',
  'description' => '',
  'weight' => '0',
))
->values(array(
  'tid' => '12',
  'vid' => '8',
  'name' => 'Ash',
  'description' => '',
  'weight' => '0',
))
->execute();
$connection->schema()->createTable('term_hierarchy', array(
  'fields' => array(
    'tid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'parent' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'tid',
    'parent',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('term_hierarchy')
->fields(array(
  'tid',
  'parent',
))
->values(array(
  'tid' => '8',
  'parent' => '0',
))
->values(array(
  'tid' => '9',
  'parent' => '0',
))
->values(array(
  'tid' => '10',
  'parent' => '9',
))
->values(array(
  'tid' => '11',
  'parent' => '0',
))
->values(array(
  'tid' => '12',
  'parent' => '0',
))
->execute();
$connection->schema()->createTable('term_node', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'tid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'vid',
    'tid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('term_node')
->fields(array(
  'nid',
  'vid',
  'tid',
))
->values(array(
  'nid' => '19',
  'vid' => '22',
  'tid' => '8',
))
->values(array(
  'nid' => '20',
  'vid' => '23',
  'tid' => '10',
))
->values(array(
  'nid' => '20',
  'vid' => '23',
  'tid' => '12',
))
->execute();
$connection->schema()->createTable('term_relation', array(
  'fields' => array(
    'trid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'tid1' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'tid2' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'trid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('term_synonym', array(
  'fields' => array(
    'tsid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'tid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'tsid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('upload', array(
  'fields' => array(
    'fid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'description' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'list' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'vid',
    'fid',
  ),
  'indexes' => array(
    'fid' => array(
      'fid',
    ),
    'nid' => array(
      'nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('url_alias', array(
  'fields' => array(
    'pid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'src' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'dst' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'pid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('url_alias')
->fields(array(
  'pid',
  'src',
  'dst',
  'language',
))
->values(array(
  'pid' => '1',
  'src' => 'node/1',
  'dst' => 'alias-one',
  'language' => 'af',
))
->values(array(
  'pid' => '5',
  'src' => 'node/11',
  'dst' => 'le-vrai-mccoy',
  'language' => 'fr',
))
->values(array(
  'pid' => '6',
  'src' => 'node/12',
  'dst' => 'abantu-zulu',
  'language' => 'zu',
))
->values(array(
  'pid' => '8',
  'src' => 'admin',
  'dst' => 'source-noslash',
  'language' => '',
))
->execute();
$connection->schema()->createTable('users', array(
  'fields' => array(
    'uid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '60',
      'default' => '',
    ),
    'pass' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'mail' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '64',
      'default' => '',
    ),
    'mode' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'sort' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'default' => '0',
    ),
    'threshold' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'default' => '0',
    ),
    'theme' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'signature' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'signature_format' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'access' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'login' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'timezone' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '8',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'picture' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'init' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '64',
      'default' => '',
    ),
    'data' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'timezone_name' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '50',
      'default' => '',
    ),
    'pass_plain' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'expected_timezone' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '50',
    ),
    'timezone_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'uid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('users')
->fields(array(
  'uid',
  'name',
  'pass',
  'mail',
  'mode',
  'sort',
  'threshold',
  'theme',
  'signature',
  'signature_format',
  'created',
  'access',
  'login',
  'status',
  'timezone',
  'language',
  'picture',
  'init',
  'data',
  'timezone_name',
  'pass_plain',
  'expected_timezone',
  'timezone_id',
))
->values(array(
  'uid' => '1',
  'name' => 'root',
  'pass' => '63a9f0ea7bb98050796b649e85481845',
  'mail' => 'root@localhost',
  'mode' => '0',
  'sort' => '0',
  'threshold' => '0',
  'theme' => '',
  'signature' => '',
  'signature_format' => '0',
  'created' => '0',
  'access' => '1687738850',
  'login' => '1687738850',
  'status' => '1',
  'timezone' => NULL,
  'language' => '',
  'picture' => '',
  'init' => 'root@localhost',
  'data' => 'b:0;',
  'timezone_name' => '',
  'pass_plain' => 'root',
  'expected_timezone' => NULL,
  'timezone_id' => '0',
))
->execute();
$connection->schema()->createTable('users_roles', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'uid',
    'rid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('variable', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'value' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('variable')
->fields(array(
  'name',
  'value',
))
->values(array(
  'name' => 'actions_max_stack',
  'value' => 'i:35;',
))
->values(array(
  'name' => 'admin_compact_mode',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'aggregator_fetcher',
  'value' => 's:10:"aggregator";',
))
->values(array(
  'name' => 'aggregator_parser',
  'value' => 's:10:"aggregator";',
))
->values(array(
  'name' => 'aggregator_processors',
  'value' => 'a:1:{i:0;s:10:"aggregator";}',
))
->values(array(
  'name' => 'aggregator_teaser_length',
  'value' => 's:3:"600";',
))
->values(array(
  'name' => 'allowed_html_1',
  'value' => 's:61:"<a> <em> <strong> <cite> <code> <ul> <ol> <li> <dl> <dt> <dd>";',
))
->values(array(
  'name' => 'allow_insecure_uploads',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'anonymous',
  'value' => 's:5:"Guest";',
))
->values(array(
  'name' => 'array_filter',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'book_allowed_types',
  'value' => 'a:1:{i:0;s:4:"book";}',
))
->values(array(
  'name' => 'book_block_mode',
  'value' => 's:10:"book pages";',
))
->values(array(
  'name' => 'book_child_type',
  'value' => 's:4:"book";',
))
->values(array(
  'name' => 'cache_lifetime',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_article',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_company',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_employee',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_page',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_sponsor',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_story',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_article',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'comment_company',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'comment_controls_article',
  'value' => 'i:3;',
))
->values(array(
  'name' => 'comment_controls_company',
  'value' => 's:1:"3";',
))
->values(array(
  'name' => 'comment_controls_employee',
  'value' => 's:1:"3";',
))
->values(array(
  'name' => 'comment_controls_page',
  'value' => 's:1:"3";',
))
->values(array(
  'name' => 'comment_controls_sponsor',
  'value' => 's:1:"3";',
))
->values(array(
  'name' => 'comment_controls_story',
  'value' => 'i:3;',
))
->values(array(
  'name' => 'comment_default_mode_article',
  'value' => 'i:4;',
))
->values(array(
  'name' => 'comment_default_mode_company',
  'value' => 's:1:"4";',
))
->values(array(
  'name' => 'comment_default_mode_employee',
  'value' => 's:1:"4";',
))
->values(array(
  'name' => 'comment_default_mode_page',
  'value' => 's:1:"4";',
))
->values(array(
  'name' => 'comment_default_mode_sponsor',
  'value' => 's:1:"4";',
))
->values(array(
  'name' => 'comment_default_mode_story',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'comment_default_order_article',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_order_company',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_default_order_employee',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_default_order_page',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_default_order_sponsor',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_default_order_story',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_per_page_article',
  'value' => 'i:50;',
))
->values(array(
  'name' => 'comment_default_per_page_company',
  'value' => 's:2:"50";',
))
->values(array(
  'name' => 'comment_default_per_page_employee',
  'value' => 's:2:"50";',
))
->values(array(
  'name' => 'comment_default_per_page_page',
  'value' => 's:2:"50";',
))
->values(array(
  'name' => 'comment_default_per_page_sponsor',
  'value' => 's:2:"50";',
))
->values(array(
  'name' => 'comment_default_per_page_story',
  'value' => 'i:70;',
))
->values(array(
  'name' => 'comment_employee',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'comment_form_location_article',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_form_location_company',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'comment_form_location_employee',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'comment_form_location_page',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'comment_form_location_sponsor',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'comment_form_location_story',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_page',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'comment_preview_article',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_preview_company',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_preview_employee',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_preview_page',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_preview_sponsor',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_preview_story',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_sponsor',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'comment_story',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'comment_subject_field_article',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_company',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_subject_field_employee',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_subject_field_page',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_sponsor',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_subject_field_story',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'configurable_timezones',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'content_extra_weights_employee',
  'value' => 'a:11:{s:5:"title";s:2:"-5";s:10:"body_field";s:1:"0";s:20:"revision_information";s:2:"20";s:6:"author";s:2:"20";s:7:"options";s:2:"25";s:16:"comment_settings";s:2:"30";s:8:"language";s:1:"0";s:11:"translation";s:2:"30";s:4:"menu";s:2:"-2";s:4:"book";s:2:"10";s:4:"path";s:2:"30";}',
))
->values(array(
  'name' => 'content_extra_weights_forum',
  'value' => 'a:9:{s:5:"title";s:2:"-5";s:10:"body_field";s:1:"0";s:20:"revision_information";s:2:"20";s:6:"author";s:2:"20";s:7:"options";s:2:"25";s:16:"comment_settings";s:2:"30";s:4:"menu";s:2:"-2";s:8:"taxonomy";s:2:"-3";s:4:"path";s:2:"30";}',
))
->values(array(
  'name' => 'content_extra_weights_story',
  'value' => 'a:9:{s:5:"title";s:2:"-5";s:10:"body_field";s:2:"-2";s:20:"revision_information";s:2:"19";s:6:"author";s:2:"18";s:7:"options";s:2:"20";s:16:"comment_settings";s:2:"22";s:4:"menu";s:2:"-3";s:8:"taxonomy";s:2:"-4";s:11:"attachments";s:2:"21";}',
))
->values(array(
  'name' => 'content_extra_weights_test_page',
  'value' => 'a:8:{s:5:"title";s:2:"37";s:10:"body_field";s:2:"38";s:20:"revision_information";s:2:"40";s:6:"author";s:2:"39";s:7:"options";s:2:"41";s:16:"comment_settings";s:2:"42";s:4:"menu";s:2:"36";s:11:"attachments";s:2:"43";}',
))
->values(array(
  'name' => 'content_schema_version',
  'value' => 'i:6009;',
))
->values(array(
  'name' => 'cron_last',
  'value' => 'i:1675409474;',
))
->values(array(
  'name' => 'cron_threshold_error',
  'value' => 'i:1209600;',
))
->values(array(
  'name' => 'cron_threshold_warning',
  'value' => 'i:172800;',
))
->values(array(
  'name' => 'css_js_query_string',
  'value' => 's:20:"mEOgby8SAkMTxRZndiw7";',
))
->values(array(
  'name' => 'date:story:4:field_test_datestamp_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:4:field_test_datestamp_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:4:field_test_datestamp_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:4:field_test_datestamp_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:4:field_test_datestamp_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:4:field_test_datetime_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:4:field_test_datetime_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:4:field_test_datetime_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:4:field_test_datetime_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:4:field_test_datetime_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:4:field_test_date_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:4:field_test_date_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:4:field_test_date_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:4:field_test_date_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:4:field_test_date_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:5:field_test_datestamp_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:5:field_test_datestamp_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:5:field_test_datestamp_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:5:field_test_datestamp_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:5:field_test_datestamp_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:5:field_test_datetime_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:5:field_test_datetime_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:5:field_test_datetime_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:5:field_test_datetime_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:5:field_test_datetime_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:5:field_test_date_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:5:field_test_date_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:5:field_test_date_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:5:field_test_date_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:5:field_test_date_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:full:field_test_datestamp_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:full:field_test_datestamp_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:full:field_test_datestamp_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:full:field_test_datestamp_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:full:field_test_datestamp_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:full:field_test_datetime_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:full:field_test_datetime_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:full:field_test_datetime_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:full:field_test_datetime_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:full:field_test_datetime_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:full:field_test_date_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:full:field_test_date_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:full:field_test_date_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:full:field_test_date_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:full:field_test_date_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datestamp_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datestamp_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datestamp_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datestamp_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datestamp_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datetime_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datetime_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datetime_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datetime_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_datetime_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_date_fromto',
  'value' => 's:4:"both";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_date_multiple_from',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_date_multiple_number',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_date_multiple_to',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'date:story:teaser:field_test_date_show_repeat_rule',
  'value' => 's:4:"show";',
))
->values(array(
  'name' => 'date_api_version',
  'value' => 's:3:"5.2";',
))
->values(array(
  'name' => 'date_default_timezone',
  'value' => 's:4:"3600";',
))
->values(array(
  'name' => 'date_first_day',
  'value' => 's:1:"4";',
))
->values(array(
  'name' => 'date_format_long',
  'value' => 's:24:"\L\O\N\G l, F j, Y - H:i";',
))
->values(array(
  'name' => 'date_format_medium',
  'value' => 's:27:"\M\E\D\I\U\M D, m/d/Y - H:i";',
))
->values(array(
  'name' => 'date_format_short',
  'value' => 's:22:"\S\H\O\R\T m/d/Y - H:i";',
))
->values(array(
  'name' => 'dblog_row_limit',
  'value' => 'i:10000;',
))
->values(array(
  'name' => 'drupal_badge_color',
  'value' => 's:12:"powered-blue";',
))
->values(array(
  'name' => 'drupal_badge_size',
  'value' => 's:5:"80x15";',
))
->values(array(
  'name' => 'drupal_http_request_fails',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'drupal_private_key',
  'value' => 's:43:"6bTz0JLHTM1R1c7VtbZtbio47JygBoNuGuzS5G0JYWs";',
))
->values(array(
  'name' => 'error_level',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'event_nodeapi_article',
  'value' => 's:5:"never";',
))
->values(array(
  'name' => 'event_nodeapi_company',
  'value' => 's:5:"never";',
))
->values(array(
  'name' => 'event_nodeapi_employee',
  'value' => 's:5:"never";',
))
->values(array(
  'name' => 'event_nodeapi_event',
  'value' => 's:3:"all";',
))
->values(array(
  'name' => 'event_nodeapi_sponsor',
  'value' => 's:5:"never";',
))
->values(array(
  'name' => 'event_timezone_display',
  'value' => 's:5:"event";',
))
->values(array(
  'name' => 'feed_default_items',
  'value' => 'i:10;',
))
->values(array(
  'name' => 'feed_item_length',
  'value' => 's:5:"title";',
))
->values(array(
  'name' => 'file_description_length',
  'value' => 'i:128;',
))
->values(array(
  'name' => 'file_description_type',
  'value' => 's:9:"textfield";',
))
->values(array(
  'name' => 'file_directory_path',
  'value' => 's:19:"sites/default/files";',
))
->values(array(
  'name' => 'file_directory_temp',
  'value' => 's:4:"/tmp";',
))
->values(array(
  'name' => 'file_downloads',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'file_icon_directory',
  'value' => 's:25:"sites/default/files/icons";',
))
->values(array(
  'name' => 'filter_allowed_protocols',
  'value' => 'a:13:{i:0;s:4:"http";i:1;s:5:"https";i:2;s:3:"ftp";i:3;s:4:"news";i:4;s:4:"nntp";i:5;s:3:"tel";i:6;s:6:"telnet";i:7;s:6:"mailto";i:8;s:3:"irc";i:9;s:3:"ssh";i:10;s:4:"sftp";i:11;s:6:"webcal";i:12;s:4:"rtsp";}',
))
->values(array(
  'name' => 'filter_html_1',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'filter_html_help_1',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'filter_html_nofollow_1',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'filter_url_length_1',
  'value' => 's:2:"72";',
))
->values(array(
  'name' => 'form_build_id_article',
  'value' => 's:48:"form-t2zKJflpBD4rpYoGQH33ckjjWAYdo5lF3Hl1O_YnWyE";',
))
->values(array(
  'name' => 'form_build_id_company',
  'value' => 's:48:"form-jFw2agRukPxjG5dG-N6joZLyoxXmCoxTzua0HUciqK0";',
))
->values(array(
  'name' => 'form_build_id_employee',
  'value' => 's:48:"form-q42bJnZxCCHxcx5FjxjEOd8OaEAg9wnK8nX1hBjtT4M";',
))
->values(array(
  'name' => 'form_build_id_sponsor',
  'value' => 's:48:"form-1iWzOEGgEeoeGb7ywYWz4iUNal77IHPDVwqYj-a7ezQ";',
))
->values(array(
  'name' => 'forum_block_num_0',
  'value' => 's:1:"3";',
))
->values(array(
  'name' => 'forum_block_num_1',
  'value' => 's:1:"4";',
))
->values(array(
  'name' => 'forum_containers',
  'value' => 'a:1:{i:0;s:1:"9";}',
))
->values(array(
  'name' => 'forum_hot_topic',
  'value' => 's:2:"15";',
))
->values(array(
  'name' => 'forum_nav_vocabulary',
  'value' => 's:1:"7";',
))
->values(array(
  'name' => 'forum_order',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'forum_per_page',
  'value' => 's:2:"25";',
))
->values(array(
  'name' => 'i18nstrings_allowed_formats',
  'value' => 'a:2:{i:0;i:1;i:1;i:2;}',
))
->values(array(
  'name' => 'i18nsync_nodeapi_employee',
  'value' => 'a:1:{i:0;s:10:"field_sync";}',
))
->values(array(
  'name' => 'i18n_lock_node_article',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'i18n_lock_node_employee',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'i18n_lock_node_sponsor',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'i18n_newnode_current_employee',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'i18n_newnode_current_sponsor',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'i18n_required_node_employee',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'i18n_required_node_sponsor',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'image_jpeg_quality',
  'value' => 'i:75;',
))
->values(array(
  'name' => 'image_toolkit',
  'value' => 's:2:"gd";',
))
->values(array(
  'name' => 'javascript_parsed',
  'value' => 'a:0:{}',
))
->values(array(
  'name' => 'menu_default_node_menu',
  'value' => 's:10:"navigation";',
))
->values(array(
  'name' => 'menu_expanded',
  'value' => 'a:0:{}',
))
->values(array(
  'name' => 'menu_masks',
  'value' => 'a:19:{i:0;i:127;i:1;i:63;i:2;i:62;i:3;i:61;i:4;i:59;i:5;i:31;i:6;i:30;i:7;i:29;i:8;i:24;i:9;i:21;i:10;i:15;i:11;i:14;i:12;i:11;i:13;i:7;i:14;i:6;i:15;i:5;i:16;i:3;i:17;i:2;i:18;i:1;}',
))
->values(array(
  'name' => 'menu_override_parent_selector',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'minimum_word_size',
  'value' => 's:1:"3";',
))
->values(array(
  'name' => 'node_admin_theme',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'node_cron_comments_scale',
  'value' => 'd:0.33333333333333331;',
))
->values(array(
  'name' => 'node_cron_last',
  'value' => 's:10:"1501955771";',
))
->values(array(
  'name' => 'node_cron_views_scale',
  'value' => 'd:0.20000000000000001;',
))
->values(array(
  'name' => 'node_options_article',
  'value' => 'a:1:{i:0;s:7:"promote";}',
))
->values(array(
  'name' => 'node_options_book',
  'value' => 'a:1:{i:0;s:6:"status";}',
))
->values(array(
  'name' => 'node_options_company',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:7:"promote";}',
))
->values(array(
  'name' => 'node_options_employee',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:7:"promote";}',
))
->values(array(
  'name' => 'node_options_forum',
  'value' => 'a:1:{i:0;s:6:"status";}',
))
->values(array(
  'name' => 'node_options_sponsor',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:7:"promote";}',
))
->values(array(
  'name' => 'node_options_test_event',
  'value' => 'a:2:{i:0;s:6:"sticky";i:1;s:8:"revision";}',
))
->values(array(
  'name' => 'node_options_test_page',
  'value' => 'a:3:{i:0;s:6:"status";i:1;s:7:"promote";i:2;s:6:"sticky";}',
))
->values(array(
  'name' => 'node_options_test_planet',
  'value' => 'a:2:{i:0;s:6:"sticky";i:1;s:8:"revision";}',
))
->values(array(
  'name' => 'node_options_test_story',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:7:"promote";}',
))
->values(array(
  'name' => 'node_preview',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'node_rank_comments',
  'value' => 's:1:"5";',
))
->values(array(
  'name' => 'node_rank_promote',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'node_rank_recent',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'node_rank_relevance',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'node_rank_sticky',
  'value' => 's:1:"8";',
))
->values(array(
  'name' => 'node_rank_views',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'overlap_cjk',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'page_compression',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'preprocess_css',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'preprocess_js',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'search_cron_limit',
  'value' => 's:3:"100";',
))
->values(array(
  'name' => 'simpletest_clear_results',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'simpletest_httpauth_method',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'simpletest_httpauth_password',
  'value' => 'N;',
))
->values(array(
  'name' => 'simpletest_httpauth_username',
  'value' => 'N;',
))
->values(array(
  'name' => 'simpletest_verbose',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'site_403',
  'value' => 's:4:"user";',
))
->values(array(
  'name' => 'site_404',
  'value' => 's:14:"page-not-found";',
))
->values(array(
  'name' => 'site_frontpage',
  'value' => 's:4:"node";',
))
->values(array(
  'name' => 'site_mail',
  'value' => 's:21:"site_mail@example.com";',
))
->values(array(
  'name' => 'site_name',
  'value' => 's:9:"site_name";',
))
->values(array(
  'name' => 'site_offline',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'site_offline_message',
  'value' => 's:94:"Drupal is currently under maintenance. We should be back shortly. Thank you for your patience.";',
))
->values(array(
  'name' => 'site_slogan',
  'value' => 's:13:"Migrate rocks";',
))
->values(array(
  'name' => 'syslog_facility',
  'value' => 'i:128;',
))
->values(array(
  'name' => 'syslog_identity',
  'value' => 's:6:"drupal";',
))
->values(array(
  'name' => 'taxonomy_override_selector',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'taxonomy_terms_per_page_admin',
  'value' => 'i:100;',
))
->values(array(
  'name' => 'teaser_length',
  'value' => 'i:456;',
))
->values(array(
  'name' => 'theme_default',
  'value' => 's:7:"garland";',
))
->values(array(
  'name' => 'theme_settings',
  'value' => 'a:22:{s:11:"toggle_logo";i:1;s:11:"toggle_name";i:1;s:13:"toggle_slogan";i:0;s:14:"toggle_mission";i:1;s:24:"toggle_node_user_picture";i:0;s:27:"toggle_comment_user_picture";i:0;s:13:"toggle_search";i:0;s:14:"toggle_favicon";i:1;s:20:"toggle_primary_links";i:1;s:22:"toggle_secondary_links";i:1;s:21:"toggle_node_info_test";i:1;s:26:"toggle_node_info_something";i:1;s:12:"default_logo";i:1;s:9:"logo_path";s:0:"";s:11:"logo_upload";s:0:"";s:15:"default_favicon";i:1;s:12:"favicon_path";s:0:"";s:14:"favicon_upload";s:0:"";s:26:"toggle_node_info_test_page";i:1;s:27:"toggle_node_info_test_story";i:1;s:27:"toggle_node_info_test_event";i:1;s:28:"toggle_node_info_test_planet";i:1;}',
))
->values(array(
  'name' => 'update_max_fetch_attempts',
  'value' => 'i:2;',
))
->values(array(
  'name' => 'upload_article',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'upload_company',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'upload_employee',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'upload_event',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'upload_sponsor',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'upload_story',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'upload_test_event',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'upload_test_page',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'upload_test_planet',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'upload_test_story',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'user_block_max_list_count',
  'value' => 's:2:"10";',
))
->values(array(
  'name' => 'user_block_seconds_online',
  'value' => 's:3:"900";',
))
->values(array(
  'name' => 'user_block_whois_new_count',
  'value' => 's:1:"5";',
))
->values(array(
  'name' => 'user_email_verification',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'user_mail_password_reset_body',
  'value' => "s:409:\"!username,\n\nA request to reset the password for your account has been made at !site.\n\nYou may now log in to !uri_brief by clicking on this link or copying and pasting it in your browser:\n\n!login_url\n\nThis is a one-time login, so it can be used only once. It expires after one day and nothing will happen if it's not used.\n\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\";",
))
->values(array(
  'name' => 'user_mail_password_reset_subject',
  'value' => 's:52:"Replacement login information for !username at !site";',
))
->values(array(
  'name' => 'user_mail_register_admin_created_body',
  'value' => "s:452:\"!username,\n\nA site administrator at !site has created an account for you. You may now log in to !login_uri using the following username and password:\n\nusername: !username\npassword: !password\n\nYou may also log in by clicking on this link or copying and pasting it in your browser:\n\n!login_url\n\nThis is a one-time login, so it can be used only once.\n\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\n\n\n--  !site team\";",
))
->values(array(
  'name' => 'user_mail_register_admin_created_subject',
  'value' => 's:52:"An administrator created an account for you at !site";',
))
->values(array(
  'name' => 'user_mail_register_no_approval_required_body',
  'value' => "s:426:\"!username,\n\nThank you for registering at !site. You may now log in to !login_uri using the following username and password:\n\nusername: !username\npassword: !password\n\nYou may also log in by clicking on this link or copying and pasting it in your browser:\n\n!login_url\n\nThis is a one-time login, so it can be used only once.\n\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\n\n\n--  !site team\";",
))
->values(array(
  'name' => 'user_mail_register_no_approval_required_subject',
  'value' => 's:38:"Account details for !username at !site";',
))
->values(array(
  'name' => 'user_mail_register_pending_approval_body',
  'value' => "s:267:\"!username,\n\nThank you for registering at !site. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.\n\n\n--  !site team\";",
))
->values(array(
  'name' => 'user_mail_register_pending_approval_subject',
  'value' => 's:63:"Account details for !username at !site (pending admin approval)";',
))
->values(array(
  'name' => 'user_mail_status_activated_body',
  'value' => "s:419:\"!username,\n\nYour account at !site has been activated.\n\nYou may now log in by clicking on this link or copying and pasting it in your browser:\n\n!login_url\n\nThis is a one-time login, so it can be used only once.\n\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\n\nOnce you have set your own password, you will be able to log in to !login_uri in the future using:\n\nusername: !username\n\";",
))
->values(array(
  'name' => 'user_mail_status_activated_notify',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'user_mail_status_activated_subject',
  'value' => 's:49:"Account details for !username at !site (approved)";',
))
->values(array(
  'name' => 'user_mail_status_blocked_body',
  'value' => "s:51:\"!username,\n\nYour account on !site has been blocked.\";",
))
->values(array(
  'name' => 'user_mail_status_blocked_notify',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'user_mail_status_blocked_subject',
  'value' => 's:48:"Account details for !username at !site (blocked)";',
))
->values(array(
  'name' => 'user_mail_status_deleted_body',
  'value' => "s:51:\"!username,\n\nYour account on !site has been deleted.\";",
))
->values(array(
  'name' => 'user_mail_status_deleted_subject',
  'value' => 's:48:"Account details for !username at !site (deleted)";',
))
->values(array(
  'name' => 'user_register',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'user_signatures',
  'value' => 's:1:"1";',
))
->execute();
$connection->schema()->createTable('vocabulary', array(
  'fields' => array(
    'vid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'help' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'relations' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'hierarchy' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'multiple' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'required' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'tags' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('vocabulary')
->fields(array(
  'vid',
  'name',
  'description',
  'help',
  'relations',
  'hierarchy',
  'multiple',
  'required',
  'tags',
  'module',
  'weight',
))
->values(array(
  'vid' => '7',
  'name' => 'Forums',
  'description' => '',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '1',
  'multiple' => '0',
  'required' => '0',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'vid' => '8',
  'name' => 'Trees',
  'description' => 'A list of trees.',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '0',
  'multiple' => '0',
  'required' => '0',
  'tags' => '0',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'vid' => '9',
  'name' => 'FreeTags',
  'description' => '',
  'help' => '',
  'relations' => '1',
  'hierarchy' => '0',
  'multiple' => '0',
  'required' => '0',
  'tags' => '1',
  'module' => 'taxonomy',
  'weight' => '0',
))
->execute();
$connection->schema()->createTable('vocabulary_node_types', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'vid',
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('vocabulary_node_types')
->fields(array(
  'vid',
  'type',
))
->values(array(
  'vid' => '7',
  'type' => 'forum',
))
->values(array(
  'vid' => '8',
  'type' => 'forum',
))
->values(array(
  'vid' => '9',
  'type' => 'forum',
))
->execute();
$connection->schema()->createTable('watchdog', array(
  'fields' => array(
    'wid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '16',
      'default' => '',
    ),
    'message' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'variables' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'severity' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'link' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'location' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'referer' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'wid',
  ),
  'mysql_character_set' => 'utf8',
));

// Reset the SQL mode.
if ($connection->databaseType() === 'mysql') {
  $connection->query("SET sql_mode = '$sql_mode'");
}
