/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.state;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.ImputationMethod;
import com.amazon.randomcutforest.config.ScoringStrategy;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.PredictorCorrector;
import com.amazon.randomcutforest.parkservices.RCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.parkservices.preprocessor.Preprocessor;
import com.amazon.randomcutforest.parkservices.state.ThresholdedRandomCutForestState;
import com.amazon.randomcutforest.parkservices.state.predictorcorrector.PredictorCorrectorMapper;
import com.amazon.randomcutforest.parkservices.state.preprocessor.PreprocessorMapper;
import com.amazon.randomcutforest.parkservices.state.preprocessor.PreprocessorState;
import com.amazon.randomcutforest.parkservices.state.returntypes.ComputeDescriptorMapper;
import com.amazon.randomcutforest.parkservices.state.threshold.BasicThresholderMapper;
import com.amazon.randomcutforest.parkservices.threshold.BasicThresholder;
import com.amazon.randomcutforest.returntypes.DiVector;
import com.amazon.randomcutforest.state.IStateMapper;
import com.amazon.randomcutforest.state.RandomCutForestMapper;
import com.amazon.randomcutforest.state.returntypes.DiVectorMapper;

public class ThresholdedRandomCutForestMapper
implements IStateMapper<ThresholdedRandomCutForest, ThresholdedRandomCutForestState> {
    public ThresholdedRandomCutForest toModel(ThresholdedRandomCutForestState state, long seed) {
        PredictorCorrector predictorCorrector;
        RCFComputeDescriptor descriptor;
        RandomCutForestMapper randomCutForestMapper = new RandomCutForestMapper();
        PreprocessorMapper preprocessorMapper = new PreprocessorMapper();
        RandomCutForest forest = randomCutForestMapper.toModel(state.getForestState());
        Preprocessor preprocessor = (Preprocessor)preprocessorMapper.toModel(state.getPreprocessorStates()[0]);
        ForestMode forestMode = ForestMode.valueOf((String)state.getForestMode());
        TransformMethod transformMethod = TransformMethod.valueOf((String)state.getTransformMethod());
        ScoringStrategy scoringStrategy = ScoringStrategy.EXPECTED_INVERSE_DEPTH;
        if (state.getScoringStrategy() != null && !state.getScoringStrategy().isEmpty()) {
            scoringStrategy = ScoringStrategy.valueOf((String)state.getScoringStrategy());
        }
        if (state.getLastDescriptorState() == null) {
            descriptor = new RCFComputeDescriptor(null, 0L);
            descriptor.setRCFScore(state.getLastAnomalyScore());
            descriptor.setInternalTimeStamp(state.getLastAnomalyTimeStamp());
            descriptor.setAttribution((DiVector)new DiVectorMapper().toModel((Object)state.getLastAnomalyAttribution()));
            descriptor.setRCFPoint(state.getLastAnomalyPoint());
            descriptor.setExpectedRCFPoint(state.getLastExpectedPoint());
            descriptor.setRelativeIndex(state.getLastRelativeIndex());
            descriptor.setScoringStrategy(scoringStrategy);
        } else {
            descriptor = (RCFComputeDescriptor)new ComputeDescriptorMapper().toModel(state.getLastDescriptorState());
        }
        descriptor.setForestMode(forestMode);
        descriptor.setTransformMethod(transformMethod);
        descriptor.setScoringStrategy(scoringStrategy);
        descriptor.setImputationMethod(ImputationMethod.valueOf((String)state.getPreprocessorStates()[0].getImputationMethod()));
        if (state.getPredictorCorrectorState() == null) {
            BasicThresholderMapper thresholderMapper = new BasicThresholderMapper();
            BasicThresholder thresholder = (BasicThresholder)thresholderMapper.toModel(state.getThresholderState());
            predictorCorrector = new PredictorCorrector(thresholder, preprocessor.getInputLength());
            predictorCorrector.setNumberOfAttributors(state.getNumberOfAttributors());
            predictorCorrector.setLastScore(new double[]{state.getLastScore()});
        } else {
            PredictorCorrectorMapper mapper = new PredictorCorrectorMapper();
            predictorCorrector = (PredictorCorrector)mapper.toModel(state.getPredictorCorrectorState());
        }
        return new ThresholdedRandomCutForest(forestMode, transformMethod, scoringStrategy, forest, predictorCorrector, preprocessor, descriptor);
    }

    public ThresholdedRandomCutForestState toState(ThresholdedRandomCutForest model) {
        ThresholdedRandomCutForestState state = new ThresholdedRandomCutForestState();
        RandomCutForestMapper randomCutForestMapper = new RandomCutForestMapper();
        randomCutForestMapper.setPartialTreeStateEnabled(true);
        randomCutForestMapper.setSaveTreeStateEnabled(true);
        randomCutForestMapper.setCompressionEnabled(true);
        randomCutForestMapper.setSaveCoordinatorStateEnabled(true);
        randomCutForestMapper.setSaveExecutorContextEnabled(true);
        state.setForestState(randomCutForestMapper.toState(model.getForest()));
        PreprocessorMapper preprocessorMapper = new PreprocessorMapper();
        state.setPreprocessorStates(new PreprocessorState[]{preprocessorMapper.toState((Preprocessor)model.getPreprocessor())});
        state.setPredictorCorrectorState(new PredictorCorrectorMapper().toState(model.getPredictorCorrector()));
        state.setForestMode(model.getForestMode().name());
        state.setTransformMethod(model.getTransformMethod().name());
        state.setScoringStrategy(model.getScoringStrategy().name());
        state.setLastDescriptorState(new ComputeDescriptorMapper().toState(model.getLastAnomalyDescriptor()));
        return state;
    }
}

