/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.config;

import java.security.AccessController;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.cluster.ClusterName;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.spark.config.SparkExecutionEngineConfig;
import org.opensearch.sql.spark.config.SparkExecutionEngineConfigClusterSetting;
import org.opensearch.sql.spark.config.SparkExecutionEngineConfigSupplier;

public class SparkExecutionEngineConfigSupplierImpl
implements SparkExecutionEngineConfigSupplier {
    private Settings settings;

    @Override
    public SparkExecutionEngineConfig getSparkExecutionEngineConfig() {
        String sparkExecutionEngineConfigSettingString = (String)this.settings.getSettingValue(Settings.Key.SPARK_EXECUTION_ENGINE_CONFIG);
        SparkExecutionEngineConfig sparkExecutionEngineConfig = new SparkExecutionEngineConfig();
        if (!StringUtils.isBlank((CharSequence)sparkExecutionEngineConfigSettingString)) {
            SparkExecutionEngineConfigClusterSetting sparkExecutionEngineConfigClusterSetting = AccessController.doPrivileged(() -> SparkExecutionEngineConfigClusterSetting.toSparkExecutionEngineConfig(sparkExecutionEngineConfigSettingString));
            sparkExecutionEngineConfig.setApplicationId(sparkExecutionEngineConfigClusterSetting.getApplicationId());
            sparkExecutionEngineConfig.setExecutionRoleARN(sparkExecutionEngineConfigClusterSetting.getExecutionRoleARN());
            sparkExecutionEngineConfig.setSparkSubmitParameters(sparkExecutionEngineConfigClusterSetting.getSparkSubmitParameters());
            sparkExecutionEngineConfig.setRegion(sparkExecutionEngineConfigClusterSetting.getRegion());
        }
        ClusterName clusterName = (ClusterName)this.settings.getSettingValue(Settings.Key.CLUSTER_NAME);
        sparkExecutionEngineConfig.setClusterName(clusterName.value());
        return sparkExecutionEngineConfig;
    }

    @Generated
    public SparkExecutionEngineConfigSupplierImpl(Settings settings) {
        this.settings = settings;
    }
}

