import { CloudFormationClient } from "../CloudFormationClient";
import { ListStacksCommand } from "../commands/ListStacksCommand";
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListStacksCommand(input), ...args);
};
export async function* paginateListStacks(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        if (config.client instanceof CloudFormationClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected CloudFormation | CloudFormationClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
