/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;

public class Crossbow
extends MeleeWeapon {
    public Crossbow() {
        this.image = ItemSpriteSheet.CROSSBOW;
        this.hitSound = "sounds/hit.mp3";
        this.hitSoundPitch = 1.0f;
        this.tier = 4;
    }

    @Override
    public boolean doUnequip(Hero hero, boolean collect, boolean single) {
        if (super.doUnequip(hero, collect, single)) {
            if (hero.buff(ChargedShot.class) != null && !(hero.belongings.weapon() instanceof Crossbow) && !(hero.belongings.secondWep() instanceof Crossbow)) {
                hero.buff(ChargedShot.class).detach();
            }
            return true;
        }
        return false;
    }

    @Override
    public int max(int lvl) {
        return 4 * (this.tier + 1) + lvl * this.tier;
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        if (hero.buff(ChargedShot.class) != null) {
            GLog.w(Messages.get(this, "ability_cant_use", new Object[0]), new Object[0]);
            return;
        }
        this.beforeAbilityUsed(hero, null);
        Buff.affect(hero, ChargedShot.class);
        hero.sprite.operate(hero.pos);
        hero.next();
        this.afterAbilityUsed(hero);
    }

    public static class ChargedShot
    extends Buff {
        public ChargedShot() {
            this.announced = true;
            this.type = Buff.buffType.POSITIVE;
        }

        @Override
        public int icon() {
            return 66;
        }
    }
}

