/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.util.List;
import java.util.ListIterator;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.InstanceReferenceNode;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.heapviewer.utils.HeapOperations;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.Value;

public class JavaReferencesProvider
extends HeapViewerNode.Provider {
    @Override
    public String getName() {
        return Bundle.JavaReferencesProvider_Name();
    }

    @Override
    public boolean supportsView(Heap heap, String viewID) {
        return viewID.startsWith("java_");
    }

    @Override
    public boolean supportsNode(HeapViewerNode parent, Heap heap, String viewID) {
        return parent instanceof InstanceNode && !InstanceNode.Mode.OUTGOING_REFERENCE.equals((Object)((InstanceNode)parent).getMode());
    }

    @Override
    public HeapViewerNode[] getNodes(HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        return this.getNodes(((InstanceNode)parent).getInstance(), parent, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
    }

    HeapViewerNode[] getNodes(Instance instance, HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        if (instance == null) {
            return null;
        }
        HeapOperations.initializeReferences(heap);
        final List references = instance.getReferences();
        NodesComputer<Value> computer = new NodesComputer<Value>(references.size(), UIThresholds.MAX_INSTANCE_REFERENCES){

            @Override
            protected boolean sorts(DataType dataType) {
                return !DataType.COUNT.equals(dataType);
            }

            @Override
            protected HeapViewerNode createNode(Value reference) {
                return InstanceReferenceNode.incoming(reference);
            }

            @Override
            protected ProgressIterator<Value> objectsIterator(int index, Progress progress) {
                ListIterator iterator = references.listIterator(index);
                return new ProgressIterator<Value>(iterator, index, false, progress);
            }

            @Override
            protected String getMoreNodesString(String moreNodesCount) {
                return Bundle.JavaReferencesProvider_MoreNodes(moreNodesCount);
            }

            @Override
            protected String getSamplesContainerString(String objectsCount) {
                return Bundle.JavaReferencesProvider_SamplesContainer(objectsCount);
            }

            @Override
            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return Bundle.JavaReferencesProvider_NodesContainer(firstNodeIdx, lastNodeIdx);
            }
        };
        return computer.computeNodes(parent, heap, viewID, null, dataTypes, sortOrders, progress);
    }
}

