/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.pluginimporter;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.graalvm.visualvm.pluginimporter.ClusterUpdateProvider;
import org.graalvm.visualvm.pluginimporter.ImportManager;
import org.graalvm.visualvm.pluginimporter.PluginImporter;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class Installer
implements Runnable {
    public static final String KEY_IMPORT_FROM = "import-from";
    public static final String CODE_NAME = "ClusterUpdateProvider";
    public static final String REMOVED = "_removed";
    private static final Logger LOG = Logger.getLogger(Installer.class.getName());
    private static final String IMPORTED = "imported";
    private static final String AUTOUPDATE_PREF = "/org/netbeans/modules/autoupdate";
    private Runnable doCheck = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File importFrom = null;
            String from = System.getProperty("plugin.manager.import.from", "");
            Preferences pref = NbPreferences.forModule(Installer.class);
            Preferences au_pref = NbPreferences.root().node(Installer.AUTOUPDATE_PREF);
            if (!from.isEmpty()) {
                importFrom = new File(from);
                boolean imported = au_pref.getBoolean(Installer.IMPORTED, false);
                if (!imported) {
                    importFrom = null;
                }
            } else if (pref.get(Installer.KEY_IMPORT_FROM, null) != null) {
                importFrom = new File(pref.get(Installer.KEY_IMPORT_FROM, ""));
            }
            au_pref.putBoolean(Installer.IMPORTED, false);
            if (importFrom == null || !importFrom.exists()) {
                LOG.fine("Nothing to import from " + importFrom);
                return;
            }
            try {
                Preferences p = au_pref.node("ClusterUpdateProvider_removed");
                p.removeNode();
            }
            catch (BackingStoreException ex) {
                LOG.log(Level.INFO, ex.getLocalizedMessage(), ex);
                return;
            }
            UpdateUnitProvider clusterUpdateProvider = null;
            for (UpdateUnitProvider p : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(false)) {
                if (!Installer.CODE_NAME.contains(p.getName())) continue;
                clusterUpdateProvider = p;
            }
            assert (clusterUpdateProvider != null) : "clusterUpdateProvider must found";
            if (clusterUpdateProvider != null) {
                block18: {
                    try {
                        assert (importFrom != null && importFrom.exists()) : importFrom + " exists.";
                        ClusterUpdateProvider.attachCluster(importFrom);
                        List units = clusterUpdateProvider.getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
                        UpdateUnitProviderFactory.getDefault().remove(clusterUpdateProvider);
                        PluginImporter importer = new PluginImporter(units);
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Already installed plugins: " + importer.getInstalledPlugins());
                            LOG.fine("Plugins available on UC: " + importer.getPluginsAvailableToInstall());
                            LOG.fine("Plugins available for import: " + importer.getPluginsToImport());
                        }
                        if (!importer.getBrokenPlugins().isEmpty()) {
                            LOG.info("Plugins for import with broken dependencies: " + importer.getBrokenPlugins());
                        }
                        if (!importer.getPluginsToImport().isEmpty() || !importer.getPluginsAvailableToInstall().isEmpty()) {
                            LOG.info(importer.getPluginsToImport().size() + importer.getPluginsAvailableToInstall().size() + " available plugins for import in " + importFrom);
                            ImportManager notifier = new ImportManager(importFrom, Installer.getUserDir(), importer);
                            notifier.notifyAvailable();
                            break block18;
                        }
                        LOG.fine(importer.getPluginsToImport().size() + importer.getPluginsAvailableToInstall().size() + " available plugins for import in " + importFrom);
                    }
                    catch (Exception x) {
                        try {
                            LOG.log(Level.INFO, x.getLocalizedMessage() + " while importing plugins from " + importFrom, x);
                        }
                        catch (Throwable throwable) {
                            UpdateUnitProviderFactory.getDefault().remove(clusterUpdateProvider);
                            throw throwable;
                        }
                        UpdateUnitProviderFactory.getDefault().remove(clusterUpdateProvider);
                    }
                }
                UpdateUnitProviderFactory.getDefault().remove(clusterUpdateProvider);
            }
        }
    };

    @Override
    public void run() {
        Preferences au_pref = NbPreferences.root().node(AUTOUPDATE_PREF);
        au_pref.node("ClusterUpdateProvider_removed").putBoolean(REMOVED, true);
        WindowManager.getDefault().invokeWhenUIReady(() -> RequestProcessor.getDefault().post(this.doCheck, this.getImportDelay()));
    }

    private static File getUserDir() {
        String user = System.getProperty("netbeans.user");
        File userDir = null;
        if (user != null) {
            userDir = FileUtil.normalizeFile((File)new File(user));
        }
        return userDir;
    }

    private int getImportDelay() {
        int delay = 30000;
        String delay_prop = System.getProperty("plugin.manager.import.delay");
        try {
            delay = Integer.parseInt(delay_prop);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return delay;
    }
}

