/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Matrix;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.BoxInfo;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class SymmetryOperation
extends M4 {
    String xyzOriginal;
    String xyzCanonical;
    String xyz;
    private boolean doNormalize = true;
    boolean isFinalized;
    private int opId;
    private V3 centering;
    private Hashtable<String, Object> info;
    static P3 atomTest;
    static final int TYPE_UNKNOWN = -1;
    static final int TYPE_IDENTITY = 0;
    static final int TYPE_TRANSLATION = 1;
    static final int TYPE_ROTATION = 2;
    static final int TYPE_INVERSION = 4;
    static final int TYPE_REFLECTION = 8;
    static final int TYPE_SCREW_ROTATION = 3;
    static final int TYPE_ROTOINVERSION = 6;
    static final int TYPE_GLIDE_REFLECTION = 9;
    private int opType = -1;
    private int opOrder;
    private V3 opTrans;
    private P3 opPoint;
    private P3 opPoint2;
    private V3 opAxis;
    P4 opPlane;
    private Boolean opIsCCW;
    boolean isIrrelevant;
    boolean isCoincident;
    static final int PLANE_MODE_POSITION_ONLY = 0;
    static final int PLANE_MODE_NOTRANS = 1;
    static final int PLANE_MODE_FULL = 2;
    private String[] myLabels;
    int modDim;
    float[] linearRotTrans;
    Matrix rsvs;
    boolean isBio;
    Matrix sigma;
    int number;
    public String subsystemCode;
    int timeReversal;
    private boolean unCentered;
    boolean isCenteringOp;
    private int magOp = Integer.MAX_VALUE;
    int divisor = 12;
    private T3 opX;
    private String opAxisCode;
    public boolean opIsLong;
    private static final int DIVISOR_MASK = 255;
    private static final int DIVISOR_OFFSET = 8;
    private static final String[] twelfths;
    static final String[] labelsXYZ;
    static final String[] labelsXn;
    static final String[] labelsXnSub;
    private static final P3 x;
    private static final int[] C3codes;
    private static V3 xneg;
    private static P4[] opPlanes;

    private String getOpName(int planeMode) {
        if (this.opType == -1) {
            this.setOpTypeAndOrder();
        }
        switch (this.opType) {
            case 0: {
                return "I";
            }
            case 1: {
                return "Trans" + SymmetryOperation.op48(this.opTrans);
            }
            case 2: {
                return "Rot" + this.opOrder + SymmetryOperation.op48(this.opPoint) + SymmetryOperation.op48(this.opAxis) + this.opIsCCW;
            }
            case 4: {
                return "Inv" + SymmetryOperation.op48(this.opPoint);
            }
            case 8: {
                return (planeMode == 0 ? "" : "Plane") + this.opPlane;
            }
            case 3: {
                return "Screw" + this.opOrder + SymmetryOperation.op48(this.opPoint) + SymmetryOperation.op48(this.opAxis) + SymmetryOperation.op48(this.opTrans) + this.opIsCCW;
            }
            case 6: {
                return "Nbar" + this.opOrder + SymmetryOperation.op48(this.opPoint) + SymmetryOperation.op48(this.opAxis) + this.opIsCCW;
            }
            case 9: {
                return (planeMode == 0 ? "" : "Glide") + this.opPlane + (planeMode == 2 ? SymmetryOperation.op48(this.opTrans) : "");
            }
        }
        System.out.println("SymmetryOperation REJECTED TYPE FOR " + this);
        return "";
    }

    String getOpTitle() {
        if (this.opType == -1) {
            this.setOpTypeAndOrder();
        }
        switch (this.opType) {
            case 0: {
                return "identity ";
            }
            case 1: {
                return "translation " + SymmetryOperation.opFrac(this.opTrans);
            }
            case 2: {
                return "rotation " + this.opOrder;
            }
            case 4: {
                return "inversion center " + SymmetryOperation.opFrac(this.opPoint);
            }
            case 8: {
                return "reflection ";
            }
            case 3: {
                return "screw rotation " + this.opOrder + (this.opIsCCW == null ? "" : (this.opIsCCW == Boolean.TRUE ? "(+) " : "(-) ")) + SymmetryOperation.opFrac(this.opTrans);
            }
            case 6: {
                return this.opOrder + "-bar " + (this.opIsCCW == null ? "" : (this.opIsCCW == Boolean.TRUE ? "(+) " : "(-) ")) + SymmetryOperation.opFrac(this.opPoint);
            }
            case 9: {
                return "glide reflection " + SymmetryOperation.opFrac(this.opTrans);
            }
        }
        return "";
    }

    private static String opFrac(T3 p) {
        return "{" + SymmetryOperation.opF(p.x) + " " + SymmetryOperation.opF(p.y) + " " + SymmetryOperation.opF(p.z) + "}";
    }

    private static String opF(float x) {
        int n48;
        boolean neg;
        boolean bl = neg = x < 0.0f;
        if (neg) {
            x = -x;
        }
        int n = 0;
        if (x >= 1.0f) {
            n = (int)x;
            x -= (float)n;
        }
        int div = (n48 = Math.round(x * 48.0f)) % 48 == 0 ? 1 : (n48 % 24 == 0 ? 2 : (n48 % 16 == 0 ? 3 : (n48 % 12 == 0 ? 4 : (n48 % 8 == 0 ? 6 : (n48 % 6 == 0 ? 8 : (n48 % 4 == 0 ? 12 : (n48 % 3 == 0 ? 16 : (n48 % 2 == 0 ? 24 : 48))))))));
        return (neg ? "-" : "") + (n * div + n48 * div / 48) + (div == 1 ? "" : "/" + div);
    }

    private static String op48(T3 p) {
        if (p == null) {
            System.err.println("SymmetryOperation.op48 null");
            return "(null)";
        }
        return "{" + Math.round(p.x * 48.0f) + " " + Math.round(p.y * 48.0f) + " " + Math.round(p.z * 48.0f) + "}";
    }

    public void setSigma(String subsystemCode, Matrix sigma) {
        this.subsystemCode = subsystemCode;
        this.sigma = sigma;
    }

    SymmetryOperation(SymmetryOperation op, int id, boolean doNormalize) {
        this.doNormalize = doNormalize;
        if (op == null) {
            this.opId = id;
            return;
        }
        this.xyzOriginal = op.xyzOriginal;
        this.xyz = op.xyz;
        this.divisor = op.divisor;
        this.opId = op.opId;
        this.modDim = op.modDim;
        this.myLabels = op.myLabels;
        this.number = op.number;
        this.linearRotTrans = op.linearRotTrans;
        this.sigma = op.sigma;
        this.subsystemCode = op.subsystemCode;
        this.timeReversal = op.timeReversal;
        this.setMatrix(false);
        if (!op.isFinalized) {
            this.doFinalize();
        }
    }

    private void setGamma(boolean isReverse) {
        int j;
        int i;
        int n = 3 + this.modDim;
        this.rsvs = new Matrix(null, n + 1, n + 1);
        double[][] a = this.rsvs.getArray();
        double[] t = new double[n];
        int pt = 0;
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                a[i][j] = this.linearRotTrans[pt++];
            }
            t[i] = (float)(isReverse ? -1 : 1) * this.linearRotTrans[pt++];
        }
        a[n][n] = 1.0;
        if (isReverse) {
            this.rsvs = this.rsvs.inverse();
        }
        for (i = 0; i < n; ++i) {
            a[i][n] = t[i];
        }
        a = this.rsvs.getSubmatrix(0, 0, 3, 3).getArray();
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                this.setElement(i, j, (float)(j < 3 ? a[i][j] : t[i]));
            }
        }
        this.setElement(3, 3, 1.0f);
    }

    void doFinalize() {
        SymmetryOperation.div12(this, this.divisor);
        if (this.modDim > 0) {
            double[][] a = this.rsvs.getArray();
            int i = a.length - 1;
            while (--i >= 0) {
                a[i][3 + this.modDim] = SymmetryOperation.finalizeD(a[i][3 + this.modDim], this.divisor);
            }
        }
        this.isFinalized = true;
    }

    private static M4 div12(M4 op, int divisor) {
        op.m03 = SymmetryOperation.finalizeF(op.m03, divisor);
        op.m13 = SymmetryOperation.finalizeF(op.m13, divisor);
        op.m23 = SymmetryOperation.finalizeF(op.m23, divisor);
        return op;
    }

    private static float finalizeF(float m, int divisor) {
        if (divisor == 0) {
            if (m == 0.0f) {
                return 0.0f;
            }
            int n = (int)m;
            return (float)(n >> 8) * 1.0f / (float)(n & 0xFF);
        }
        return m / (float)divisor;
    }

    private static double finalizeD(double m, int divisor) {
        if (divisor == 0) {
            if (m == 0.0) {
                return 0.0;
            }
            int n = (int)m;
            return (float)(n >> 8) * 1.0f / (float)(n & 0xFF);
        }
        return m / (double)divisor;
    }

    String getXyz(boolean normalized) {
        return normalized && this.modDim == 0 || this.xyzOriginal == null ? this.xyz : this.xyzOriginal;
    }

    public String getxyzTrans(T3 t) {
        M4 m = SymmetryOperation.newM4(this);
        m.add(t);
        return SymmetryOperation.getXYZFromMatrix(m, false, false, false);
    }

    String dumpInfo() {
        return "\n" + this.xyz + "\ninternal matrix representation:\n" + this.toString();
    }

    static final String dumpSeitz(M4 s, boolean isCanonical) {
        SB sb = new SB();
        float[] r = new float[4];
        for (int i = 0; i < 3; ++i) {
            s.getRow(i, r);
            sb.append("[\t");
            for (int j = 0; j < 3; ++j) {
                sb.appendI((int)r[j]).append("\t");
            }
            float trans = r[3];
            if (trans != (float)((int)trans)) {
                trans = 12.0f * trans;
            }
            sb.append(SymmetryOperation.twelfthsOf(isCanonical ? SymmetryOperation.normalizeTwelfths(trans / 12.0f, 12, true) : (float)((int)trans))).append("\t]\n");
        }
        return sb.toString();
    }

    boolean setMatrixFromXYZ(String xyz, int modDim, boolean allowScaling) {
        if (xyz == null) {
            return false;
        }
        this.xyzOriginal = xyz;
        this.divisor = SymmetryOperation.setDivisor(xyz);
        xyz = xyz.toLowerCase();
        this.setModDim(modDim);
        boolean isReverse = false;
        boolean halfOrLess = true;
        if (xyz.startsWith("!")) {
            if (xyz.startsWith("!nohalf!")) {
                halfOrLess = false;
                this.xyzOriginal = xyz = xyz.substring(8);
            } else {
                isReverse = false;
                xyz = xyz.substring(1);
            }
        }
        if (xyz.indexOf("xyz matrix:") == 0) {
            this.xyz = xyz;
            Parser.parseStringInfestedFloatArray(xyz, null, this.linearRotTrans);
            return this.setFromMatrix(null, isReverse);
        }
        if (xyz.indexOf("[[") == 0) {
            xyz = xyz.replace('[', ' ').replace(']', ' ').replace(',', ' ');
            Parser.parseStringInfestedFloatArray(xyz, null, this.linearRotTrans);
            int i = this.linearRotTrans.length;
            while (--i >= 0) {
                if (!Float.isNaN(this.linearRotTrans[i])) continue;
                return false;
            }
            this.setMatrix(isReverse);
            this.isFinalized = true;
            this.isBio = xyz.indexOf("bio") >= 0;
            this.xyz = this.isBio ? (this.xyzOriginal = super.toString()) : SymmetryOperation.getXYZFromMatrix(this, false, false, false);
            return true;
        }
        if (modDim == 0 && xyz.indexOf("x4") >= 0) {
            int i = 14;
            while (--i >= 4) {
                if (xyz.indexOf("x" + i) < 0) continue;
                this.setModDim(i - 3);
                break;
            }
        }
        String mxyz = null;
        if (xyz.endsWith("m")) {
            this.timeReversal = xyz.indexOf("-m") >= 0 ? -1 : 1;
            allowScaling = true;
        } else if (xyz.indexOf("mz)") >= 0) {
            int pt = xyz.indexOf("(");
            mxyz = xyz.substring(pt + 1, xyz.length() - 1);
            xyz = xyz.substring(0, pt);
            allowScaling = false;
        }
        String strOut = SymmetryOperation.getMatrixFromString(this, xyz, this.linearRotTrans, allowScaling, halfOrLess, true);
        if (strOut == null) {
            return false;
        }
        this.xyzCanonical = strOut;
        if (mxyz != null) {
            boolean isProper = M4.newA16(this.linearRotTrans).determinant3() == 1.0f;
            this.timeReversal = xyz.indexOf("-x") < 0 == mxyz.indexOf("-mx") < 0 == isProper ? 1 : -1;
        }
        this.setMatrix(isReverse);
        String string = isReverse ? SymmetryOperation.getXYZFromMatrix(this, true, false, false) : (this.xyz = this.doNormalize ? strOut : xyz);
        if (this.timeReversal != 0) {
            this.xyz = this.xyz + (this.timeReversal == 1 ? ",m" : ",-m");
        }
        if (Logger.debugging) {
            Logger.debug("" + this);
        }
        return true;
    }

    private static int setDivisor(String xyz) {
        int pt = xyz.indexOf(47);
        int len = xyz.length();
        while (pt > 0 && pt < len - 1) {
            char c = xyz.charAt(pt + 1);
            if ("2346".indexOf(c) < 0 || pt < len - 2 && Character.isDigit(xyz.charAt(pt + 2))) {
                return 0;
            }
            pt = xyz.indexOf(47, pt + 1);
        }
        return 12;
    }

    private void setModDim(int dim) {
        int n = (dim + 4) * (dim + 4);
        this.modDim = dim;
        if (dim > 0) {
            this.myLabels = labelsXn;
        }
        this.linearRotTrans = new float[n];
    }

    private void setMatrix(boolean isReverse) {
        if (this.linearRotTrans.length > 16) {
            this.setGamma(isReverse);
        } else {
            this.setA(this.linearRotTrans);
            if (isReverse) {
                P3 p3 = P3.new3(this.m03, this.m13, this.m23);
                this.invert();
                this.rotate(p3);
                p3.scale(-1.0f);
                this.setTranslation(p3);
            }
        }
    }

    boolean setFromMatrix(float[] offset, boolean isReverse) {
        float v = 0.0f;
        int pt = 0;
        this.myLabels = this.modDim == 0 ? labelsXYZ : labelsXn;
        int rowPt = 0;
        int n = 3 + this.modDim;
        int i = 0;
        while (rowPt < n) {
            boolean isTrans;
            if (Float.isNaN(this.linearRotTrans[i])) {
                return false;
            }
            v = this.linearRotTrans[i];
            if (Math.abs(v) < 1.0E-5f) {
                v = 0.0f;
            }
            boolean bl = isTrans = (i + 1) % (n + 1) == 0;
            if (isTrans) {
                int denom;
                int n2 = denom = this.divisor == 0 ? (int)v & 0xFF : this.divisor;
                if (denom == 0) {
                    denom = 12;
                }
                v = SymmetryOperation.finalizeF(v, this.divisor);
                if (offset != null && pt < offset.length) {
                    v += offset[pt++];
                }
                v = SymmetryOperation.normalizeTwelfths((float)(v < 0.0f ? -1 : 1) * Math.abs(v * (float)denom) / (float)denom, denom, this.doNormalize);
                if (this.divisor == 0) {
                    v = SymmetryOperation.toDivisor(v, denom);
                }
                ++rowPt;
            }
            this.linearRotTrans[i] = v;
            ++i;
        }
        this.linearRotTrans[this.linearRotTrans.length - 1] = this.divisor;
        this.setMatrix(isReverse);
        this.isFinalized = offset == null;
        this.xyz = SymmetryOperation.getXYZFromMatrix(this, true, false, false);
        return true;
    }

    public static M4 getMatrixFromXYZ(String xyz, float[] v, boolean halfOrLess) {
        if (v == null) {
            v = new float[16];
        }
        if ((xyz = SymmetryOperation.getMatrixFromString(null, xyz, v, false, halfOrLess, true)) == null) {
            return null;
        }
        M4 m = new M4();
        m.setA(v);
        return SymmetryOperation.div12(m, SymmetryOperation.setDivisor(xyz));
    }

    static String getJmolCanonicalXYZ(String xyz) {
        try {
            return SymmetryOperation.getMatrixFromString(null, xyz, null, false, true, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMatrixFromString(SymmetryOperation op, String xyz, float[] linearRotTrans, boolean allowScaling, boolean halfOrLess, boolean retString) {
        String[] myLabels;
        int transPt;
        int dimOffset;
        int divisor;
        boolean isDenominator = false;
        boolean isDecimal = false;
        boolean isNegative = false;
        xyz = PT.rep(xyz, "[bio[", "");
        int modDim = op == null ? 0 : op.modDim;
        int nRows = 4 + modDim;
        int n = divisor = op == null ? SymmetryOperation.setDivisor(xyz) : op.divisor;
        boolean doNormalize = halfOrLess && (op == null ? !xyz.startsWith("!") : op.doNormalize);
        int n2 = dimOffset = modDim > 0 ? 3 : 0;
        if (linearRotTrans != null) {
            int n3;
            int i = n3 = linearRotTrans.length - 1;
            while (--i >= 0) {
                linearRotTrans[i] = 0.0f;
            }
            linearRotTrans[n3] = 1.0f;
        }
        if ((transPt = xyz.indexOf(59) + 1) != 0) {
            allowScaling = true;
            if (transPt == xyz.length()) {
                xyz = xyz + "0,0,0";
            }
        }
        int rotPt = -1;
        String[] stringArray = myLabels = op == null || modDim == 0 ? null : op.myLabels;
        if (myLabels == null) {
            myLabels = labelsXYZ;
        }
        xyz = xyz.toLowerCase() + ",";
        xyz = xyz.replace('(', ',');
        if (modDim > 0) {
            xyz = SymmetryOperation.replaceXn(xyz, modDim + 3);
        }
        int xpt = 0;
        int tpt0 = 0;
        int rowPt = 0;
        float iValue = 0.0f;
        int denom = 0;
        int numer = 0;
        float decimalMultiplier = 1.0f;
        String strT = "";
        String strOut = retString ? "" : null;
        int[] ret = new int[1];
        int len = xyz.length();
        block12: for (int i = 0; i < len; ++i) {
            char ch = xyz.charAt(i);
            switch (ch) {
                case ';': {
                    break;
                }
                case ' ': 
                case '!': 
                case '\'': 
                case '{': 
                case '}': {
                    continue block12;
                }
                case '-': {
                    isNegative = true;
                    continue block12;
                }
                case '+': {
                    isNegative = false;
                    continue block12;
                }
                case '/': {
                    denom = 0;
                    isDenominator = true;
                    continue block12;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'x': 
                case 'y': 
                case 'z': {
                    int val;
                    tpt0 = rowPt * nRows;
                    int ipt = ch >= 'x' ? ch - 120 : ch - 97 + dimOffset;
                    xpt = tpt0 + ipt;
                    int n4 = val = isNegative ? -1 : 1;
                    if (allowScaling && iValue != 0.0f) {
                        if (linearRotTrans != null) {
                            linearRotTrans[xpt] = iValue;
                        }
                        val = (int)iValue;
                        iValue = 0.0f;
                    } else if (linearRotTrans != null) {
                        linearRotTrans[xpt] = val;
                    }
                    if (strOut == null) break;
                    strT = strT + SymmetryOperation.plusMinus(strT, val, myLabels[ipt], false);
                    break;
                }
                case ',': {
                    if (transPt != 0) {
                        if (transPt > 0) {
                            rotPt = i;
                            i = transPt - 1;
                            transPt = -i;
                            iValue = 0.0f;
                            denom = 0;
                            continue block12;
                        }
                        transPt = i + 1;
                        i = rotPt;
                    }
                    iValue = SymmetryOperation.normalizeTwelfths(iValue, denom == 0 ? 12 : (divisor == 0 ? denom : divisor), doNormalize);
                    if (linearRotTrans != null) {
                        float f = linearRotTrans[tpt0 + nRows - 1] = divisor == 0 && denom > 0 ? (iValue = (float)SymmetryOperation.toDivisor(numer, denom)) : iValue;
                    }
                    if (strOut != null) {
                        strT = strT + SymmetryOperation.xyzFraction12(iValue, divisor == 0 ? denom : divisor, false, halfOrLess);
                        strOut = strOut + (strOut == "" ? "" : ",") + strT;
                    }
                    if (rowPt == nRows - 2) {
                        return retString ? strOut : "ok";
                    }
                    iValue = 0.0f;
                    numer = 0;
                    denom = 0;
                    strT = "";
                    tpt0 += 4;
                    if (rowPt++ <= 2 || modDim != 0) break;
                    Logger.warn("Symmetry Operation? " + xyz);
                    return null;
                }
                case '.': {
                    isDecimal = true;
                    decimalMultiplier = 1.0f;
                    continue block12;
                }
                case '0': {
                    if (!isDecimal && divisor == 12 && (isDenominator || !allowScaling)) continue block12;
                }
                default: {
                    int ich = ch - 48;
                    if (ich >= 0 && ich <= 9) {
                        if (isDecimal) {
                            decimalMultiplier /= 10.0f;
                            if (iValue < 0.0f) {
                                isNegative = true;
                            }
                            iValue += decimalMultiplier * (float)ich * (float)(isNegative ? -1 : 1);
                            continue block12;
                        }
                        if (isDenominator) {
                            ret[0] = i;
                            denom = PT.parseIntNext(xyz, ret);
                            if (denom < 0) {
                                return null;
                            }
                            i = ret[0] - 1;
                            if (iValue == 0.0f) {
                                if (linearRotTrans == null) break;
                                int n5 = xpt;
                                linearRotTrans[n5] = linearRotTrans[n5] / (float)denom;
                                break;
                            }
                            numer = (int)iValue;
                            iValue /= (float)denom;
                            break;
                        }
                        iValue = iValue * 10.0f + (float)((isNegative ? -1 : 1) * ich);
                        isNegative = false;
                        break;
                    }
                    Logger.warn("symmetry character?" + ch);
                }
            }
            isNegative = false;
            isDenominator = false;
            isDecimal = false;
        }
        return null;
    }

    static String replaceXn(String xyz, int n) {
        int i = n;
        while (--i >= 0) {
            xyz = PT.rep(xyz, labelsXn[i], labelsXnSub[i]);
        }
        return xyz;
    }

    private static final int toDivisor(float numer, int denom) {
        int n = (int)numer;
        if ((float)n != numer) {
            float f = numer - (float)n;
            denom = (int)Math.abs((float)denom / f);
            n = (int)(Math.abs(numer) / f);
        }
        return (n << 8) + denom;
    }

    private static final String xyzFraction12(float n12ths, int denom, boolean allPositive, boolean halfOrLess) {
        String s;
        if (n12ths == 0.0f) {
            return "";
        }
        float n = n12ths;
        if (denom != 12) {
            int in = (int)n;
            denom = in & 0xFF;
            n = in >> 8;
        }
        int half = denom / 2;
        if (allPositive) {
            while (n < 0.0f) {
                n += (float)denom;
            }
        } else if (halfOrLess) {
            while (n > (float)half) {
                n -= (float)denom;
            }
            while (n < (float)(-half)) {
                n += (float)denom;
            }
        }
        String string = denom == 12 ? SymmetryOperation.twelfthsOf(n) : (s = n == 0.0f ? "0" : n + "/" + denom);
        return s.charAt(0) == '0' ? "" : (n > 0.0f ? "+" + s : s);
    }

    static final String twelfthsOf(float n12ths) {
        String str = "";
        if (n12ths < 0.0f) {
            n12ths = -n12ths;
            str = "-";
        }
        int m = 12;
        int n = Math.round(n12ths);
        if (Math.abs((float)n - n12ths) > 0.01f) {
            float fm;
            float f = n12ths / 12.0f;
            int max = 20;
            for (m = 3; m < max && !(Math.abs((float)(n = Math.round(fm = f * (float)m)) - fm) < 0.01f); ++m) {
            }
            if (m == max) {
                return str + f;
            }
        } else {
            if (n == 12) {
                return str + "1";
            }
            if (n < 12) {
                return str + twelfths[n % 12];
            }
            switch (n % 12) {
                case 0: {
                    return str + n / 12;
                }
                case 2: 
                case 10: {
                    m = 6;
                    break;
                }
                case 3: 
                case 9: {
                    m = 4;
                    break;
                }
                case 4: 
                case 8: {
                    m = 3;
                    break;
                }
                case 6: {
                    m = 2;
                    break;
                }
            }
            n = n * m / 12;
        }
        return str + n + "/" + m;
    }

    private static String plusMinus(String strT, float x, String sx, boolean allowFractions) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        if (x == 0.0f) {
            string = "";
        } else {
            String string2;
            StringBuilder stringBuilder2 = new StringBuilder().append(x < 0.0f ? "-" : (strT.length() == 0 ? "" : "+"));
            if (x == 1.0f || x == -1.0f) {
                string2 = "";
            } else {
                float f;
                float a = Math.abs(x);
                string2 = f < 1.0f && allowFractions ? SymmetryOperation.twelfthsOf(a * 12.0f) : "" + (int)a;
            }
            string = stringBuilder2.append(string2).toString();
        }
        return stringBuilder.append(string).append(sx).toString();
    }

    private static float normalizeTwelfths(float iValue, int divisor, boolean doNormalize) {
        iValue *= (float)divisor;
        int half = divisor / 2;
        if (doNormalize) {
            while (iValue > (float)half) {
                iValue -= (float)divisor;
            }
            while (iValue <= (float)(-half)) {
                iValue += (float)divisor;
            }
        }
        return iValue;
    }

    public static final String getXYZFromMatrix(M4 mat, boolean is12ths, boolean allPositive, boolean halfOrLess) {
        return SymmetryOperation.getXYZFromMatrixFrac(mat, is12ths, allPositive, halfOrLess, false);
    }

    public static final String getXYZFromMatrixFrac(M4 mat, boolean is12ths, boolean allPositive, boolean halfOrLess, boolean allowFractions) {
        SymmetryOperation op;
        String str = "";
        SymmetryOperation symmetryOperation = op = mat instanceof SymmetryOperation ? (SymmetryOperation)mat : null;
        if (op != null && op.modDim > 0) {
            return SymmetryOperation.getXYZFromRsVs(op.rsvs.getRotation(), op.rsvs.getTranslation(), is12ths);
        }
        float[] row = new float[4];
        int denom = (int)mat.getElement(3, 3);
        if (denom == 1) {
            denom = 12;
        } else {
            mat.setElement(3, 3, 1.0f);
        }
        for (int i = 0; i < 3; ++i) {
            int lpt = i < 3 ? 0 : 3;
            mat.getRow(i, row);
            String term = "";
            for (int j = 0; j < 3; ++j) {
                float x = row[j];
                if (SymmetryOperation.approx(x) == 0.0f) continue;
                term = term + SymmetryOperation.plusMinus(term, x, labelsXYZ[j + lpt], allowFractions);
            }
            if ((is12ths ? row[3] : SymmetryOperation.approx(row[3])) != 0.0f) {
                term = term + SymmetryOperation.xyzFraction12(is12ths ? row[3] : row[3] * (float)denom, denom, allPositive, halfOrLess);
            }
            str = str + "," + term;
        }
        return str.substring(1);
    }

    V3[] rotateAxes(V3[] vectors, UnitCell unitcell, P3 ptTemp, M3 mTemp) {
        V3[] vRot = new V3[3];
        this.getRotationScale(mTemp);
        int i = vectors.length;
        while (--i >= 0) {
            ptTemp.setT(vectors[i]);
            unitcell.toFractional(ptTemp, true);
            mTemp.rotate(ptTemp);
            unitcell.toCartesian(ptTemp, true);
            vRot[i] = V3.newV(ptTemp);
        }
        return vRot;
    }

    public String fcoord2(T3 p) {
        if (this.divisor == 12) {
            return SymmetryOperation.fcoord(p);
        }
        return this.fc2((int)this.linearRotTrans[3]) + " " + this.fc2((int)this.linearRotTrans[7]) + " " + this.fc2((int)this.linearRotTrans[11]);
    }

    private String fc2(int num) {
        int denom = num & 0xFF;
        return (num >>= 8) == 0 ? "0" : num + "/" + denom;
    }

    public static String fcoord(T3 p) {
        return SymmetryOperation.fc(p.x) + " " + SymmetryOperation.fc(p.y) + " " + SymmetryOperation.fc(p.z);
    }

    private static String fc(float x) {
        float xabs = Math.abs(x);
        String m = x < 0.0f ? "-" : "";
        int x24 = (int)SymmetryOperation.approx(xabs * 24.0f);
        if ((float)x24 / 24.0f == (float)((int)((float)x24 / 24.0f))) {
            return m + x24 / 24;
        }
        if (x24 % 8 != 0) {
            return m + SymmetryOperation.twelfthsOf(x24 >> 1);
        }
        return x24 == 0 ? "0" : (x24 == 24 ? m + "1" : m + x24 / 8 + "/3");
    }

    static float approx(float f) {
        return PT.approx(f, 100.0f);
    }

    static float approx6(float f) {
        return PT.approx(f, 1000000.0f);
    }

    public static String getXYZFromRsVs(Matrix rs, Matrix vs, boolean is12ths) {
        double[][] ra = rs.getArray();
        double[][] va = vs.getArray();
        int d = ra.length;
        String s = "";
        for (int i = 0; i < d; ++i) {
            s = s + ",";
            for (int j = 0; j < d; ++j) {
                double r = ra[i][j];
                if (r == 0.0) continue;
                s = s + (r < 0.0 ? "-" : (s.endsWith(",") ? "" : "+")) + (Math.abs(r) == 1.0 ? "" : "" + (int)Math.abs(r)) + "x" + (j + 1);
            }
            s = s + SymmetryOperation.xyzFraction12((int)(va[i][0] * (double)(is12ths ? 1 : 12)), 12, false, true);
        }
        return PT.rep(s.substring(1), ",+", ",");
    }

    @Override
    public String toString() {
        return this.rsvs == null ? super.toString() : super.toString() + " " + this.rsvs.toString();
    }

    int getMagneticOp() {
        return this.magOp == Integer.MAX_VALUE ? (this.magOp = (int)(this.determinant3() * (float)this.timeReversal)) : this.magOp;
    }

    void setTimeReversal(int magRev) {
        this.timeReversal = magRev;
        if (this.xyz.indexOf("m") >= 0) {
            this.xyz = this.xyz.substring(0, this.xyz.indexOf("m"));
        }
        if (magRev != 0) {
            this.xyz = this.xyz + (magRev == 1 ? ",m" : ",-m");
        }
    }

    V3 getCentering() {
        if (!this.isFinalized) {
            this.doFinalize();
        }
        if (this.centering == null && !this.unCentered) {
            if (this.modDim == 0 && this.m00 == 1.0f && this.m11 == 1.0f && this.m22 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m10 == 0.0f && this.m12 == 0.0f && this.m20 == 0.0f && this.m21 == 0.0f && (this.m03 != 0.0f || this.m13 != 0.0f || this.m23 != 0.0f)) {
                this.isCenteringOp = true;
                this.centering = V3.new3(this.m03, this.m13, this.m23);
            } else {
                this.unCentered = true;
                this.centering = null;
            }
        }
        return this.centering;
    }

    String fixMagneticXYZ(M4 m, String xyz, boolean addMag) {
        if (this.timeReversal == 0) {
            return xyz;
        }
        int pt = xyz.indexOf("m");
        String string = xyz = (pt -= (3 - this.timeReversal) / 2) < 0 ? xyz : xyz.substring(0, pt);
        if (!addMag) {
            return xyz + (this.timeReversal > 0 ? " +1" : " -1");
        }
        M4 m2 = M4.newM4(m);
        m2.m23 = 0.0f;
        m2.m13 = 0.0f;
        m2.m03 = 0.0f;
        if (this.getMagneticOp() < 0) {
            m2.scale(-1.0f);
        }
        xyz = xyz + "(" + PT.rep(PT.rep(PT.rep(SymmetryOperation.getXYZFromMatrix(m2, false, false, false), "x", "mx"), "y", "my"), "z", "mz") + ")";
        return xyz;
    }

    public Map<String, Object> getInfo() {
        if (this.info == null) {
            this.info = new Hashtable();
            this.info.put("xyz", this.xyz);
            if (this.centering != null) {
                this.info.put("centering", this.centering);
            }
            this.info.put("index", this.number - 1);
            this.info.put("isCenteringOp", this.isCenteringOp);
            if (this.linearRotTrans != null) {
                this.info.put("linearRotTrans", this.linearRotTrans);
            }
            this.info.put("modulationDimension", this.modDim);
            this.info.put("matrix", M4.newM4(this));
            if ((float)this.magOp != Float.MAX_VALUE) {
                this.info.put("magOp", Float.valueOf(this.magOp));
            }
            this.info.put("id", this.opId);
            this.info.put("timeReversal", this.timeReversal);
            if (this.xyzOriginal != null) {
                this.info.put("xyzOriginal", this.xyzOriginal);
            }
        }
        return this.info;
    }

    public static void normalizeOperationToCentroid(int dim, M4 m, P3[] fracPts, int i0, int n) {
        int i;
        if (n <= 0) {
            return;
        }
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (atomTest == null) {
            atomTest = new P3();
        }
        int i2 = i + n;
        for (i = i0; i < i2; ++i) {
            m.rotTrans2(fracPts[i], atomTest);
            x += SymmetryOperation.atomTest.x;
            y += SymmetryOperation.atomTest.y;
            z += SymmetryOperation.atomTest.z;
        }
        x /= (float)n;
        y /= (float)n;
        z /= (float)n;
        while ((double)x < -0.001 || (double)x >= 1.001) {
            m.m03 = m.m03 + (float)(x < 0.0f ? 1 : -1);
            x += (float)(x < 0.0f ? 1 : -1);
        }
        if (dim > 1) {
            while ((double)y < -0.001 || (double)y >= 1.001) {
                m.m13 = m.m13 + (float)(y < 0.0f ? 1 : -1);
                y += (float)(y < 0.0f ? 1 : -1);
            }
        }
        if (dim > 2) {
            while ((double)z < -0.001 || (double)z >= 1.001) {
                m.m23 = m.m23 + (float)(z < 0.0f ? 1 : -1);
                z += (float)(z < 0.0f ? 1 : -1);
            }
        }
    }

    public static Lst<P3> getLatticeCentering(SymmetryOperation[] ops) {
        Lst<P3> list = new Lst<P3>();
        for (int i = 0; i < ops.length; ++i) {
            V3 c;
            V3 v3 = c = ops[i] == null ? null : ops[i].getCentering();
            if (c == null) continue;
            list.addLast(P3.newP(c));
        }
        return list;
    }

    public Boolean getOpIsCCW() {
        if (this.opType == -1) {
            this.setOpTypeAndOrder();
        }
        return this.opIsCCW;
    }

    public int getOpType() {
        if (this.opType == -1) {
            this.setOpTypeAndOrder();
        }
        return this.opType;
    }

    public int getOpOrder() {
        if (this.opType == -1) {
            this.setOpTypeAndOrder();
        }
        return this.opOrder;
    }

    public P3 getOpPoint() {
        if (this.opType == -1) {
            this.setOpTypeAndOrder();
        }
        return this.opPoint;
    }

    public V3 getOpAxis() {
        if (this.opType == -1) {
            this.setOpTypeAndOrder();
        }
        return this.opAxis;
    }

    public P3 getOpPoint2() {
        return this.opPoint2;
    }

    public V3 getOpTrans() {
        if (this.opType == -1) {
            this.setOpTypeAndOrder();
        }
        return this.opTrans == null ? (this.opTrans = new V3()) : this.opTrans;
    }

    private static int opGet3code(M4 m) {
        int c = 0;
        float[] row = new float[4];
        for (int r = 0; r < 3; ++r) {
            m.getRow(r, row);
            block5: for (int i = 0; i < 3; ++i) {
                switch ((int)row[i]) {
                    case 1: {
                        c |= i + 1 << (2 - r << 3);
                        continue block5;
                    }
                    case -1: {
                        c |= 16 + i + 1 << (2 - r << 3);
                    }
                }
            }
        }
        return c;
    }

    private static T3 opGet3x(M4 m) {
        if (m.m22 != 0.0f) {
            return x;
        }
        int c = SymmetryOperation.opGet3code(m);
        for (int i = 0; i < 8; ++i) {
            if (c != C3codes[i]) continue;
            if (xneg == null) {
                xneg = V3.newV(x);
                xneg.scale(-1.0f);
            }
            return xneg;
        }
        return x;
    }

    private void setOpTypeAndOrder() {
        this.clearOp();
        int det = Math.round(this.determinant3());
        int trace = Math.round(this.m00 + this.m11 + this.m22);
        int order = 0;
        int angle = 0;
        T3 px = x;
        switch (trace) {
            case 3: {
                if (SymmetryOperation.hasTrans(this)) {
                    this.opType = 1;
                    this.opTrans = new V3();
                    this.getTranslation(this.opTrans);
                    this.opOrder = 2;
                } else {
                    this.opType = 0;
                    this.opOrder = 1;
                }
                return;
            }
            case -3: {
                this.opType = 4;
                order = 2;
                break;
            }
            default: {
                order = trace * det + 3;
                if (order == 5) {
                    order = 6;
                }
                if (det > 0) {
                    this.opType = 2;
                    angle = (int)(Math.acos((float)(trace - 1) / 2.0f) * 180.0 / Math.PI);
                    if (angle != 120) break;
                    if (this.opX == null) {
                        this.opX = SymmetryOperation.opGet3x(this);
                    }
                    px = this.opX;
                    break;
                }
                if (order == 2) {
                    this.opType = 8;
                    break;
                }
                this.opType = 6;
                if (order == 3) {
                    order = 6;
                }
                if ((angle = (int)(Math.acos((float)(-trace - 1) / 2.0f) * 180.0 / Math.PI)) != 120) break;
                if (this.opX == null) {
                    this.opX = SymmetryOperation.opGet3x(this);
                }
                px = this.opX;
            }
        }
        this.opOrder = order;
        M4 m4 = new M4();
        P3 p1 = new P3();
        P3 p2 = P3.newP(px);
        m4.setM4(this);
        P3 p1sum = new P3();
        P3 p2sum = P3.newP(p2);
        P3 p2odd = new P3();
        P3 p2even = P3.newP(p2);
        P3 p21 = new P3();
        for (int i = 1; i < order; ++i) {
            m4.mul(this);
            this.rotTrans(p1);
            this.rotTrans(p2);
            if (i == 1) {
                p21.setT(p2);
            }
            p1sum.add(p1);
            p2sum.add(p2);
            if (this.opType != 6) continue;
            if (i % 2 == 0) {
                p2even.add(p2);
                continue;
            }
            p2odd.add(p2);
        }
        this.opTrans = new V3();
        m4.getTranslation(this.opTrans);
        this.opTrans.scale(1.0f / (float)order);
        float d = SymmetryOperation.approx6(this.opTrans.length());
        float dmax = 1.0f;
        this.opPoint = new P3();
        V3 v = null;
        boolean isOK = true;
        switch (this.opType) {
            case 4: {
                p2sum.add2(p2, px);
                p2sum.scale(0.5f);
                this.opPoint = P3.newP(SymmetryOperation.opClean6(p2sum));
                isOK = SymmetryOperation.checkOpPoint(this.opPoint);
                break;
            }
            case 6: {
                p2odd.scale(2.0f / (float)order);
                p2even.scale(2.0f / (float)order);
                v = V3.newVsub(p2odd, p2even);
                v.normalize();
                this.opAxis = (V3)SymmetryOperation.opClean6(v);
                p1sum.add2(p2odd, p2even);
                p2sum.scale(1.0f / (float)order);
                this.opPoint.setT(SymmetryOperation.opClean6(p2sum));
                isOK = SymmetryOperation.checkOpPoint(this.opPoint);
                if (angle == 180) break;
                p2.cross(px, p2);
                this.opIsCCW = p2.dot(v) < 0.0f;
                break;
            }
            case 2: {
                v = V3.newVsub(p2sum, p1sum);
                v.normalize();
                this.opAxis = (V3)SymmetryOperation.opClean6(v);
                p1sum.scale(1.0f / (float)order);
                p1.setT(p1sum);
                if (d > 0.0f) {
                    p1sum.sub(this.opTrans);
                }
                this.opPoint.setT(p1sum);
                SymmetryOperation.opClean6(this.opPoint);
                if (angle != 180) {
                    p2.cross(px, p2);
                    this.opIsCCW = p2.dot(v) < 0.0f;
                }
                if (isOK &= SymmetryOperation.checkOpAxis(p1, d == 0.0f ? this.opAxis : this.opTrans, p1sum, new V3(), new V3(), null)) {
                    this.opPoint.setT(p1sum);
                    if (SymmetryOperation.checkOpAxis(this.opPoint, this.opAxis, p2, new V3(), new V3(), this.opPoint)) {
                        this.opPoint2 = P3.newP(p2);
                    }
                    if (d > 0.0f) {
                        p1sum.scaleAdd2(0.5f, this.opTrans, this.opPoint);
                        isOK = SymmetryOperation.checkOpPoint(p1sum);
                        if (this.opPoint2 != null) {
                            p1sum.scaleAdd2(0.5f, this.opTrans, this.opPoint2);
                            if (!SymmetryOperation.checkOpPoint(p1sum)) {
                                this.opPoint2 = null;
                            }
                        }
                    }
                }
                if (v.dot(p1) < 0.0f) {
                    isOK = false;
                }
                if (d > 0.0f && this.opTrans.z == 0.0f && this.opTrans.lengthSquared() == 1.25f) {
                    dmax = 1.25f;
                    this.opIsLong = true;
                    break;
                }
                dmax = 1.0f;
                break;
            }
            case 8: {
                p1.sub(this.opTrans);
                p1.scale(0.5f);
                this.opPoint.setT(p1);
                p21.sub(this.opTrans);
                this.opAxis = V3.newVsub(p21, px);
                p2.scaleAdd2(0.5f, this.opAxis, px);
                this.opAxis.normalize();
                this.opPlane = new P4();
                p1.set(px.x + 1.1f, px.y + 1.7f, px.z + 2.1f);
                p1.scale(0.5f);
                this.rotTrans(p1);
                p1.sub(this.opTrans);
                p1.scaleAdd2(0.5f, px, p1);
                p1.scale(0.5f);
                v = new V3();
                isOK = SymmetryOperation.checkOpPlane(this.opPoint, p1, p2, this.opAxis, this.opPlane, v, new V3());
                SymmetryOperation.opClean6(this.opPlane);
                if (SymmetryOperation.approx6(this.opPlane.w) == 0.0f) {
                    this.opPlane.w = 0.0f;
                }
                SymmetryOperation.approx6Pt(this.opAxis);
                SymmetryOperation.normalizePlane(this.opPlane);
                if (d > 0.0f && (this.opTrans.z == 0.0f && this.opTrans.lengthSquared() == 1.25f || this.opTrans.z == 0.5f && this.opTrans.lengthSquared() == 1.5f)) {
                    dmax = 1.25f;
                    this.opIsLong = true;
                    break;
                }
                dmax = 0.78f;
            }
        }
        if (d > 0.0f) {
            SymmetryOperation.opClean6(this.opTrans);
            if (this.opType == 8 && (this.opTrans.x == 1.0f || this.opTrans.y == 1.0f || this.opTrans.z == 1.0f) && this.m22 == -1.0f) {
                isOK = false;
            }
            this.opType |= 1;
            if (Math.abs(SymmetryOperation.approx(this.opTrans.x)) >= dmax || Math.abs(SymmetryOperation.approx(this.opTrans.y)) >= dmax || Math.abs(SymmetryOperation.approx(this.opTrans.z)) >= dmax) {
                isOK = false;
            }
        } else {
            this.opTrans = null;
        }
        if (!isOK) {
            this.isIrrelevant = true;
        }
    }

    private static void normalizePlane(P4 plane) {
        SymmetryOperation.approx6Pt(plane);
        plane.w = SymmetryOperation.approx6(plane.w);
        if (plane.w > 0.0f || plane.w == 0.0f && (plane.x < 0.0f || plane.x == 0.0f && plane.y < 0.0f || plane.y == 0.0f && plane.z < 0.0f)) {
            plane.scale4(-1.0f);
        }
        SymmetryOperation.opClean6(plane);
        plane.w = SymmetryOperation.approx6(plane.w);
    }

    private static boolean isCoaxial(T3 v) {
        return Math.abs(SymmetryOperation.approx(v.x)) == 1.0f || Math.abs(SymmetryOperation.approx(v.y)) == 1.0f || Math.abs(SymmetryOperation.approx(v.z)) == 1.0f;
    }

    private void clearOp() {
        if (!this.isFinalized) {
            this.doFinalize();
        }
        this.isIrrelevant = false;
        this.opTrans = null;
        this.opPoint2 = null;
        this.opPoint = null;
        this.opPlane = null;
        this.opIsCCW = null;
        this.opIsLong = false;
    }

    private static boolean hasTrans(M4 m4) {
        return SymmetryOperation.approx6(m4.m03) != 0.0f || SymmetryOperation.approx6(m4.m13) != 0.0f || SymmetryOperation.approx6(m4.m23) != 0.0f;
    }

    private static boolean checkOpAxis(P3 pt, V3 axis, P3 ptRet, V3 t1, V3 t2, P3 ptNot) {
        if (opPlanes == null) {
            opPlanes = BoxInfo.getBoxFacesFromOABC(null);
        }
        int[] map = BoxInfo.faceOrder;
        float f = ptNot == null ? 1 : -1;
        for (int i = 0; i < 6; ++i) {
            P3 p = Measure.getIntersection(pt, axis, opPlanes[map[i]], ptRet, t1, t2);
            if (p == null || !SymmetryOperation.checkOpPoint(p) || !(axis.dot(t1) * f < 0.0f) || ptNot != null && !(SymmetryOperation.approx(ptNot.distance(p) - 0.5f) >= 0.0f)) continue;
            return true;
        }
        return false;
    }

    static T3 opClean6(T3 t) {
        if (SymmetryOperation.approx6(t.x) == 0.0f) {
            t.x = 0.0f;
        }
        if (SymmetryOperation.approx6(t.y) == 0.0f) {
            t.y = 0.0f;
        }
        if (SymmetryOperation.approx6(t.z) == 0.0f) {
            t.z = 0.0f;
        }
        return t;
    }

    static boolean checkOpPoint(T3 pt) {
        return SymmetryOperation.checkOK(pt.x, 0.0f) && SymmetryOperation.checkOK(pt.y, 0.0f) && SymmetryOperation.checkOK(pt.z, 0.0f);
    }

    private static boolean checkOK(float p, float a) {
        return a != 0.0f || SymmetryOperation.approx(p) >= 0.0f && SymmetryOperation.approx(p) <= 1.0f;
    }

    private static boolean checkOpPlane(P3 p1, P3 p2, P3 p3, V3 v, P4 plane, V3 vtemp1, V3 vtemp2) {
        Measure.getPlaneThroughPoints(p1, p2, p3, vtemp1, vtemp2, plane);
        P3[] pts = BoxInfo.unitCubePoints;
        int nPos = 0;
        int nNeg = 0;
        int i = 8;
        while (--i >= 0) {
            float d = Measure.getPlaneProjection(pts[i], plane, p1, vtemp1);
            switch ((int)Math.signum(SymmetryOperation.approx6(d))) {
                case 1: {
                    if (nNeg > 0) {
                        return true;
                    }
                    ++nPos;
                    break;
                }
                case 0: {
                    break;
                }
                case -1: {
                    if (nPos > 0) {
                        return true;
                    }
                    ++nNeg;
                }
            }
        }
        return nNeg != 8 && nPos != 8;
    }

    public static SymmetryOperation[] getAdditionalOperations(SymmetryOperation[] ops) {
        int i;
        int n = ops.length;
        Lst<SymmetryOperation> lst = new Lst<SymmetryOperation>();
        SB xyzLst = new SB();
        Hashtable<String, Lst<SymmetryOperation>> mapPlanes = new Hashtable<String, Lst<SymmetryOperation>>();
        for (i = 0; i < n; ++i) {
            SymmetryOperation op = ops[i];
            lst.addLast(op);
            String s = op.getOpName(1);
            xyzLst.append(s).appendC(';');
            if ((op.getOpType() & 8) == 0) continue;
            SymmetryOperation.addPlaneMap(mapPlanes, op);
        }
        for (i = 1; i < n; ++i) {
            ops[i].addOps(xyzLst, lst, mapPlanes, n, i);
        }
        return lst.toArray(new SymmetryOperation[lst.size()]);
    }

    void addOps(SB xyzList, Lst<SymmetryOperation> lst, Map<String, Lst<SymmetryOperation>> mapPlanes, int n0, int isym) {
        V3 t0 = new V3();
        this.getTranslation(t0);
        boolean isPlane = (this.getOpType() & 8) == 8;
        V3 t = new V3();
        SymmetryOperation opTemp = null;
        int i = 3;
        while (--i >= -3) {
            int j = 3;
            while (--j >= -3) {
                int k = 3;
                while (--k >= -3) {
                    if (opTemp == null) {
                        opTemp = new SymmetryOperation(null, 0, false);
                    }
                    t.set(i, j, k);
                    if (this.checkOpSimilar(t) || !opTemp.opCheckAdd(this, t0, n0, t, xyzList, lst, isym + 1)) continue;
                    if (isPlane) {
                        SymmetryOperation.addPlaneMap(mapPlanes, opTemp);
                    }
                    opTemp = null;
                }
            }
        }
    }

    private static void addPlaneMap(Map<String, Lst<SymmetryOperation>> mapPlanes, SymmetryOperation op) {
        boolean havePlane;
        String s = op.getOpName(0);
        Lst<SymmetryOperation> l = mapPlanes.get(s);
        op.isCoincident = false;
        boolean bl = havePlane = op.opType == 8;
        if (l == null) {
            l = new Lst();
            mapPlanes.put(s, l);
        } else {
            SymmetryOperation op0 = (SymmetryOperation)l.get(0);
            if (op0.isCoincident) {
                op.isCoincident = true;
            } else if (havePlane || op0.opType == 8) {
                op.isCoincident = true;
                int i = l.size();
                while (--i >= 0) {
                    ((SymmetryOperation)l.get((int)i)).isCoincident = true;
                }
            }
        }
        l.addLast(op);
    }

    private boolean checkOpSimilar(V3 t) {
        switch (this.getOpType() & 0xFFFFFFFE) {
            default: {
                return false;
            }
            case 0: {
                return true;
            }
            case 2: {
                return SymmetryOperation.approx6(t.dot(this.opAxis) - t.length()) == 0.0f;
            }
            case 8: 
        }
        return SymmetryOperation.approx6(t.dot(this.opAxis)) == 0.0f;
    }

    private boolean opCheckAdd(SymmetryOperation opThis, V3 t0, int n0, V3 t, SB xyzList, Lst<SymmetryOperation> lst, int itno) {
        String s;
        this.setM4(opThis);
        V3 t1 = V3.newV(t);
        t1.add(t0);
        this.setTranslation(t1);
        this.isFinalized = true;
        this.setOpTypeAndOrder();
        if (!this.isIrrelevant && this.opType != 0 && this.opType != 1 && xyzList.indexOf(s = this.getOpName(1) + ";") < 0) {
            xyzList.append(s);
            lst.addLast(this);
            this.isFinalized = true;
            this.xyz = SymmetryOperation.getXYZFromMatrix(this, false, false, false);
            return true;
        }
        return false;
    }

    static void approx6Pt(T3 pt) {
        if (pt != null) {
            pt.x = SymmetryOperation.approx6(pt.x);
            pt.y = SymmetryOperation.approx6(pt.y);
            pt.z = SymmetryOperation.approx6(pt.z);
        }
    }

    public static void normalize12ths(V3 vtrans) {
        vtrans.x = PT.approx(vtrans.x, 12.0f);
        vtrans.y = PT.approx(vtrans.y, 12.0f);
        vtrans.z = PT.approx(vtrans.z, 12.0f);
    }

    public String getCode() {
        String s;
        if (this.opAxisCode != null) {
            return this.opAxisCode;
        }
        int t = this.getOpName(2).charAt(0);
        int o = this.opOrder;
        int ccw = this.opIsCCW == null ? 0 : (this.opIsCCW == Boolean.TRUE ? 1 : 2);
        String g = "";
        String m = "";
        switch (t) {
            case 71: {
                t = SymmetryOperation.getGlideFromTrans(this.opTrans, this.opPlane);
            }
            case 80: {
                if (SymmetryOperation.isCoaxial(this.opAxis)) break;
                t = (char)(t == 80 ? 112 : (char)(t - 32));
                break;
            }
            case 83: {
                float d = this.opTrans.length();
                if (this.opIsCCW == null || d < (d > 1.0f ? 6.0f : 0.5f) != (this.opIsCCW == Boolean.TRUE)) break;
                t = 119;
                break;
            }
            case 82: {
                if (!SymmetryOperation.isCoaxial(this.opAxis)) {
                    t = 111;
                }
                if (this.opPoint.length() != 0.0f) break;
                t = t == 111 ? 113 : 81;
                break;
            }
        }
        this.opAxisCode = s = g + m + (char)t + "." + (char)(48 + o) + "." + ccw + ".";
        return this.opAxisCode;
    }

    public static char getGlideFromTrans(T3 ftrans, T3 ax1) {
        float fx = Math.abs(SymmetryOperation.approx(ftrans.x * 12.0f));
        float fy = Math.abs(SymmetryOperation.approx(ftrans.y * 12.0f));
        float fz = Math.abs(SymmetryOperation.approx(ftrans.z * 12.0f));
        if (fx == 9.0f) {
            fx = 3.0f;
        }
        if (fy == 9.0f) {
            fy = 3.0f;
        }
        if (fz == 9.0f) {
            fz = 3.0f;
        }
        if (fx != 0.0f && fy != 0.0f && fz != 0.0f) {
            return (char)(fx == 3.0f && fy == 3.0f && fz == 3.0f ? 100 : (fx == 6.0f && fy == 6.0f && fz == 6.0f ? 110 : 103));
        }
        if (fx != 0.0f && fy != 0.0f || fy != 0.0f && fz != 0.0f || fz != 0.0f && fx != 0.0f) {
            if (fx == 3.0f && fy == 3.0f || fx == 3.0f && fz == 3.0f || fy == 3.0f && fz == 3.0f) {
                return 'd';
            }
            if (fx == 6.0f && fy == 6.0f || fx == 6.0f && fz == 6.0f || fy == 6.0f && fz == 6.0f) {
                if (fx == 0.0f && ax1.x == 0.0f || fy == 0.0f && ax1.y == 0.0f || fz == 0.0f && ax1.z == 0.0f) {
                    return 'g';
                }
                return 'n';
            }
            return 'g';
        }
        return (char)(fx != 0.0f ? 97 : (fy != 0.0f ? 98 : 99));
    }

    static void rotateAndTranslatePoint(M4 m, P3 src, int ta, int tb, int tc, P3 dest) {
        m.rotTrans2(src, dest);
        dest.add3(ta, tb, tc);
    }

    static {
        twelfths = new String[]{"0", "1/12", "1/6", "1/4", "1/3", "5/12", "1/2", "7/12", "2/3", "3/4", "5/6", "11/12"};
        labelsXYZ = new String[]{"x", "y", "z"};
        labelsXn = new String[]{"x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13"};
        labelsXnSub = new String[]{"x", "y", "z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j"};
        x = P3.new3((float)Math.PI, (float)Math.E, 8.539734f);
        C3codes = new int[]{200978, 1184513, 1245458, 135953, 1245442, 131857, 200962, 1180417};
    }
}

