/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.DefNode;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.parser.StaticScope;

public class IterNode
extends Node
implements DefNode {
    private final Node varNode;
    private final Node bodyNode;
    private final StaticScope scope;
    private final int endLine;

    public IterNode(int line, Node args2, StaticScope scope, Node body, int endLine) {
        super(line, args2 != null && args2.containsVariableAssignment || body != null && body.containsVariableAssignment);
        this.varNode = args2;
        this.scope = scope;
        this.bodyNode = body;
        this.endLine = endLine;
    }

    public IterNode(int line, ArgsNode args2, Node body, StaticScope scope, int endLine) {
        super(line, args2 != null && args2.containsVariableAssignment || body != null && body.containsVariableAssignment);
        this.varNode = args2;
        this.bodyNode = body == null ? NilImplicitNode.NIL : body;
        this.scope = scope;
        this.endLine = endLine;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ITERNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitIterNode(this);
    }

    @Override
    public ArgsNode getArgsNode() {
        return (ArgsNode)this.varNode;
    }

    @Override
    public StaticScope getScope() {
        return this.scope;
    }

    @Override
    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getVarNode() {
        return this.varNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.varNode, this.bodyNode);
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }
}

