/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AddPermissionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String topicArn;
    private String label;
    private SdkInternalList<String> aWSAccountIds;
    private SdkInternalList<String> actionNames;

    public AddPermissionRequest() {
    }

    public AddPermissionRequest(String topicArn, String label, List<String> aWSAccountIds, List<String> actionNames) {
        this.setTopicArn(topicArn);
        this.setLabel(label);
        this.setAWSAccountIds(aWSAccountIds);
        this.setActionNames(actionNames);
    }

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public AddPermissionRequest withTopicArn(String topicArn) {
        this.setTopicArn(topicArn);
        return this;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public AddPermissionRequest withLabel(String label) {
        this.setLabel(label);
        return this;
    }

    public List<String> getAWSAccountIds() {
        if (this.aWSAccountIds == null) {
            this.aWSAccountIds = new SdkInternalList();
        }
        return this.aWSAccountIds;
    }

    public void setAWSAccountIds(Collection<String> aWSAccountIds) {
        if (aWSAccountIds == null) {
            this.aWSAccountIds = null;
            return;
        }
        this.aWSAccountIds = new SdkInternalList(aWSAccountIds);
    }

    public AddPermissionRequest withAWSAccountIds(String ... aWSAccountIds) {
        if (this.aWSAccountIds == null) {
            this.setAWSAccountIds((Collection<String>)new SdkInternalList(aWSAccountIds.length));
        }
        for (String ele : aWSAccountIds) {
            this.aWSAccountIds.add((Object)ele);
        }
        return this;
    }

    public AddPermissionRequest withAWSAccountIds(Collection<String> aWSAccountIds) {
        this.setAWSAccountIds(aWSAccountIds);
        return this;
    }

    public List<String> getActionNames() {
        if (this.actionNames == null) {
            this.actionNames = new SdkInternalList();
        }
        return this.actionNames;
    }

    public void setActionNames(Collection<String> actionNames) {
        if (actionNames == null) {
            this.actionNames = null;
            return;
        }
        this.actionNames = new SdkInternalList(actionNames);
    }

    public AddPermissionRequest withActionNames(String ... actionNames) {
        if (this.actionNames == null) {
            this.setActionNames((Collection<String>)new SdkInternalList(actionNames.length));
        }
        for (String ele : actionNames) {
            this.actionNames.add((Object)ele);
        }
        return this;
    }

    public AddPermissionRequest withActionNames(Collection<String> actionNames) {
        this.setActionNames(actionNames);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTopicArn() != null) {
            sb.append("TopicArn: ").append(this.getTopicArn()).append(",");
        }
        if (this.getLabel() != null) {
            sb.append("Label: ").append(this.getLabel()).append(",");
        }
        if (this.getAWSAccountIds() != null) {
            sb.append("AWSAccountIds: ").append(this.getAWSAccountIds()).append(",");
        }
        if (this.getActionNames() != null) {
            sb.append("ActionNames: ").append(this.getActionNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPermissionRequest)) {
            return false;
        }
        AddPermissionRequest other = (AddPermissionRequest)obj;
        if (other.getTopicArn() == null ^ this.getTopicArn() == null) {
            return false;
        }
        if (other.getTopicArn() != null && !other.getTopicArn().equals(this.getTopicArn())) {
            return false;
        }
        if (other.getLabel() == null ^ this.getLabel() == null) {
            return false;
        }
        if (other.getLabel() != null && !other.getLabel().equals(this.getLabel())) {
            return false;
        }
        if (other.getAWSAccountIds() == null ^ this.getAWSAccountIds() == null) {
            return false;
        }
        if (other.getAWSAccountIds() != null && !other.getAWSAccountIds().equals(this.getAWSAccountIds())) {
            return false;
        }
        if (other.getActionNames() == null ^ this.getActionNames() == null) {
            return false;
        }
        return other.getActionNames() == null || other.getActionNames().equals(this.getActionNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTopicArn() == null ? 0 : this.getTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.getLabel() == null ? 0 : this.getLabel().hashCode());
        hashCode = 31 * hashCode + (this.getAWSAccountIds() == null ? 0 : this.getAWSAccountIds().hashCode());
        hashCode = 31 * hashCode + (this.getActionNames() == null ? 0 : this.getActionNames().hashCode());
        return hashCode;
    }

    public AddPermissionRequest clone() {
        return (AddPermissionRequest)super.clone();
    }
}

