# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
# pylint: disable=protected-access

import argparse
from collections import defaultdict
from knack.util import CLIError


class AddSoldTo(argparse.Action):
    def __call__(self, parser, namespace, values, option_string=None):
        action = self.get_action(values, option_string)

        if hasattr(namespace, 'sold_to'):
            namespace.sold_to = action
        if hasattr(namespace, 'bill_to'):
            namespace.bill_to = action

    def get_action(self, values, option_string):  # pylint: disable=no-self-use
        try:
            properties = defaultdict(list)
            for (k, v) in (x.split('=', 1) for x in values):
                properties[k].append(v)
            properties = dict(properties)
        except ValueError:
            raise CLIError('usage error: {} [KEY=VALUE ...]'.format(option_string))
        d = {}
        for k in properties:
            kl = k.lower()
            v = properties[k]
            if kl == 'first-name':
                d['first_name'] = v[0]
            elif kl == 'last-name':
                d['last_name'] = v[0]
            elif kl == 'company-name':
                d['company_name'] = v[0]
            elif kl == 'address-line1':
                d['address_line1'] = v[0]
            elif kl == 'address-line2':
                d['address_line2'] = v[0]
            elif kl == 'address-line3':
                d['address_line3'] = v[0]
            elif kl == 'city':
                d['city'] = v[0]
            elif kl == 'district':
                d['district'] = v[0]
            elif kl == 'region':
                d['region'] = v[0]
            elif kl == 'country':
                d['country'] = v[0]
            elif kl == 'postal-code':
                d['postal_code'] = v[0]
            elif kl == 'email':
                d['email'] = v[0]
            elif kl == 'phone-number':
                d['phone_number'] = v[0]
        return d


class AddEnabledAzurePlans(argparse._AppendAction):
    def __call__(self, parser, namespace, values, option_string=None):
        action = self.get_action(values, option_string)
        super(AddEnabledAzurePlans, self).__call__(parser, namespace, action, option_string)

    def get_action(self, values, option_string):  # pylint: disable=no-self-use
        try:
            properties = defaultdict(list)
            for (k, v) in (x.split('=', 1) for x in values):
                properties[k].append(v)
            properties = dict(properties)
        except ValueError:
            raise CLIError('usage error: {} [KEY=VALUE ...]'.format(option_string))
        d = {}
        for k in properties:
            kl = k.lower()
            v = properties[k]
            if kl == 'sku-id':
                d['sku_id'] = v[0]
        return d


class AddLabels(argparse.Action):
    def __call__(self, parser, namespace, values, option_string=None):
        action = self.get_action(values, option_string)
        namespace.labels = action

    def get_action(self, values, option_string):  # pylint: disable=no-self-use
        try:
            properties = defaultdict(list)
            for (k, v) in (x.split('=', 1) for x in values):
                properties[k].append(v)
            properties = dict(properties)
        except ValueError:
            raise CLIError('usage error: {} [KEY=VALUE ...]'.format(option_string))
        d = {}
        for k in properties:
            v = properties[k]
            d[k] = v[0]
        return d
