/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.tuple;

import com.yahoo.sketches.tuple.CompactSketch;
import com.yahoo.sketches.tuple.QuickSelectSketch;
import com.yahoo.sketches.tuple.Sketch;
import com.yahoo.sketches.tuple.SketchIterator;
import com.yahoo.sketches.tuple.Summary;
import com.yahoo.sketches.tuple.SummarySetOperations;

public class Union<S extends Summary> {
    private final int nomEntries_;
    private final SummarySetOperations<S> summarySetOps_;
    private QuickSelectSketch<S> sketch_;
    private long theta_;

    public Union(SummarySetOperations<S> summarySetOps) {
        this(4096, summarySetOps);
    }

    public Union(int nomEntries, SummarySetOperations<S> summarySetOps) {
        this.nomEntries_ = nomEntries;
        this.summarySetOps_ = summarySetOps;
        this.sketch_ = new QuickSelectSketch(nomEntries, null);
        this.theta_ = this.sketch_.getThetaLong();
    }

    public void update(Sketch<S> sketchIn) {
        if (sketchIn == null || sketchIn.isEmpty()) {
            return;
        }
        if (sketchIn.theta_ < this.theta_) {
            this.theta_ = sketchIn.theta_;
        }
        SketchIterator<S> it = sketchIn.iterator();
        while (it.next()) {
            this.sketch_.merge(it.getKey(), it.getSummary(), this.summarySetOps_);
        }
    }

    public CompactSketch<S> getResult() {
        this.sketch_.trim();
        if (this.theta_ < this.sketch_.theta_) {
            this.sketch_.setThetaLong(this.theta_);
            this.sketch_.rebuild();
        }
        return this.sketch_.compact();
    }

    public void reset() {
        this.sketch_ = new QuickSelectSketch(this.nomEntries_, null);
    }
}

