"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function defineRoutes(router) {
  router.post({
    path: '/api/gantt_vis/query',
    validate: {
      body: _configSchema.schema.object({
        index: _configSchema.schema.string(),
        size: _configSchema.schema.number(),
        body: _configSchema.schema.object({
          query: _configSchema.schema.maybe(_configSchema.schema.object({
            bool: _configSchema.schema.object({
              filter: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
                unknowns: 'allow'
              }))),
              must: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
                unknowns: 'allow'
              }))),
              should: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
                unknowns: 'allow'
              }))),
              must_not: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
                unknowns: 'allow'
              })))
            })
          })),
          sort: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any()))
        })
      })
    }
  }, async (context, request, response) => {
    const {
      index,
      size,
      ...rest
    } = request.body;
    const params = {
      index,
      size,
      ...rest
    };
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('search', params);
      return response.ok({
        body: {
          total: resp.hits.total.value,
          hits: resp.hits.hits
        }
      });
    } catch (error) {
      console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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