/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.aggregation.AvgAggregator;
import org.opensearch.sql.expression.aggregation.CountAggregator;
import org.opensearch.sql.expression.aggregation.MaxAggregator;
import org.opensearch.sql.expression.aggregation.MinAggregator;
import org.opensearch.sql.expression.aggregation.StdDevAggregator;
import org.opensearch.sql.expression.aggregation.SumAggregator;
import org.opensearch.sql.expression.aggregation.TakeAggregator;
import org.opensearch.sql.expression.aggregation.VarianceAggregator;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.DefaultFunctionResolver;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionSignature;

public final class AggregatorFunction {
    public static void register(BuiltinFunctionRepository repository) {
        repository.register(AggregatorFunction.avg());
        repository.register(AggregatorFunction.sum());
        repository.register(AggregatorFunction.count());
        repository.register(AggregatorFunction.min());
        repository.register(AggregatorFunction.max());
        repository.register(AggregatorFunction.varSamp());
        repository.register(AggregatorFunction.varPop());
        repository.register(AggregatorFunction.stddevSamp());
        repository.register(AggregatorFunction.stddevPop());
        repository.register(AggregatorFunction.take());
    }

    private static DefaultFunctionResolver avg() {
        FunctionName functionName = BuiltinFunctionName.AVG.getName();
        return new DefaultFunctionResolver(functionName, (Map<FunctionSignature, FunctionBuilder>)new ImmutableMap.Builder().put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), (functionProperties, arguments) -> new AvgAggregator(arguments, ExprCoreType.DOUBLE)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DATE)), (functionProperties, arguments) -> new AvgAggregator(arguments, ExprCoreType.DATE)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DATETIME)), (functionProperties, arguments) -> new AvgAggregator(arguments, ExprCoreType.DATETIME)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.TIME)), (functionProperties, arguments) -> new AvgAggregator(arguments, ExprCoreType.TIME)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.TIMESTAMP)), (functionProperties, arguments) -> new AvgAggregator(arguments, ExprCoreType.TIMESTAMP)).build());
    }

    private static DefaultFunctionResolver count() {
        FunctionName functionName = BuiltinFunctionName.COUNT.getName();
        DefaultFunctionResolver functionResolver = new DefaultFunctionResolver(functionName, ExprCoreType.coreTypes().stream().collect(Collectors.toMap(type -> new FunctionSignature(functionName, Collections.singletonList(type)), type -> (functionProperties, arguments) -> new CountAggregator(arguments, ExprCoreType.INTEGER))));
        return functionResolver;
    }

    private static DefaultFunctionResolver sum() {
        FunctionName functionName = BuiltinFunctionName.SUM.getName();
        return new DefaultFunctionResolver(functionName, (Map<FunctionSignature, FunctionBuilder>)new ImmutableMap.Builder().put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.INTEGER)), (functionProperties, arguments) -> new SumAggregator(arguments, ExprCoreType.INTEGER)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.LONG)), (functionProperties, arguments) -> new SumAggregator(arguments, ExprCoreType.LONG)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.FLOAT)), (functionProperties, arguments) -> new SumAggregator(arguments, ExprCoreType.FLOAT)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), (functionProperties, arguments) -> new SumAggregator(arguments, ExprCoreType.DOUBLE)).build());
    }

    private static DefaultFunctionResolver min() {
        FunctionName functionName = BuiltinFunctionName.MIN.getName();
        return new DefaultFunctionResolver(functionName, (Map<FunctionSignature, FunctionBuilder>)new ImmutableMap.Builder().put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.INTEGER)), (functionProperties, arguments) -> new MinAggregator(arguments, ExprCoreType.INTEGER)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.LONG)), (functionProperties, arguments) -> new MinAggregator(arguments, ExprCoreType.LONG)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.FLOAT)), (functionProperties, arguments) -> new MinAggregator(arguments, ExprCoreType.FLOAT)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), (functionProperties, arguments) -> new MinAggregator(arguments, ExprCoreType.DOUBLE)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.STRING)), (functionProperties, arguments) -> new MinAggregator(arguments, ExprCoreType.STRING)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DATE)), (functionProperties, arguments) -> new MinAggregator(arguments, ExprCoreType.DATE)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DATETIME)), (functionProperties, arguments) -> new MinAggregator(arguments, ExprCoreType.DATETIME)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.TIME)), (functionProperties, arguments) -> new MinAggregator(arguments, ExprCoreType.TIME)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.TIMESTAMP)), (functionProperties, arguments) -> new MinAggregator(arguments, ExprCoreType.TIMESTAMP)).build());
    }

    private static DefaultFunctionResolver max() {
        FunctionName functionName = BuiltinFunctionName.MAX.getName();
        return new DefaultFunctionResolver(functionName, (Map<FunctionSignature, FunctionBuilder>)new ImmutableMap.Builder().put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.INTEGER)), (functionProperties, arguments) -> new MaxAggregator(arguments, ExprCoreType.INTEGER)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.LONG)), (functionProperties, arguments) -> new MaxAggregator(arguments, ExprCoreType.LONG)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.FLOAT)), (functionProperties, arguments) -> new MaxAggregator(arguments, ExprCoreType.FLOAT)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), (functionProperties, arguments) -> new MaxAggregator(arguments, ExprCoreType.DOUBLE)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.STRING)), (functionProperties, arguments) -> new MaxAggregator(arguments, ExprCoreType.STRING)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DATE)), (functionProperties, arguments) -> new MaxAggregator(arguments, ExprCoreType.DATE)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DATETIME)), (functionProperties, arguments) -> new MaxAggregator(arguments, ExprCoreType.DATETIME)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.TIME)), (functionProperties, arguments) -> new MaxAggregator(arguments, ExprCoreType.TIME)).put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.TIMESTAMP)), (functionProperties, arguments) -> new MaxAggregator(arguments, ExprCoreType.TIMESTAMP)).build());
    }

    private static DefaultFunctionResolver varSamp() {
        FunctionName functionName = BuiltinFunctionName.VARSAMP.getName();
        return new DefaultFunctionResolver(functionName, (Map<FunctionSignature, FunctionBuilder>)new ImmutableMap.Builder().put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), (functionProperties, arguments) -> VarianceAggregator.varianceSample(arguments, ExprCoreType.DOUBLE)).build());
    }

    private static DefaultFunctionResolver varPop() {
        FunctionName functionName = BuiltinFunctionName.VARPOP.getName();
        return new DefaultFunctionResolver(functionName, (Map<FunctionSignature, FunctionBuilder>)new ImmutableMap.Builder().put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), (functionProperties, arguments) -> VarianceAggregator.variancePopulation(arguments, ExprCoreType.DOUBLE)).build());
    }

    private static DefaultFunctionResolver stddevSamp() {
        FunctionName functionName = BuiltinFunctionName.STDDEV_SAMP.getName();
        return new DefaultFunctionResolver(functionName, (Map<FunctionSignature, FunctionBuilder>)new ImmutableMap.Builder().put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), (functionProperties, arguments) -> StdDevAggregator.stddevSample(arguments, ExprCoreType.DOUBLE)).build());
    }

    private static DefaultFunctionResolver stddevPop() {
        FunctionName functionName = BuiltinFunctionName.STDDEV_POP.getName();
        return new DefaultFunctionResolver(functionName, (Map<FunctionSignature, FunctionBuilder>)new ImmutableMap.Builder().put((Object)new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), (functionProperties, arguments) -> StdDevAggregator.stddevPopulation(arguments, ExprCoreType.DOUBLE)).build());
    }

    private static DefaultFunctionResolver take() {
        FunctionName functionName = BuiltinFunctionName.TAKE.getName();
        DefaultFunctionResolver functionResolver = new DefaultFunctionResolver(functionName, (Map<FunctionSignature, FunctionBuilder>)new ImmutableMap.Builder().put((Object)new FunctionSignature(functionName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.INTEGER)), (functionProperties, arguments) -> new TakeAggregator(arguments, ExprCoreType.ARRAY)).build());
        return functionResolver;
    }

    @Generated
    private AggregatorFunction() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

