/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.StreamCorruptedException;
import java.time.zone.Ser;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesException;
import java.time.zone.ZoneRulesProvider;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

final class TzdbZoneRulesProvider
extends ZoneRulesProvider {
    private List<String> regionIds;
    private String versionId;
    private final Map<String, Object> regionToRules = new ConcurrentHashMap<String, Object>();

    public TzdbZoneRulesProvider() {
        try {
            String string = System.getProperty("java.home") + File.separator + "lib";
            try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(string, "tzdb.dat"))));){
                this.load(dataInputStream);
            }
        }
        catch (Exception exception) {
            throw new ZoneRulesException("Unable to load TZDB time-zone rules", exception);
        }
    }

    @Override
    protected Set<String> provideZoneIds() {
        return new HashSet<String>(this.regionIds);
    }

    @Override
    protected ZoneRules provideRules(String string, boolean bl) {
        Object object = this.regionToRules.get(string);
        if (object == null) {
            throw new ZoneRulesException("Unknown time-zone ID: " + string);
        }
        try {
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                object = Ser.read(dataInputStream);
                this.regionToRules.put(string, object);
            }
            return (ZoneRules)object;
        }
        catch (Exception exception) {
            throw new ZoneRulesException("Invalid binary time-zone data: TZDB:" + string + ", version: " + this.versionId, exception);
        }
    }

    @Override
    protected NavigableMap<String, ZoneRules> provideVersions(String string) {
        TreeMap<String, ZoneRules> treeMap = new TreeMap<String, ZoneRules>();
        ZoneRules zoneRules = TzdbZoneRulesProvider.getRules(string, false);
        if (zoneRules != null) {
            treeMap.put(this.versionId, zoneRules);
        }
        return treeMap;
    }

    private void load(DataInputStream dataInputStream) throws Exception {
        int n;
        int n2;
        int n3;
        if (dataInputStream.readByte() != 1) {
            throw new StreamCorruptedException("File format not recognised");
        }
        String string = dataInputStream.readUTF();
        if (!"TZDB".equals(string)) {
            throw new StreamCorruptedException("File format not recognised");
        }
        int n4 = dataInputStream.readShort();
        for (n3 = 0; n3 < n4; ++n3) {
            this.versionId = dataInputStream.readUTF();
        }
        n3 = dataInputStream.readShort();
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = dataInputStream.readUTF();
        }
        this.regionIds = Arrays.asList(stringArray);
        n2 = dataInputStream.readShort();
        Object[] objectArray = new Object[n2];
        for (n = 0; n < n2; ++n) {
            byte[] byArray = new byte[dataInputStream.readShort()];
            dataInputStream.readFully(byArray);
            objectArray[n] = byArray;
        }
        for (n = 0; n < n4; ++n) {
            int n5 = dataInputStream.readShort();
            this.regionToRules.clear();
            for (int i = 0; i < n5; ++i) {
                String string2 = stringArray[dataInputStream.readShort()];
                Object object = objectArray[dataInputStream.readShort() & 0xFFFF];
                this.regionToRules.put(string2, object);
            }
        }
    }

    public String toString() {
        return "TZDB[" + this.versionId + "]";
    }
}

