/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.configurator;

import com.tngtech.archunit.core.domain.JavaClass;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.event.RowSorterEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.codeexplorer.configurator.CellRendererWithTooltip;
import org.freeplane.plugin.codeexplorer.dependencies.CodeDependency;
import org.freeplane.plugin.codeexplorer.map.ClassNode;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.map.DependencySelection;

class CodeDependenciesPanel
extends JPanel
implements INodeSelectionListener,
IMapSelectionListener,
IFreeplanePropertyListener,
IMapChangeListener {
    private static final String[] COLUMN_NAMES = new String[]{"Verdict", "Origin", "Target", "Dependency"};
    private static final long serialVersionUID = 1L;
    private static final Icon filterIcon = ResourceController.getResourceController().getIcon("filterDependencyIncormation.icon");
    private final JTextField filterField;
    private final JTable dependencyViewer;
    private final JLabel countLabel;
    private List<CodeDependency> allDependencies;

    CodeDependenciesPanel() {
        JPanel topPanel = new JPanel(new BorderLayout());
        this.countLabel = new JLabel(filterIcon);
        int countLabelMargin = (int)(UITools.FONT_SCALE_FACTOR * 10.0f);
        this.countLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, countLabelMargin));
        this.countLabel.setIconTextGap(countLabelMargin / 2);
        topPanel.add((Component)this.countLabel, "West");
        this.filterField = new JTextField();
        this.filterField.addActionListener(e -> this.updateDependencyFilter());
        topPanel.add((Component)this.filterField, "Center");
        this.dependencyViewer = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                JComponent component = (JComponent)super.prepareRenderer(renderer, row, column);
                int modelColumn = this.convertColumnIndexToModel(column);
                if (modelColumn == 1 || modelColumn == 2) {
                    CodeDependency codeDependency = (CodeDependency)CodeDependenciesPanel.this.allDependencies.get(this.convertRowIndexToModel(row));
                    JavaClass javaClass = modelColumn == 1 ? codeDependency.getOriginClass() : codeDependency.getTargetClass();
                    component.setToolTipText(CodeDependenciesPanel.this.toDisplayedFullName(javaClass));
                }
                return component;
            }
        };
        this.allDependencies = Collections.emptyList();
        DependenciesWrapper dataModel = new DependenciesWrapper();
        this.dependencyViewer.setModel(dataModel);
        CellRendererWithTooltip cellRenderer = new CellRendererWithTooltip();
        TableColumnModel columnModel = this.dependencyViewer.getColumnModel();
        this.updateColumn(columnModel, 0, 200, cellRenderer);
        this.updateColumn(columnModel, 1, 200, cellRenderer);
        this.updateColumn(columnModel, 2, 200, cellRenderer);
        this.updateColumn(columnModel, 3, 1200, cellRenderer);
        this.dependencyViewer.getSelectionModel().setSelectionMode(2);
        this.dependencyViewer.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.dependencyViewer.setCellSelectionEnabled(true);
        TableRowSorter<DependenciesWrapper> sorter = new TableRowSorter<DependenciesWrapper>(dataModel);
        sorter.addRowSorterListener(e -> {
            if (e.getType() == RowSorterEvent.Type.SORT_ORDER_CHANGED) {
                SwingUtilities.invokeLater(this::scrollSelectedToVisible);
            }
        });
        this.dependencyViewer.setRowSorter(sorter);
        JTextField cellEditor = new JTextField();
        cellEditor.setEditable(false);
        this.dependencyViewer.setDefaultEditor(Object.class, new DefaultCellEditor(cellEditor));
        JScrollPane scrollPane = new JScrollPane(this.dependencyViewer);
        this.setLayout(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.add((Component)scrollPane, "Center");
    }

    private void updateDependencyFilter() {
        final String[] filteredWords = this.filterField.getText().trim().split("[^\\w:.$]+");
        TableRowSorter rowSorter = (TableRowSorter)this.dependencyViewer.getRowSorter();
        if (filteredWords.length == 1 && filteredWords[0].isEmpty()) {
            rowSorter.setRowFilter(null);
        } else {
            RowFilter<DependenciesWrapper, Integer> dependencyFilter = new RowFilter<DependenciesWrapper, Integer>(){
                BiPredicate<CodeDependency, String[]> combinedFilter;
                {
                    this.combinedFilter = Stream.of(filteredWords).map(this::createPredicateFromString).reduce((x, y) -> true, BiPredicate::and);
                }

                private BiPredicate<CodeDependency, String[]> createPredicateFromString(String searchedString) {
                    if (searchedString.startsWith("origin:")) {
                        String value = searchedString.substring("origin:".length());
                        return (dependency, row) -> dependency.getOriginClass().getName().contains(value);
                    }
                    if (searchedString.startsWith("target:")) {
                        String value = searchedString.substring("target:".length());
                        return (dependency, row) -> dependency.getTargetClass().getName().contains(value);
                    }
                    if (searchedString.startsWith("verdict:")) {
                        String value = searchedString.substring("verdict:".length());
                        return (dependency, row) -> row[0].contains(value);
                    }
                    if (searchedString.startsWith("dependency:")) {
                        String value = searchedString.substring("dependency:".length());
                        return (dependency, row) -> row[3].contains(value);
                    }
                    return (dependency, row) -> Stream.of(row).anyMatch(s -> s.contains(searchedString));
                }

                @Override
                public boolean include(RowFilter.Entry<? extends DependenciesWrapper, ? extends Integer> entry) {
                    TableModel tableData = CodeDependenciesPanel.this.dependencyViewer.getModel();
                    int rowIndex = entry.getIdentifier();
                    String[] row = (String[])IntStream.range(0, 4).mapToObj(column -> tableData.getValueAt(rowIndex, column).toString()).toArray(String[]::new);
                    return this.combinedFilter.test((CodeDependency)CodeDependenciesPanel.this.allDependencies.get(rowIndex), row);
                }
            };
            rowSorter.setRowFilter(dependencyFilter);
        }
        this.scrollSelectedToVisible();
        this.countLabel.setText("( " + rowSorter.getViewRowCount() + " / " + rowSorter.getModelRowCount() + " )");
    }

    private void updateColumn(TableColumnModel columns, int index, int columnWidth, TableCellRenderer cellRenderer) {
        int scaledWidth = (int)((float)columnWidth * UITools.FONT_SCALE_FACTOR);
        TableColumn columnModel = columns.getColumn(index);
        columnModel.setWidth(scaledWidth);
        columnModel.setPreferredWidth(scaledWidth);
        columnModel.setCellRenderer(cellRenderer);
    }

    public void afterMapChange(MapModel oldMap, MapModel newMap) {
        this.update();
    }

    void update() {
        Controller controller = Controller.getCurrentController();
        this.update(controller.getSelection());
    }

    public void onSelectionSetChange(IMapSelection selection) {
        this.update(selection);
    }

    public void mapChanged(MapChangeEvent event) {
        if (event.getProperty().equals(Filter.class)) {
            SwingUtilities.invokeLater(this::update);
        }
    }

    private void update(IMapSelection selection) {
        Set selectedDependencies = this.getSelectedDependencies().collect(Collectors.toSet());
        int selectedColumn = this.dependencyViewer.getSelectedColumn();
        this.allDependencies = selection == null || !(selection.getMap() instanceof CodeMap) ? Collections.emptyList() : this.selectedDependencies(new DependencySelection(selection));
        ((DependenciesWrapper)this.dependencyViewer.getModel()).fireTableDataChanged();
        this.updateRowCountLabel();
        if (!selectedDependencies.isEmpty()) {
            IntStream.range(0, this.allDependencies.size()).filter(i -> selectedDependencies.contains(this.allDependencies.get(i))).map(this.dependencyViewer::convertRowIndexToView).forEach(row -> this.dependencyViewer.addRowSelectionInterval(row, row));
            if (this.dependencyViewer.getSelectedRow() != -1) {
                this.dependencyViewer.setColumnSelectionInterval(selectedColumn, selectedColumn);
                SwingUtilities.invokeLater(this::scrollSelectedToVisible);
            }
        }
    }

    private List<CodeDependency> selectedDependencies(DependencySelection dependencySelection) {
        return dependencySelection.getSelectedDependencies().map(dependencySelection.getMap()::toCodeDependency).collect(Collectors.toCollection(ArrayList::new));
    }

    private Stream<CodeDependency> getSelectedDependencies() {
        return IntStream.of(this.dependencyViewer.getSelectedRows()).map(this.dependencyViewer::convertRowIndexToModel).mapToObj(this.allDependencies::get);
    }

    private void updateRowCountLabel() {
        this.countLabel.setText("( " + this.dependencyViewer.getRowCount() + " / " + this.allDependencies.size() + " )");
    }

    private void scrollSelectedToVisible() {
        int selectedRowOnView = this.dependencyViewer.getSelectedRow();
        if (selectedRowOnView != -1) {
            this.dependencyViewer.scrollRectToVisible(new Rectangle(this.dependencyViewer.getCellRect(selectedRowOnView, 0, true)));
        }
    }

    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        if (propertyName.equals("code_showOutsideDependencies")) {
            Controller controller = Controller.getCurrentController();
            IMapSelection selection = controller.getSelection();
            this.update(selection);
            controller.getMapViewManager().getMapViewComponent().repaint();
        }
    }

    void addDependencySelectionCallback(final Consumer<Set<JavaClass>> listener) {
        this.dependencyViewer.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                listener.accept(this.getSelectedClasses());
            }
        });
        this.dependencyViewer.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    listener.accept(CodeDependenciesPanel.this.getSelectedClasses());
                }
            }
        });
    }

    private Set<JavaClass> getSelectedClasses() {
        return this.getSelectedDependencies().map(CodeDependency::getDependency).flatMap(d -> Stream.of(d.getOriginClass(), d.getTargetClass())).collect(Collectors.toSet());
    }

    private String toDisplayedFullName(JavaClass originClass) {
        return CodeNode.findEnclosingNamedClass(originClass).getName().replace('$', '.');
    }

    private class DependenciesWrapper
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private DependenciesWrapper() {
        }

        @Override
        public int getRowCount() {
            return CodeDependenciesPanel.this.allDependencies.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            CodeDependency row = (CodeDependency)CodeDependenciesPanel.this.allDependencies.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return row.describeVerdict();
                }
                case 1: {
                    return ClassNode.nodeText(row.getOriginClass());
                }
                case 2: {
                    return ClassNode.nodeText(row.getTargetClass());
                }
                case 3: {
                    return row.getDescription();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            return COLUMN_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }
    }
}

