/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.configurator;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.core.util.TextUtils;
import org.freeplane.plugin.codeexplorer.configurator.AutoResizedTable;
import org.freeplane.plugin.codeexplorer.configurator.CellRendererWithTooltip;
import org.freeplane.plugin.codeexplorer.configurator.CodeProjectController;
import org.freeplane.plugin.codeexplorer.task.CodeExplorerConfigurations;
import org.freeplane.plugin.codeexplorer.task.ConfigurationChange;
import org.freeplane.plugin.codeexplorer.task.UserDefinedCodeExplorerConfiguration;

class CodeExplorerConfigurator
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DefaultTableModel configTableModel;
    private DefaultTableModel locationsTableModel;
    private JTable configTable;
    private JTable locationsTable;
    private final CodeProjectController codeProjectController;
    private JTextArea rules;
    private JFileChooser fileChooser;
    private ConfigurationChange configurationChange;
    private JToggleButton helpToggleButton;

    CodeExplorerConfigurator(CodeProjectController codeProjectController) {
        this.codeProjectController = codeProjectController;
        this.configurationChange = ConfigurationChange.CODE_BASE;
        this.initializeComponents();
        this.updateConfigurationsTable(this.explorerConfigurations());
    }

    private void updateConfigurationsTable(CodeExplorerConfigurations explorerConfigurations) {
        this.configTableModel.setRowCount(0);
        for (UserDefinedCodeExplorerConfiguration config : explorerConfigurations.getConfigurations()) {
            this.configTableModel.addRow(new Object[]{config.getProjectName()});
        }
    }

    private void initializeComponents() {
        this.createPanels();
        this.createFileChooser();
    }

    private void createFileChooser() {
        this.fileChooser = UITools.newFileChooser(null);
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.setFileSelectionMode(2);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("jar", "jar");
        this.fileChooser.setFileFilter(filter);
    }

    private JComponent createConfigurationsPanel() {
        this.configTableModel = new DefaultTableModel(new Object[]{""}, 0);
        this.configTable = new JTable(this.configTableModel);
        this.configTable.setSelectionMode(1);
        JScrollPane configTableScrollPane = new JScrollPane(this.configTable);
        this.configTable.getSelectionModel().addListSelectionListener(e -> this.updateConfiguration());
        this.configTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int firstRow = e.getFirstRow();
                if (e.getType() == 0 && firstRow >= 0) {
                    int lastRow = e.getLastRow();
                    CodeExplorerConfigurator.this.updateConfigurationNames(firstRow, lastRow);
                }
            }
        });
        return configTableScrollPane;
    }

    private JComponent createLocationsPane(final JLabel paneLabel, JToggleButton helpToggleButton) {
        this.locationsTableModel = new DefaultTableModel(new Object[]{""}, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.locationsTable = new AutoResizedTable(this.locationsTableModel);
        this.locationsTable.getTableHeader().setVisible(false);
        this.locationsTable.setSelectionMode(2);
        CellRendererWithTooltip cellRenderer = new CellRendererWithTooltip();
        TableColumn locationsColumn = this.locationsTable.getColumnModel().getColumn(0);
        locationsColumn.setCellRenderer(cellRenderer);
        JScrollPane locationsTableScrollPane = new JScrollPane(this.locationsTable);
        locationsTableScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CodeExplorerConfigurator.this.locationsTable.revalidate();
                CodeExplorerConfigurator.this.locationsTable.repaint();
            }
        });
        CardLayout cardLayout = new CardLayout();
        JPanel cardPanel = new JPanel(cardLayout);
        cardPanel.add((Component)locationsTableScrollPane, "Locations");
        JTextArea helpText = new JTextArea("Rule Format:\n-> Rules are defined one per line in the following formats:\n\n  [command] [originPattern] [direction] [targetPattern]\n  classpath [path]\n  ignore class [classPattern]\n  import interface [classPattern]\n  import annotation [classPattern]\n  import annotation [classPattern].[methodName]()\n\n-> Commands (Related to Dependency Rules): allow, forbid, ignore\n   - 'allow', 'forbid', 'ignore' commands are used to define rules for managing dependencies between different parts of the code.\n-> Direction: ->, ->v, ->^ (representing bidirectional, downward, upward respectively)\n   - Specifies the direction of dependency between the origin and target patterns.\n-> Patterns: follow AspectJ-like syntax for matching package names\n-> Path: additional path segment to be appended to each root directory defined in the 'locations' table.\n-> ClassPattern: same syntax as originPattern for matching class names\n   - Note: For 'ignore class', '..' is implicitly added at the start of the pattern if not already present, ensuring a broader match.\n\nLocations Table:\n-> The 'locations' table defines the root directories for the project.\n-> The 'classpath' lines specify additional path segments to be appended to these root directories, resulting in paths like '/root/target/classes'.\n\nDefault Classpath Behavior:\n-> If no 'classpath' elements are given:\n   - If the location directory contains 'pom.xml', defaults to appending 'target/classes'.\n   - If the location directory contains 'build.gradle', defaults to appending 'build/classes'.\n   - Otherwise, defaults to appending the current directory ('.').\n\nComments:\n-> Lines starting with '#' or '//' are considered comments and ignored.\n\nExamples:\n\n  allow *.service.* -> *.repository.*\n  forbid *.*.controller*.. ->^ ..model..\n  ignore ..util.. ->v ..*Helper..\n  classpath /target/classes\n  ignore class com.example..*ServiceImpl..\n  import interface java.io.Serializable\n  import interface java.util.List\n  import annotation com.example..*Annotation\n  import annotation com.example..*Annotation.*.value()\n\nNote:\n-> 'classpath' lines augment the root directories defined in the 'locations' table.\n-> The 'ignore class' command is designed to include a broader range of classes by implicitly adding '..' at the start of the pattern.\n-> The commands 'allow', 'forbid', and 'ignore' specifically dictate how different code segments (e.g., packages, classes) can depend on each other.\n");
        helpText.setEditable(false);
        cardPanel.add((Component)new JScrollPane(helpText), "Help");
        final String rulesHelpHeaderText = TextUtils.getText((String)"code.helplabel");
        final String locationsHeaderText = TextUtils.getText((String)"code.locations");
        paneLabel.setText(locationsHeaderText);
        paneLabel.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                Component component = e.getComponent();
                if (0L != (e.getChangeFlags() & 4L) && component.isShowing()) {
                    paneLabel.setText(rulesHelpHeaderText);
                    Dimension rulesPreferredSize = paneLabel.getPreferredSize();
                    paneLabel.setText(locationsHeaderText);
                    Dimension locationPreferredSize = paneLabel.getPreferredSize();
                    paneLabel.setMinimumSize(new Dimension(Math.max(locationPreferredSize.width, rulesPreferredSize.width), Math.max(locationPreferredSize.height, rulesPreferredSize.height)));
                    paneLabel.removeHierarchyListener(this);
                }
            }
        });
        helpToggleButton.addActionListener(e -> {
            if (helpToggleButton.isSelected()) {
                paneLabel.setText(rulesHelpHeaderText);
                cardLayout.show(cardPanel, "Help");
            } else {
                paneLabel.setText(locationsHeaderText);
                cardLayout.show(cardPanel, "Locations");
            }
        });
        return cardPanel;
    }

    private JComponent createRulesPane() {
        this.rules = new JTextArea();
        JScrollPane rulesScrollPane = new JScrollPane(this.rules);
        return rulesScrollPane;
    }

    private void updateConfigurationNames(int firstRow, int lastRow) {
        for (int row = firstRow; row <= lastRow; ++row) {
            this.updateConfigurationName(row);
        }
    }

    private void updateConfigurationName(int row) {
        String projectName = ((String)this.configTableModel.getValueAt(row, 0)).trim();
        UserDefinedCodeExplorerConfiguration config = this.getConfiguration(row);
        config.setProjectName(projectName);
    }

    private void updateConfiguration() {
        this.locationsTableModel.setRowCount(0);
        int selectedRow = this.getSelectedConfigurationIndex();
        if (selectedRow >= 0) {
            UserDefinedCodeExplorerConfiguration config = this.getConfiguration(selectedRow);
            for (File location : config.getLocations()) {
                this.locationsTableModel.addRow(new Object[]{location.getAbsolutePath()});
            }
            this.rules.setText(config.getConfigurationRules());
        } else {
            this.rules.setText("");
        }
        this.configurationChange = ConfigurationChange.CODE_BASE;
    }

    private void exploreSelectedConfiguration() {
        UserDefinedCodeExplorerConfiguration selectedConfiguration = this.getSelectedConfiguration();
        if (selectedConfiguration != null) {
            this.setConfigurationRules();
            this.codeProjectController.exploreConfiguration(selectedConfiguration);
            this.configurationChange = ConfigurationChange.SAME;
        }
    }

    UserDefinedCodeExplorerConfiguration getSelectedConfiguration() {
        int selectedConfigurationIndex = this.getSelectedConfigurationIndex();
        UserDefinedCodeExplorerConfiguration selectedConfiguration = this.getConfiguration(selectedConfigurationIndex);
        return selectedConfiguration;
    }

    private UserDefinedCodeExplorerConfiguration getConfiguration(int selectedConfigurationIndex) {
        if (selectedConfigurationIndex >= 0) {
            return this.explorerConfigurations().getConfigurations().get(selectedConfigurationIndex);
        }
        return null;
    }

    private int getSelectedConfigurationIndex() {
        if (this.configTable.getSelectedRowCount() != 1) {
            return -1;
        }
        return this.configTable.getSelectedRow();
    }

    private void addNewConfiguration() {
        UserDefinedCodeExplorerConfiguration newConfig = new UserDefinedCodeExplorerConfiguration();
        this.explorerConfigurations().getConfigurations().add(newConfig);
        this.configTableModel.addRow(new Object[]{newConfig.getProjectName()});
        int newRow = this.configTable.getRowCount() - 1;
        this.configTable.setRowSelectionInterval(newRow, newRow);
        this.configTable.editCellAt(newRow, 0);
        this.configTable.getEditorComponent().requestFocusInWindow();
    }

    private void deleteSelectedConfigurations() {
        int maxSelectionIndex;
        ListSelectionModel selectionModel = this.configTable.getSelectionModel();
        int minSelectionIndex = selectionModel.getMinSelectionIndex();
        if (minSelectionIndex == -1) {
            return;
        }
        for (int row = maxSelectionIndex = selectionModel.getMaxSelectionIndex(); row >= minSelectionIndex; --row) {
            this.configTableModel.removeRow(row);
            this.explorerConfigurations().getConfigurations().remove(row);
        }
        int rowCount = this.configTableModel.getRowCount();
        if (minSelectionIndex < rowCount) {
            this.configTable.setRowSelectionInterval(minSelectionIndex, minSelectionIndex);
        } else if (rowCount > 0) {
            this.configTable.setRowSelectionInterval(rowCount - 1, rowCount - 1);
        }
        this.updateConfiguration();
    }

    private void moveSelectedLocationsToTheTop() {
        int i;
        int[] selectedRows = this.locationsTable.getSelectedRows();
        Arrays.sort(selectedRows);
        for (i = 0; i < selectedRows.length; ++i) {
            this.locationsTableModel.moveRow(selectedRows[i], selectedRows[i], i);
        }
        this.locationsTable.getSelectionModel().setValueIsAdjusting(true);
        this.locationsTable.clearSelection();
        for (i = 0; i < selectedRows.length; ++i) {
            this.locationsTable.addRowSelectionInterval(i, i);
        }
        this.locationsTable.getSelectionModel().setValueIsAdjusting(false);
        this.updateSelectedConfigurationLocations();
    }

    private void moveSelectedLocationsUp() {
        int[] selectedRows = this.locationsTable.getSelectedRows();
        if (selectedRows.length > 0 && selectedRows[0] > 0) {
            for (int i = 0; i < selectedRows.length; ++i) {
                int selectedIndex = selectedRows[i];
                this.locationsTableModel.moveRow(selectedIndex, selectedIndex, selectedIndex - 1);
            }
            this.locationsTable.getSelectionModel().setValueIsAdjusting(true);
            this.locationsTable.clearSelection();
            for (int selectedIndex : selectedRows) {
                this.locationsTable.addRowSelectionInterval(selectedIndex - 1, selectedIndex - 1);
            }
            this.locationsTable.getSelectionModel().setValueIsAdjusting(false);
            this.updateSelectedConfigurationLocations();
        }
    }

    private void moveSelectedLocationsDown() {
        int[] selectedRows = this.locationsTable.getSelectedRows();
        if (selectedRows.length > 0 && selectedRows[selectedRows.length - 1] < this.locationsTableModel.getRowCount() - 1) {
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                int selectedIndex = selectedRows[i];
                this.locationsTableModel.moveRow(selectedIndex, selectedIndex, selectedIndex + 1);
            }
            this.locationsTable.getSelectionModel().setValueIsAdjusting(true);
            this.locationsTable.clearSelection();
            for (int selectedIndex : selectedRows) {
                this.locationsTable.addRowSelectionInterval(selectedIndex + 1, selectedIndex + 1);
            }
            this.locationsTable.getSelectionModel().setValueIsAdjusting(false);
            this.updateSelectedConfigurationLocations();
        }
    }

    private void moveSelectedLocationsToTheBottom() {
        int i;
        int[] selectedRows = this.locationsTable.getSelectedRows();
        Arrays.sort(selectedRows);
        int rowCount = this.locationsTableModel.getRowCount();
        for (i = selectedRows.length - 1; i >= 0; --i) {
            int selectedIndex = selectedRows[i];
            this.locationsTableModel.moveRow(selectedIndex, selectedIndex, rowCount - 1 - (selectedRows.length - 1 - i));
        }
        this.locationsTable.getSelectionModel().setValueIsAdjusting(true);
        this.locationsTable.clearSelection();
        for (i = 0; i < selectedRows.length; ++i) {
            int newRow = rowCount - selectedRows.length + i;
            this.locationsTable.addRowSelectionInterval(newRow, newRow);
        }
        this.locationsTable.getSelectionModel().setValueIsAdjusting(false);
        this.updateSelectedConfigurationLocations();
    }

    private void updateSelectedConfigurationLocations() {
        int selectedConfigRow = this.getSelectedConfigurationIndex();
        if (selectedConfigRow >= 0) {
            UserDefinedCodeExplorerConfiguration config = this.getConfiguration(selectedConfigRow);
            config.removeAllLocations();
            for (int row = 0; row < this.locationsTableModel.getRowCount(); ++row) {
                config.addLocation((String)this.locationsTableModel.getValueAt(row, 0));
            }
        }
    }

    private void removeSelectedLocations() {
        int[] selectedRows = this.locationsTable.getSelectedRows();
        Arrays.sort(selectedRows);
        int removedRowCount = 0;
        for (int selectedIndex : selectedRows) {
            int row = selectedIndex - removedRowCount;
            int selectedConfigRow = this.getSelectedConfigurationIndex();
            if (selectedConfigRow >= 0) {
                UserDefinedCodeExplorerConfiguration config = this.getConfiguration(selectedConfigRow);
                config.removeLocation(this.locationsTableModel.getValueAt(row, 0).toString());
            }
            this.locationsTableModel.removeRow(row);
            ++removedRowCount;
        }
        if (removedRowCount > 0) {
            this.configurationChange = ConfigurationChange.CODE_BASE;
        }
    }

    private void addJarsAndFolders() {
        int option;
        File selectedFile;
        File selectedDirectory;
        if (this.configTable.getRowCount() == 0) {
            this.addNewConfiguration();
        }
        int selectedConfigRow = this.getSelectedConfigurationIndex();
        UserDefinedCodeExplorerConfiguration selectedConfig = this.getConfiguration(selectedConfigRow);
        int selectedRow = this.locationsTable.getSelectedRow();
        if (selectedRow >= 0 && (selectedDirectory = (selectedFile = new File(this.locationsTable.getValueAt(selectedRow, 0).toString())).getParentFile()) != null) {
            this.fileChooser.setSelectedFile(null);
            this.fileChooser.setCurrentDirectory(selectedDirectory);
        }
        if ((option = this.fileChooser.showOpenDialog(this)) == 0) {
            File[] files;
            for (File file : files = this.fileChooser.getSelectedFiles()) {
                String path = file.getAbsolutePath();
                if (!file.exists()) {
                    path = path.trim();
                    file = new File(path);
                }
                if (selectedConfig.containsLocation(path) || !file.exists()) continue;
                this.locationsTableModel.addRow(new Object[]{path});
                selectedConfig.addLocation(file);
                this.configurationChange = ConfigurationChange.CODE_BASE;
            }
        }
    }

    private void cancelAnalysis() {
        this.codeProjectController.cancelAnalysis();
    }

    private void applyConfigurationRules() {
        this.setConfigurationRules();
        switch (this.configurationChange) {
            case CODE_BASE: {
                this.exploreSelectedConfiguration();
                break;
            }
            case CONFIGURATION: {
                this.codeProjectController.updateProjectConfiguration();
                break;
            }
        }
        this.configurationChange = ConfigurationChange.SAME;
    }

    private void setConfigurationRules() {
        UserDefinedCodeExplorerConfiguration selectedConfiguration = this.getSelectedConfiguration();
        if (selectedConfiguration != null) {
            String ruleSpecification = this.rules.getText();
            if (!selectedConfiguration.getConfigurationRules().equals(ruleSpecification)) {
                try {
                    ConfigurationChange status = selectedConfiguration.applyConfigurationRules(ruleSpecification);
                    this.configurationChange = ConfigurationChange.max(this.configurationChange, status);
                }
                catch (IllegalArgumentException e) {
                    if (!this.helpToggleButton.isSelected()) {
                        this.helpToggleButton.doClick();
                    }
                    String text = e.getMessage();
                    UITools.informationMessage((Object)text);
                }
            }
        }
    }

    private void createPanels() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel configurationsLabel = new JLabel(TextUtils.getText((String)"code.configurations"));
        JComponent configurationsPanel = this.createConfigurationsPanel();
        JComponent configurationTableToolbar = this.createConfigurationTableToolbar();
        JLabel locationsLabel = new JLabel();
        this.helpToggleButton = TranslatedElementFactory.createToggleButtonWithIcon((String)"code.help.icon", (String)"code.help");
        JComponent locationsToolbar = this.createLocationButtons(this.helpToggleButton);
        JComponent locationsPane = this.createLocationsPane(locationsLabel, this.helpToggleButton);
        JLabel rulesLabel = new JLabel(TextUtils.getText((String)"code.rules"));
        JComponent rulesPane = this.createRulesPane();
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        this.add((Component)configurationsLabel, gbc);
        gbc.gridy = 1;
        gbc.anchor = 21;
        this.add((Component)configurationTableToolbar, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 10;
        this.add((Component)locationsLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 21;
        this.add((Component)locationsToolbar, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 10;
        this.add((Component)rulesLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 1;
        configurationsPanel.setPreferredSize(new Dimension(1, 1));
        this.add((Component)configurationsPanel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 2.0;
        locationsPane.setPreferredSize(new Dimension(1, 1));
        this.add((Component)locationsPane, gbc);
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        rulesPane.setPreferredSize(new Dimension(1, 1));
        this.add((Component)rulesPane, gbc);
    }

    private JComponent createConfigurationTableToolbar() {
        FreeplaneToolBar toolbar = new FreeplaneToolBar(0);
        JButton addConfigurationButton = TranslatedElementFactory.createButtonWithIcon((String)"code.add");
        addConfigurationButton.addActionListener(e -> this.addNewConfiguration());
        JButton deleteConfigurationButton = TranslatedElementFactory.createButtonWithIcon((String)"code.delete");
        deleteConfigurationButton.addActionListener(e -> this.deleteSelectedConfigurations());
        JButton applyButton = TranslatedElementFactory.createButtonWithIcon((String)"code.apply");
        applyButton.addActionListener(e -> this.applyConfigurationRules());
        JButton exploreConfigurationButton = TranslatedElementFactory.createButtonWithIcon((String)"code.explore");
        exploreConfigurationButton.addActionListener(e -> this.exploreSelectedConfiguration());
        JButton cancelButton = TranslatedElementFactory.createButtonWithIcon((String)"code.cancel");
        cancelButton.addActionListener(e -> this.cancelAnalysis());
        JComponent[] panelButtons = new JComponent[]{addConfigurationButton, deleteConfigurationButton, exploreConfigurationButton, applyButton, cancelButton};
        Stream.of(panelButtons).forEach(button -> toolbar.add((Component)button));
        JButton[] enablingButtons = new JButton[]{exploreConfigurationButton, applyButton};
        Stream.of(enablingButtons).forEach(button -> button.setEnabled(false));
        Runnable enableButtons = () -> {
            boolean enable = this.configTable.getSelectedRowCount() == 1;
            Stream.of(enablingButtons).forEach(button -> button.setEnabled(enable));
        };
        this.configTable.getSelectionModel().addListSelectionListener(l -> enableButtons.run());
        return toolbar;
    }

    private JComponent createLocationButtons(JToggleButton helpToggleButton) {
        FreeplaneToolBar toolbar = new FreeplaneToolBar(0);
        JButton revertButton = TranslatedElementFactory.createButtonWithIcon((String)"code.revert");
        revertButton.addActionListener(e -> this.rules.setText(this.getSelectedConfiguration().getConfigurationRules()));
        JButton addLocationsButton = TranslatedElementFactory.createButtonWithIcon((String)"code.add_location");
        addLocationsButton.addActionListener(e1 -> this.addJarsAndFolders());
        JButton removeLocationsButton = TranslatedElementFactory.createButtonWithIcon((String)"code.remove_location");
        removeLocationsButton.addActionListener(e6 -> this.removeSelectedLocations());
        JButton btnMoveToTheTop = TranslatedElementFactory.createButtonWithIcon((String)"code.move_to_the_top");
        btnMoveToTheTop.addActionListener(e4 -> this.moveSelectedLocationsToTheTop());
        JButton btnMoveUp = TranslatedElementFactory.createButtonWithIcon((String)"code.move_up");
        btnMoveUp.addActionListener(e3 -> this.moveSelectedLocationsUp());
        JButton btnMoveDown = TranslatedElementFactory.createButtonWithIcon((String)"code.move_down");
        btnMoveDown.addActionListener(e5 -> this.moveSelectedLocationsDown());
        JButton btnMoveToTheBottom = TranslatedElementFactory.createButtonWithIcon((String)"code.move_to_the_bottom");
        btnMoveToTheBottom.addActionListener(e2 -> this.moveSelectedLocationsToTheBottom());
        JComponent[] panelButtons = new JComponent[]{addLocationsButton, removeLocationsButton, btnMoveToTheTop, btnMoveUp, btnMoveDown, btnMoveToTheBottom, revertButton, helpToggleButton};
        Stream.of(panelButtons).forEach(button -> toolbar.add((Component)button));
        JButton[] enablingButtons = new JButton[]{addLocationsButton, removeLocationsButton, btnMoveToTheTop, btnMoveUp, btnMoveDown, btnMoveToTheBottom, revertButton};
        Stream.of(enablingButtons).forEach(button -> button.setEnabled(false));
        Runnable enableButtons = () -> {
            boolean enable = this.configTable.getSelectionModel().getMinSelectionIndex() >= 0 && !helpToggleButton.isSelected();
            Stream.of(enablingButtons).forEach(button -> button.setEnabled(enable));
        };
        this.configTable.getSelectionModel().addListSelectionListener(l -> enableButtons.run());
        helpToggleButton.addActionListener(l -> enableButtons.run());
        return toolbar;
    }

    public List<File> getSelectedLocations() {
        ArrayList<File> paths = new ArrayList<File>();
        for (int i = 0; i < this.locationsTableModel.getRowCount(); ++i) {
            paths.add(new File(this.locationsTableModel.getValueAt(i, 0).toString()));
        }
        return paths;
    }

    private CodeExplorerConfigurations explorerConfigurations() {
        return this.codeProjectController.explorerConfigurations();
    }
}

