/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import sun.java2d.marlin.FloatMath;
import sun.java2d.marlin.MarlinCache;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinRenderingEngine;
import sun.java2d.marlin.MarlinUtils;
import sun.java2d.marlin.OffHeapArray;
import sun.java2d.marlin.Renderer;
import sun.java2d.marlin.RendererContext;
import sun.java2d.pipe.AATileGenerator;
import sun.misc.Unsafe;

final class MarlinTileGenerator
implements AATileGenerator,
MarlinConst {
    private static final int MAX_TILE_ALPHA_SUM = TILE_SIZE * TILE_SIZE * MAX_AA_ALPHA;
    private final Renderer rdr;
    private final MarlinCache cache;
    private int x;
    private int y;

    MarlinTileGenerator(Renderer renderer) {
        this.rdr = renderer;
        this.cache = renderer.cache;
    }

    MarlinTileGenerator init() {
        this.x = this.cache.bboxX0;
        this.y = this.cache.bboxY0;
        return this;
    }

    @Override
    public void dispose() {
        this.cache.dispose();
        this.rdr.dispose();
        MarlinRenderingEngine.returnRendererContext(this.rdr.rdrCtx);
    }

    void getBbox(int[] nArray) {
        nArray[0] = this.cache.bboxX0;
        nArray[1] = this.cache.bboxY0;
        nArray[2] = this.cache.bboxX1;
        nArray[3] = this.cache.bboxY1;
    }

    @Override
    public int getTileWidth() {
        return TILE_SIZE;
    }

    @Override
    public int getTileHeight() {
        return TILE_SIZE;
    }

    @Override
    public int getTypicalAlpha() {
        int n;
        int n2 = this.cache.alphaSumInTile(this.x);
        int n3 = n2 == 0 ? 0 : (n = n2 == MAX_TILE_ALPHA_SUM ? 255 : 128);
        if (doStats) {
            RendererContext.stats.hist_tile_generator_alpha.add(n);
        }
        return n;
    }

    @Override
    public void nextTile() {
        if ((this.x += TILE_SIZE) >= this.cache.bboxX1) {
            this.x = this.cache.bboxX0;
            this.y += TILE_SIZE;
            if (this.y < this.cache.bboxY1) {
                this.rdr.endRendering(this.y);
            }
        }
    }

    @Override
    public void getAlpha(byte[] byArray, int n, int n2) {
        if (this.cache.useRLE) {
            this.getAlphaRLE(byArray, n, n2);
        } else {
            this.getAlphaNoRLE(byArray, n, n2);
        }
    }

    private void getAlphaNoRLE(byte[] byArray, int n, int n2) {
        MarlinCache marlinCache = this.cache;
        long[] lArray = marlinCache.rowAAChunkIndex;
        int[] nArray = marlinCache.rowAAx0;
        int[] nArray2 = marlinCache.rowAAx1;
        int n3 = this.x;
        int n4 = FloatMath.min(n3 + TILE_SIZE, marlinCache.bboxX1);
        int n5 = FloatMath.min(this.y + TILE_SIZE, marlinCache.bboxY1) - this.y;
        if (doLogBounds) {
            MarlinUtils.logInfo("getAlpha = [" + n3 + " ... " + n4 + "[ [" + 0 + " ... " + n5 + "[");
        }
        Unsafe unsafe = OffHeapArray.unsafe;
        long l = marlinCache.rowAAChunk.address;
        int n6 = n2 - (n4 - n3);
        int n7 = n;
        for (int i = 0; i < n5; ++i) {
            int n8;
            int n9 = n3;
            int n10 = nArray2[i];
            if (n10 > n3 && (n8 = nArray[i]) < n4) {
                int n11;
                n9 = n8;
                if (n9 <= n3) {
                    n9 = n3;
                } else {
                    for (n11 = n3; n11 < n9; ++n11) {
                        byArray[n7++] = 0;
                    }
                }
                long l2 = l + lArray[i] + (long)(n9 - n8);
                int n12 = n11 = n10 <= n4 ? n10 : n4;
                while (n9 < n11) {
                    byArray[n7++] = unsafe.getByte(l2);
                    ++l2;
                    ++n9;
                }
            }
            while (n9 < n4) {
                byArray[n7++] = 0;
                ++n9;
            }
            if (doTrace) {
                for (int j = n7 - (n4 - n3); j < n7; ++j) {
                    System.out.print(MarlinTileGenerator.hex(byArray[j], 2));
                }
                System.out.println();
            }
            n7 += n6;
        }
        this.nextTile();
    }

    private void getAlphaRLE(byte[] byArray, int n, int n2) {
        MarlinCache marlinCache = this.cache;
        long[] lArray = marlinCache.rowAAChunkIndex;
        int[] nArray = marlinCache.rowAAx0;
        int[] nArray2 = marlinCache.rowAAx1;
        int[] nArray3 = marlinCache.rowAAEnc;
        long[] lArray2 = marlinCache.rowAALen;
        long[] lArray3 = marlinCache.rowAAPos;
        int n3 = this.x;
        int n4 = FloatMath.min(n3 + TILE_SIZE, marlinCache.bboxX1);
        int n5 = FloatMath.min(this.y + TILE_SIZE, marlinCache.bboxY1) - this.y;
        if (doLogBounds) {
            MarlinUtils.logInfo("getAlpha = [" + n3 + " ... " + n4 + "[ [" + 0 + " ... " + n5 + "[");
        }
        Unsafe unsafe = OffHeapArray.unsafe;
        long l = marlinCache.rowAAChunk.address;
        int n6 = n2 - (n4 - n3);
        int n7 = n;
        for (int i = 0; i < n5; ++i) {
            long l2;
            int n8;
            int n9 = n3;
            if (nArray3[i] == 0) {
                int n10;
                n8 = nArray2[i];
                if (n8 > n3 && (n10 = nArray[i]) < n4) {
                    int n11;
                    n9 = n10;
                    if (n9 <= n3) {
                        n9 = n3;
                    } else {
                        for (n11 = n3; n11 < n9; ++n11) {
                            byArray[n7++] = 0;
                        }
                    }
                    l2 = l + lArray[i] + (long)(n9 - n10);
                    int n12 = n11 = n8 <= n4 ? n8 : n4;
                    while (n9 < n11) {
                        byArray[n7++] = unsafe.getByte(l2);
                        ++l2;
                        ++n9;
                    }
                }
            } else if (nArray2[i] > n3) {
                n9 = nArray[i];
                if (n9 > n4) {
                    n9 = n4;
                }
                for (n8 = n3; n8 < n9; ++n8) {
                    byArray[n7++] = 0;
                }
                long l3 = l + lArray[i];
                long l4 = l3 + lArray2[i];
                l2 = l3 + lArray3[i];
                long l5 = 0L;
                while (n9 < n4 && l2 < l4) {
                    int n13;
                    int n14;
                    l5 = l2;
                    int n15 = unsafe.getInt(l2);
                    int n16 = n15 >> 8;
                    l2 += 4L;
                    int n17 = n9;
                    if (n17 < n3) {
                        n17 = n3;
                    }
                    if ((n14 = (n9 = n16)) > n4) {
                        n14 = n4;
                        n9 = n4;
                    }
                    if ((n13 = n14 - n17) <= 0) continue;
                    byte by = (byte)(n15 & 0xFF);
                    do {
                        byArray[n7++] = by;
                    } while (--n13 > 0);
                }
                if (l5 != 0L) {
                    nArray[i] = n9;
                    lArray3[i] = l5 - l3;
                }
            }
            while (n9 < n4) {
                byArray[n7++] = 0;
                ++n9;
            }
            if (doTrace) {
                for (n8 = n7 - (n4 - n3); n8 < n7; ++n8) {
                    System.out.print(MarlinTileGenerator.hex(byArray[n8], 2));
                }
                System.out.println();
            }
            n7 += n6;
        }
        this.nextTile();
    }

    static String hex(int n, int n2) {
        String string = Integer.toHexString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string.substring(0, n2);
    }
}

