/*
 * Decompiled with CFR 0.152.
 */
package com.babbel.mobile.android.commons.okhttpawssigner.internal;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0000\u001a\f\u0010\t\u001a\u00020\u0001*\u00020\u0006H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"HASHING_ALGORITHM", "", "MAC_ALGORITHM", "hash", "value", "hmacSha256", "", "key", "data", "toHexString", "okhttp-aws-signer"})
public final class HashingKt {
    @NotNull
    public static final String HASHING_ALGORITHM = "SHA-256";
    @NotNull
    public static final String MAC_ALGORITHM = "HmacSHA256";

    @NotNull
    public static final String hash(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        MessageDigest md = MessageDigest.getInstance(HASHING_ALGORITHM);
        byte[] digest = md.digest(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)digest, (String)"digest");
        return HashingKt.toHexString(digest);
    }

    @NotNull
    public static final byte[] hmacSha256(@NotNull byte[] key, @NotNull String data) throws Exception {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Mac sha256Hmac = Mac.getInstance(MAC_ALGORITHM);
        SecretKeySpec secretKey = new SecretKeySpec(key, MAC_ALGORITHM);
        sha256Hmac.init(secretKey);
        String string = data;
        Object object = "UTF-8";
        boolean bl = false;
        Charset charset = Charset.forName((String)object);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(charsetName)");
        object = charset;
        bl = false;
        byte[] byArray = string.getBytes((Charset)object);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = sha256Hmac.doFinal(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"sha256Hmac.doFinal(data.\u2026eArray(charset(\"UTF-8\")))");
        return byArray2;
    }

    @NotNull
    public static final byte[] hmacSha256(@NotNull String key, @NotNull String data) throws Exception {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = key;
        Charset charset = Charset.forName("utf-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(\"utf-8\")");
        Charset charset2 = charset;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return HashingKt.hmacSha256(byArray, data);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toHexString(@NotNull byte[] $this$toHexString) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toHexString, (String)"$this$toHexString");
        byte[] byArray = $this$toHexString;
        String initial$iv = "";
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        void var5_5 = $this$fold$iv;
        int n = ((void)var5_5).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv;
            void var9_9 = element$iv = var5_5[i];
            String str = accumulator$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append(str);
            String string = "%02x";
            Object[] objectArray = new Object[]{(byte)it};
            boolean bl2 = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
            accumulator$iv = stringBuilder.append(string2).toString();
        }
        return accumulator$iv;
    }
}

