/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elasticmapreduce.model.transform.ConfigurationMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Configuration
implements Serializable,
Cloneable,
StructuredPojo {
    private String classification;
    private SdkInternalList<Configuration> configurations;
    private SdkInternalMap<String, String> properties;

    public void setClassification(String classification) {
        this.classification = classification;
    }

    public String getClassification() {
        return this.classification;
    }

    public Configuration withClassification(String classification) {
        this.setClassification(classification);
        return this;
    }

    public List<Configuration> getConfigurations() {
        if (this.configurations == null) {
            this.configurations = new SdkInternalList();
        }
        return this.configurations;
    }

    public void setConfigurations(Collection<Configuration> configurations) {
        if (configurations == null) {
            this.configurations = null;
            return;
        }
        this.configurations = new SdkInternalList(configurations);
    }

    public Configuration withConfigurations(Configuration ... configurations) {
        if (this.configurations == null) {
            this.setConfigurations((Collection<Configuration>)new SdkInternalList(configurations.length));
        }
        for (Configuration ele : configurations) {
            this.configurations.add((Object)ele);
        }
        return this;
    }

    public Configuration withConfigurations(Collection<Configuration> configurations) {
        this.setConfigurations(configurations);
        return this;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new SdkInternalMap();
        }
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties == null ? null : new SdkInternalMap(properties);
    }

    public Configuration withProperties(Map<String, String> properties) {
        this.setProperties(properties);
        return this;
    }

    public Configuration addPropertiesEntry(String key, String value) {
        if (null == this.properties) {
            this.properties = new SdkInternalMap();
        }
        if (this.properties.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.properties.put((Object)key, (Object)value);
        return this;
    }

    public Configuration clearPropertiesEntries() {
        this.properties = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClassification() != null) {
            sb.append("Classification: ").append(this.getClassification()).append(",");
        }
        if (this.getConfigurations() != null) {
            sb.append("Configurations: ").append(this.getConfigurations()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)obj;
        if (other.getClassification() == null ^ this.getClassification() == null) {
            return false;
        }
        if (other.getClassification() != null && !other.getClassification().equals(this.getClassification())) {
            return false;
        }
        if (other.getConfigurations() == null ^ this.getConfigurations() == null) {
            return false;
        }
        if (other.getConfigurations() != null && !other.getConfigurations().equals(this.getConfigurations())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        return other.getProperties() == null || other.getProperties().equals(this.getProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClassification() == null ? 0 : this.getClassification().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurations() == null ? 0 : this.getConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        return hashCode;
    }

    public Configuration clone() {
        try {
            return (Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

