/* next-pieces-widget.c generated by valac 0.56.0, the Vala compiler
 * generated from next-pieces-widget.vala, do not modify */

/*
 * Color lines for GNOME
 * Copyright © 1999 Free Software Foundation
 * Authors: Robert Szokovacs <szo@szo.hu>
 *          Szabolcs Ban <shooby@gnome.hu>
 *          Karuna Grewal <karunagrewal98@gmail.com>
 *          Ruxandra Simion <ruxandra.simion93@gmail.com>
 * Copyright © 2007 Christian Persch
 *
 * This game is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>

#define FIVE_OR_MORE_APP_KEY_SIZE "size"
#define THEME_RENDERER_DEFAULT_SPRITE_SIZE 20
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_NEXT_PIECES_WIDGET (next_pieces_widget_get_type ())
#define NEXT_PIECES_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NEXT_PIECES_WIDGET, NextPiecesWidget))
#define NEXT_PIECES_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NEXT_PIECES_WIDGET, NextPiecesWidgetClass))
#define IS_NEXT_PIECES_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NEXT_PIECES_WIDGET))
#define IS_NEXT_PIECES_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NEXT_PIECES_WIDGET))
#define NEXT_PIECES_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NEXT_PIECES_WIDGET, NextPiecesWidgetClass))

typedef struct _NextPiecesWidget NextPiecesWidget;
typedef struct _NextPiecesWidgetClass NextPiecesWidgetClass;
typedef struct _NextPiecesWidgetPrivate NextPiecesWidgetPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_THEME_RENDERER (theme_renderer_get_type ())
#define THEME_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_RENDERER, ThemeRenderer))
#define THEME_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_RENDERER, ThemeRendererClass))
#define IS_THEME_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_RENDERER))
#define IS_THEME_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_RENDERER))
#define THEME_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_RENDERER, ThemeRendererClass))

typedef struct _ThemeRenderer ThemeRenderer;
typedef struct _ThemeRendererClass ThemeRendererClass;

#define TYPE_PIECE (piece_get_type ())
#define PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIECE, Piece))
#define PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIECE, PieceClass))
#define IS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIECE))
#define IS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIECE))
#define PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIECE, PieceClass))

typedef struct _Piece Piece;
typedef struct _PieceClass PieceClass;
enum  {
	NEXT_PIECES_WIDGET_0_PROPERTY,
	NEXT_PIECES_WIDGET_NUM_PROPERTIES
};
static GParamSpec* next_pieces_widget_properties[NEXT_PIECES_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _theme_renderer_unref0(var) ((var == NULL) ? NULL : (var = (theme_renderer_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GamePrivate GamePrivate;

#define TYPE_BOARD (board_get_type ())
#define BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD, Board))
#define BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD, BoardClass))
#define IS_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD))
#define IS_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD))
#define BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD, BoardClass))

typedef struct _Board Board;
typedef struct _BoardClass BoardClass;

#define TYPE_CELL (cell_get_type ())
#define CELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CELL, Cell))
#define CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CELL, CellClass))
#define IS_CELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CELL))
#define IS_CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CELL))
#define CELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CELL, CellClass))

typedef struct _Cell Cell;
typedef struct _CellClass CellClass;
typedef struct _PiecePrivate PiecePrivate;
#define _piece_unref0(var) ((var == NULL) ? NULL : (var = (piece_unref (var), NULL)))

struct _NextPiecesWidget {
	GtkDrawingArea parent_instance;
	NextPiecesWidgetPrivate * priv;
};

struct _NextPiecesWidgetClass {
	GtkDrawingAreaClass parent_class;
};

struct _NextPiecesWidgetPrivate {
	GSettings* settings;
	Game* game;
	ThemeRenderer* theme;
	GeeArrayList* local_pieces_queue;
	gint widget_height;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Board* board;
	gint n_next_pieces;
	gint n_filled_cells;
	GeeArrayList* current_path;
	gboolean animating;
	Piece* animating_piece;
	gint n_categories;
	gchar* score_current_category;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _Piece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PiecePrivate * priv;
	gint id;
};

struct _PieceClass {
	GTypeClass parent_class;
	void (*finalize) (Piece *self);
};

static gint NextPiecesWidget_private_offset;
static gpointer next_pieces_widget_parent_class = NULL;

VALA_EXTERN GType next_pieces_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NextPiecesWidget, g_object_unref)
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN gpointer theme_renderer_ref (gpointer instance);
VALA_EXTERN void theme_renderer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_theme_renderer (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_theme_renderer (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_theme_renderer (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_theme_renderer (const GValue* value);
VALA_EXTERN GType theme_renderer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeRenderer, theme_renderer_unref)
VALA_EXTERN gpointer piece_ref (gpointer instance);
VALA_EXTERN void piece_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_piece (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_piece (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_piece (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_piece (const GValue* value);
VALA_EXTERN GType piece_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Piece, piece_unref)
VALA_EXTERN NextPiecesWidget* next_pieces_widget_new (GSettings* settings,
                                          Game* game,
                                          ThemeRenderer* theme);
VALA_EXTERN NextPiecesWidget* next_pieces_widget_construct (GType object_type,
                                                GSettings* settings,
                                                Game* game,
                                                ThemeRenderer* theme);
static void next_pieces_widget_set_queue_size (NextPiecesWidget* self);
static void __lambda4_ (NextPiecesWidget* self);
static void ___lambda4__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
VALA_EXTERN GeeArrayList* game_get_next_pieces_queue (Game* self);
static void next_pieces_widget_queue_changed_cb (NextPiecesWidget* self,
                                          GeeArrayList* next_pieces_queue);
static void _next_pieces_widget_queue_changed_cb_game_queue_changed (Game* _sender,
                                                              GeeArrayList* next_pieces_queue,
                                                              gpointer self);
VALA_EXTERN gpointer board_ref (gpointer instance);
VALA_EXTERN void board_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_board (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_board (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_board (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_board (const GValue* value);
VALA_EXTERN GType board_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Board, board_unref)
VALA_EXTERN gpointer cell_ref (gpointer instance);
VALA_EXTERN void cell_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_cell (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_cell (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_cell (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_cell (const GValue* value);
VALA_EXTERN GType cell_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Cell, cell_unref)
static gboolean next_pieces_widget_real_draw (GtkWidget* base,
                                       cairo_t* cr);
VALA_EXTERN void theme_renderer_render_sprite (ThemeRenderer* self,
                                   cairo_t* cr,
                                   gint type,
                                   gint animation,
                                   gdouble x,
                                   gdouble y,
                                   gint size);
static void next_pieces_widget_finalize (GObject * obj);
static GType next_pieces_widget_get_type_once (void);

static inline gpointer
next_pieces_widget_get_instance_private (NextPiecesWidget* self)
{
	return G_STRUCT_MEMBER_P (self, NextPiecesWidget_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_theme_renderer_ref0 (gpointer self)
{
	return self ? theme_renderer_ref (self) : NULL;
}

static void
__lambda4_ (NextPiecesWidget* self)
{
	next_pieces_widget_set_queue_size (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
___lambda4__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
	__lambda4_ ((NextPiecesWidget*) self);
}

static void
_next_pieces_widget_queue_changed_cb_game_queue_changed (Game* _sender,
                                                         GeeArrayList* next_pieces_queue,
                                                         gpointer self)
{
	next_pieces_widget_queue_changed_cb ((NextPiecesWidget*) self, next_pieces_queue);
}

NextPiecesWidget*
next_pieces_widget_construct (GType object_type,
                              GSettings* settings,
                              Game* game,
                              ThemeRenderer* theme)
{
	NextPiecesWidget * self = NULL;
	GSettings* _tmp0_;
	Game* _tmp1_;
	ThemeRenderer* _tmp2_;
	gchar* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (game != NULL, NULL);
	g_return_val_if_fail (theme != NULL, NULL);
	self = (NextPiecesWidget*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = _g_object_ref0 (game);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp1_;
	_tmp2_ = _theme_renderer_ref0 (theme);
	_theme_renderer_unref0 (self->priv->theme);
	self->priv->theme = _tmp2_;
	next_pieces_widget_set_queue_size (self);
	_tmp3_ = g_strconcat ("changed::", FIVE_OR_MORE_APP_KEY_SIZE, NULL);
	g_signal_connect_object (settings, _tmp3_, (GCallback) ___lambda4__g_settings_changed, self, 0);
	_g_free0 (_tmp3_);
	_tmp4_ = game_get_next_pieces_queue (game);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->local_pieces_queue);
	self->priv->local_pieces_queue = _tmp6_;
	_tmp7_ = self->priv->local_pieces_queue;
	next_pieces_widget_queue_changed_cb (self, _tmp7_);
	g_signal_connect_object (game, "queue-changed", (GCallback) _next_pieces_widget_queue_changed_cb_game_queue_changed, self, 0);
	return self;
}

NextPiecesWidget*
next_pieces_widget_new (GSettings* settings,
                        Game* game,
                        ThemeRenderer* theme)
{
	return next_pieces_widget_construct (TYPE_NEXT_PIECES_WIDGET, settings, game, theme);
}

static void
next_pieces_widget_set_queue_size (NextPiecesWidget* self)
{
	Game* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	gtk_widget_set_size_request ((GtkWidget*) self, THEME_RENDERER_DEFAULT_SPRITE_SIZE * _tmp0_->n_next_pieces, THEME_RENDERER_DEFAULT_SPRITE_SIZE);
}

static void
next_pieces_widget_queue_changed_cb (NextPiecesWidget* self,
                                     GeeArrayList* next_pieces_queue)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (next_pieces_queue != NULL);
	_tmp0_ = _g_object_ref0 (next_pieces_queue);
	_g_object_unref0 (self->priv->local_pieces_queue);
	self->priv->local_pieces_queue = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static gboolean
next_pieces_widget_real_draw (GtkWidget* base,
                              cairo_t* cr)
{
	NextPiecesWidget * self;
	ThemeRenderer* _tmp0_;
	GdkRGBA background_color = {0};
	GdkRGBA _tmp1_;
	gboolean result;
	self = (NextPiecesWidget*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = self->priv->theme;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	if (self->priv->widget_height == -1) {
		self->priv->widget_height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	}
	memset (&background_color, 0, sizeof (GdkRGBA));
	background_color.alpha = (gdouble) 0;
	background_color.blue = background_color.alpha;
	background_color.green = background_color.blue;
	background_color.red = background_color.green;
	_tmp1_ = background_color;
	gdk_cairo_set_source_rgba (cr, &_tmp1_);
	cairo_paint (cr);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				ThemeRenderer* _tmp7_;
				GeeArrayList* _tmp8_;
				gpointer _tmp9_;
				Piece* _tmp10_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = self->priv->local_pieces_queue;
				_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
				_tmp6_ = _tmp5_;
				if (!(i < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->theme;
				_tmp8_ = self->priv->local_pieces_queue;
				_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, i);
				_tmp10_ = (Piece*) _tmp9_;
				theme_renderer_render_sprite (_tmp7_, cr, _tmp10_->id, 0, (gdouble) (i * THEME_RENDERER_DEFAULT_SPRITE_SIZE), (gdouble) ((self->priv->widget_height / 2) - (THEME_RENDERER_DEFAULT_SPRITE_SIZE / 2)), THEME_RENDERER_DEFAULT_SPRITE_SIZE);
				_piece_unref0 (_tmp10_);
			}
		}
	}
	cairo_stroke (cr);
	result = TRUE;
	return result;
}

static void
next_pieces_widget_class_init (NextPiecesWidgetClass * klass,
                               gpointer klass_data)
{
	next_pieces_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NextPiecesWidget_private_offset);
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) next_pieces_widget_real_draw;
	G_OBJECT_CLASS (klass)->finalize = next_pieces_widget_finalize;
}

static void
next_pieces_widget_instance_init (NextPiecesWidget * self,
                                  gpointer klass)
{
	self->priv = next_pieces_widget_get_instance_private (self);
	self->priv->widget_height = -1;
}

static void
next_pieces_widget_finalize (GObject * obj)
{
	NextPiecesWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NEXT_PIECES_WIDGET, NextPiecesWidget);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->game);
	_theme_renderer_unref0 (self->priv->theme);
	_g_object_unref0 (self->priv->local_pieces_queue);
	G_OBJECT_CLASS (next_pieces_widget_parent_class)->finalize (obj);
}

static GType
next_pieces_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NextPiecesWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) next_pieces_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NextPiecesWidget), 0, (GInstanceInitFunc) next_pieces_widget_instance_init, NULL };
	GType next_pieces_widget_type_id;
	next_pieces_widget_type_id = g_type_register_static (gtk_drawing_area_get_type (), "NextPiecesWidget", &g_define_type_info, 0);
	NextPiecesWidget_private_offset = g_type_add_instance_private (next_pieces_widget_type_id, sizeof (NextPiecesWidgetPrivate));
	return next_pieces_widget_type_id;
}

GType
next_pieces_widget_get_type (void)
{
	static volatile gsize next_pieces_widget_type_id__once = 0;
	if (g_once_init_enter (&next_pieces_widget_type_id__once)) {
		GType next_pieces_widget_type_id;
		next_pieces_widget_type_id = next_pieces_widget_get_type_once ();
		g_once_init_leave (&next_pieces_widget_type_id__once, next_pieces_widget_type_id);
	}
	return next_pieces_widget_type_id__once;
}

