/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import net.osmand.Location;
import net.osmand.data.LatLon;
import net.osmand.plus.GPXUtilities;
import net.osmand.plus.routing.RouteCalculationResult;
import net.osmand.router.RouteSegmentResult;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.actions.OffRoadAction;
import net.sourceforge.offroad.data.ElevationHelper;
import net.sourceforge.offroad.ui.GraphPanel;

public class ShowRouteDetailsAction
extends OffRoadAction
implements ElevationHelper.LatLonGeneralization {
    private RouteCalculationResult mRouteCalculationResult;
    private List<RouteHolder> mRouteHolderList;
    private GraphPanel mGraphPanel;
    private JTextPane mContentDisplay;
    private boolean mAdjustmentCancelled;
    private ElevationHelper mElevationHelper;
    private long now = System.currentTimeMillis();

    public ShowRouteDetailsAction(OsmWindow pContext, RouteCalculationResult pRouteCalculationResult) {
        super(pContext, pContext.getOffRoadString("offroad.route_details"), null);
        this.mRouteCalculationResult = pRouteCalculationResult;
        this.mElevationHelper = new ElevationHelper();
        List<RouteSegmentResult> pts = this.mRouteCalculationResult.getOriginalRoute();
        List<Location> locations = this.mRouteCalculationResult.getImmutableAllLocations();
        int index = 0;
        this.mRouteHolderList = new ArrayList<RouteHolder>();
        for (RouteSegmentResult rsr : pts) {
            int i = rsr.getStartPointIndex();
            while (i != rsr.getEndPointIndex()) {
                if (locations.size() > index) {
                    if (!locations.get(index).getLatLon().equals(rsr.getPoint(i))) {
                        log.error((Object)("Location doesn't coincide " + index));
                    }
                    RouteHolder holder = new RouteHolder(rsr, i, locations.get(index));
                    this.mRouteHolderList.add(holder);
                    log.debug((Object)("Adding segment result " + rsr + " and index " + i + " and time " + holder.getTime()));
                } else {
                    log.error((Object)("Not enough locations present : " + index));
                }
                i = rsr.isForwardDirection() ? ++i : --i;
                ++index;
            }
        }
        if (index != locations.size()) {
            log.error((Object)("Not all locations of " + locations.size() + " used, but only " + index));
        }
    }

    @Override
    public void actionPerformed(ActionEvent pE) {
        this.createDialog();
        String title = (String)this.getValue("Name");
        this.mDialog.setTitle(title);
        Container contentPane = this.mDialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        gbl.columnWeights = new double[]{1.0};
        gbl.rowWeights = new double[]{1.0};
        contentPane.setLayout(gbl);
        int y = 0;
        this.mContentDisplay = new JTextPane();
        this.mContentDisplay.setContentType("text/html");
        this.updateAnalysis();
        this.mContentDisplay.setEditable(false);
        this.mContentDisplay.setBackground(null);
        this.mContentDisplay.setBorder(null);
        contentPane.add((Component)new JScrollPane(this.mContentDisplay), new GridBagConstraints(0, y++, 4, 1, 4.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mGraphPanel = new GraphPanel(new TreeMap<Long, Double>());
        this.updateGraphPanel();
        contentPane.add((Component)this.mGraphPanel, new GridBagConstraints(0, y++, 4, 1, 4.0, 10.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        final JButton adjustElevationButton = new JButton(this.mContext.getOffRoadString("offroad.adjust_elevation_calculation"));
        final JButton cancelElevationButton = new JButton(this.mContext.getOffRoadString("offroad.cancel_elevation_calculation"));
        cancelElevationButton.setEnabled(false);
        adjustElevationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ShowRouteDetailsAction.this.mContext.setWaitingCursor(true);
                        ShowRouteDetailsAction.this.mGraphPanel.setBackgroundColor(Color.LIGHT_GRAY);
                        ShowRouteDetailsAction.this.mGraphPanel.setDrawText(ShowRouteDetailsAction.this.mContext.getOffRoadString("offroad.Calculating"));
                        ShowRouteDetailsAction.this.mAdjustmentCancelled = false;
                        adjustElevationButton.setEnabled(false);
                        cancelElevationButton.setEnabled(true);
                        try {
                            ShowRouteDetailsAction.this.mElevationHelper.adjustElevations(ShowRouteDetailsAction.this, ShowRouteDetailsAction.this.mContext.getRenderer().getMetaInfoFiles());
                        }
                        finally {
                            adjustElevationButton.setEnabled(true);
                            cancelElevationButton.setEnabled(false);
                            ShowRouteDetailsAction.this.mContext.setWaitingCursor(false);
                            ShowRouteDetailsAction.this.updateAnalysis();
                            ShowRouteDetailsAction.this.updateGraphPanel();
                            ShowRouteDetailsAction.this.mGraphPanel.setBackgroundColor(Color.WHITE);
                            ShowRouteDetailsAction.this.mGraphPanel.setDrawText(null);
                        }
                    }
                }).start();
            }
        });
        cancelElevationButton.addActionListener(l -> {
            this.mAdjustmentCancelled = true;
        });
        contentPane.add((Component)adjustElevationButton, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        contentPane.add((Component)cancelElevationButton, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JButton okButton = new JButton(this.mContext.getString(720));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                ShowRouteDetailsAction.this.disposeDialog();
            }
        });
        contentPane.add((Component)okButton, new GridBagConstraints(3, y++, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mDialog.getRootPane().setDefaultButton(okButton);
        this.mDialog.pack();
        this.decorateDialog();
        this.mDialog.setVisible(true);
    }

    public void updateAnalysis() {
        GPXUtilities.GPXFile gpxFile = this.mContext.getRoutingHelper().generateGPXFileWithRoute();
        GPXUtilities.GPXTrackAnalysis analysis = gpxFile.getAnalysis(System.currentTimeMillis());
        String content = "<table border='2'><thead><th>Key</th><th>Value</th></thead><tbody>";
        String inBrk = "</td><td align='right'>";
        content = content + "<tr><td>" + this.mContext.getOffRoadString("totalDistance") + inBrk + this.toDist(this.mRouteCalculationResult.getWholeDistance()) + "</td></tr>";
        content = content + "<tr><td>" + this.mContext.getOffRoadString("totalTime") + inBrk + this.toTimeString((long)(this.mRouteCalculationResult.getRoutingTime() * 1000.0f)) + "</td></tr>";
        content = content + "<tr><td>" + this.mContext.getOffRoadString("totalDistance") + inBrk + this.toDist(analysis.totalDistance) + "</td></tr>";
        if (analysis.isTimeMoving()) {
            content = content + "<tr><td>" + this.mContext.getOffRoadString("totalDistanceMoving") + inBrk + this.toDist(analysis.totalDistanceMoving) + "</td></tr>";
        }
        content = content + "<tr><td>" + this.mContext.getOffRoadString("points") + inBrk + analysis.points + "</td></tr>";
        if (analysis.isElevationSpecified()) {
            content = content + "<tr><td>" + this.mContext.getOffRoadString("minElevation") + inBrk + this.toDist(analysis.minElevation) + "</td></tr>";
            content = content + "<tr><td>" + this.mContext.getOffRoadString("maxElevation") + inBrk + this.toDist(analysis.maxElevation) + "</td></tr>";
            content = content + "<tr><td>" + this.mContext.getOffRoadString("diffElevation") + inBrk + this.toDist(analysis.maxElevation - analysis.minElevation) + "</td></tr>";
            content = content + "<tr><td>" + this.mContext.getOffRoadString("diffElevationUp") + inBrk + this.toDist(analysis.diffElevationUp) + "</td></tr>";
            content = content + "<tr><td>" + this.mContext.getOffRoadString("diffElevationDown") + inBrk + this.toDist(analysis.diffElevationDown) + "</td></tr>";
            content = content + "<tr><td>" + this.mContext.getOffRoadString("avgElevation") + inBrk + this.toDist(analysis.avgElevation) + "</td></tr>";
        }
        content = content + "</tbody></table";
        this.mContentDisplay.setText(content);
    }

    private String toVelocity(float pValue) {
        return MessageFormat.format("{0,number,#.##} km/h", Float.valueOf(pValue));
    }

    @Override
    public void updateGraphPanel() {
        TreeMap<Long, Double> elevation = new TreeMap<Long, Double>();
        long totalTime = this.now;
        for (RouteHolder routeHolder : this.mRouteHolderList) {
            elevation.put(new Long(totalTime), routeHolder.getElevation());
            totalTime += (long)routeHolder.getTime();
        }
        this.mGraphPanel.setScores(elevation);
    }

    private String toDist(double pValue) {
        return MessageFormat.format("{0,number,#} m", pValue);
    }

    private String toTimeString(long pF) {
        return DateFormat.getTimeInstance().format(pF);
    }

    @Override
    public List<ElevationHelper.LatLonHolder> getPoints() {
        ArrayList<ElevationHelper.LatLonHolder> res = new ArrayList<ElevationHelper.LatLonHolder>();
        res.addAll(this.mRouteHolderList);
        return res;
    }

    @Override
    public boolean isCancelled() {
        return this.mAdjustmentCancelled;
    }

    private static class RouteHolder
    implements ElevationHelper.LatLonHolder {
        private int mIndex;
        public RouteSegmentResult mRsr;
        private LatLon mLatLon;
        private Location mLocation;

        public RouteHolder(RouteSegmentResult pRsr, int pIndex, Location pLocation) {
            this.mRsr = pRsr;
            this.mIndex = pIndex;
            this.mLocation = pLocation;
            this.mLatLon = pLocation.getLatLon();
        }

        public float getTime() {
            return this.mRsr.getSegmentTime() * 1000.0f / (float)Math.abs(this.mRsr.getStartPointIndex() - this.mRsr.getEndPointIndex());
        }

        @Override
        public LatLon getLatLon() {
            return this.mLatLon;
        }

        @Override
        public double getLatitude() {
            return this.getLatLon().getLatitude();
        }

        @Override
        public double getLongitude() {
            return this.getLatLon().getLongitude();
        }

        @Override
        public void setElevation(double pEle1) {
            this.mLocation.setAltitude(pEle1);
        }

        @Override
        public double getElevation() {
            return this.mLocation.getAltitude();
        }
    }
}

