/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.opensearch.neuralsearch.search.util.HybridSearchResultFormatUtil;

public class CompoundTopDocs {
    @Generated
    private static final Logger log = LogManager.getLogger(CompoundTopDocs.class);
    private TotalHits totalHits;
    private List<TopDocs> topDocs;
    private List<ScoreDoc> scoreDocs;

    public CompoundTopDocs(TotalHits totalHits, List<TopDocs> topDocs) {
        this.initialize(totalHits, topDocs);
    }

    private void initialize(TotalHits totalHits, List<TopDocs> topDocs) {
        this.totalHits = totalHits;
        this.topDocs = topDocs;
        this.scoreDocs = this.cloneLargestScoreDocs(topDocs);
    }

    public CompoundTopDocs(TopDocs topDocs) {
        ScoreDoc[] scoreDocs = topDocs.scoreDocs;
        if (Objects.isNull(scoreDocs) || scoreDocs.length < 2) {
            this.initialize(topDocs.totalHits, new ArrayList<TopDocs>());
            return;
        }
        ArrayList<TopDocs> topDocsList = new ArrayList<TopDocs>();
        ArrayList<ScoreDoc> scoreDocList = new ArrayList<ScoreDoc>();
        for (int index = 2; index < scoreDocs.length; ++index) {
            ScoreDoc scoreDoc = scoreDocs[index];
            if (HybridSearchResultFormatUtil.isHybridQueryDelimiterElement(scoreDoc) || HybridSearchResultFormatUtil.isHybridQueryStartStopElement(scoreDoc)) {
                ScoreDoc[] subQueryScores = scoreDocList.toArray(new ScoreDoc[0]);
                TotalHits totalHits = new TotalHits((long)subQueryScores.length, TotalHits.Relation.EQUAL_TO);
                TopDocs subQueryTopDocs = new TopDocs(totalHits, subQueryScores);
                topDocsList.add(subQueryTopDocs);
                scoreDocList.clear();
                continue;
            }
            scoreDocList.add(scoreDoc);
        }
        this.initialize(topDocs.totalHits, topDocsList);
    }

    private List<ScoreDoc> cloneLargestScoreDocs(List<TopDocs> docs) {
        if (docs == null) {
            return null;
        }
        ScoreDoc[] maxScoreDocs = new ScoreDoc[]{};
        int maxLength = -1;
        for (TopDocs topDoc : docs) {
            if (topDoc == null || topDoc.scoreDocs == null || topDoc.scoreDocs.length <= maxLength) continue;
            maxLength = topDoc.scoreDocs.length;
            maxScoreDocs = topDoc.scoreDocs;
        }
        return Arrays.stream(maxScoreDocs).map(doc -> new ScoreDoc(doc.doc, doc.score, doc.shardIndex)).collect(Collectors.toList());
    }

    @Generated
    public CompoundTopDocs(TotalHits totalHits, List<TopDocs> topDocs, List<ScoreDoc> scoreDocs) {
        this.totalHits = totalHits;
        this.topDocs = topDocs;
        this.scoreDocs = scoreDocs;
    }

    @Generated
    public TotalHits getTotalHits() {
        return this.totalHits;
    }

    @Generated
    public List<TopDocs> getTopDocs() {
        return this.topDocs;
    }

    @Generated
    public List<ScoreDoc> getScoreDocs() {
        return this.scoreDocs;
    }

    @Generated
    public String toString() {
        return "CompoundTopDocs(totalHits=" + this.getTotalHits() + ", topDocs=" + this.getTopDocs() + ", scoreDocs=" + this.getScoreDocs() + ")";
    }

    @Generated
    public void setTotalHits(TotalHits totalHits) {
        this.totalHits = totalHits;
    }

    @Generated
    public void setScoreDocs(List<ScoreDoc> scoreDocs) {
        this.scoreDocs = scoreDocs;
    }
}

