
use builtin;
use str;

set edit:completion:arg-completer[uv] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'uv'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'uv'= {
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
            cand pip 'Resolve and install Python packages'
            cand venv 'Create a virtual environment'
            cand cache 'Manage the cache'
            cand self 'Manage the `uv` executable'
            cand clean 'Remove all items from the cache'
            cand version 'Display uv''s version'
            cand generate-shell-completion 'Generate shell completion'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;pip'= {
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
            cand compile 'Compile a `requirements.in` file to a `requirements.txt` file'
            cand sync 'Sync dependencies from a `requirements.txt` file'
            cand install 'Install packages into the current environment'
            cand uninstall 'Uninstall packages from the current environment'
            cand freeze 'Enumerate the installed packages in the current environment'
            cand list 'Enumerate the installed packages in the current environment'
            cand show 'Show information about one or more installed packages'
            cand check 'Verify installed packages have compatible dependencies'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;pip;compile'= {
            cand -c 'Constrain versions using the given requirements files'
            cand --constraint 'Constrain versions using the given requirements files'
            cand --override 'Override versions using the given requirements files'
            cand --extra 'Include optional dependencies in the given extra group name; may be provided more than once'
            cand --resolution 'resolution'
            cand --prerelease 'prerelease'
            cand -o 'Write the compiled requirements to the given `requirements.txt` file'
            cand --output-file 'Write the compiled requirements to the given `requirements.txt` file'
            cand --custom-compile-command 'Change header comment to reflect custom command wrapping `uv pip compile`'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand -i 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url 'Extra URLs of package indexes to use, in addition to `--index-url`'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index urls'
            cand -f 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand --find-links 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in the existing output file'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in the existing output file'
            cand --only-binary 'Only use pre-built wheels; don''t build source distributions'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand -p 'The minimum Python version that should be supported by the compiled requirements (e.g., `3.7` or `3.7.9`)'
            cand --python-version 'The minimum Python version that should be supported by the compiled requirements (e.g., `3.7` or `3.7.9`)'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --no-emit-package 'Specify a package to omit from the output resolution. Its dependencies will still be included in the resolution. Equivalent to pip-compile''s `--unsafe-package` option'
            cand --annotation-style 'Choose the style of the annotation comments, which indicate the source of each package'
            cand --resolver 'resolver'
            cand --max-rounds 'max-rounds'
            cand --cert 'cert'
            cand --client-cert 'client-cert'
            cand --trusted-host 'trusted-host'
            cand --config 'config'
            cand --pip-args 'pip-args'
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand --all-extras 'Include all optional dependencies'
            cand --no-deps 'Ignore package dependencies, instead only add those packages explicitly listed on the command line to the resulting the requirements file'
            cand --pre 'pre'
            cand --no-strip-extras 'Include extras in the output file'
            cand --no-annotate 'Exclude comment annotations indicating the source of each package'
            cand --no-header 'Exclude the comment header at the top of the generated output file'
            cand --offline 'Run offline, i.e., without accessing the network'
            cand --refresh 'Refresh all cached data'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those discovered via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in the existing output file'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in the existing output file'
            cand --generate-hashes 'Include distribution hashes in the output file'
            cand --legacy-setup-py 'Use legacy `setuptools` behavior when building source distributions without a `pyproject.toml`'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --no-build 'Don''t build source distributions'
            cand --emit-index-url 'Include `--index-url` and `--extra-index-url` entries in the generated output file'
            cand --emit-find-links 'Include `--find-links` entries in the generated output file'
            cand --allow-unsafe 'allow-unsafe'
            cand --no-allow-unsafe 'no-allow-unsafe'
            cand --reuse-hashes 'reuse-hashes'
            cand --no-reuse-hashes 'no-reuse-hashes'
            cand --build-isolation 'build-isolation'
            cand --emit-trusted-host 'emit-trusted-host'
            cand --no-emit-trusted-host 'no-emit-trusted-host'
            cand --no-config 'no-config'
            cand --no-emit-index-url 'no-emit-index-url'
            cand --no-emit-find-links 'no-emit-find-links'
            cand --emit-options 'emit-options'
            cand --no-emit-options 'no-emit-options'
            cand --strip-extras 'strip-extras'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;pip;sync'= {
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand -i 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url 'Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand --find-links 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index urls'
            cand -p 'The Python interpreter into which packages should be installed.'
            cand --python 'The Python interpreter into which packages should be installed.'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --only-binary 'Only use pre-built wheels; don''t build source distributions'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --trusted-host 'trusted-host'
            cand --python-executable 'python-executable'
            cand --cert 'cert'
            cand --client-cert 'client-cert'
            cand --config 'config'
            cand --pip-args 'pip-args'
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed'
            cand --offline 'Run offline, i.e., without accessing the network'
            cand --refresh 'Refresh all cached data'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those discovered via `--find-links`'
            cand --system 'Install packages into the system Python'
            cand --break-system-packages 'Allow `uv` to modify an `EXTERNALLY-MANAGED` Python installation'
            cand --legacy-setup-py 'Use legacy `setuptools` behavior when building source distributions without a `pyproject.toml`'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --no-build 'Don''t build source distributions'
            cand --compile 'Compile Python files to bytecode'
            cand --strict 'Validate the virtual environment after completing the installation, to detect packages with missing dependencies or other issues'
            cand -a 'a'
            cand --ask 'ask'
            cand --user 'user'
            cand --no-config 'no-config'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;pip;install'= {
            cand -r 'Install all packages listed in the given requirements files'
            cand --requirement 'Install all packages listed in the given requirements files'
            cand -e 'Install the editable package based on the provided local file path'
            cand --editable 'Install the editable package based on the provided local file path'
            cand -c 'Constrain versions using the given requirements files'
            cand --constraint 'Constrain versions using the given requirements files'
            cand --override 'Override versions using the given requirements files'
            cand --extra 'Include optional dependencies in the given extra group name; may be provided more than once'
            cand -P 'Allow upgrade of a specific package'
            cand --upgrade-package 'Allow upgrade of a specific package'
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --resolution 'resolution'
            cand --prerelease 'prerelease'
            cand -o 'Write the compiled requirements to the given `requirements.txt` file'
            cand --output-file 'Write the compiled requirements to the given `requirements.txt` file'
            cand -i 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url 'Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand --find-links 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index urls'
            cand -p 'The Python interpreter into which packages should be installed.'
            cand --python 'The Python interpreter into which packages should be installed.'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --only-binary 'Only use pre-built wheels; don''t build source distributions'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand --all-extras 'Include all optional dependencies'
            cand -U 'Allow package upgrades'
            cand --upgrade 'Allow package upgrades'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed'
            cand --offline 'Run offline, i.e., without accessing the network'
            cand --refresh 'Refresh all cached data'
            cand --no-deps 'Ignore package dependencies, instead only installing those packages explicitly listed on the command line or in the requirements files'
            cand --pre 'pre'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those discovered via `--find-links`'
            cand --system 'Install packages into the system Python'
            cand --break-system-packages 'Allow `uv` to modify an `EXTERNALLY-MANAGED` Python installation'
            cand --legacy-setup-py 'Use legacy `setuptools` behavior when building source distributions without a `pyproject.toml`'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --no-build 'Don''t build source distributions'
            cand --compile 'Compile Python files to bytecode'
            cand --strict 'Validate the virtual environment after completing the installation, to detect packages with missing dependencies or other issues'
            cand --dry-run 'Perform a dry run, i.e., don''t actually install anything but resolve the dependencies and print the resulting plan'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;pip;uninstall'= {
            cand -r 'Uninstall all packages listed in the given requirements files'
            cand --requirement 'Uninstall all packages listed in the given requirements files'
            cand -e 'Uninstall the editable package based on the provided local file path'
            cand --editable 'Uninstall the editable package based on the provided local file path'
            cand -p 'The Python interpreter from which packages should be uninstalled.'
            cand --python 'The Python interpreter from which packages should be uninstalled.'
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand --system 'Use the system Python to uninstall packages'
            cand --break-system-packages 'Allow `uv` to modify an `EXTERNALLY-MANAGED` Python installation'
            cand --offline 'Run offline, i.e., without accessing the network'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;pip;freeze'= {
            cand -p 'The Python interpreter for which packages should be listed.'
            cand --python 'The Python interpreter for which packages should be listed.'
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand --strict 'Validate the virtual environment, to detect packages with missing dependencies or other issues'
            cand --system 'List packages for the system Python'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;pip;list'= {
            cand --exclude 'Exclude the specified package(s) from the output'
            cand --format 'Select the output format between: `columns` (default), `freeze`, or `json`'
            cand -p 'The Python interpreter for which packages should be listed.'
            cand --python 'The Python interpreter for which packages should be listed.'
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand --strict 'Validate the virtual environment, to detect packages with missing dependencies or other issues'
            cand -e 'Only include editable projects'
            cand --editable 'Only include editable projects'
            cand --exclude-editable 'Exclude any editable packages from output'
            cand --system 'List packages for the system Python'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;pip;show'= {
            cand -p 'The Python interpreter for which packages should be listed.'
            cand --python 'The Python interpreter for which packages should be listed.'
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand --strict 'Validate the virtual environment, to detect packages with missing dependencies or other issues'
            cand --system 'List packages for the system Python'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;pip;check'= {
            cand -p 'The Python interpreter for which packages should be listed.'
            cand --python 'The Python interpreter for which packages should be listed.'
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand --system 'List packages for the system Python'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;pip;help'= {
            cand compile 'Compile a `requirements.in` file to a `requirements.txt` file'
            cand sync 'Sync dependencies from a `requirements.txt` file'
            cand install 'Install packages into the current environment'
            cand uninstall 'Uninstall packages from the current environment'
            cand freeze 'Enumerate the installed packages in the current environment'
            cand list 'Enumerate the installed packages in the current environment'
            cand show 'Show information about one or more installed packages'
            cand check 'Verify installed packages have compatible dependencies'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;pip;help;compile'= {
        }
        &'uv;pip;help;sync'= {
        }
        &'uv;pip;help;install'= {
        }
        &'uv;pip;help;uninstall'= {
        }
        &'uv;pip;help;freeze'= {
        }
        &'uv;pip;help;list'= {
        }
        &'uv;pip;help;show'= {
        }
        &'uv;pip;help;check'= {
        }
        &'uv;pip;help;help'= {
        }
        &'uv;venv'= {
            cand -p 'The Python interpreter to use for the virtual environment.'
            cand --python 'The Python interpreter to use for the virtual environment.'
            cand --prompt 'Provide an alternative prompt prefix for the virtual environment.'
            cand -i 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url 'Extra URLs of package indexes to use, in addition to `--index-url`'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index urls'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand --system 'Use the system Python to uninstall packages'
            cand --seed 'Install seed packages (`pip`, `setuptools`, and `wheel`) into the virtual environment'
            cand --system-site-packages 'Give the virtual environment access to the system site packages directory'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those discovered via `--find-links`'
            cand --offline 'Run offline, i.e., without accessing the network'
            cand --clear 'clear'
            cand --no-seed 'no-seed'
            cand --no-pip 'no-pip'
            cand --no-setuptools 'no-setuptools'
            cand --no-wheel 'no-wheel'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;cache'= {
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
            cand clean 'Remove all items from the cache'
            cand dir 'Show the cache directory'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;cache;clean'= {
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;cache;dir'= {
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;cache;help'= {
            cand clean 'Remove all items from the cache'
            cand dir 'Show the cache directory'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;cache;help;clean'= {
        }
        &'uv;cache;help;dir'= {
        }
        &'uv;cache;help;help'= {
        }
        &'uv;self'= {
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
            cand update 'Update `uv` to the latest version'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;self;update'= {
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;self;help'= {
            cand update 'Update `uv` to the latest version'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;self;help;update'= {
        }
        &'uv;self;help;help'= {
        }
        &'uv;clean'= {
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;version'= {
            cand --output-format 'output-format'
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;generate-shell-completion'= {
            cand --color 'Control colors in output'
            cand --cache-dir 'Path to the cache directory'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;help'= {
            cand pip 'Resolve and install Python packages'
            cand venv 'Create a virtual environment'
            cand cache 'Manage the cache'
            cand self 'Manage the `uv` executable'
            cand clean 'Remove all items from the cache'
            cand version 'Display uv''s version'
            cand generate-shell-completion 'Generate shell completion'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;help;pip'= {
            cand compile 'Compile a `requirements.in` file to a `requirements.txt` file'
            cand sync 'Sync dependencies from a `requirements.txt` file'
            cand install 'Install packages into the current environment'
            cand uninstall 'Uninstall packages from the current environment'
            cand freeze 'Enumerate the installed packages in the current environment'
            cand list 'Enumerate the installed packages in the current environment'
            cand show 'Show information about one or more installed packages'
            cand check 'Verify installed packages have compatible dependencies'
        }
        &'uv;help;pip;compile'= {
        }
        &'uv;help;pip;sync'= {
        }
        &'uv;help;pip;install'= {
        }
        &'uv;help;pip;uninstall'= {
        }
        &'uv;help;pip;freeze'= {
        }
        &'uv;help;pip;list'= {
        }
        &'uv;help;pip;show'= {
        }
        &'uv;help;pip;check'= {
        }
        &'uv;help;venv'= {
        }
        &'uv;help;cache'= {
            cand clean 'Remove all items from the cache'
            cand dir 'Show the cache directory'
        }
        &'uv;help;cache;clean'= {
        }
        &'uv;help;cache;dir'= {
        }
        &'uv;help;self'= {
            cand update 'Update `uv` to the latest version'
        }
        &'uv;help;self;update'= {
        }
        &'uv;help;clean'= {
        }
        &'uv;help;version'= {
        }
        &'uv;help;generate-shell-completion'= {
        }
        &'uv;help;help'= {
        }
    ]
    $completions[$command]
}
