/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.xml;

import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.beans.ReplacementMode;
import com.install4j.api.context.Context;
import com.install4j.runtime.beans.actions.xml.AbstractModifyMultipleXmlFilesAction;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathReplaceAction
extends AbstractModifyMultipleXmlFilesAction
implements PropertyLoggingInterceptor {
    private String xpathExpression;
    private String regex = ".*";
    private String replacement;
    private boolean replaceAll = false;
    private boolean quoteVariables = true;
    private boolean logReplacement = true;

    public String getXpathExpression() {
        return XPathReplaceAction.replaceVariables(XPathReplaceAction.replaceVariables(this.xpathExpression));
    }

    public void setXpathExpression(String xpathExpression) {
        this.xpathExpression = xpathExpression;
    }

    public String getRegex() {
        return XPathReplaceAction.replaceVariables(XPathReplaceAction.replaceVariables(this.regex, this.isQuoteVariables() ? ReplacementMode.REGEXP_MATCH : ReplacementMode.PLAIN));
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public String getReplacement() {
        return XPathReplaceAction.replaceVariables(XPathReplaceAction.replaceVariables(this.replacement, this.isQuoteVariables() ? ReplacementMode.REGEXP_REPLACEMENT : ReplacementMode.PLAIN));
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public boolean isReplaceAll() {
        return this.replaceWithTextOverride("replaceAll", this.replaceAll);
    }

    public void setReplaceAll(boolean replaceAll) {
        this.replaceAll = replaceAll;
    }

    public boolean isQuoteVariables() {
        return this.replaceWithTextOverride("quoteVariables", this.quoteVariables);
    }

    public void setQuoteVariables(boolean quoteVariables) {
        this.quoteVariables = quoteVariables;
    }

    public boolean isLogReplacement() {
        return this.replaceWithTextOverride("logReplacement", this.logReplacement);
    }

    public void setLogReplacement(boolean logReplacement) {
        this.logReplacement = logReplacement;
    }

    @Override
    public Object getLogValueForProperty(String propertyName, Object propertyValue) {
        return this.maybeFilterLogReplacement(propertyName, "replacement", propertyValue, this.isLogReplacement());
    }

    @Override
    protected boolean modifyFile(File file, Context context) throws IOException {
        Document doc = this.parseFile(file);
        if (!this.modifyDirect(doc) & !this.modifyEmpty(doc)) {
            Logger.getInstance().log(this, "No nodes found for XPath " + this.getXpathExpression(), false);
            return false;
        }
        XmlHelper.writeFile(file, doc);
        return true;
    }

    private boolean modifyDirect(Document doc) {
        NodeList nodeList = XmlHelper.getNodeList(doc, this.getXpathExpression());
        if (nodeList == null || nodeList.getLength() == 0) {
            return false;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String nodeValue = node.getNodeValue();
            if (nodeValue == null) {
                return false;
            }
            node.setNodeValue(this.replaceNodeValue(nodeValue));
        }
        return true;
    }

    private boolean modifyEmpty(Document doc) {
        if (this.getXpathExpression().endsWith("/text()")) {
            NodeList nodeList = XmlHelper.getNodeList(doc, this.getXpathExpression().substring(0, this.getXpathExpression().length() - "/text()".length()));
            if (nodeList == null || nodeList.getLength() == 0) {
                return false;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String nodeValue;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || node.hasChildNodes() || (nodeValue = this.replaceNodeValue("")).isEmpty()) continue;
                node.appendChild(doc.createTextNode(nodeValue));
            }
            return true;
        }
        return false;
    }

    private String replaceNodeValue(String nodeValue) {
        if (this.isReplaceAll()) {
            return nodeValue.replaceAll(this.getRegex(), this.getReplacement());
        }
        return nodeValue.replaceFirst(this.getRegex(), this.getReplacement());
    }
}

