/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.map.INodeDuplicator;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeRelativePath;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.plugin.codeexplorer.dependencies.CodeDependency;
import org.freeplane.plugin.codeexplorer.dependencies.DependencyVerdict;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.map.EmptyNodeModel;
import org.freeplane.plugin.codeexplorer.map.SubprojectFinder;
import org.freeplane.plugin.codeexplorer.task.AnnotationMatcher;
import org.freeplane.plugin.codeexplorer.task.CodeExplorerConfiguration;
import org.freeplane.plugin.codeexplorer.task.DependencyJudge;
import org.freeplane.plugin.codeexplorer.task.DependencyRuleJudge;

public class CodeMap
extends MMapModel {
    private DependencyJudge judge = new DependencyRuleJudge();
    private SubprojectFinder subprojectFinder = SubprojectFinder.EMPTY;
    private CodeExplorerConfiguration codeExplorerConfiguration;
    private boolean canBeSaved = false;

    public CodeMap(INodeDuplicator nodeDuplicator) {
        super(nodeDuplicator);
        this.setRoot(new EmptyNodeModel(this, "No locations selected"));
        this.getRootNode().setFolded(false);
    }

    protected Map<String, NodeModel> createNodeByIdMap() {
        return new ConcurrentHashMap<String, NodeModel>(){

            @Override
            public NodeModel put(String key, NodeModel value) {
                if (value == null) {
                    return (NodeModel)this.remove(key);
                }
                return super.put(key, value);
            }
        };
    }

    public boolean isSaved() {
        return !this.canBeSaved || super.isSaved();
    }

    public String getTitle() {
        String longTitle = "Code: " + this.getRootNode().toString();
        int maximumTitleLEngth = 30;
        return longTitle.length() <= 30 ? longTitle : longTitle.substring(0, 27) + "...";
    }

    public void setJudge(DependencyJudge judge) {
        this.judge = judge;
    }

    public void enableAutosave() {
    }

    public void updateAnnotations(AnnotationMatcher annotationMatcher) {
        boolean saved = this.isSaved();
        this.getRootNode().updateAnnotations(annotationMatcher);
        if (saved) {
            this.setSaved(true);
        }
    }

    public DependencyJudge getJudge() {
        return this.judge;
    }

    public CodeNode getRootNode() {
        return (CodeNode)super.getRootNode();
    }

    public void setRoot(NodeModel newRoot) {
        MapStyleModel mapStyles;
        CodeNode oldRoot = this.getRootNode();
        if (oldRoot != null && (mapStyles = (MapStyleModel)oldRoot.getExtension(MapStyleModel.class)) != null) {
            newRoot.addExtension((IExtension)mapStyles);
        }
        super.setRoot(newRoot);
    }

    public void setSubprojectFinder(SubprojectFinder subprojectFinder) {
        this.subprojectFinder = subprojectFinder;
    }

    DependencyVerdict judge(Dependency dependency, boolean goesUp) {
        return this.judge.judge(dependency, goesUp);
    }

    public int subprojectIndexOf(JavaClass javaClass) {
        return this.subprojectFinder.subprojectIndexOf(javaClass);
    }

    public int subprojectIndexOf(String location) {
        return this.subprojectFinder.subprojectIndexOf(location);
    }

    public Stream<JavaClass> allClasses() {
        return this.subprojectFinder.allClasses();
    }

    public String getClassNodeId(JavaClass javaClass) {
        int subprojectIndex = this.subprojectIndexOf(javaClass);
        return this.getClassNodeId(javaClass, subprojectIndex);
    }

    private String getClassNodeId(JavaClass javaClass, int subprojectIndex) {
        JavaClass nodeClass = CodeNode.findEnclosingNamedClass(javaClass);
        String nodeClassName = nodeClass.getName();
        String classNodeId = CodeNode.idWithSubprojectIndex(nodeClassName, subprojectIndex);
        return classNodeId;
    }

    public CodeNode getNodeByClass(JavaClass javaClass) {
        String existingNodeId = this.getExistingNodeId(javaClass);
        return existingNodeId == null ? null : (CodeNode)this.getNodeForID(existingNodeId);
    }

    String getExistingNodeId(JavaClass javaClass) {
        int subprojectIndex = this.subprojectIndexOf(javaClass);
        return this.getClassNodeId(javaClass, subprojectIndex);
    }

    public CodeDependency toCodeDependency(Dependency dependency) {
        CodeNode originNode = this.getNodeByClass(dependency.getOriginClass());
        CodeNode targetNode = this.getNodeByClass(dependency.getTargetClass());
        if (originNode == null || targetNode == null) {
            throw new IllegalStateException("Can not find nodes for dependency " + dependency);
        }
        NodeRelativePath nodeRelativePath = new NodeRelativePath((NodeModel)originNode, (NodeModel)targetNode);
        boolean goesUp = nodeRelativePath.compareNodePositions() > 0;
        return new CodeDependency(dependency, goesUp, this.judge(dependency, goesUp));
    }

    public void releaseResources() {
        super.releaseResources();
    }

    public void setConfiguration(CodeExplorerConfiguration codeExplorerConfiguration) {
        this.codeExplorerConfiguration = codeExplorerConfiguration;
    }

    public CodeExplorerConfiguration getConfiguration() {
        return this.codeExplorerConfiguration;
    }

    public String locationByIndex(int index) {
        return this.subprojectFinder.locationByIndex(index);
    }

    public void setCanBeSaved(boolean canBeSaved) {
        this.canBeSaved = canBeSaved;
    }
}

